/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.internal.java.search;

import java.io.File;
import java.util.zip.CRC32;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.search.IJavaSearchConstants;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchDocument;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.web.core.internal.JsCoreMessages;
import org.eclipse.wst.jsdt.web.core.internal.java.JsNameManglerUtil;
import org.eclipse.wst.jsdt.web.core.internal.java.search.JSDTSearchDocumentDelegate;
import org.eclipse.wst.jsdt.web.core.internal.java.search.JsIndexManager;
import org.eclipse.wst.jsdt.web.core.internal.java.search.JsSearchDocument;
import org.eclipse.wst.jsdt.web.core.internal.java.search.JsSearchParticipant;
import org.eclipse.wst.jsdt.web.core.internal.validation.Util;

public class JsSearchSupport {
    static final boolean DEBUG;
    private static JsSearchSupport singleton;
    private final CRC32 fChecksumCalculator = new CRC32();
    private final IProgressMonitor fMonitor = new NullProgressMonitor();
    private JsSearchParticipant fParticipant = null;

    static {
        singleton = null;
        String string = Platform.getDebugOption((String)"org.eclipse.wst.jsdt.web.core/debug/jspsearch");
        DEBUG = string != null && string.equalsIgnoreCase("true");
    }

    public static synchronized JsSearchSupport getInstance() {
        if (singleton == null) {
            singleton = new JsSearchSupport();
        }
        return singleton;
    }

    public static boolean isJsp(IFile iFile) {
        if (iFile != null && iFile.exists()) {
            return Util.isJsType(iFile.getName());
        }
        return false;
    }

    private JsSearchSupport() {
    }

    public SearchDocument addJspFile(IFile iFile) {
        SearchDocument searchDocument;
        block6: {
            if (JsSearchSupport.getInstance().isCanceled() || !iFile.isAccessible()) {
                return null;
            }
            if (DEBUG) {
                System.out.println("adding JSP file:" + iFile.getFullPath());
            }
            if ((searchDocument = this.createSearchDocument(iFile)) != null) {
                try {
                    this.getSearchParticipant().scheduleDocumentIndexing(searchDocument, this.computeIndexLocation(iFile.getParent().getFullPath()));
                }
                catch (Exception exception) {
                    if (!DEBUG) break block6;
                    exception.printStackTrace();
                }
            }
        }
        if (DEBUG) {
            System.out.println("scheduled" + searchDocument + "for indexing");
        }
        return searchDocument;
    }

    public final IPath computeContainerLocation(IPath iPath) {
        return null;
    }

    public final IPath computeIndexLocation(IPath iPath) {
        String string = null;
        String string2 = iPath.toOSString();
        this.fChecksumCalculator.reset();
        this.fChecksumCalculator.update(string2.getBytes());
        String string3 = String.valueOf(Long.toString(this.fChecksumCalculator.getValue())) + ".index";
        string = this.getModelJspPluginWorkingLocation(this.getProject(iPath)).append(string3).toOSString();
        JavaModelManager.getJavaModelManager().getIndexManager().indexLocations.put((Object)iPath, (Object)new Path(string));
        return new Path(string);
    }

    private SearchDocument createSearchDocument(IFile iFile) {
        JSDTSearchDocumentDelegate jSDTSearchDocumentDelegate = null;
        if (iFile != null && iFile.exists() && JsSearchSupport.isJsp(iFile)) {
            jSDTSearchDocumentDelegate = new JSDTSearchDocumentDelegate(new JsSearchDocument(iFile.getFullPath().toString(), this.getSearchParticipant()));
        }
        return jSDTSearchDocumentDelegate;
    }

    private IFile fileForCUPath(String string) {
        Path path;
        String[] stringArray = string.split("/");
        String string2 = stringArray[stringArray.length - 1];
        if (!string.endsWith(".js")) {
            return null;
        }
        String string3 = JsNameManglerUtil.unmangle(string2);
        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(string3));
        if (iFile == null && (path = new Path(string3)).segmentCount() >= 2) {
            iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        return iFile;
    }

    public IPath getModelJspPluginWorkingLocation(IProject iProject) {
        IPath iPath;
        File file;
        if (iProject == null) {
            System.out.println("Null project");
        }
        if (!(file = new File((iPath = iProject.getWorkingLocation("org.eclipse.wst.jsdt.web.core").append("jspsearch")).toOSString())).isDirectory()) {
            try {
                file.mkdir();
            }
            catch (SecurityException securityException) {}
        }
        return iPath;
    }

    public final IProgressMonitor getProgressMonitor() {
        return this.fMonitor;
    }

    private IProject getProject(IPath iPath) {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IResource iResource = iWorkspace.getRoot().findMember(iPath.toString());
        if (iResource == null) {
            return null;
        }
        IProject iProject = iResource.getProject();
        return iProject;
    }

    public SearchDocument getSearchDocument(String string) {
        SearchDocument searchDocument = null;
        IFile iFile = this.fileForCUPath(string);
        if (iFile != null) {
            searchDocument = this.createSearchDocument(iFile);
        }
        return searchDocument;
    }

    JsSearchParticipant getSearchParticipant() {
        if (this.fParticipant == null) {
            this.fParticipant = new JsSearchParticipant();
        }
        return this.fParticipant;
    }

    public final synchronized boolean isCanceled() {
        return this.fMonitor.isCanceled();
    }

    public void search(IJavaElement iJavaElement, IJavaSearchScope iJavaSearchScope, SearchRequestor searchRequestor) {
        JsIndexManager.getInstance().rebuildIndexIfNeeded();
        SearchJob searchJob = new SearchJob(iJavaElement, iJavaSearchScope, searchRequestor);
        this.setCanceled(false);
        searchJob.setUser(true);
        searchJob.schedule();
    }

    public void search(String string, IJavaSearchScope iJavaSearchScope, int n, int n2, int n3, boolean bl, SearchRequestor searchRequestor) {
        JsIndexManager.getInstance().rebuildIndexIfNeeded();
        SearchJob searchJob = new SearchJob(string, iJavaSearchScope, n, n2, n3, bl, searchRequestor);
        this.setCanceled(false);
        searchJob.setUser(true);
        searchJob.schedule();
    }

    public void searchRunnable(IJavaElement iJavaElement, IJavaSearchScope iJavaSearchScope, SearchRequestor searchRequestor) {
        JsIndexManager.getInstance().rebuildIndexIfNeeded();
        SearchRunnable searchRunnable = new SearchRunnable(iJavaElement, iJavaSearchScope, searchRequestor);
        try {
            this.setCanceled(false);
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)searchRunnable, JsSearchSupport.getInstance().getProgressMonitor());
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    public final synchronized void setCanceled(boolean bl) {
        this.fMonitor.setCanceled(bl);
    }

    private class SearchJob
    extends Job
    implements IJavaSearchConstants {
        IJavaElement fElement = null;
        boolean fIsCaseSensitive = false;
        int fLimitTo = 3;
        int fMatchMode = 2;
        SearchRequestor fRequestor = null;
        IJavaSearchScope fScope = null;
        int fSearchFor = 4;
        String fSearchText = "";

        public SearchJob(IJavaElement iJavaElement, IJavaSearchScope iJavaSearchScope, SearchRequestor searchRequestor) {
            super(String.valueOf(JsCoreMessages.JSP_Search) + iJavaElement.getElementName());
            this.fElement = iJavaElement;
            this.fScope = iJavaSearchScope;
            this.fRequestor = searchRequestor;
        }

        public SearchJob(String string, IJavaSearchScope iJavaSearchScope, int n, int n2, int n3, boolean bl, SearchRequestor searchRequestor) {
            super(String.valueOf(JsCoreMessages.JSP_Search) + string);
            this.fSearchText = string;
            this.fScope = iJavaSearchScope;
            this.fSearchFor = n;
            this.fLimitTo = n2;
            this.fMatchMode = n3;
            this.fIsCaseSensitive = bl;
            this.fRequestor = searchRequestor;
        }

        /*
         * Exception decompiling
         */
        public IStatus run(IProgressMonitor var1_1) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 188->191)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class SearchRunnable
    implements IWorkspaceRunnable,
    IJavaSearchConstants {
        IJavaElement fElement = null;
        boolean fIsCaseSensitive = false;
        int fLimitTo = 3;
        int fMatchMode = 2;
        SearchRequestor fRequestor = null;
        IJavaSearchScope fScope = null;
        int fSearchFor = 4;
        String fSearchText = "";

        public SearchRunnable(IJavaElement iJavaElement, IJavaSearchScope iJavaSearchScope, SearchRequestor searchRequestor) {
            this.fElement = iJavaElement;
            this.fScope = iJavaSearchScope;
            this.fRequestor = searchRequestor;
        }

        public SearchRunnable(String string, IJavaSearchScope iJavaSearchScope, int n, int n2, int n3, boolean bl, SearchRequestor searchRequestor) {
            this.fSearchText = string;
            this.fScope = iJavaSearchScope;
            this.fSearchFor = n;
            this.fLimitTo = n2;
            this.fMatchMode = n3;
            this.fIsCaseSensitive = bl;
            this.fRequestor = searchRequestor;
        }

        /*
         * Exception decompiling
         */
        public void run(IProgressMonitor var1_1) throws CoreException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 170->174)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

