/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.extensions.LinkHelperService;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ILinkHelper;
import org.eclipse.ui.progress.UIJob;

public class LinkEditorAction
extends Action
implements ISelectionChangedListener,
IAction,
IPropertyListener {
    private static final long BRIEF_DELAY = 100L;
    private IPartListener partListener;
    private final CommonNavigator commonNavigator;
    private final CommonViewer commonViewer;
    private final LinkHelperService linkService;
    private UIJob activateEditorJob = new UIJob(CommonNavigatorMessages.Link_With_Editor_Job_){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            ILinkHelper[] helpers;
            IStructuredSelection sSelection;
            ISelection selection = LinkEditorAction.this.commonViewer.getSelection();
            if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (sSelection = (IStructuredSelection)selection).size() == 1 && (helpers = LinkEditorAction.this.linkService.getLinkHelpersFor(sSelection.getFirstElement())).length > 0) {
                helpers[0].activateEditor(LinkEditorAction.this.commonNavigator.getSite().getPage(), sSelection);
            }
            return Status.OK_STATUS;
        }
    };
    private UIJob updateSelectionJob = new UIJob(CommonNavigatorMessages.Link_With_Editor_Job_){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            try {
                IEditorPart editor;
                IWorkbenchPage page = LinkEditorAction.this.commonNavigator.getSite().getPage();
                if (page != null && (editor = page.getActiveEditor()) != null) {
                    IEditorInput input = editor.getEditorInput();
                    IStructuredSelection newSelection = LinkEditorAction.this.linkService.getSelectionFor(input);
                    if (!newSelection.isEmpty()) {
                        LinkEditorAction.this.commonNavigator.selectReveal((ISelection)newSelection);
                    }
                }
            }
            catch (Throwable e) {
                String msg = e.getMessage() != null ? e.getMessage() : e.toString();
                NavigatorPlugin.logError(0, msg, e);
            }
            return Status.OK_STATUS;
        }
    };

    public LinkEditorAction(CommonNavigator aNavigator, CommonViewer aViewer, LinkHelperService linkHelperService) {
        super(CommonNavigatorMessages.LinkEditorActionDelegate_0);
        this.linkService = linkHelperService;
        this.setToolTipText(CommonNavigatorMessages.LinkEditorActionDelegate_1);
        this.commonNavigator = aNavigator;
        this.commonViewer = aViewer;
        this.init();
    }

    protected void init() {
        this.partListener = new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
                if (part instanceof IEditorPart) {
                    LinkEditorAction.this.updateSelectionJob.schedule(100L);
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
                if (part instanceof IEditorPart) {
                    LinkEditorAction.this.updateSelectionJob.schedule(100L);
                }
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partOpened(IWorkbenchPart part) {
            }
        };
        this.updateLinkingEnabled(this.commonNavigator.isLinkingEnabled());
        this.commonNavigator.addPropertyListener(this);
    }

    public void dispose() {
        this.commonNavigator.removePropertyListener(this);
        if (this.isChecked()) {
            this.commonViewer.removePostSelectionChangedListener(this);
            this.commonNavigator.getSite().getPage().removePartListener(this.partListener);
        }
    }

    public void run() {
        this.commonNavigator.setLinkingEnabled(!this.commonNavigator.isLinkingEnabled());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.commonNavigator.isLinkingEnabled()) {
            this.activateEditor();
        }
    }

    protected void activateEditor() {
        ISelection selection = this.commonViewer.getSelection();
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            this.activateEditorJob.schedule(100L);
        }
    }

    public void propertyChanged(Object aSource, int aPropertyId) {
        switch (aPropertyId) {
            case 1: {
                this.updateLinkingEnabled(((CommonNavigator)((Object)aSource)).isLinkingEnabled());
            }
        }
    }

    private void updateLinkingEnabled(boolean toEnableLinking) {
        this.setChecked(toEnableLinking);
        if (toEnableLinking) {
            this.updateSelectionJob.schedule(100L);
            this.commonViewer.addPostSelectionChangedListener(this);
            this.commonNavigator.getSite().getPage().addPartListener(this.partListener);
        } else {
            this.commonViewer.removePostSelectionChangedListener(this);
            this.commonNavigator.getSite().getPage().removePartListener(this.partListener);
        }
    }
}

