/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanScorer;
import org.apache.lucene.search.BooleanScorer2;
import org.apache.lucene.search.ConjunctionScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.SimilarityDelegator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;

public class BooleanQuery
extends Query {
    public static int maxClauseCount = 1024;
    private Vector clauses = new Vector();
    private boolean disableCoord;
    protected int minNrShouldMatch = 0;
    private static boolean useScorer14 = false;

    public static int getMaxClauseCount() {
        return maxClauseCount;
    }

    public static void setMaxClauseCount(int maxClauseCount) {
        if (maxClauseCount < 1) {
            throw new IllegalArgumentException("maxClauseCount must be >= 1");
        }
        BooleanQuery.maxClauseCount = maxClauseCount;
    }

    public BooleanQuery() {
    }

    public BooleanQuery(boolean disableCoord) {
        this.disableCoord = disableCoord;
    }

    public boolean isCoordDisabled() {
        return this.disableCoord;
    }

    public Similarity getSimilarity(Searcher searcher) {
        Similarity result = super.getSimilarity(searcher);
        if (this.disableCoord) {
            result = new SimilarityDelegator(result){

                public float coord(int overlap, int maxOverlap) {
                    return 1.0f;
                }
            };
        }
        return result;
    }

    public void setMinimumNumberShouldMatch(int min) {
        this.minNrShouldMatch = min;
    }

    public int getMinimumNumberShouldMatch() {
        return this.minNrShouldMatch;
    }

    public void add(Query query, boolean required, boolean prohibited) {
        this.add(new BooleanClause(query, required, prohibited));
    }

    public void add(Query query, BooleanClause.Occur occur) {
        this.add(new BooleanClause(query, occur));
    }

    public void add(BooleanClause clause) {
        if (this.clauses.size() >= maxClauseCount) {
            throw new TooManyClauses();
        }
        this.clauses.addElement(clause);
    }

    public BooleanClause[] getClauses() {
        return this.clauses.toArray(new BooleanClause[0]);
    }

    public static void setUseScorer14(boolean use14) {
        useScorer14 = use14;
    }

    public static boolean getUseScorer14() {
        return useScorer14;
    }

    protected Weight createWeight(Searcher searcher) throws IOException {
        if (0 < this.minNrShouldMatch) {
            return new BooleanWeight2(searcher);
        }
        return BooleanQuery.getUseScorer14() ? new BooleanWeight(searcher) : new BooleanWeight2(searcher);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        BooleanClause c;
        if (this.clauses.size() == 1 && !(c = (BooleanClause)this.clauses.elementAt(0)).isProhibited()) {
            Query query = c.getQuery().rewrite(reader);
            if (this.getBoost() != 1.0f) {
                if (query == c.getQuery()) {
                    query = (Query)query.clone();
                }
                query.setBoost(this.getBoost() * query.getBoost());
            }
            return query;
        }
        BooleanQuery clone = null;
        for (int i = 0; i < this.clauses.size(); ++i) {
            BooleanClause c2 = (BooleanClause)this.clauses.elementAt(i);
            Query query = c2.getQuery().rewrite(reader);
            if (query == c2.getQuery()) continue;
            if (clone == null) {
                clone = (BooleanQuery)this.clone();
            }
            clone.clauses.setElementAt(new BooleanClause(query, c2.getOccur()), i);
        }
        if (clone != null) {
            return clone;
        }
        return this;
    }

    public void extractTerms(Set terms) {
        Iterator i = this.clauses.iterator();
        while (i.hasNext()) {
            BooleanClause clause = (BooleanClause)i.next();
            clause.getQuery().extractTerms(terms);
        }
    }

    public Object clone() {
        BooleanQuery clone = (BooleanQuery)super.clone();
        clone.clauses = (Vector)this.clauses.clone();
        return clone;
    }

    public String toString(String field) {
        boolean needParens;
        StringBuffer buffer = new StringBuffer();
        boolean bl = needParens = (double)this.getBoost() != 1.0 || this.getMinimumNumberShouldMatch() > 0;
        if (needParens) {
            buffer.append("(");
        }
        for (int i = 0; i < this.clauses.size(); ++i) {
            BooleanClause c = (BooleanClause)this.clauses.elementAt(i);
            if (c.isProhibited()) {
                buffer.append("-");
            } else if (c.isRequired()) {
                buffer.append("+");
            }
            Query subQuery = c.getQuery();
            if (subQuery instanceof BooleanQuery) {
                buffer.append("(");
                buffer.append(c.getQuery().toString(field));
                buffer.append(")");
            } else {
                buffer.append(c.getQuery().toString(field));
            }
            if (i == this.clauses.size() - 1) continue;
            buffer.append(" ");
        }
        if (needParens) {
            buffer.append(")");
        }
        if (this.getMinimumNumberShouldMatch() > 0) {
            buffer.append('~');
            buffer.append(this.getMinimumNumberShouldMatch());
        }
        if (this.getBoost() != 1.0f) {
            buffer.append(ToStringUtils.boost(this.getBoost()));
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BooleanQuery)) {
            return false;
        }
        BooleanQuery other = (BooleanQuery)o;
        return this.getBoost() == other.getBoost() && this.clauses.equals(other.clauses) && this.getMinimumNumberShouldMatch() == other.getMinimumNumberShouldMatch();
    }

    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) ^ this.clauses.hashCode() + this.getMinimumNumberShouldMatch();
    }

    private class BooleanWeight
    implements Weight {
        protected Similarity similarity;
        protected Vector weights = new Vector();

        public BooleanWeight(Searcher searcher) throws IOException {
            this.similarity = BooleanQuery.this.getSimilarity(searcher);
            for (int i = 0; i < BooleanQuery.this.clauses.size(); ++i) {
                BooleanClause c = (BooleanClause)BooleanQuery.this.clauses.elementAt(i);
                this.weights.add(c.getQuery().createWeight(searcher));
            }
        }

        public Query getQuery() {
            return BooleanQuery.this;
        }

        public float getValue() {
            return BooleanQuery.this.getBoost();
        }

        public float sumOfSquaredWeights() throws IOException {
            float sum = 0.0f;
            for (int i = 0; i < this.weights.size(); ++i) {
                BooleanClause c = (BooleanClause)BooleanQuery.this.clauses.elementAt(i);
                Weight w = (Weight)this.weights.elementAt(i);
                if (c.isProhibited()) continue;
                sum += w.sumOfSquaredWeights();
            }
            return sum *= BooleanQuery.this.getBoost() * BooleanQuery.this.getBoost();
        }

        public void normalize(float norm) {
            norm *= BooleanQuery.this.getBoost();
            for (int i = 0; i < this.weights.size(); ++i) {
                BooleanClause c = (BooleanClause)BooleanQuery.this.clauses.elementAt(i);
                Weight w = (Weight)this.weights.elementAt(i);
                if (c.isProhibited()) continue;
                w.normalize(norm);
            }
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            boolean allRequired = true;
            boolean noneBoolean = true;
            for (int i = 0; i < this.weights.size(); ++i) {
                BooleanClause c = (BooleanClause)BooleanQuery.this.clauses.elementAt(i);
                if (!c.isRequired()) {
                    allRequired = false;
                }
                if (!(c.getQuery() instanceof BooleanQuery)) continue;
                noneBoolean = false;
            }
            if (allRequired && noneBoolean) {
                ConjunctionScorer result = new ConjunctionScorer(this.similarity);
                for (int i = 0; i < this.weights.size(); ++i) {
                    Weight w = (Weight)this.weights.elementAt(i);
                    Scorer subScorer = w.scorer(reader);
                    if (subScorer == null) {
                        return null;
                    }
                    result.add(subScorer);
                }
                return result;
            }
            BooleanScorer result = new BooleanScorer(this.similarity);
            for (int i = 0; i < this.weights.size(); ++i) {
                BooleanClause c = (BooleanClause)BooleanQuery.this.clauses.elementAt(i);
                Weight w = (Weight)this.weights.elementAt(i);
                Scorer subScorer = w.scorer(reader);
                if (subScorer != null) {
                    result.add(subScorer, c.isRequired(), c.isProhibited());
                    continue;
                }
                if (!c.isRequired()) continue;
                return null;
            }
            return result;
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            float coordFactor;
            Explanation sumExpl = new Explanation();
            sumExpl.setDescription("sum of:");
            int coord = 0;
            int maxCoord = 0;
            float sum = 0.0f;
            for (int i = 0; i < this.weights.size(); ++i) {
                BooleanClause c = (BooleanClause)BooleanQuery.this.clauses.elementAt(i);
                Weight w = (Weight)this.weights.elementAt(i);
                Explanation e = w.explain(reader, doc);
                if (!c.isProhibited()) {
                    ++maxCoord;
                }
                if (e.getValue() > 0.0f) {
                    if (!c.isProhibited()) {
                        sumExpl.addDetail(e);
                        sum += e.getValue();
                        ++coord;
                        continue;
                    }
                    return new Explanation(0.0f, "match prohibited");
                }
                if (!c.isRequired()) continue;
                return new Explanation(0.0f, "match required");
            }
            sumExpl.setValue(sum);
            if (coord == 1) {
                sumExpl = sumExpl.getDetails()[0];
            }
            if ((coordFactor = this.similarity.coord(coord, maxCoord)) == 1.0f) {
                return sumExpl;
            }
            Explanation result = new Explanation();
            result.setDescription("product of:");
            result.addDetail(sumExpl);
            result.addDetail(new Explanation(coordFactor, "coord(" + coord + "/" + maxCoord + ")"));
            result.setValue(sum * coordFactor);
            return result;
        }
    }

    private class BooleanWeight2
    extends BooleanWeight {
        public BooleanWeight2(Searcher searcher) throws IOException {
            super(searcher);
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            BooleanScorer2 result = new BooleanScorer2(this.similarity, BooleanQuery.this.minNrShouldMatch);
            for (int i = 0; i < this.weights.size(); ++i) {
                BooleanClause c = (BooleanClause)BooleanQuery.this.clauses.elementAt(i);
                Weight w = (Weight)this.weights.elementAt(i);
                Scorer subScorer = w.scorer(reader);
                if (subScorer != null) {
                    result.add(subScorer, c.isRequired(), c.isProhibited());
                    continue;
                }
                if (!c.isRequired()) continue;
                return null;
            }
            return result;
        }
    }

    public static class TooManyClauses
    extends RuntimeException {
    }
}

