/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core;

import java.util.StringTokenizer;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaModelStatus;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.parser.Scanner;
import org.eclipse.wst.jsdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.wst.jsdt.internal.core.ClasspathEntry;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public final class JavaConventions {
    private static final char DOT = '.';
    private static final String PACKAGE_INFO = new String(TypeConstants.PACKAGE_INFO_NAME);
    private static final Scanner SCANNER = new Scanner(false, true, false, 0x2F0000L, null, null, true);

    private JavaConventions() {
    }

    public static boolean isOverlappingRoots(IPath iPath, IPath iPath2) {
        if (iPath == null || iPath2 == null) {
            return false;
        }
        String string = iPath.getFileExtension();
        String string2 = iPath2.getFileExtension();
        if (string != null && (string.equalsIgnoreCase("JAR") || string.equalsIgnoreCase("ZIP"))) {
            return false;
        }
        if (string2 != null && (string2.equalsIgnoreCase("JAR") || string2.equalsIgnoreCase("ZIP"))) {
            return false;
        }
        return iPath.isPrefixOf(iPath2) || iPath2.isPrefixOf(iPath);
    }

    private static synchronized char[] scannedIdentifier(String string, String string2, String string3) {
        block7: {
            if (string == null) {
                return null;
            }
            JavaConventions.SCANNER.sourceLevel = string2 == null ? 0x2F0000L : CompilerOptions.versionToJdkLevel(string2);
            JavaConventions.SCANNER.complianceLevel = string3 == null ? 0x2F0000L : CompilerOptions.versionToJdkLevel(string3);
            try {
                SCANNER.setSource(string.toCharArray());
                int n = SCANNER.scanIdentifier();
                if (n == 32) break block7;
                return null;
            }
            catch (InvalidInputException invalidInputException) {
                return null;
            }
        }
        if (JavaConventions.SCANNER.currentPosition == JavaConventions.SCANNER.eofPosition) {
            try {
                return SCANNER.getCurrentIdentifierSource();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
        }
        return null;
    }

    public static IStatus validateCompilationUnitName(String string) {
        return JavaConventions.validateCompilationUnitName(string, "1.3", "1.3");
    }

    public static IStatus validateCompilationUnitName(String string, String string2, String string3) {
        if (string == null) {
            return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.convention_unit_nullName, null);
        }
        if (!Util.isJavaLikeFileName(string)) {
            return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.convention_unit_notJavaName, null);
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.convention_unit_notJavaName, null);
        }
        string.substring(0, n);
        return JavaModelStatus.VERIFIED_OK;
    }

    public static IStatus validateClassFileName(String string) {
        return JavaConventions.validateClassFileName(string, "1.3", "1.3");
    }

    public static IStatus validateClassFileName(String string, String string2, String string3) {
        if (string == null) {
            return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.convention_classFile_nullName, null);
        }
        if (!org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(string)) {
            return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.convention_classFile_notClassFileName, null);
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.convention_classFile_notClassFileName, null);
        }
        string.substring(0, n);
        IStatus iStatus = ResourcesPlugin.getWorkspace().validateName(string, 1);
        if (!iStatus.isOK()) {
            return iStatus;
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    public static IStatus validateFieldName(String string) {
        return JavaConventions.validateIdentifier(string, "1.3", "1.3");
    }

    public static IStatus validateFieldName(String string, String string2, String string3) {
        return JavaConventions.validateIdentifier(string, string2, string3);
    }

    public static IStatus validateIdentifier(String string) {
        return JavaConventions.validateIdentifier(string, "1.3", "1.3");
    }

    public static IStatus validateIdentifier(String string, String string2, String string3) {
        if (JavaConventions.scannedIdentifier(string, string2, string3) != null) {
            return JavaModelStatus.VERIFIED_OK;
        }
        return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.bind(Messages.convention_illegalIdentifier, string), null);
    }

    public static IStatus validateImportDeclaration(String string) {
        return JavaConventions.validateImportDeclaration(string, "1.3", "1.3");
    }

    public static IStatus validateImportDeclaration(String string, String string2, String string3) {
        if (string == null || string.length() == 0) {
            return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.convention_import_nullImport, null);
        }
        if (string.charAt(string.length() - 1) == '*') {
            if (string.charAt(string.length() - 2) == '.') {
                return JavaConventions.validatePackageName(string.substring(0, string.length() - 2), string2, string3);
            }
            return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.convention_import_unqualifiedImport, null);
        }
        return JavaConventions.validatePackageName(string, string2, string3);
    }

    public static IStatus validateJavaTypeName(String string) {
        return JavaConventions.validateJavaTypeName(string, "1.3", "1.3");
    }

    public static IStatus validateJavaTypeName(String string, String string2, String string3) {
        String string4;
        char[] cArray;
        if (string == null) {
            return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.convention_type_nullName, null);
        }
        String string5 = string.trim();
        if (!string.equals(string5)) {
            return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.convention_type_nameWithBlanks, null);
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            cArray = JavaConventions.scannedIdentifier(string, string2, string3);
        } else {
            string4 = string.substring(0, n).trim();
            IStatus iStatus = JavaConventions.validatePackageName(string4, string2, string3);
            if (!iStatus.isOK()) {
                return iStatus;
            }
            String string6 = string.substring(n + 1).trim();
            cArray = JavaConventions.scannedIdentifier(string6, string2, string3);
        }
        if (cArray != null) {
            string4 = ResourcesPlugin.getWorkspace().validateName(new String(cArray), 1);
            if (!string4.isOK()) {
                return string4;
            }
            if (CharOperation.contains('$', cArray)) {
                return new Status(2, "org.eclipse.wst.jsdt.core", -1, Messages.convention_type_dollarName, null);
            }
            if (cArray.length > 0 && ScannerHelper.isLowerCase(cArray[0])) {
                return new Status(2, "org.eclipse.wst.jsdt.core", -1, Messages.convention_type_lowercaseName, null);
            }
            return JavaModelStatus.VERIFIED_OK;
        }
        return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.bind(Messages.convention_type_invalidName, string), null);
    }

    public static IStatus validateMethodName(String string) {
        return JavaConventions.validateMethodName(string, "1.3", "1.3");
    }

    public static IStatus validateMethodName(String string, String string2, String string3) {
        return JavaConventions.validateIdentifier(string, string2, string3);
    }

    public static IStatus validatePackageName(String string) {
        return JavaConventions.validatePackageName(string, "1.3", "1.3");
    }

    public static IStatus validatePackageName(String string, String string2, String string3) {
        if (string == null) {
            return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.convention_package_nullName, null);
        }
        int n = string.length();
        if (n == 0) {
            return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.convention_package_emptyName, null);
        }
        if (string.charAt(0) == '.' || string.charAt(n - 1) == '.') {
            return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.convention_package_dotName, null);
        }
        if (CharOperation.isWhitespace(string.charAt(0)) || CharOperation.isWhitespace(string.charAt(string.length() - 1))) {
            return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.convention_package_nameWithBlanks, null);
        }
        int n2 = 0;
        while (n2 != -1 && n2 < n - 1) {
            if ((n2 = string.indexOf(46, n2 + 1)) == -1 || n2 >= n - 1 || string.charAt(n2 + 1) != '.') continue;
            return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.convention_package_consecutiveDotsName, null);
        }
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        boolean bl = true;
        Status status = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            char[] cArray = JavaConventions.scannedIdentifier(string4 = string4.trim(), string2, string3);
            if (cArray == null) {
                return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.bind(Messages.convention_illegalIdentifier, string4), null);
            }
            IStatus iStatus = iWorkspace.validateName(new String(cArray), 2);
            if (!iStatus.isOK()) {
                return iStatus;
            }
            if (bl && cArray.length > 0 && ScannerHelper.isUpperCase(cArray[0]) && status == null) {
                status = new Status(2, "org.eclipse.wst.jsdt.core", -1, Messages.convention_package_uppercaseName, null);
            }
            bl = false;
        }
        if (status != null) {
            return status;
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    public static IJavaModelStatus validateClasspath(IJavaProject iJavaProject, IClasspathEntry[] iClasspathEntryArray, IPath iPath) {
        return ClasspathEntry.validateClasspath(iJavaProject, iClasspathEntryArray, iPath);
    }

    public static IJavaModelStatus validateClasspathEntry(IJavaProject iJavaProject, IClasspathEntry iClasspathEntry, boolean bl) {
        IJavaModelStatus iJavaModelStatus = ClasspathEntry.validateClasspathEntry(iJavaProject, iClasspathEntry, bl, true);
        if (iJavaModelStatus.getCode() == 964 && ((ClasspathEntry)iClasspathEntry).isOptional()) {
            return JavaModelStatus.VERIFIED_OK;
        }
        return iJavaModelStatus;
    }

    public static IStatus validateTypeVariableName(String string) {
        return JavaConventions.validateIdentifier(string, "1.3", "1.3");
    }

    public static IStatus validateTypeVariableName(String string, String string2, String string3) {
        return JavaConventions.validateIdentifier(string, string2, string3);
    }
}

