/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core;

import java.util.ArrayList;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public final class Signature {
    public static final char C_BOOLEAN = 'Z';
    public static final char C_BYTE = 'B';
    public static final char C_CHAR = 'C';
    public static final char C_DOUBLE = 'D';
    public static final char C_FLOAT = 'F';
    public static final char C_INT = 'I';
    public static final char C_SEMICOLON = ';';
    public static final char C_COLON = ':';
    public static final char C_LONG = 'J';
    public static final char C_SHORT = 'S';
    public static final char C_VOID = 'V';
    public static final char C_ANY = 'A';
    public static final char C_TYPE_VARIABLE = 'T';
    public static final char C_STAR = '*';
    public static final char C_EXCEPTION_START = '^';
    public static final char C_EXTENDS = '+';
    public static final char C_SUPER = '-';
    public static final char C_DOT = '.';
    public static final char C_DOLLAR = '$';
    public static final char C_ARRAY = '[';
    public static final char C_RESOLVED = 'L';
    public static final char C_COMPILATION_UNIT = 'X';
    public static final char C_UNRESOLVED = 'Q';
    public static final char C_NAME_END = ';';
    public static final char C_PARAM_START = '(';
    public static final char C_PARAM_END = ')';
    public static final char C_GENERIC_START = '<';
    public static final char C_GENERIC_END = '>';
    public static final char C_CAPTURE = '!';
    public static final String SIG_BOOLEAN = "Z";
    public static final String SIG_BYTE = "B";
    public static final String SIG_CHAR = "C";
    public static final String SIG_DOUBLE = "D";
    public static final String SIG_FLOAT = "F";
    public static final String SIG_INT = "I";
    public static final String SIG_LONG = "J";
    public static final String SIG_SHORT = "S";
    public static final String SIG_VOID = "V";
    public static final String SIG_ANY = "A";
    public static final String SIG_COMPILATION_UNIT = "X";
    public static final int CLASS_TYPE_SIGNATURE = 1;
    public static final int BASE_TYPE_SIGNATURE = 2;
    public static final int TYPE_VARIABLE_SIGNATURE = 3;
    public static final int ARRAY_TYPE_SIGNATURE = 4;
    public static final int WILDCARD_TYPE_SIGNATURE = 5;
    public static final int CAPTURE_TYPE_SIGNATURE = 6;
    private static final char[] BOOLEAN = "boolean".toCharArray();
    private static final char[] BYTE = "byte".toCharArray();
    private static final char[] CHAR = "char".toCharArray();
    private static final char[] DOUBLE = "double".toCharArray();
    private static final char[] FLOAT = "float".toCharArray();
    private static final char[] INT = "int".toCharArray();
    private static final char[] LONG = "long".toCharArray();
    private static final char[] SHORT = "short".toCharArray();
    private static final char[] VOID = "void".toCharArray();
    private static final char[] EXTENDS = "extends".toCharArray();
    private static final char[] SUPER = "super".toCharArray();
    private static final char[] CAPTURE = "capture-of".toCharArray();
    public static final char[] ANY = "any".toCharArray();

    private Signature() {
    }

    private static int checkName(char[] cArray, char[] cArray2, int n, int n2) {
        if (CharOperation.fragmentEquals(cArray, cArray2, n, true)) {
            if ((n += cArray.length) == n2) {
                return n;
            }
            char c = cArray2[n];
            switch (c) {
                case ' ': 
                case ',': 
                case '.': 
                case '<': 
                case '>': 
                case '[': {
                    return n;
                }
            }
            if (ScannerHelper.isWhitespace(c)) {
                return n;
            }
        }
        return -1;
    }

    public static char[] createArraySignature(char[] cArray, int n) {
        if (n == 0) {
            return cArray;
        }
        int n2 = cArray.length;
        char[] cArray2 = new char[n + n2];
        int n3 = 0;
        while (n3 < n) {
            cArray2[n3] = 91;
            ++n3;
        }
        System.arraycopy(cArray, 0, cArray2, n, n2);
        return cArray2;
    }

    public static String createArraySignature(String string, int n) {
        return new String(Signature.createArraySignature(string.toCharArray(), n));
    }

    public static char[] createMethodSignature(char[][] cArray, char[] cArray2) {
        int n = cArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 += cArray[n3].length;
            ++n3;
        }
        n3 = cArray2.length;
        char[] cArray3 = new char[1 + n2 + 1 + n3];
        cArray3[0] = 40;
        int n4 = 1;
        int n5 = 0;
        while (n5 < n) {
            char[] cArray4 = cArray[n5];
            int n6 = cArray4.length;
            System.arraycopy(cArray4, 0, cArray3, n4, n6);
            n4 += n6;
            ++n5;
        }
        cArray3[n4] = 41;
        System.arraycopy(cArray2, 0, cArray3, n4 + 1, n3);
        return cArray3;
    }

    public static String createMethodSignature(String[] stringArray, String string) {
        int n = stringArray.length;
        char[][] cArrayArray = new char[n][];
        int n2 = 0;
        while (n2 < n) {
            cArrayArray[n2] = stringArray[n2].toCharArray();
            ++n2;
        }
        return new String(Signature.createMethodSignature(cArrayArray, string.toCharArray()));
    }

    public static char[] createTypeParameterSignature(char[] cArray, char[][] cArray2) {
        int n = cArray2.length;
        if (n == 0) {
            return CharOperation.append(cArray, ':');
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 += cArray2[n3].length + 1;
            ++n3;
        }
        n3 = cArray.length;
        char[] cArray3 = new char[n3 + n2];
        System.arraycopy(cArray, 0, cArray3, 0, n3);
        int n4 = n3;
        int n5 = 0;
        while (n5 < n) {
            cArray3[n4++] = 58;
            int n6 = cArray2[n5].length;
            System.arraycopy(cArray2[n5], 0, cArray3, n4, n6);
            n4 += n6;
            ++n5;
        }
        return cArray3;
    }

    public static String createTypeParameterSignature(String string, String[] stringArray) {
        int n = stringArray.length;
        char[][] cArrayArray = new char[n][];
        int n2 = 0;
        while (n2 < n) {
            cArrayArray[n2] = stringArray[n2].toCharArray();
            ++n2;
        }
        return new String(Signature.createTypeParameterSignature(string.toCharArray(), cArrayArray));
    }

    public static String createTypeSignature(char[] cArray, boolean bl) {
        return new String(Signature.createCharArrayTypeSignature(cArray, bl));
    }

    public static char[] createCharArrayTypeSignature(char[] cArray, boolean bl) {
        if (cArray == null) {
            return new char[]{'A'};
        }
        int n = cArray.length;
        if (n == 0) {
            throw new IllegalArgumentException(new String(cArray));
        }
        StringBuffer stringBuffer = new StringBuffer(5);
        int n2 = Signature.encodeTypeSignature(cArray, 0, bl, n, stringBuffer);
        if ((n2 = Signature.consumeWhitespace(cArray, n2, n)) < n) {
            throw new IllegalArgumentException(new String(cArray));
        }
        n = stringBuffer.length();
        char[] cArray2 = new char[n];
        stringBuffer.getChars(0, n, cArray2, 0);
        return cArray2;
    }

    private static int consumeWhitespace(char[] cArray, int n, int n2) {
        while (n < n2) {
            char c = cArray[n];
            if (c != ' ' && !CharOperation.isWhitespace(c)) break;
            ++n;
        }
        return n;
    }

    private static int encodeQualifiedName(char[] cArray, int n, int n2, StringBuffer stringBuffer) {
        int n3 = 0;
        int n4 = 0;
        block4: while (n < n2) {
            int n5 = cArray[n];
            switch (n5) {
                case 44: 
                case 60: 
                case 62: 
                case 91: {
                    break block4;
                }
                case 46: {
                    stringBuffer.append('.');
                    n4 = 46;
                    ++n3;
                    break;
                }
                default: {
                    if (n5 == 32 || ScannerHelper.isWhitespace((char)n5)) {
                        if (n4 == 46) {
                            n = Signature.consumeWhitespace(cArray, n, n2) - 1;
                            break;
                        }
                        int n6 = Signature.checkNextChar(cArray, '.', n, n2, true);
                        if (n6 <= 0) break block4;
                        stringBuffer.append('.');
                        n4 = 46;
                        ++n3;
                        n = n6;
                        break;
                    }
                    stringBuffer.append((char)n5);
                    n4 = n5;
                    ++n3;
                }
            }
            ++n;
        }
        if (n3 == 0) {
            throw new IllegalArgumentException(new String(cArray));
        }
        return n;
    }

    private static int encodeArrayDimension(char[] cArray, int n, int n2, StringBuffer stringBuffer) {
        int n3;
        while (n < n2 && (n3 = Signature.checkNextChar(cArray, '[', n, n2, true)) > 0) {
            n = Signature.checkNextChar(cArray, ']', n3, n2, false);
            stringBuffer.append('[');
        }
        return n;
    }

    private static int checkArrayDimension(char[] cArray, int n, int n2) {
        int n3 = 0;
        while (n < n2) {
            switch (cArray[n]) {
                case '<': {
                    ++n3;
                    break;
                }
                case ',': {
                    if (n3 != 0) break;
                    return -1;
                }
                case '>': {
                    if (n3 == 0) {
                        return -1;
                    }
                    --n3;
                    break;
                }
                case '[': {
                    if (n3 != 0) break;
                    return n;
                }
            }
            ++n;
        }
        return -1;
    }

    private static int checkNextChar(char[] cArray, char c, int n, int n2, boolean bl) {
        if ((n = Signature.consumeWhitespace(cArray, n, n2)) < n2 && cArray[n] == c) {
            return n + 1;
        }
        if (!bl) {
            throw new IllegalArgumentException(new String(cArray));
        }
        return -1;
    }

    private static int encodeTypeSignature(char[] cArray, int n, boolean bl, int n2, StringBuffer stringBuffer) {
        int n3;
        int n4 = n;
        if ((n4 = Signature.consumeWhitespace(cArray, n4, n2)) >= n2) {
            throw new IllegalArgumentException(new String(cArray));
        }
        char c = cArray[n4];
        switch (c) {
            case 'b': {
                n3 = Signature.checkName(BOOLEAN, cArray, n4, n2);
                if (n3 > 0) {
                    n4 = Signature.encodeArrayDimension(cArray, n3, n2, stringBuffer);
                    stringBuffer.append('Z');
                    return n4;
                }
                n3 = Signature.checkName(BYTE, cArray, n4, n2);
                if (n3 <= 0) break;
                n4 = Signature.encodeArrayDimension(cArray, n3, n2, stringBuffer);
                stringBuffer.append('B');
                return n4;
            }
            case 'd': {
                n3 = Signature.checkName(DOUBLE, cArray, n4, n2);
                if (n3 <= 0) break;
                n4 = Signature.encodeArrayDimension(cArray, n3, n2, stringBuffer);
                stringBuffer.append('D');
                return n4;
            }
            case 'f': {
                n3 = Signature.checkName(FLOAT, cArray, n4, n2);
                if (n3 <= 0) break;
                n4 = Signature.encodeArrayDimension(cArray, n3, n2, stringBuffer);
                stringBuffer.append('F');
                return n4;
            }
            case 'i': {
                n3 = Signature.checkName(INT, cArray, n4, n2);
                if (n3 <= 0) break;
                n4 = Signature.encodeArrayDimension(cArray, n3, n2, stringBuffer);
                stringBuffer.append('I');
                return n4;
            }
            case 'l': {
                n3 = Signature.checkName(LONG, cArray, n4, n2);
                if (n3 <= 0) break;
                n4 = Signature.encodeArrayDimension(cArray, n3, n2, stringBuffer);
                stringBuffer.append('J');
                return n4;
            }
            case 's': {
                n3 = Signature.checkName(SHORT, cArray, n4, n2);
                if (n3 <= 0) break;
                n4 = Signature.encodeArrayDimension(cArray, n3, n2, stringBuffer);
                stringBuffer.append('S');
                return n4;
            }
            case 'v': {
                n3 = Signature.checkName(VOID, cArray, n4, n2);
                if (n3 <= 0) break;
                n4 = Signature.encodeArrayDimension(cArray, n3, n2, stringBuffer);
                stringBuffer.append('V');
                return n4;
            }
            case 'c': {
                n3 = Signature.checkName(CHAR, cArray, n4, n2);
                if (n3 > 0) {
                    n4 = Signature.encodeArrayDimension(cArray, n3, n2, stringBuffer);
                    stringBuffer.append('C');
                    return n4;
                }
                n3 = Signature.checkName(CAPTURE, cArray, n4, n2);
                if (n3 <= 0 || cArray[n4 = Signature.consumeWhitespace(cArray, n3, n2)] != '?') break;
                stringBuffer.append('!');
            }
            case '?': {
                n4 = Signature.consumeWhitespace(cArray, n4 + 1, n2);
                n3 = Signature.checkName(EXTENDS, cArray, n4, n2);
                if (n3 > 0) {
                    stringBuffer.append('+');
                    n4 = Signature.encodeTypeSignature(cArray, n3, bl, n2, stringBuffer);
                    return n4;
                }
                n3 = Signature.checkName(SUPER, cArray, n4, n2);
                if (n3 > 0) {
                    stringBuffer.append('-');
                    n4 = Signature.encodeTypeSignature(cArray, n3, bl, n2, stringBuffer);
                    return n4;
                }
                stringBuffer.append('*');
                return n4;
            }
        }
        n3 = Signature.checkArrayDimension(cArray, n4, n2);
        int n5 = n3 > 0 ? Signature.encodeArrayDimension(cArray, n3, n2, stringBuffer) : -1;
        stringBuffer.append(bl ? (char)'L' : 'Q');
        while (true) {
            if ((n3 = Signature.checkNextChar(cArray, '<', n4 = Signature.encodeQualifiedName(cArray, n4, n2, stringBuffer), n2, true)) > 0) {
                stringBuffer.append('<');
                n4 = Signature.encodeTypeSignature(cArray, n3, bl, n2, stringBuffer);
                while ((n3 = Signature.checkNextChar(cArray, ',', n4, n2, true)) > 0) {
                    n4 = Signature.encodeTypeSignature(cArray, n3, bl, n2, stringBuffer);
                }
                n4 = Signature.checkNextChar(cArray, '>', n4, n2, false);
                stringBuffer.append('>');
            }
            if ((n3 = Signature.checkNextChar(cArray, '.', n4, n2, true)) <= 0) break;
            stringBuffer.append('.');
            n4 = n3;
        }
        stringBuffer.append(';');
        if (n5 > 0) {
            n4 = n5;
        }
        return n4;
    }

    public static String createTypeSignature(String string, boolean bl) {
        return Signature.createTypeSignature(string == null ? null : string.toCharArray(), bl);
    }

    public static int getArrayCount(char[] cArray) throws IllegalArgumentException {
        try {
            int n = 0;
            while (cArray[n] == '[') {
                ++n;
            }
            return n;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException();
        }
    }

    public static int getArrayCount(String string) throws IllegalArgumentException {
        return Signature.getArrayCount(string.toCharArray());
    }

    public static char[] getElementType(char[] cArray) throws IllegalArgumentException {
        int n = Signature.getArrayCount(cArray);
        if (n == 0) {
            return cArray;
        }
        int n2 = cArray.length;
        char[] cArray2 = new char[n2 - n];
        System.arraycopy(cArray, n, cArray2, 0, n2 - n);
        return cArray2;
    }

    public static String getElementType(String string) throws IllegalArgumentException {
        return new String(Signature.getElementType(string.toCharArray()));
    }

    public static int getParameterCount(char[] cArray) throws IllegalArgumentException {
        if (cArray == null) {
            return 0;
        }
        try {
            int n = 0;
            int n2 = CharOperation.indexOf('(', cArray);
            if (n2 < 0) {
                throw new IllegalArgumentException();
            }
            ++n2;
            while (true) {
                if (cArray[n2] == ')') {
                    return n;
                }
                int n3 = Util.scanTypeSignature(cArray, n2);
                if (n3 < 0) {
                    throw new IllegalArgumentException();
                }
                n2 = n3 + 1;
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException();
        }
    }

    public static int getTypeSignatureKind(char[] cArray) {
        if (cArray.length < 1) {
            throw new IllegalArgumentException();
        }
        char c = cArray[0];
        if (c == '<') {
            int n = 1;
            int n2 = 1;
            int n3 = cArray.length;
            while (n2 < n3) {
                switch (cArray[n2]) {
                    case '<': {
                        ++n;
                        break;
                    }
                    case '>': {
                        --n;
                    }
                }
                if (n == 0) {
                    if (n2 + 1 >= n3) break;
                    c = cArray[n2 + 1];
                    break;
                }
                ++n2;
            }
        }
        switch (c) {
            case '[': {
                return 4;
            }
            case 'L': 
            case 'Q': {
                return 1;
            }
            case 'T': {
                return 3;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return 2;
            }
            case '*': 
            case '+': 
            case '-': {
                return 5;
            }
            case '!': {
                return 6;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int getTypeSignatureKind(String string) {
        if (string.length() < 1) {
            throw new IllegalArgumentException();
        }
        char c = string.charAt(0);
        if (c == '<') {
            int n = 1;
            int n2 = 1;
            int n3 = string.length();
            while (n2 < n3) {
                switch (string.charAt(n2)) {
                    case '<': {
                        ++n;
                        break;
                    }
                    case '>': {
                        --n;
                    }
                }
                if (n == 0) {
                    if (n2 + 1 >= n3) break;
                    c = string.charAt(n2 + 1);
                    break;
                }
                ++n2;
            }
        }
        switch (c) {
            case '[': {
                return 4;
            }
            case 'L': 
            case 'Q': {
                return 1;
            }
            case 'T': {
                return 3;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return 2;
            }
            case '*': 
            case '+': 
            case '-': {
                return 5;
            }
            case '!': {
                return 6;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int getParameterCount(String string) throws IllegalArgumentException {
        return Signature.getParameterCount(string.toCharArray());
    }

    public static char[][] getParameterTypes(char[] cArray) throws IllegalArgumentException {
        try {
            int n = Signature.getParameterCount(cArray);
            char[][] cArrayArray = new char[n][];
            if (n == 0) {
                return cArrayArray;
            }
            int n2 = CharOperation.indexOf('(', cArray);
            if (n2 < 0) {
                throw new IllegalArgumentException();
            }
            ++n2;
            int n3 = 0;
            while (true) {
                if (cArray[n2] == ')') {
                    return cArrayArray;
                }
                int n4 = Util.scanTypeSignature(cArray, n2);
                if (n4 < 0) {
                    throw new IllegalArgumentException();
                }
                cArrayArray[n3] = CharOperation.subarray(cArray, n2, n4 + 1);
                ++n3;
                n2 = n4 + 1;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException();
        }
    }

    public static String[] getParameterTypes(String string) throws IllegalArgumentException {
        char[][] cArray = Signature.getParameterTypes(string.toCharArray());
        return CharOperation.toStrings(cArray);
    }

    public static String[] getThrownExceptionTypes(String string) throws IllegalArgumentException {
        char[][] cArray = Signature.getThrownExceptionTypes(string.toCharArray());
        return CharOperation.toStrings(cArray);
    }

    public static char[][] getThrownExceptionTypes(char[] cArray) throws IllegalArgumentException {
        int n = CharOperation.indexOf('^', cArray);
        if (n == -1) {
            int n2;
            int n3 = CharOperation.lastIndexOf(')', cArray);
            if (n3 == -1) {
                throw new IllegalArgumentException();
            }
            n = Util.scanTypeSignature(cArray, n3 + 1) + 1;
            if (n == (n2 = cArray.length)) {
                return CharOperation.NO_CHAR_CHAR;
            }
            throw new IllegalArgumentException();
        }
        int n4 = cArray.length;
        int n5 = n;
        ArrayList<char[]> arrayList = new ArrayList<char[]>(1);
        while (n5 < n4) {
            if (cArray[n5] == '^') {
                ++n5;
            } else {
                throw new IllegalArgumentException();
            }
            n5 = Util.scanTypeSignature(cArray, n5) + 1;
            arrayList.add(CharOperation.subarray(cArray, ++n, n5));
            n = n5;
        }
        char[][] cArrayArray = new char[arrayList.size()][];
        arrayList.toArray((T[])cArrayArray);
        return cArrayArray;
    }

    public static char[][] getTypeArguments(char[] cArray) throws IllegalArgumentException {
        int n = cArray.length;
        if (n < 2 || cArray[n - 2] != '>') {
            return CharOperation.NO_CHAR_CHAR;
        }
        int n2 = 1;
        int n3 = n - 2;
        while (n3 >= 0 && n2 > 0) {
            switch (cArray[--n3]) {
                case '<': {
                    --n2;
                    break;
                }
                case '>': {
                    ++n2;
                }
            }
        }
        if (n3 < 0) {
            throw new IllegalArgumentException();
        }
        ArrayList<char[]> arrayList = new ArrayList<char[]>();
        int n4 = n3 + 1;
        while (true) {
            int n5;
            if (n4 >= cArray.length) {
                throw new IllegalArgumentException();
            }
            char c = cArray[n4];
            if (c == '>') {
                n5 = arrayList.size();
                char[][] cArrayArray = new char[n5][];
                arrayList.toArray((T[])cArrayArray);
                return cArrayArray;
            }
            n5 = Util.scanTypeArgumentSignature(cArray, n4);
            arrayList.add(CharOperation.subarray(cArray, n4, n5 + 1));
            n4 = n5 + 1;
        }
    }

    public static String[] getTypeArguments(String string) throws IllegalArgumentException {
        char[][] cArray = Signature.getTypeArguments(string.toCharArray());
        return CharOperation.toStrings(cArray);
    }

    public static char[] getTypeErasure(char[] cArray) throws IllegalArgumentException {
        int n = CharOperation.indexOf('<', cArray);
        if (n == -1) {
            return cArray;
        }
        int n2 = cArray.length;
        char[] cArray2 = new char[n2];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = n;
        while (n6 < n2) {
            switch (cArray[n6]) {
                case '<': {
                    if (n5 == 0) {
                        int n7 = n6 - n4;
                        System.arraycopy(cArray, n4, cArray2, n3, n7);
                        n = n6;
                        n3 += n7;
                    }
                    ++n5;
                    break;
                }
                case '>': {
                    if (--n5 < 0) {
                        throw new IllegalArgumentException();
                    }
                    if (n5 != 0) break;
                    n4 = n6 + 1;
                }
            }
            ++n6;
        }
        if (n5 > 0) {
            throw new IllegalArgumentException();
        }
        n6 = n3 + n2 - n4;
        char[] cArray3 = new char[n6];
        System.arraycopy(cArray2, 0, cArray3, 0, n3);
        System.arraycopy(cArray, n4, cArray3, n3, n2 - n4);
        return cArray3;
    }

    public static String getTypeErasure(String string) throws IllegalArgumentException {
        return new String(Signature.getTypeErasure(string.toCharArray()));
    }

    /*
     * Unable to fully structure code
     */
    public static char[][] getTypeParameters(char[] var0) throws IllegalArgumentException {
        try {
            var1_1 = var0.length;
            if (var1_1 == 0) {
                return CharOperation.NO_CHAR_CHAR;
            }
            if (var0[0] != '<') {
                return CharOperation.NO_CHAR_CHAR;
            }
            var2_2 = new ArrayList<char[]>(1);
            var3_3 = 1;
            var4_4 = 1;
            while (var4_4 < var1_1) {
                if (var0[var4_4] == '>') {
                    var5_5 = var2_2.size();
                    if (var5_5 == 0) {
                        throw new IllegalArgumentException();
                    }
                    var6_6 = new char[var5_5][];
                    var2_2.toArray((T[])var6_6);
                    return var6_6;
                }
                if ((var4_4 = CharOperation.indexOf(':', var0, var4_4)) >= 0 && var4_4 < var1_1) ** GOTO lbl46
                throw new IllegalArgumentException();
lbl-1000:
                // 1 sources

                {
                    switch (var0[++var4_4]) {
                        case ':': {
                            break;
                        }
                        case '>': {
                            break;
                        }
                        case 'L': {
                            try {
                                var4_4 = Util.scanClassTypeSignature(var0, var4_4);
                                ++var4_4;
                            }
                            catch (IllegalArgumentException v0) {}
                            continue block16;
                        }
                        case '[': {
                            try {
                                var4_4 = Util.scanArrayTypeSignature(var0, var4_4);
                                ++var4_4;
                            }
                            catch (IllegalArgumentException v1) {}
                            continue block16;
                        }
                        case 'T': {
                            try {
                                var4_4 = Util.scanTypeVariableSignature(var0, var4_4);
                                ++var4_4;
                                break;
                            }
                            catch (IllegalArgumentException v2) {}
                        }
                    }
lbl46:
                    // 10 sources

                    ** while (var0[var4_4] == ':')
                }
lbl47:
                // 1 sources

                var2_2.add(CharOperation.subarray(var0, var3_3, var4_4));
                var3_3 = var4_4;
            }
        }
        catch (ArrayIndexOutOfBoundsException v3) {}
        throw new IllegalArgumentException();
    }

    public static String[] getTypeParameters(String string) throws IllegalArgumentException {
        char[][] cArray = Signature.getTypeParameters(string.toCharArray());
        return CharOperation.toStrings(cArray);
    }

    public static String getTypeVariable(String string) throws IllegalArgumentException {
        return new String(Signature.getTypeVariable(string.toCharArray()));
    }

    public static char[] getTypeVariable(char[] cArray) throws IllegalArgumentException {
        int n = CharOperation.indexOf(':', cArray);
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        return CharOperation.subarray(cArray, 0, n);
    }

    public static char[][] getTypeParameterBounds(char[] cArray) throws IllegalArgumentException {
        int n = CharOperation.indexOf(':', cArray);
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == cArray.length - 1) {
            return CharOperation.NO_CHAR_CHAR;
        }
        int n2 = CharOperation.indexOf(':', cArray, n + 1);
        if (n2 < 0) {
            char[] cArray2 = CharOperation.subarray(cArray, n + 1, cArray.length);
            return new char[][]{cArray2};
        }
        char[] cArray3 = n2 == n + 1 ? (char[])null : CharOperation.subarray(cArray, n + 1, n2);
        char[][] cArray4 = CharOperation.splitOn(':', cArray, n2 + 1, cArray.length);
        if (cArray3 == null) {
            return cArray4;
        }
        int n3 = cArray4.length + 1;
        char[][] cArrayArray = new char[n3][];
        cArrayArray[0] = cArray3;
        System.arraycopy(cArray4, 0, cArrayArray, 1, cArray4.length);
        return cArrayArray;
    }

    public static String[] getTypeParameterBounds(String string) throws IllegalArgumentException {
        char[][] cArray = Signature.getTypeParameterBounds(string.toCharArray());
        return CharOperation.toStrings(cArray);
    }

    public static char[] getQualifier(char[] cArray) {
        int n = CharOperation.indexOf('<', cArray);
        int n2 = CharOperation.lastIndexOf('.', cArray, 0, n == -1 ? cArray.length - 1 : n);
        if (n2 == -1) {
            return CharOperation.NO_CHAR;
        }
        return CharOperation.subarray(cArray, 0, n2);
    }

    public static String getQualifier(String string) {
        char[] cArray = Signature.getQualifier(string.toCharArray());
        if (cArray.length == 0) {
            return org.eclipse.wst.jsdt.internal.compiler.util.Util.EMPTY_STRING;
        }
        return new String(cArray);
    }

    public static char[] getReturnType(char[] cArray) throws IllegalArgumentException {
        if (cArray == null) {
            return CharOperation.NO_CHAR;
        }
        int n = CharOperation.lastIndexOf(')', cArray);
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        int n2 = Util.scanTypeSignature(cArray, n + 1);
        return CharOperation.subarray(cArray, n + 1, n2 + 1);
    }

    public static String getReturnType(String string) throws IllegalArgumentException {
        return new String(Signature.getReturnType(string.toCharArray()));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static char[] getSignatureQualifier(char[] cArray) {
        if (cArray == null) {
            return CharOperation.NO_CHAR;
        }
        char[] cArray2 = Signature.toCharArray(cArray);
        int n = 0;
        int n2 = 0;
        block5: while (n2 < cArray.length) {
            switch (cArray[n2]) {
                case '.': {
                    ++n;
                    break;
                }
                case '<': {
                    break block5;
                }
                case '$': {
                    break block5;
                }
            }
            ++n2;
        }
        if (n > 0) {
            n2 = 0;
            while (n2 < cArray2.length) {
                if (cArray2[n2] == '.') {
                    --n;
                }
                if (n <= 0) {
                    return CharOperation.subarray(cArray2, 0, n2);
                }
                ++n2;
            }
        }
        return CharOperation.NO_CHAR;
    }

    public static String getSignatureQualifier(String string) {
        return new String(Signature.getSignatureQualifier(string == null ? null : string.toCharArray()));
    }

    public static char[] getSignatureSimpleName(char[] cArray) {
        if (cArray == null) {
            return CharOperation.NO_CHAR;
        }
        char[] cArray2 = Signature.toCharArray(cArray);
        return cArray2;
    }

    public static String getSignatureSimpleName(String string) {
        return new String(Signature.getSignatureSimpleName(string == null ? null : string.toCharArray()));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static char[] getSimpleName(char[] cArray) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        int n5 = cArray.length;
        int n6 = n5 - 1;
        block5: while (n6 >= 0) {
            switch (cArray[n6]) {
                case '.': {
                    if (n4 != 0) break;
                    n = n6;
                    break block5;
                }
                case '<': {
                    if (--n4 != 0) break;
                    n2 = n6;
                    break;
                }
                case '>': {
                    if (n4 == 0) {
                        n3 = n6;
                    }
                    ++n4;
                }
            }
            --n6;
        }
        if (n2 < 0) {
            if (n < 0) {
                return cArray;
            }
            return CharOperation.subarray(cArray, n + 1, n5);
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        int n7 = n < 0 ? 0 : n + 1;
        stringBuffer.append(cArray, n7, n2 - n7);
        Signature.appendArgumentSimpleNames(cArray, n2, n3, stringBuffer);
        stringBuffer.append(cArray, n3 + 1, n5 - n3 - 1);
        n5 = stringBuffer.length();
        char[] cArray2 = new char[n5];
        stringBuffer.getChars(0, n5, cArray2, 0);
        return cArray2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String getSimpleName(String string) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        int n5 = string.length();
        int n6 = n5 - 1;
        block5: while (n6 >= 0) {
            switch (string.charAt(n6)) {
                case '.': {
                    if (n4 != 0) break;
                    n = n6;
                    break block5;
                }
                case '<': {
                    if (--n4 != 0) break;
                    n2 = n6;
                    break;
                }
                case '>': {
                    if (n4 == 0) {
                        n3 = n6;
                    }
                    ++n4;
                }
            }
            --n6;
        }
        if (n2 < 0) {
            if (n < 0) {
                return string;
            }
            return string.substring(n + 1, n5);
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        char[] cArray = string.toCharArray();
        int n7 = n < 0 ? 0 : n + 1;
        stringBuffer.append(cArray, n7, n2 - n7);
        Signature.appendArgumentSimpleNames(cArray, n2, n3, stringBuffer);
        stringBuffer.append(cArray, n3 + 1, n5 - n3 - 1);
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void appendSimpleName(char[] cArray, int n, int n2, StringBuffer stringBuffer) {
        int n3;
        int n4;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = 0;
        if (cArray[n] == '?') {
            stringBuffer.append("?");
            n4 = Signature.consumeWhitespace(cArray, n + 1, n2 + 1);
            switch (cArray[n4]) {
                case 'e': {
                    n3 = Signature.checkName(EXTENDS, cArray, n4, n2);
                    if (n3 <= 0) break;
                    stringBuffer.append(' ').append(EXTENDS).append(' ');
                    n4 = Signature.consumeWhitespace(cArray, n3, n2 + 1);
                    break;
                }
                case 's': {
                    n3 = Signature.checkName(SUPER, cArray, n4, n2 + 1);
                    if (n3 <= 0) break;
                    stringBuffer.append(' ').append(SUPER).append(' ');
                    n4 = Signature.consumeWhitespace(cArray, n3, n2 + 1);
                    break;
                }
            }
            n = n4;
        }
        n4 = n2;
        block9: while (n4 >= n) {
            switch (cArray[n4]) {
                case '.': {
                    if (n8 != 0) break;
                    n5 = n4;
                    n3 = cArray[n];
                    if (n3 != 43 && n3 != 45) break block9;
                    stringBuffer.append((char)n3);
                    break block9;
                }
                case '<': {
                    if (--n8 != 0) break;
                    n6 = n4;
                    break;
                }
                case '>': {
                    if (n8 == 0) {
                        n7 = n4;
                    }
                    ++n8;
                }
            }
            --n4;
        }
        n4 = n5 < 0 ? n : n5 + 1;
        n3 = n6 < 0 ? n2 + 1 : n6;
        stringBuffer.append(cArray, n4, n3 - n4);
        if (n6 >= 0) {
            Signature.appendArgumentSimpleNames(cArray, n6, n7, stringBuffer);
            stringBuffer.append(cArray, n7 + 1, n2 - n7);
        }
    }

    private static void appendArgumentSimpleNames(char[] cArray, int n, int n2, StringBuffer stringBuffer) {
        stringBuffer.append('<');
        int n3 = 0;
        int n4 = -1;
        int n5 = 0;
        int n6 = n;
        while (n6 <= n2) {
            switch (cArray[n6]) {
                case '<': {
                    if (++n3 != 1) break;
                    n4 = n6 + 1;
                    break;
                }
                case '>': {
                    if (n3 == 1) {
                        if (n5 > 0) {
                            stringBuffer.append(',');
                        }
                        Signature.appendSimpleName(cArray, n4, n6 - 1, stringBuffer);
                        ++n5;
                    }
                    --n3;
                    break;
                }
                case ',': {
                    if (n3 != 1) break;
                    if (n5 > 0) {
                        stringBuffer.append(',');
                    }
                    Signature.appendSimpleName(cArray, n4, n6 - 1, stringBuffer);
                    ++n5;
                    n4 = n6 + 1;
                }
            }
            ++n6;
        }
        stringBuffer.append('>');
    }

    /*
     * Enabled aggressive block sorting
     */
    public static char[][] getSimpleNames(char[] cArray) {
        int n;
        int n2 = n = cArray == null ? 0 : cArray.length;
        if (n == 0) {
            return CharOperation.NO_CHAR_CHAR;
        }
        int n3 = 1;
        int n4 = 0;
        block4: while (n4 < n) {
            switch (cArray[n4]) {
                case '.': {
                    ++n3;
                    break;
                }
                case '<': {
                    break block4;
                }
            }
            ++n4;
        }
        char[][] cArrayArray = new char[n3][];
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n) {
            if (cArray[n7] == '<') break;
            if (cArray[n7] == '.') {
                cArrayArray[n6] = new char[n7 - n5];
                System.arraycopy(cArray, n5, cArrayArray[n6++], 0, n7 - n5);
                n5 = n7 + 1;
            }
            ++n7;
        }
        cArrayArray[n6] = new char[n - n5];
        System.arraycopy(cArray, n5, cArrayArray[n6], 0, n - n5);
        return cArrayArray;
    }

    public static String[] getSimpleNames(String string) {
        return CharOperation.toStrings(Signature.getSimpleNames(string.toCharArray()));
    }

    public static char[] removeCapture(char[] cArray) {
        return CharOperation.remove(cArray, '!');
    }

    public static String removeCapture(String string) {
        char[] cArray;
        char[] cArray2 = string.toCharArray();
        if (cArray2 == (cArray = Signature.removeCapture(cArray2))) {
            return string;
        }
        return new String(cArray);
    }

    public static char[] toCharArray(char[] cArray, char[] cArray2, char[][] cArray3, boolean bl, boolean bl2) {
        return Signature.toCharArray(cArray, cArray2, cArray3, bl, bl2, false);
    }

    public static char[] toCharArray(char[] cArray, char[] cArray2, char[][] cArray3, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        int n = CharOperation.indexOf('(', cArray);
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        StringBuffer stringBuffer = new StringBuffer(cArray.length + 10);
        if (bl2) {
            object = Signature.getReturnType(cArray);
            Signature.appendTypeSignature(object, 0, bl, stringBuffer);
            stringBuffer.append(' ');
        }
        if (cArray2 != null) {
            stringBuffer.append(cArray2);
        }
        stringBuffer.append('(');
        object = Signature.getParameterTypes(cArray);
        int n2 = 0;
        int n3 = ((char[])object).length;
        while (n2 < n3) {
            if (n2 == n3 - 1) {
                Signature.appendTypeSignature((char[])object[n2], 0, bl, stringBuffer, bl3);
            } else {
                Signature.appendTypeSignature((char[])object[n2], 0, bl, stringBuffer);
            }
            if (cArray3 != null) {
                stringBuffer.append(' ');
                stringBuffer.append(cArray3[n2]);
            }
            if (n2 != ((char[])object).length - 1) {
                stringBuffer.append(',');
                stringBuffer.append(' ');
            }
            ++n2;
        }
        stringBuffer.append(')');
        char[] cArray4 = new char[stringBuffer.length()];
        stringBuffer.getChars(0, stringBuffer.length(), cArray4, 0);
        return cArray4;
    }

    public static char[] toCharArray(char[] cArray) throws IllegalArgumentException {
        int n = cArray.length;
        if (n == 0 || cArray[0] == '(' || cArray[0] == '<') {
            return Signature.toCharArray(cArray, CharOperation.NO_CHAR, null, true, true);
        }
        StringBuffer stringBuffer = new StringBuffer(cArray.length + 10);
        Signature.appendTypeSignature(cArray, 0, true, stringBuffer);
        char[] cArray2 = new char[stringBuffer.length()];
        stringBuffer.getChars(0, stringBuffer.length(), cArray2, 0);
        return cArray2;
    }

    private static int appendTypeSignature(char[] cArray, int n, boolean bl, StringBuffer stringBuffer) {
        return Signature.appendTypeSignature(cArray, n, bl, stringBuffer, false);
    }

    private static int appendTypeSignature(char[] cArray, int n, boolean bl, StringBuffer stringBuffer, boolean bl2) {
        if (n >= cArray.length) {
            throw new IllegalArgumentException();
        }
        char c = cArray[n];
        if (bl2) {
            switch (c) {
                case '[': {
                    return Signature.appendArrayTypeSignature(cArray, n, bl, stringBuffer, true);
                }
            }
            throw new IllegalArgumentException();
        }
        switch (c) {
            case '[': {
                return Signature.appendArrayTypeSignature(cArray, n, bl, stringBuffer);
            }
            case 'L': 
            case 'Q': {
                return Signature.appendClassTypeSignature(cArray, n, bl, stringBuffer);
            }
            case 'T': {
                int n2 = Util.scanTypeVariableSignature(cArray, n);
                stringBuffer.append(cArray, n + 1, n2 - n - 1);
                return n2;
            }
            case 'Z': {
                stringBuffer.append(BOOLEAN);
                return n;
            }
            case 'B': {
                stringBuffer.append(BYTE);
                return n;
            }
            case 'C': {
                stringBuffer.append(CHAR);
                return n;
            }
            case 'X': {
                return Signature.appendCompilationUnitSignature(cArray, n, bl, stringBuffer);
            }
            case 'A': {
                stringBuffer.append(ANY);
                return n;
            }
            case 'D': {
                stringBuffer.append(DOUBLE);
                return n;
            }
            case 'F': {
                stringBuffer.append(FLOAT);
                return n;
            }
            case 'I': {
                stringBuffer.append(INT);
                return n;
            }
            case 'J': {
                stringBuffer.append(LONG);
                return n;
            }
            case 'S': {
                stringBuffer.append(SHORT);
                return n;
            }
            case 'V': {
                stringBuffer.append(VOID);
                return n;
            }
            case '!': {
                return Signature.appendCaptureTypeSignature(cArray, n, bl, stringBuffer);
            }
            case '*': 
            case '+': 
            case '-': {
                return Signature.appendTypeArgumentSignature(cArray, n, bl, stringBuffer);
            }
        }
        throw new IllegalArgumentException();
    }

    private static int appendCompilationUnitSignature(char[] cArray, int n, boolean bl, StringBuffer stringBuffer) {
        if (n >= cArray.length - 2) {
            throw new IllegalArgumentException();
        }
        char c = cArray[n];
        if (c != 'X') {
            throw new IllegalArgumentException();
        }
        int n2 = n + 1;
        stringBuffer.length();
        while (true) {
            if (n2 >= cArray.length) {
                throw new IllegalArgumentException();
            }
            c = cArray[n2];
            switch (c) {
                case ';': {
                    return n2;
                }
            }
            stringBuffer.append(c);
            ++n2;
        }
    }

    private static int appendArrayTypeSignature(char[] cArray, int n, boolean bl, StringBuffer stringBuffer) {
        return Signature.appendArrayTypeSignature(cArray, n, bl, stringBuffer, false);
    }

    private static int appendCaptureTypeSignature(char[] cArray, int n, boolean bl, StringBuffer stringBuffer) {
        if (n >= cArray.length - 1) {
            throw new IllegalArgumentException();
        }
        char c = cArray[n];
        if (c != '!') {
            throw new IllegalArgumentException();
        }
        stringBuffer.append(CAPTURE).append(' ');
        return Signature.appendTypeArgumentSignature(cArray, n + 1, bl, stringBuffer);
    }

    private static int appendArrayTypeSignature(char[] cArray, int n, boolean bl, StringBuffer stringBuffer, boolean bl2) {
        int n2 = cArray.length;
        if (n >= n2 - 1) {
            throw new IllegalArgumentException();
        }
        char c = cArray[n];
        if (c != '[') {
            throw new IllegalArgumentException();
        }
        int n3 = n;
        c = cArray[++n3];
        while (c == '[') {
            if (n3 >= n2 - 1) {
                throw new IllegalArgumentException();
            }
            c = cArray[++n3];
        }
        int n4 = Signature.appendTypeSignature(cArray, n3, bl, stringBuffer);
        int n5 = 1;
        int n6 = n3 - n;
        while (n5 < n6) {
            stringBuffer.append('[').append(']');
            ++n5;
        }
        if (bl2) {
            stringBuffer.append('.').append('.').append('.');
        } else {
            stringBuffer.append('[').append(']');
        }
        return n4;
    }

    private static int appendClassTypeSignature(char[] cArray, int n, boolean bl, StringBuffer stringBuffer) {
        boolean bl2;
        if (n >= cArray.length - 2) {
            throw new IllegalArgumentException();
        }
        char c = cArray[n];
        if (c != 'L' && c != 'Q') {
            throw new IllegalArgumentException();
        }
        boolean bl3 = c == 'L';
        boolean bl4 = bl2 = !bl;
        if (!bl3) {
            bl2 = false;
        }
        int n2 = n + 1;
        int n3 = stringBuffer.length();
        int n4 = -1;
        boolean bl5 = false;
        while (true) {
            if (n2 >= cArray.length) {
                throw new IllegalArgumentException();
            }
            c = cArray[n2];
            switch (c) {
                case ';': {
                    return n2;
                }
                case '<': {
                    int n5 = Signature.appendTypeArgumentSignatures(cArray, n2, bl, stringBuffer);
                    bl2 = false;
                    n2 = n5;
                    break;
                }
                case '.': {
                    if (bl2) {
                        stringBuffer.setLength(n3);
                        break;
                    }
                    stringBuffer.append('.');
                    break;
                }
                case '/': {
                    if (bl2) {
                        stringBuffer.setLength(n3);
                        break;
                    }
                    stringBuffer.append('/');
                    break;
                }
                case '$': {
                    n4 = stringBuffer.length();
                    bl5 = false;
                    if (!bl3) break;
                    bl2 = false;
                    stringBuffer.append('.');
                    break;
                }
                default: {
                    if (n4 != -1 && !bl5 && Character.isDigit(c)) {
                        bl5 = true;
                        stringBuffer.setLength(n4);
                        stringBuffer.insert(n3, "new ");
                        stringBuffer.append("(){}");
                    }
                    if (!bl5) {
                        stringBuffer.append(c);
                    }
                    n4 = -1;
                }
            }
            ++n2;
        }
    }

    private static int appendTypeArgumentSignatures(char[] cArray, int n, boolean bl, StringBuffer stringBuffer) {
        if (n >= cArray.length - 1) {
            throw new IllegalArgumentException();
        }
        char c = cArray[n];
        if (c != '<') {
            throw new IllegalArgumentException();
        }
        stringBuffer.append('<');
        int n2 = n + 1;
        int n3 = 0;
        while (true) {
            if (n2 >= cArray.length) {
                throw new IllegalArgumentException();
            }
            c = cArray[n2];
            if (c == '>') {
                stringBuffer.append('>');
                return n2;
            }
            if (n3 != 0) {
                stringBuffer.append(',');
            }
            int n4 = Signature.appendTypeArgumentSignature(cArray, n2, bl, stringBuffer);
            ++n3;
            n2 = n4 + 1;
        }
    }

    private static int appendTypeArgumentSignature(char[] cArray, int n, boolean bl, StringBuffer stringBuffer) {
        if (n >= cArray.length) {
            throw new IllegalArgumentException();
        }
        char c = cArray[n];
        switch (c) {
            case '*': {
                stringBuffer.append('?');
                return n;
            }
            case '+': {
                stringBuffer.append("? extends ");
                return Signature.appendTypeSignature(cArray, n + 1, bl, stringBuffer);
            }
            case '-': {
                stringBuffer.append("? super ");
                return Signature.appendTypeSignature(cArray, n + 1, bl, stringBuffer);
            }
        }
        return Signature.appendTypeSignature(cArray, n, bl, stringBuffer);
    }

    public static char[] toQualifiedName(char[][] cArray) {
        int n = cArray.length;
        if (n == 0) {
            return CharOperation.NO_CHAR;
        }
        if (n == 1) {
            return cArray[0];
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 += cArray[n3].length + 1;
            ++n3;
        }
        char[] cArray2 = new char[--n2];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            char[] cArray3 = cArray[n5];
            int n6 = cArray3.length;
            System.arraycopy(cArray3, 0, cArray2, n4, n6);
            n4 += n6;
            if (n5 != n - 1) {
                cArray2[n4++] = 46;
            }
            ++n5;
        }
        return cArray2;
    }

    public static String toQualifiedName(String[] stringArray) {
        int n = stringArray.length;
        char[][] cArrayArray = new char[n][];
        int n2 = 0;
        while (n2 < n) {
            cArrayArray[n2] = stringArray[n2].toCharArray();
            ++n2;
        }
        return new String(Signature.toQualifiedName(cArrayArray));
    }

    public static String toString(String string) throws IllegalArgumentException {
        return new String(Signature.toCharArray(string.toCharArray()));
    }

    public static String toString(String string, String string2, String[] stringArray, boolean bl, boolean bl2) {
        return Signature.toString(string, string2, stringArray, bl, bl2, false);
    }

    public static String toString(String string, String string2, String[] stringArray, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        if (stringArray == null) {
            object = null;
        } else {
            int n = stringArray.length;
            object = new char[n][];
            int n2 = 0;
            while (n2 < n) {
                object[n2] = stringArray[n2].toCharArray();
                ++n2;
            }
        }
        return new String(Signature.toCharArray(string.toCharArray(), string2 == null ? null : string2.toCharArray(), object, bl, bl2, bl3));
    }
}

