/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.codeassist.impl;

import java.util.Map;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.codeassist.impl.AssistOptions;
import org.eclipse.wst.jsdt.internal.codeassist.impl.AssistParser;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Initializer;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRestriction;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryType;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.ISourceType;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ImportConflictBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.parser.SourceTypeConverter;
import org.eclipse.wst.jsdt.internal.core.SearchableEnvironment;

public abstract class Engine
implements ITypeRequestor {
    public LookupEnvironment lookupEnvironment;
    protected CompilationUnitScope unitScope;
    public SearchableEnvironment nameEnvironment;
    public AssistOptions options;
    public CompilerOptions compilerOptions;
    public boolean forbiddenReferenceIsError;
    public boolean discouragedReferenceIsError;
    public boolean importCachesInitialized = false;
    public char[][][] importsCache;
    public ImportBinding[] onDemandImportsCache;
    public int importCacheCount = 0;
    public int onDemandImportCacheCount = 0;
    public char[] currentPackageName = null;

    public Engine(Map map) {
        this.options = new AssistOptions(map);
        this.compilerOptions = new CompilerOptions(map);
        this.forbiddenReferenceIsError = (this.compilerOptions.getSeverity(0x400000000L) & 1) != 0;
        this.discouragedReferenceIsError = (this.compilerOptions.getSeverity(0x80000000000L) & 1) != 0;
    }

    public void accept(IBinaryType iBinaryType, PackageBinding packageBinding, AccessRestriction accessRestriction) {
    }

    public abstract CompilationUnitDeclaration doParse(ICompilationUnit var1, AccessRestriction var2);

    public void accept(ICompilationUnit iCompilationUnit, AccessRestriction accessRestriction) {
        CompilationUnitDeclaration compilationUnitDeclaration = this.doParse(iCompilationUnit, accessRestriction);
        this.lookupEnvironment.buildTypeBindings(compilationUnitDeclaration, accessRestriction);
        this.lookupEnvironment.completeTypeBindings(compilationUnitDeclaration, true);
    }

    public void accept(ISourceType[] iSourceTypeArray, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        CompilationResult compilationResult = new CompilationResult(iSourceTypeArray[0].getFileName(), iSourceTypeArray[0].getPackageName(), 1, 1, this.compilerOptions.maxProblemsPerUnit);
        CompilationUnitDeclaration compilationUnitDeclaration = SourceTypeConverter.buildCompilationUnit(iSourceTypeArray, 15, this.lookupEnvironment.problemReporter, compilationResult);
        if (compilationUnitDeclaration != null) {
            this.lookupEnvironment.buildTypeBindings(compilationUnitDeclaration, accessRestriction);
            this.lookupEnvironment.completeTypeBindings(compilationUnitDeclaration, true);
        }
    }

    public abstract AssistParser getParser();

    public void initializeImportCaches() {
        ImportBinding[] importBindingArray = this.unitScope.imports;
        int n = importBindingArray == null ? 0 : importBindingArray.length;
        this.currentPackageName = CharOperation.concatWith(new char[0][], '.');
        int n2 = 0;
        while (n2 < n) {
            ImportBinding importBinding = importBindingArray[n2];
            if (importBinding.onDemand) {
                if (this.onDemandImportsCache == null) {
                    this.onDemandImportsCache = new ImportBinding[n - n2];
                }
                this.onDemandImportsCache[this.onDemandImportCacheCount++] = importBinding;
            } else if (!(importBinding.resolvedImport instanceof MethodBinding) || importBinding instanceof ImportConflictBinding) {
                if (this.importsCache == null) {
                    this.importsCache = new char[n - n2][][];
                }
                this.importsCache[this.importCacheCount++] = new char[][]{importBinding.compoundName[importBinding.compoundName.length - 1], CharOperation.concatWith(importBinding.compoundName, '.')};
            }
            ++n2;
        }
        this.importCachesInitialized = true;
    }

    protected boolean mustQualifyType(char[] cArray, char[] cArray2, char[] cArray3, int n) {
        if (this.unitScope == null) {
            return true;
        }
        if (!this.importCachesInitialized) {
            this.initializeImportCaches();
        }
        int n2 = 0;
        while (n2 < this.importCacheCount) {
            char[][] cArray4 = this.importsCache[n2];
            if (CharOperation.equals(cArray2, cArray4[0])) {
                char[] cArray5 = cArray3 == null || cArray3.length == 0 ? CharOperation.concat(cArray, cArray2, '.') : CharOperation.concat(CharOperation.concat(cArray, cArray3, '.'), cArray2, '.');
                return !CharOperation.equals(cArray5, cArray4[1]);
            }
            ++n2;
        }
        if ((cArray3 == null || cArray3.length == 0) && CharOperation.equals(this.currentPackageName, cArray)) {
            return false;
        }
        char[] cArray6 = null;
        int n3 = 0;
        while (n3 < this.onDemandImportCacheCount) {
            ImportBinding importBinding = this.onDemandImportsCache[n3];
            Binding binding = importBinding.resolvedImport;
            char[][] cArray7 = importBinding.compoundName;
            char[] cArray8 = CharOperation.concatWith(cArray7, '.');
            boolean bl = false;
            if (binding instanceof ReferenceBinding) {
                if (cArray3 != null && cArray3.length != 0) {
                    if (cArray6 == null) {
                        cArray6 = CharOperation.concat(cArray, cArray3, '.');
                    }
                    if (CharOperation.equals(cArray6, cArray8)) {
                        bl = importBinding.isStatic() ? (n & 8) != 0 : true;
                    }
                }
            } else if ((cArray3 == null || cArray3.length == 0) && CharOperation.equals(cArray, cArray8)) {
                bl = importBinding.isStatic() ? (n & 8) != 0 : true;
            }
            if (bl) {
                int n4 = 0;
                while (n4 < this.onDemandImportCacheCount) {
                    if (n3 != n4) {
                        Object object;
                        ImportBinding importBinding2 = this.onDemandImportsCache[n4];
                        if (importBinding2.resolvedImport instanceof ReferenceBinding) {
                            object = (ReferenceBinding)importBinding2.resolvedImport;
                            if (((ReferenceBinding)object).getMemberType(cArray2) != null) {
                                return true;
                            }
                        } else {
                            object = CharOperation.concatWith(importBinding2.compoundName, '.');
                            if (this.nameEnvironment.nameLookup.findType(String.valueOf(cArray2), String.valueOf((char[])object), false, 30, false) != null) {
                                return true;
                            }
                        }
                    }
                    ++n4;
                }
                return false;
            }
            ++n3;
        }
        return true;
    }

    protected ASTNode parseBlockStatements(CompilationUnitDeclaration compilationUnitDeclaration, int n) {
        int n2 = compilationUnitDeclaration.types.length;
        int n3 = 0;
        while (n3 < n2) {
            TypeDeclaration typeDeclaration = compilationUnitDeclaration.types[n3];
            if (typeDeclaration.declarationSourceStart < n && typeDeclaration.declarationSourceEnd >= n) {
                this.getParser().scanner.setSource(compilationUnitDeclaration.compilationResult);
                return this.parseBlockStatements(typeDeclaration, compilationUnitDeclaration, n);
            }
            ++n3;
        }
        return null;
    }

    private ASTNode parseBlockStatements(TypeDeclaration typeDeclaration, CompilationUnitDeclaration compilationUnitDeclaration, int n) {
        FieldDeclaration[] fieldDeclarationArray;
        AbstractMethodDeclaration[] abstractMethodDeclarationArray;
        int n2;
        TypeDeclaration[] typeDeclarationArray = typeDeclaration.memberTypes;
        if (typeDeclarationArray != null) {
            int n3 = typeDeclarationArray.length;
            n2 = 0;
            while (n2 < n3) {
                TypeDeclaration typeDeclaration2 = typeDeclarationArray[n2];
                if (typeDeclaration2.bodyStart <= n && typeDeclaration2.declarationSourceEnd >= n) {
                    return this.parseBlockStatements(typeDeclaration2, compilationUnitDeclaration, n);
                }
                ++n2;
            }
        }
        if ((abstractMethodDeclarationArray = typeDeclaration.methods) != null) {
            n2 = abstractMethodDeclarationArray.length;
            int n4 = 0;
            while (n4 < n2) {
                AbstractMethodDeclaration abstractMethodDeclaration = abstractMethodDeclarationArray[n4];
                if (abstractMethodDeclaration.bodyStart <= n && !abstractMethodDeclaration.isDefaultConstructor() && abstractMethodDeclaration.declarationSourceEnd >= n) {
                    this.getParser().parseBlockStatements(abstractMethodDeclaration, compilationUnitDeclaration);
                    return abstractMethodDeclaration;
                }
                ++n4;
            }
        }
        if ((fieldDeclarationArray = typeDeclaration.fields) != null) {
            int n5 = fieldDeclarationArray.length;
            int n6 = 0;
            while (n6 < n5) {
                FieldDeclaration fieldDeclaration = fieldDeclarationArray[n6];
                if (fieldDeclaration.sourceStart <= n && fieldDeclaration.declarationSourceEnd >= n) {
                    if (fieldDeclaration instanceof Initializer) {
                        this.getParser().parseBlockStatements((Initializer)fieldDeclaration, typeDeclaration, compilationUnitDeclaration);
                    }
                    return fieldDeclaration;
                }
                ++n6;
            }
        }
        return null;
    }

    protected void reset() {
        this.lookupEnvironment.reset();
    }

    public static char[] getTypeSignature(TypeBinding typeBinding) {
        return typeBinding.signature();
    }

    public static char[] getSignature(Binding binding) {
        char[] cArray = null;
        if ((binding.kind() & 4) != 0 || (binding.kind() & 0x2000) != 0) {
            TypeBinding typeBinding = (TypeBinding)binding;
            cArray = typeBinding.genericTypeSignature();
        } else if ((binding.kind() & 8) != 0) {
            MethodBinding methodBinding = (MethodBinding)binding;
            int n = methodBinding.modifiers;
            methodBinding.modifiers |= 0x40000000;
            cArray = methodBinding.genericSignature();
            if (cArray == null) {
                cArray = methodBinding.signature();
            }
            methodBinding.modifiers = n;
        }
        if (cArray != null && (binding.kind() & 4) != 0) {
            cArray = CharOperation.replaceOnCopy(cArray, '/', '.');
        }
        return cArray;
    }

    public static char[][] getSignatures(Binding[] bindingArray) {
        int n = bindingArray == null ? 0 : bindingArray.length;
        char[][] cArrayArray = new char[n][];
        int n2 = 0;
        while (n2 < n) {
            cArrayArray[n2] = Engine.getSignature(bindingArray[n2]);
            ++n2;
        }
        return cArrayArray;
    }
}

