/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.wst.jsdt.internal.compiler.ast.NameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Reference;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;

public abstract class Annotation
extends Expression {
    static final MemberValuePair[] NoValuePairs = new MemberValuePair[0];
    public int declarationSourceEnd;
    public Binding recipient;
    public TypeReference type;
    private AnnotationBinding compilerAnnotation = null;

    public static long getRetentionPolicy(char[] cArray) {
        if (cArray == null || cArray.length == 0) {
            return 0L;
        }
        switch (cArray[0]) {
            case 'C': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_CLASS)) break;
                return 0x200000000000L;
            }
            case 'S': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_SOURCE)) break;
                return 0x100000000000L;
            }
            case 'R': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_RUNTIME)) break;
                return 0x300000000000L;
            }
        }
        return 0L;
    }

    public static long getTargetElementType(char[] cArray) {
        if (cArray == null || cArray.length == 0) {
            return 0L;
        }
        switch (cArray[0]) {
            case 'A': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_ANNOTATION_TYPE)) break;
                return 0x40000000000L;
            }
            case 'C': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_CONSTRUCTOR)) break;
                return 0x10000000000L;
            }
            case 'F': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_FIELD)) break;
                return 0x2000000000L;
            }
            case 'L': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_LOCAL_VARIABLE)) break;
                return 0x20000000000L;
            }
            case 'M': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_METHOD)) break;
                return 0x4000000000L;
            }
            case 'P': {
                if (CharOperation.equals(cArray, TypeConstants.UPPER_PARAMETER)) {
                    return 0x8000000000L;
                }
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_PACKAGE)) break;
                return 0x80000000000L;
            }
            case 'T': {
                if (!CharOperation.equals(cArray, TypeConstants.TYPE)) break;
                return 0x1000000000L;
            }
        }
        return 0L;
    }

    public ElementValuePair[] computeElementValuePairs() {
        return Binding.NO_ELEMENT_VALUE_PAIRS;
    }

    private long detectStandardAnnotation(Scope scope, ReferenceBinding referenceBinding, MemberValuePair memberValuePair) {
        long l = 0L;
        switch (referenceBinding.id) {
            case 48: {
                FieldBinding fieldBinding;
                if (memberValuePair == null) break;
                Expression expression = memberValuePair.value;
                if ((expression.bits & 3) != 1 || (fieldBinding = ((Reference)expression).fieldBinding()) == null || fieldBinding.declaringClass.id != 51) break;
                l |= Annotation.getRetentionPolicy(fieldBinding.name);
                break;
            }
            case 50: {
                FieldBinding fieldBinding;
                l |= 0x800000000L;
                if (memberValuePair == null) break;
                Expression expression = memberValuePair.value;
                if (expression instanceof ArrayInitializer) {
                    ArrayInitializer arrayInitializer = (ArrayInitializer)expression;
                    Expression[] expressionArray = arrayInitializer.expressions;
                    if (expressionArray == null) break;
                    int n = 0;
                    int n2 = expressionArray.length;
                    while (n < n2) {
                        FieldBinding fieldBinding2;
                        Expression expression2 = expressionArray[n];
                        if ((expression2.bits & 3) == 1 && (fieldBinding2 = ((Reference)expression2).fieldBinding()) != null && fieldBinding2.declaringClass.id == 52) {
                            long l2 = Annotation.getTargetElementType(fieldBinding2.name);
                            if ((l & l2) != 0L) {
                                scope.problemReporter().duplicateTargetInTargetAnnotation(referenceBinding, (NameReference)expression2);
                            } else {
                                l |= l2;
                            }
                        }
                        ++n;
                    }
                    break;
                }
                if ((expression.bits & 3) != 1 || (fieldBinding = ((Reference)expression).fieldBinding()) == null || fieldBinding.declaringClass.id != 52) break;
                l |= Annotation.getTargetElementType(fieldBinding.name);
                break;
            }
            case 44: {
                l |= 0x400000000000L;
                break;
            }
            case 45: {
                l |= 0x800000000000L;
                break;
            }
            case 46: {
                l |= 0x1000000000000L;
                break;
            }
            case 47: {
                l |= 0x2000000000000L;
                break;
            }
            case 49: {
                l |= 0x4000000000000L;
            }
        }
        return l;
    }

    public AnnotationBinding getCompilerAnnotation() {
        return this.compilerAnnotation;
    }

    public abstract MemberValuePair[] memberValuePairs();

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        stringBuffer.append('@');
        this.type.printExpression(0, stringBuffer);
        return stringBuffer;
    }

    public void recordSuppressWarnings(Scope scope, int n, int n2, boolean bl) {
        long l = 0L;
        MemberValuePair[] memberValuePairArray = this.memberValuePairs();
        int n3 = 0;
        int n4 = memberValuePairArray.length;
        block0: while (n3 < n4) {
            MemberValuePair memberValuePair = memberValuePairArray[n3];
            if (CharOperation.equals(memberValuePair.name, TypeConstants.VALUE)) {
                Expression expression = memberValuePair.value;
                if (expression instanceof ArrayInitializer) {
                    ArrayInitializer arrayInitializer = (ArrayInitializer)expression;
                    Expression[] expressionArray = arrayInitializer.expressions;
                    if (expressionArray == null) break;
                    int n5 = 0;
                    int n6 = expressionArray.length;
                    while (n5 < n6) {
                        Constant constant = expressionArray[n5].constant;
                        if (constant != Constant.NotAConstant && constant.typeID() == 11) {
                            long l2 = CompilerOptions.warningTokenToIrritant(constant.stringValue());
                            if (l2 != 0L) {
                                if (((l |= l2) ^ 0xFFFFFFFFFFFFFFFFL) == 0L) {
                                    break block0;
                                }
                            } else {
                                scope.problemReporter().unhandledWarningToken(expressionArray[n5]);
                            }
                        }
                        ++n5;
                    }
                    break;
                }
                Constant constant = expression.constant;
                if (constant == Constant.NotAConstant || constant.typeID() != 11) break;
                long l3 = CompilerOptions.warningTokenToIrritant(constant.stringValue());
                if (l3 != 0L) {
                    if (((l |= l3) ^ 0xFFFFFFFFFFFFFFFFL) != 0L) break;
                    break;
                }
                scope.problemReporter().unhandledWarningToken(expression);
                break;
            }
            ++n3;
        }
        if (bl && l != 0L) {
            scope.referenceCompilationUnit().compilationResult.recordSuppressWarnings(l, n, n2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public TypeBinding resolveType(BlockScope blockScope) {
        long l;
        int n;
        MemberValuePair[] memberValuePairArray;
        if (this.compilerAnnotation != null) {
            return this.resolvedType;
        }
        this.constant = Constant.NotAConstant;
        TypeBinding typeBinding = this.type.resolveType(blockScope);
        if (typeBinding == null) {
            return null;
        }
        this.resolvedType = typeBinding;
        if (!typeBinding.isAnnotationType()) {
            blockScope.problemReporter().typeMismatchError(typeBinding, blockScope.getJavaLangAnnotationAnnotation(), this.type);
            return null;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.resolvedType;
        MethodBinding[] methodBindingArray = referenceBinding.methods();
        MemberValuePair[] memberValuePairArray2 = this.memberValuePairs();
        MemberValuePair memberValuePair = null;
        int n2 = memberValuePairArray2.length;
        if (n2 > 0) {
            memberValuePairArray = new MemberValuePair[n2];
            System.arraycopy(memberValuePairArray2, 0, memberValuePairArray, 0, n2);
        } else {
            memberValuePairArray = memberValuePairArray2;
        }
        int n3 = 0;
        int n4 = methodBindingArray.length;
        while (n3 < n4) {
            block31: {
                MethodBinding methodBinding = methodBindingArray[n3];
                char[] cArray = methodBinding.selector;
                n = 0;
                int n5 = 0;
                while (n5 < n2) {
                    char[] cArray2;
                    MemberValuePair memberValuePair2 = memberValuePairArray[n5];
                    if (memberValuePair2 != null && CharOperation.equals(cArray2 = memberValuePair2.name, cArray)) {
                        if (memberValuePair == null && CharOperation.equals(cArray2, TypeConstants.VALUE)) {
                            memberValuePair = memberValuePair2;
                        }
                        memberValuePair2.binding = methodBinding;
                        memberValuePair2.resolveTypeExpecting(blockScope, methodBinding.returnType);
                        memberValuePairArray[n5] = null;
                        n = 1;
                        boolean bl = false;
                        int n6 = n5 + 1;
                        while (n6 < n2) {
                            MemberValuePair memberValuePair3 = memberValuePairArray[n6];
                            if (memberValuePair3 != null && CharOperation.equals(memberValuePair3.name, cArray)) {
                                bl = true;
                                blockScope.problemReporter().duplicateAnnotationValue(referenceBinding, memberValuePair3);
                                memberValuePair3.binding = methodBinding;
                                memberValuePair3.resolveTypeExpecting(blockScope, methodBinding.returnType);
                                memberValuePairArray[n6] = null;
                            }
                            ++n6;
                        }
                        if (bl) {
                            blockScope.problemReporter().duplicateAnnotationValue(referenceBinding, memberValuePair2);
                            break block31;
                        }
                    }
                    ++n5;
                }
                if (n == 0 && (methodBinding.modifiers & 0x20000) == 0) {
                    blockScope.problemReporter().missingValueForAnnotationMember(this, cArray);
                }
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            if (memberValuePairArray[n3] != null) {
                blockScope.problemReporter().undefinedAnnotationValue(referenceBinding, memberValuePairArray[n3]);
                memberValuePairArray[n3].resolveTypeExpecting(blockScope, null);
            }
            ++n3;
        }
        this.compilerAnnotation = blockScope.environment().createAnnotation((ReferenceBinding)this.resolvedType, this.computeElementValuePairs());
        long l2 = this.detectStandardAnnotation(blockScope, referenceBinding, memberValuePair);
        blockScope.referenceCompilationUnit().compilationResult.recordSuppressWarnings(256L, this.sourceStart, this.declarationSourceEnd);
        if (this.recipient == null) return this.resolvedType;
        if (l2 != 0L) {
            switch (this.recipient.kind()) {
                case 16: {
                    ((PackageBinding)this.recipient).tagBits |= l2;
                    break;
                }
                case 4: 
                case 2052: {
                    SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)this.recipient;
                    sourceTypeBinding.tagBits |= l2;
                    if ((l2 & 0x4000000000000L) == 0L) break;
                    TypeDeclaration typeDeclaration = sourceTypeBinding.classScope.referenceContext;
                    n = blockScope.referenceCompilationUnit().types[0] == typeDeclaration ? 0 : typeDeclaration.declarationSourceStart;
                    this.recordSuppressWarnings(blockScope, n, typeDeclaration.declarationSourceEnd, blockScope.compilerOptions().suppressWarnings);
                    break;
                }
                case 8: {
                    MethodBinding methodBinding = (MethodBinding)this.recipient;
                    methodBinding.tagBits |= l2;
                    if ((l2 & 0x4000000000000L) == 0L) break;
                    SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)methodBinding.declaringClass;
                    AbstractMethodDeclaration abstractMethodDeclaration = sourceTypeBinding.classScope.referenceContext.declarationOf(methodBinding);
                    this.recordSuppressWarnings(blockScope, abstractMethodDeclaration.declarationSourceStart, abstractMethodDeclaration.declarationSourceEnd, blockScope.compilerOptions().suppressWarnings);
                    break;
                }
                case 1: {
                    FieldBinding fieldBinding = (FieldBinding)this.recipient;
                    fieldBinding.tagBits |= l2;
                    if ((l2 & 0x4000000000000L) == 0L) break;
                    SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)fieldBinding.declaringClass;
                    FieldDeclaration fieldDeclaration = sourceTypeBinding.classScope.referenceContext.declarationOf(fieldBinding);
                    this.recordSuppressWarnings(blockScope, fieldDeclaration.declarationSourceStart, fieldDeclaration.declarationSourceEnd, blockScope.compilerOptions().suppressWarnings);
                    break;
                }
                case 2: {
                    LocalVariableBinding localVariableBinding = (LocalVariableBinding)this.recipient;
                    localVariableBinding.tagBits |= l2;
                    if ((l2 & 0x4000000000000L) == 0L) break;
                    LocalDeclaration localDeclaration = localVariableBinding.declaration;
                    this.recordSuppressWarnings(blockScope, localDeclaration.declarationSourceStart, localDeclaration.declarationSourceEnd, blockScope.compilerOptions().suppressWarnings);
                    break;
                }
            }
        }
        if (((l = referenceBinding.getAnnotationTagBits()) & 0xFF800000000L) == 0L) {
            return this.resolvedType;
        }
        switch (this.recipient.kind()) {
            case 16: {
                if ((l & 0x80000000000L) == 0L) break;
                return this.resolvedType;
            }
            case 4: 
            case 2052: {
                if (!(((ReferenceBinding)this.recipient).isAnnotationType() ? (l & 0x41000000000L) != 0L : (l & 0x1000000000L) != 0L)) break;
                return this.resolvedType;
            }
            case 8: {
                if (!(((MethodBinding)this.recipient).isConstructor() ? (l & 0x10000000000L) != 0L : (l & 0x4000000000L) != 0L)) break;
                return this.resolvedType;
            }
            case 1: {
                if ((l & 0x2000000000L) == 0L) break;
                return this.resolvedType;
            }
            case 2: {
                if (!((((LocalVariableBinding)this.recipient).tagBits & 0x400L) != 0L ? (l & 0x8000000000L) != 0L : (referenceBinding.tagBits & 0x20000000000L) != 0L)) break;
                return this.resolvedType;
            }
        }
        blockScope.problemReporter().disallowedTargetForAnnotation(this);
        return this.resolvedType;
    }

    public abstract void traverse(ASTVisitor var1, BlockScope var2);
}

