/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ClassFile;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Annotation;
import org.eclipse.wst.jsdt.internal.compiler.ast.ImportReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Javadoc;
import org.eclipse.wst.jsdt.internal.compiler.ast.ProgramElement;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.ast.StringLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.parser.NLSTag;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortMethod;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortType;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.wst.jsdt.internal.infer.InferredMethod;
import org.eclipse.wst.jsdt.internal.infer.InferredType;

public class CompilationUnitDeclaration
extends ASTNode
implements ProblemSeverities,
ReferenceContext {
    private static final Comparator STRING_LITERAL_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            StringLiteral stringLiteral = (StringLiteral)object;
            StringLiteral stringLiteral2 = (StringLiteral)object2;
            return stringLiteral.sourceStart - stringLiteral2.sourceStart;
        }
    };
    private static final int STRING_LITERALS_INCREMENT = 10;
    public ImportReference currentPackage;
    public ImportReference[] imports;
    public TypeDeclaration[] types;
    public ProgramElement[] statements;
    public int[][] comments;
    public InferredType[] inferredTypes = new InferredType[10];
    public int numberInferredTypes = 0;
    public HashtableOfObject inferredTypesHash = new HashtableOfObject();
    public boolean ignoreFurtherInvestigation = false;
    public boolean ignoreMethodBodies = false;
    public CompilationUnitScope scope;
    public ProblemReporter problemReporter;
    public CompilationResult compilationResult;
    public LocalTypeBinding[] localTypes;
    public int localTypeCount = 0;
    public CompilationUnitBinding compilationUnitBinding;
    public boolean isPropagatingInnerClassEmulation;
    public Javadoc javadoc;
    public NLSTag[] nlsTags;
    private StringLiteral[] stringLiterals;
    private int stringLiteralsPtr;

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public CompilationUnitDeclaration(ProblemReporter problemReporter, CompilationResult compilationResult, int n) {
        this.problemReporter = problemReporter;
        this.compilationResult = compilationResult;
        this.sourceStart = 0;
        this.sourceEnd = n - 1;
    }

    public void abort(int n, CategorizedProblem categorizedProblem) {
        switch (n) {
            case 8: {
                throw new AbortType(this.compilationResult, categorizedProblem);
            }
            case 16: {
                throw new AbortMethod(this.compilationResult, categorizedProblem);
            }
        }
        throw new AbortCompilationUnit(this.compilationResult, categorizedProblem);
    }

    public void analyseCode() {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            TypeConstants typeConstants;
            int n;
            if (this.types != null) {
                n = 0;
                int n2 = this.types.length;
                while (n < n2) {
                    this.types[n].analyseCode(this.scope);
                    ++n;
                }
            }
            this.propagateInnerEmulationForAllLocalTypes();
            this.scope.temporaryAnalysisIndex = 0;
            n = this.scope.localIndex;
            Object object = this.scope.externalCompilationUnits.iterator();
            while (object.hasNext()) {
                typeConstants = (CompilationUnitScope)object.next();
                typeConstants.temporaryAnalysisIndex = n;
                n += typeConstants.localIndex;
            }
            object = FlowInfo.initial(n);
            typeConstants = new FlowContext(null, this);
            if (this.statements != null) {
                int n3 = 0;
                int n4 = this.statements.length;
                while (n3 < n4) {
                    if (this.statements[n3] instanceof AbstractMethodDeclaration) {
                        ((AbstractMethodDeclaration)this.statements[n3]).analyseCode(this.scope, null, ((FlowInfo)object).copy());
                    } else {
                        object = ((Statement)this.statements[n3]).analyseCode(this.scope, (FlowContext)typeConstants, (FlowInfo)object);
                    }
                    ++n3;
                }
            }
            this.scope.reportUnusedDeclarations();
        }
        catch (AbortCompilationUnit abortCompilationUnit) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
    }

    public void cleanUp() {
        int n;
        if (this.compilationUnitBinding != null) {
            this.compilationUnitBinding.cleanup();
        }
        if (this.types != null) {
            n = 0;
            int n2 = this.types.length;
            while (n < n2) {
                this.cleanUp(this.types[n]);
                ++n;
            }
            n = 0;
            n2 = this.localTypeCount;
            while (n < n2) {
                LocalTypeBinding localTypeBinding = this.localTypes[n];
                localTypeBinding.scope = null;
                localTypeBinding.enclosingCase = null;
                ++n;
            }
        }
        n = 0;
        while (n < this.numberInferredTypes) {
            SourceTypeBinding sourceTypeBinding = this.inferredTypes[n].binding;
            if (sourceTypeBinding != null) {
                sourceTypeBinding.cleanup();
            }
            ++n;
        }
        this.compilationResult.recoveryScannerData = null;
        ClassFile[] classFileArray = this.compilationResult.getClassFiles();
        int n3 = 0;
        int n4 = classFileArray.length;
        while (n3 < n4) {
            ClassFile classFile = classFileArray[n3];
            classFile.referenceBinding = null;
            classFile.innerClassesBindings = null;
            ++n3;
        }
    }

    private void cleanUp(TypeDeclaration typeDeclaration) {
        if (typeDeclaration.memberTypes != null) {
            int n = 0;
            int n2 = typeDeclaration.memberTypes.length;
            while (n < n2) {
                this.cleanUp(typeDeclaration.memberTypes[n]);
                ++n;
            }
        }
        if (typeDeclaration.binding != null && typeDeclaration.binding.isAnnotationType()) {
            this.compilationResult.hasAnnotations = true;
        }
        if (typeDeclaration.binding != null) {
            typeDeclaration.binding.scope = null;
        }
    }

    public void checkUnusedImports() {
        if (this.scope.imports != null) {
            int n = 0;
            int n2 = this.scope.imports.length;
            while (n < n2) {
                ImportBinding importBinding = this.scope.imports[n];
                ImportReference importReference = importBinding.reference;
                if (importReference != null && (importReference.bits & 2) == 0) {
                    this.scope.problemReporter().unusedImport(importReference);
                }
                ++n;
            }
        }
    }

    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    public TypeDeclaration declarationOfType(char[][] cArray) {
        int n = 0;
        while (n < this.types.length) {
            TypeDeclaration typeDeclaration = this.types[n].declarationOfType(cArray);
            if (typeDeclaration != null) {
                return typeDeclaration;
            }
            ++n;
        }
        return null;
    }

    public AbstractMethodDeclaration declarationOf(MethodBinding methodBinding) {
        if (methodBinding != null && this.statements != null) {
            int n = 0;
            int n2 = this.statements.length;
            while (n < n2) {
                if (this.statements[n] instanceof AbstractMethodDeclaration) {
                    AbstractMethodDeclaration abstractMethodDeclaration = (AbstractMethodDeclaration)this.statements[n];
                    if (abstractMethodDeclaration.binding == methodBinding) {
                        return abstractMethodDeclaration;
                    }
                }
                ++n;
            }
        }
        return null;
    }

    public void generateCode() {
        if (this.ignoreFurtherInvestigation) {
            if (this.types != null) {
                int n = 0;
                int n2 = this.types.length;
                while (n < n2) {
                    this.types[n].ignoreFurtherInvestigation = true;
                    this.types[n].generateCode(this.scope);
                    ++n;
                }
            }
            return;
        }
        if (this.isPackageInfo() && this.types != null && this.currentPackage.annotations != null) {
            this.types[0].annotations = this.currentPackage.annotations;
        }
        try {
            if (this.types != null) {
                int n = 0;
                int n3 = this.types.length;
                while (n < n3) {
                    this.types[n].generateCode(this.scope);
                    ++n;
                }
            }
        }
        catch (AbortCompilationUnit abortCompilationUnit) {}
    }

    public char[] getFileName() {
        return this.compilationResult.getFileName();
    }

    public char[] getMainTypeName() {
        if (this.compilationResult.compilationUnit == null) {
            int n;
            char[] cArray = this.compilationResult.getFileName();
            int n2 = CharOperation.lastIndexOf('/', cArray) + 1;
            if (n2 == 0 || n2 < CharOperation.lastIndexOf('\\', cArray)) {
                n2 = CharOperation.lastIndexOf('\\', cArray) + 1;
            }
            if ((n = CharOperation.lastIndexOf('.', cArray)) == -1) {
                n = cArray.length;
            }
            return CharOperation.subarray(cArray, n2, n);
        }
        return this.compilationResult.compilationUnit.getMainTypeName();
    }

    public boolean isEmpty() {
        return this.currentPackage == null && this.imports == null && this.types == null && this.statements == null;
    }

    public boolean isPackageInfo() {
        return CharOperation.equals(this.getMainTypeName(), TypeConstants.PACKAGE_INFO_NAME);
    }

    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    public StringBuffer print(int n, StringBuffer stringBuffer) {
        int n2;
        if (this.currentPackage != null) {
            CompilationUnitDeclaration.printIndent(n, stringBuffer).append("package ");
            this.currentPackage.print(0, stringBuffer, false).append(";\n");
        }
        if (this.imports != null) {
            n2 = 0;
            while (n2 < this.imports.length) {
                CompilationUnitDeclaration.printIndent(n, stringBuffer).append("import ");
                ImportReference importReference = this.imports[n2];
                if (importReference.isStatic()) {
                    stringBuffer.append("static ");
                }
                importReference.print(0, stringBuffer).append(";\n");
                ++n2;
            }
        }
        if (this.types != null) {
            n2 = 0;
            while (n2 < this.types.length) {
                this.types[n2].print(n, stringBuffer).append("\n");
                ++n2;
            }
        }
        if (this.statements != null) {
            n2 = 0;
            while (n2 < this.statements.length) {
                this.statements[n2].printStatement(n, stringBuffer).append("\n");
                ++n2;
            }
        }
        return stringBuffer;
    }

    public void propagateInnerEmulationForAllLocalTypes() {
        this.isPropagatingInnerClassEmulation = true;
        int n = 0;
        int n2 = this.localTypeCount;
        while (n < n2) {
            LocalTypeBinding localTypeBinding = this.localTypes[n];
            if ((localTypeBinding.classScope.referenceType().bits & Integer.MIN_VALUE) != 0) {
                localTypeBinding.updateInnerEmulationDependents();
            }
            ++n;
        }
    }

    public void recordStringLiteral(StringLiteral stringLiteral) {
        if (this.stringLiterals == null) {
            this.stringLiterals = new StringLiteral[10];
            this.stringLiteralsPtr = 0;
        } else {
            int n = this.stringLiterals.length;
            if (this.stringLiteralsPtr == n) {
                this.stringLiterals = new StringLiteral[n + 10];
                System.arraycopy(this.stringLiterals, 0, this.stringLiterals, 0, n);
            }
        }
        this.stringLiterals[this.stringLiteralsPtr++] = stringLiteral;
    }

    public void record(LocalTypeBinding localTypeBinding) {
        if (this.localTypeCount == 0) {
            this.localTypes = new LocalTypeBinding[5];
        } else if (this.localTypeCount == this.localTypes.length) {
            this.localTypes = new LocalTypeBinding[this.localTypeCount * 2];
            System.arraycopy(this.localTypes, 0, this.localTypes, 0, this.localTypeCount);
        }
        this.localTypes[this.localTypeCount++] = localTypeBinding;
    }

    public void resolve() {
        int n = 0;
        boolean bl = false;
        if (this.types != null && bl) {
            TypeDeclaration typeDeclaration = this.types[0];
            if (typeDeclaration.javadoc == null) {
                typeDeclaration.javadoc = new Javadoc(typeDeclaration.declarationSourceStart, typeDeclaration.declarationSourceStart);
            }
            typeDeclaration.resolve(this.scope);
            if (this.currentPackage != null && this.currentPackage.annotations != null) {
                CompilationUnitDeclaration.resolveAnnotations(typeDeclaration.staticInitializerScope, this.currentPackage.annotations, this.scope.getDefaultPackage());
            }
            if (this.javadoc != null) {
                this.javadoc.resolve(typeDeclaration.staticInitializerScope);
            }
            n = 1;
        } else if (this.javadoc != null) {
            this.javadoc.resolve(this.scope);
        }
        if (this.currentPackage != null && this.currentPackage.annotations != null && !bl) {
            this.scope.problemReporter().invalidFileNameForPackageAnnotations(this.currentPackage.annotations[0]);
        }
        try {
            int n2;
            if (this.types != null) {
                int n3 = n;
                n2 = this.types.length;
                while (n3 < n2) {
                    this.types[n3].resolve(this.scope);
                    ++n3;
                }
            }
            if (this.statements != null) {
                int n4 = 0;
                n2 = this.statements.length;
                while (n4 < n2) {
                    this.statements[n4].resolve(this.scope);
                    ++n4;
                }
            }
            if (!this.compilationResult.hasErrors()) {
                this.checkUnusedImports();
            }
            this.reportNLSProblems();
        }
        catch (AbortCompilationUnit abortCompilationUnit) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void reportNLSProblems() {
        block25: {
            block27: {
                block26: {
                    if (this.nlsTags == null && this.stringLiterals == null) break block25;
                    var1_1 = this.stringLiteralsPtr;
                    v0 = var2_2 = this.nlsTags == null ? 0 : this.nlsTags.length;
                    if (var1_1 != 0) break block26;
                    if (var2_2 == 0) break block25;
                    var3_3 = 0;
                    while (var3_3 < var2_2) {
                        var4_6 = this.nlsTags[var3_3];
                        if (var4_6 != null) {
                            this.scope.problemReporter().unnecessaryNLSTags(var4_6.start, var4_6.end);
                        }
                        ++var3_3;
                    }
                    break block25;
                }
                if (var2_2 != 0) break block27;
                if (this.stringLiterals.length != var1_1) {
                    this.stringLiterals = new StringLiteral[var1_1];
                    System.arraycopy(this.stringLiterals, 0, this.stringLiterals, 0, var1_1);
                }
                Arrays.sort(this.stringLiterals, CompilationUnitDeclaration.STRING_LITERAL_COMPARATOR);
                var3_4 = 0;
                while (var3_4 < var1_1) {
                    this.scope.problemReporter().nonExternalizedStringLiteral(this.stringLiterals[var3_4]);
                    ++var3_4;
                }
                break block25;
            }
            if (this.stringLiterals.length != var1_1) {
                this.stringLiterals = new StringLiteral[var1_1];
                System.arraycopy(this.stringLiterals, 0, this.stringLiterals, 0, var1_1);
            }
            Arrays.sort(this.stringLiterals, CompilationUnitDeclaration.STRING_LITERAL_COMPARATOR);
            var3_5 = 1;
            var4_7 = -1;
            var5_8 = null;
            var6_9 = 0;
            var7_10 = 0;
            block2: while (var7_10 < var1_1) {
                var5_8 = this.stringLiterals[var7_10];
                var8_11 = var5_8.lineNumber;
                if (var4_7 != var8_11) {
                    var3_5 = 1;
                    var4_7 = var8_11;
                } else {
                    ++var3_5;
                }
                if (var6_9 >= var2_2) break;
                while (var6_9 < var2_2) {
                    block24: {
                        var9_13 = this.nlsTags[var6_9];
                        if (var9_13 == null) ** GOTO lbl74
                        var10_14 = var9_13.lineNumber;
                        if (var8_11 < var10_14) {
                            this.scope.problemReporter().nonExternalizedStringLiteral(var5_8);
                        } else if (var8_11 == var10_14) {
                            if (var9_13.index == var3_5) {
                                this.nlsTags[var6_9] = null;
                                ++var6_9;
                            } else {
                                var11_15 = var6_9 + 1;
                                while (var11_15 < var2_2) {
                                    var12_16 = this.nlsTags[var11_15];
                                    if (var12_16 != null) {
                                        var13_17 = var12_16.lineNumber;
                                        if (var8_11 == var13_17) {
                                            if (var12_16.index == var3_5) {
                                                this.nlsTags[var11_15] = null;
                                                break block24;
                                            }
                                        } else {
                                            this.scope.problemReporter().nonExternalizedStringLiteral(var5_8);
                                            break block24;
                                        }
                                    }
                                    ++var11_15;
                                }
                                this.scope.problemReporter().nonExternalizedStringLiteral(var5_8);
                            }
                        } else {
                            this.scope.problemReporter().unnecessaryNLSTags(var9_13.start, var9_13.end);
lbl74:
                            // 2 sources

                            ++var6_9;
                            continue;
                        }
                    }
                    ++var7_10;
                    continue block2;
                }
                break block2;
            }
            while (var7_10 < var1_1) {
                this.scope.problemReporter().nonExternalizedStringLiteral(this.stringLiterals[var7_10]);
                ++var7_10;
            }
            if (var6_9 < var2_2) {
                while (var6_9 < var2_2) {
                    var8_12 = this.nlsTags[var6_9];
                    if (var8_12 != null) {
                        this.scope.problemReporter().unnecessaryNLSTags(var8_12.start, var8_12.end);
                    }
                    ++var6_9;
                }
            }
        }
    }

    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
    }

    public void traverse(ASTVisitor aSTVisitor, CompilationUnitScope compilationUnitScope) {
        this.traverse(aSTVisitor, this.scope, false);
    }

    public void traverse(ASTVisitor aSTVisitor, CompilationUnitScope compilationUnitScope, boolean bl) {
        if (this.ignoreFurtherInvestigation && !bl) {
            return;
        }
        try {
            if (aSTVisitor.visit(this, this.scope)) {
                if (this.types != null && this.isPackageInfo()) {
                    Annotation[] annotationArray;
                    TypeDeclaration typeDeclaration = this.types[0];
                    MethodScope methodScope = typeDeclaration.staticInitializerScope;
                    if (this.javadoc != null) {
                        this.javadoc.traverse(aSTVisitor, methodScope);
                    }
                    if (this.currentPackage != null && (annotationArray = this.currentPackage.annotations) != null) {
                        int n = annotationArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            annotationArray[n2].traverse(aSTVisitor, methodScope);
                            ++n2;
                        }
                    }
                }
                if (this.statements != null) {
                    int n = this.statements.length;
                    int n3 = 0;
                    while (n3 < n) {
                        this.statements[n3].traverse(aSTVisitor, this.scope);
                        ++n3;
                    }
                }
                this.traverseInferredTypes(aSTVisitor, compilationUnitScope);
            }
            aSTVisitor.endVisit(this, this.scope);
        }
        catch (AbortCompilationUnit abortCompilationUnit) {}
    }

    public void traverseInferredTypes(ASTVisitor aSTVisitor, BlockScope blockScope) {
        boolean bl = true;
        int n = 0;
        while (n < this.numberInferredTypes) {
            InferredType inferredType = this.inferredTypes[n];
            bl = aSTVisitor.visit(inferredType, (BlockScope)this.scope);
            int n2 = 0;
            while (n2 < inferredType.numberAttributes) {
                aSTVisitor.visit(inferredType.attributes[n2], (BlockScope)this.scope);
                ++n2;
            }
            if (inferredType.methods != null) {
                Iterator iterator = inferredType.methods.iterator();
                while (bl && iterator.hasNext()) {
                    InferredMethod inferredMethod = (InferredMethod)iterator.next();
                    aSTVisitor.visit(inferredMethod, (BlockScope)this.scope);
                }
            }
            aSTVisitor.endVisit(inferredType, (BlockScope)this.scope);
            ++n;
        }
    }

    public InferredType findInferredType(char[] cArray) {
        return (InferredType)this.inferredTypesHash.get(cArray);
    }

    public void printInferredTypes(StringBuffer stringBuffer) {
        int n = 0;
        while (n < this.numberInferredTypes) {
            InferredType inferredType = this.inferredTypes[n];
            if (inferredType.isDefinition) {
                inferredType.print(0, stringBuffer);
                stringBuffer.append("\n");
            }
            ++n;
        }
    }
}

