/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.Assignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompoundAssignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Reference;
import org.eclipse.wst.jsdt.internal.compiler.codegen.CodeStream;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class ThisReference
extends Reference {
    public static ThisReference implicitThis() {
        ThisReference thisReference = new ThisReference(0, 0);
        thisReference.bits |= 4;
        return thisReference;
    }

    public ThisReference(int n, int n2) {
        this.sourceStart = n;
        this.sourceEnd = n2;
    }

    public FlowInfo analyseAssignment(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo, Assignment assignment, boolean bl) {
        return flowInfo;
    }

    public boolean checkAccess(MethodScope methodScope) {
        if (methodScope != null && methodScope.isConstructorCall) {
            methodScope.problemReporter().fieldsOrThisBeforeConstructorInvocation(this);
            return false;
        }
        if (methodScope != null && methodScope.isStatic) {
            methodScope.problemReporter().errorThisSuperInStatic(this);
            return false;
        }
        return true;
    }

    public void generateAssignment(BlockScope blockScope, CodeStream codeStream, Assignment assignment, boolean bl) {
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        if (bl) {
            codeStream.aload_0();
        }
        if ((this.bits & 4) == 0) {
            codeStream.recordPositionsFrom(n, this.sourceStart);
        }
    }

    public void generateCompoundAssignment(BlockScope blockScope, CodeStream codeStream, Expression expression, int n, int n2, boolean bl) {
    }

    public void generatePostIncrement(BlockScope blockScope, CodeStream codeStream, CompoundAssignment compoundAssignment, boolean bl) {
    }

    public boolean isImplicitThis() {
        return (this.bits & 4) != 0;
    }

    public boolean isThis() {
        return true;
    }

    public int nullStatus(FlowInfo flowInfo) {
        return -1;
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        if (this.isImplicitThis()) {
            return stringBuffer;
        }
        return stringBuffer.append("this");
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        this.constant = Constant.NotAConstant;
        if (!this.isImplicitThis() && !this.checkAccess(blockScope.methodScope())) {
            return null;
        }
        this.resolvedType = blockScope.enclosingReceiverType();
        return this.resolvedType;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        aSTVisitor.visit(this, blockScope);
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        aSTVisitor.visit(this, classScope);
        aSTVisitor.endVisit(this, classScope);
    }
}

