/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.batch;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.batch.ClasspathDirectory;
import org.eclipse.wst.jsdt.internal.compiler.batch.ClasspathFile;
import org.eclipse.wst.jsdt.internal.compiler.batch.ClasspathJar;
import org.eclipse.wst.jsdt.internal.compiler.batch.ClasspathLocation;
import org.eclipse.wst.jsdt.internal.compiler.batch.ClasspathSourceJar;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.wst.jsdt.internal.compiler.env.INameEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.wst.jsdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.wst.jsdt.internal.compiler.util.SuffixConstants;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;

public class FileSystem
implements INameEnvironment,
SuffixConstants {
    Classpath[] classpaths;
    Set knownFileNames;

    public FileSystem(String[] stringArray, String[] stringArray2, String string) {
        int n = stringArray.length;
        this.classpaths = new Classpath[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Classpath classpath = FileSystem.getClasspath(stringArray[n3], string, null);
            try {
                classpath.initialize();
                this.classpaths[n2++] = classpath;
            }
            catch (IOException iOException) {}
            ++n3;
        }
        if (n2 != n) {
            this.classpaths = new Classpath[n2];
            System.arraycopy(this.classpaths, 0, this.classpaths, 0, n2);
        }
        this.initializeKnownFileNames(stringArray2);
    }

    FileSystem(Classpath[] classpathArray, String[] stringArray) {
        int n = classpathArray.length;
        int n2 = 0;
        this.classpaths = new Classpath[n];
        int n3 = 0;
        while (n3 < n) {
            Classpath classpath = classpathArray[n3];
            try {
                classpath.initialize();
                this.classpaths[n2++] = classpath;
            }
            catch (IOException iOException) {}
            ++n3;
        }
        if (n2 != n) {
            this.classpaths = new Classpath[n2];
            System.arraycopy(this.classpaths, 0, this.classpaths, 0, n2);
        }
        this.initializeKnownFileNames(stringArray);
    }

    public static Classpath getClasspath(String string, String string2, AccessRuleSet accessRuleSet) {
        return FileSystem.getClasspath(string, string2, false, accessRuleSet, null);
    }

    static Classpath getClasspath(String string, String string2, boolean bl, AccessRuleSet accessRuleSet, String string3) {
        ClasspathLocation classpathLocation = null;
        File file = new File(FileSystem.convertPathSeparators(string));
        if (file.isDirectory()) {
            if (file.exists()) {
                classpathLocation = new ClasspathDirectory(file, string2, bl ? 1 : 3, accessRuleSet, string3 == null || string3 == "none" ? string3 : FileSystem.convertPathSeparators(string3));
            }
        } else {
            String string4 = string.toLowerCase();
            if (string4.endsWith(".jar") || string4.endsWith(".zip")) {
                if (bl) {
                    classpathLocation = new ClasspathSourceJar(file, true, accessRuleSet, string2, string3 == null || string3 == "none" ? string3 : FileSystem.convertPathSeparators(string3));
                } else if (string3 == null) {
                    classpathLocation = new ClasspathJar(file, true, accessRuleSet, null);
                }
            } else if (string4.endsWith(".js")) {
                classpathLocation = new ClasspathFile(file, string2, accessRuleSet, string3 == null || string3 == "none" ? string3 : FileSystem.convertPathSeparators(string3));
            }
        }
        return classpathLocation;
    }

    private void initializeKnownFileNames(String[] stringArray) {
        if (stringArray == null) {
            this.knownFileNames = new HashSet(0);
            return;
        }
        this.knownFileNames = new HashSet(stringArray.length * 2);
        int n = stringArray.length;
        while (--n >= 0) {
            char[] cArray = stringArray[n].toCharArray();
            char[] cArray2 = null;
            int n2 = CharOperation.lastIndexOf('.', cArray);
            if (n2 != -1) {
                cArray = CharOperation.subarray(cArray, 0, n2);
            }
            CharOperation.replace(cArray, '\\', '/');
            int n3 = 0;
            while (n3 < this.classpaths.length) {
                char[] cArray3 = this.classpaths[n3].normalizedPath();
                if (this.classpaths[n3] instanceof ClasspathDirectory && CharOperation.prefixEquals(cArray3, cArray) && (cArray2 == null || cArray3.length < cArray2.length)) {
                    cArray2 = cArray3;
                }
                ++n3;
            }
            if (cArray2 == null) {
                this.knownFileNames.add(new String(cArray));
            } else {
                this.knownFileNames.add(new String(CharOperation.subarray(cArray, cArray2.length, cArray.length)));
            }
            cArray2 = null;
        }
    }

    public void cleanup() {
        int n = 0;
        int n2 = this.classpaths.length;
        while (n < n2) {
            this.classpaths[n].reset();
            ++n;
        }
    }

    private static String convertPathSeparators(String string) {
        return File.separatorChar == '/' ? string.replace('\\', '/') : string.replace('/', '\\');
    }

    private NameEnvironmentAnswer findClass(String string, char[] cArray, boolean bl) {
        if (this.knownFileNames.contains(string)) {
            return null;
        }
        String string2 = String.valueOf(string) + ".js";
        String string3 = string.length() == cArray.length ? Util.EMPTY_STRING : string2.substring(0, string.length() - cArray.length - 1);
        String string4 = File.separatorChar == '/' ? string3 : string3.replace('/', File.separatorChar);
        NameEnvironmentAnswer nameEnvironmentAnswer = null;
        if (string3 == string4) {
            int n = 0;
            int n2 = this.classpaths.length;
            while (n < n2) {
                NameEnvironmentAnswer nameEnvironmentAnswer2 = this.classpaths[n].findClass(cArray, string3, string2, bl);
                if (nameEnvironmentAnswer2 != null) {
                    if (!nameEnvironmentAnswer2.ignoreIfBetter()) {
                        if (nameEnvironmentAnswer2.isBetter(nameEnvironmentAnswer)) {
                            return nameEnvironmentAnswer2;
                        }
                    } else if (nameEnvironmentAnswer2.isBetter(nameEnvironmentAnswer)) {
                        nameEnvironmentAnswer = nameEnvironmentAnswer2;
                    }
                }
                ++n;
            }
        } else {
            String string5 = string2.replace('/', File.separatorChar);
            int n = 0;
            int n3 = this.classpaths.length;
            while (n < n3) {
                NameEnvironmentAnswer nameEnvironmentAnswer3;
                Classpath classpath = this.classpaths[n];
                NameEnvironmentAnswer nameEnvironmentAnswer4 = nameEnvironmentAnswer3 = classpath instanceof ClasspathJar ? classpath.findClass(cArray, string3, string2, bl) : classpath.findClass(cArray, string4, string5, bl);
                if (nameEnvironmentAnswer3 != null) {
                    if (!nameEnvironmentAnswer3.ignoreIfBetter()) {
                        if (nameEnvironmentAnswer3.isBetter(nameEnvironmentAnswer)) {
                            return nameEnvironmentAnswer3;
                        }
                    } else if (nameEnvironmentAnswer3.isBetter(nameEnvironmentAnswer)) {
                        nameEnvironmentAnswer = nameEnvironmentAnswer3;
                    }
                }
                ++n;
            }
        }
        if (nameEnvironmentAnswer != null) {
            return nameEnvironmentAnswer;
        }
        return null;
    }

    private NameEnvironmentAnswer findBinding(String string, char[] cArray, int n, ITypeRequestor iTypeRequestor) {
        if (this.knownFileNames.contains(string)) {
            return null;
        }
        String string2 = string.length() == cArray.length ? "" : string.substring(0, string.length() - cArray.length - 1);
        NameEnvironmentAnswer nameEnvironmentAnswer = null;
        int n2 = 0;
        int n3 = this.classpaths.length;
        while (n2 < n3) {
            NameEnvironmentAnswer nameEnvironmentAnswer2 = this.classpaths[n2].findBinding(cArray, string2, n, iTypeRequestor);
            if (nameEnvironmentAnswer2 != null) {
                if (!nameEnvironmentAnswer2.ignoreIfBetter()) {
                    if (nameEnvironmentAnswer2.isBetter(nameEnvironmentAnswer)) {
                        return nameEnvironmentAnswer2;
                    }
                } else if (nameEnvironmentAnswer2.isBetter(nameEnvironmentAnswer)) {
                    nameEnvironmentAnswer = nameEnvironmentAnswer2;
                }
            }
            ++n2;
        }
        if (nameEnvironmentAnswer != null) {
            return nameEnvironmentAnswer;
        }
        return null;
    }

    public NameEnvironmentAnswer findBinding(char[] cArray, char[][] cArray2, int n, ITypeRequestor iTypeRequestor, boolean bl, String string) {
        if (cArray != null) {
            return this.findBinding(new String(CharOperation.concatWith(cArray2, cArray, '/')), cArray, n, iTypeRequestor);
        }
        return null;
    }

    public NameEnvironmentAnswer findType(char[][] cArray, ITypeRequestor iTypeRequestor) {
        if (cArray != null) {
            return this.findClass(new String(CharOperation.concatWith(cArray, '/')), cArray[cArray.length - 1], false);
        }
        return null;
    }

    public char[][][] findTypeNames(char[][] cArray) {
        Object object;
        block10: {
            String string;
            object = null;
            if (cArray == null) break block10;
            String string2 = new String(CharOperation.concatWith(cArray, '/'));
            String string3 = string = File.separatorChar == '/' ? string2 : string2.replace('/', File.separatorChar);
            if (string2 == string) {
                int n = 0;
                int n2 = this.classpaths.length;
                while (n < n2) {
                    char[][][] cArray2 = this.classpaths[n].findTypeNames(string2);
                    if (cArray2 != null) {
                        if (object == null) {
                            object = cArray2;
                        } else {
                            int n3 = ((char[][][])object).length;
                            int n4 = cArray2.length;
                            char[][][] cArray3 = object;
                            char[][][] cArrayArray = new char[n4 + n3][][];
                            object = cArrayArray;
                            System.arraycopy(cArray3, 0, cArrayArray, 0, n3);
                            System.arraycopy(cArray2, 0, object, n3, n4);
                        }
                    }
                    ++n;
                }
            } else {
                int n = 0;
                int n5 = this.classpaths.length;
                while (n < n5) {
                    char[][][] cArray4;
                    Classpath classpath = this.classpaths[n];
                    char[][][] cArray5 = cArray4 = classpath instanceof ClasspathJar ? classpath.findTypeNames(string2) : classpath.findTypeNames(string);
                    if (cArray4 != null) {
                        if (object == null) {
                            object = cArray4;
                        } else {
                            int n6 = ((char[][][])object).length;
                            int n7 = cArray4.length;
                            char[][][] cArray6 = object;
                            char[][][] cArrayArray = new char[n7 + n6][][];
                            object = cArrayArray;
                            System.arraycopy(cArray6, 0, cArrayArray, 0, n6);
                            System.arraycopy(cArray4, 0, object, n6, n7);
                        }
                    }
                    ++n;
                }
            }
        }
        return object;
    }

    public NameEnvironmentAnswer findType(char[][] cArray, boolean bl) {
        if (cArray != null) {
            return this.findClass(new String(CharOperation.concatWith(cArray, '/')), cArray[cArray.length - 1], bl);
        }
        return null;
    }

    public NameEnvironmentAnswer findType(char[] cArray, char[][] cArray2, ITypeRequestor iTypeRequestor) {
        if (cArray != null) {
            return this.findClass(new String(CharOperation.concatWith(cArray2, cArray, '/')), cArray, false);
        }
        return null;
    }

    public boolean isPackage(char[][] cArray, char[] cArray2) {
        String string;
        String string2 = new String(CharOperation.concatWith(cArray, cArray2, '/'));
        String string3 = string = File.separatorChar == '/' ? string2 : string2.replace('/', File.separatorChar);
        if (string2 == string) {
            int n = 0;
            int n2 = this.classpaths.length;
            while (n < n2) {
                if (this.classpaths[n].isPackage(string2)) {
                    return true;
                }
                ++n;
            }
        } else {
            int n = 0;
            int n3 = this.classpaths.length;
            while (n < n3) {
                Classpath classpath = this.classpaths[n];
                if (classpath instanceof ClasspathJar ? classpath.isPackage(string2) : classpath.isPackage(string)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public static interface Classpath {
        public char[][][] findTypeNames(String var1);

        public NameEnvironmentAnswer findClass(char[] var1, String var2, String var3);

        public boolean isPackage(String var1);

        public NameEnvironmentAnswer findBinding(char[] var1, String var2, int var3, ITypeRequestor var4);

        public NameEnvironmentAnswer findClass(char[] var1, String var2, String var3, boolean var4);

        public void reset();

        public char[] normalizedPath();

        public String getPath();

        public void initialize() throws IOException;
    }

    public static class ClasspathNormalizer {
        public static ArrayList normalize(ArrayList arrayList) {
            ArrayList<Classpath> arrayList2 = new ArrayList<Classpath>();
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Classpath classpath = (Classpath)iterator.next();
                String string = classpath.getPath();
                if (hashSet.contains(string)) continue;
                arrayList2.add(classpath);
                hashSet.add(string);
            }
            return arrayList2;
        }
    }
}

