/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.env;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRestriction;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRule;

public class AccessRuleSet {
    private AccessRule[] accessRules;
    public String[] messageTemplates;
    public static final int MESSAGE_TEMPLATES_LENGTH = 4;

    public AccessRuleSet(AccessRule[] accessRuleArray, String[] stringArray) {
        this.accessRules = accessRuleArray;
        this.messageTemplates = stringArray != null && stringArray.length == 4 ? stringArray : new String[]{"{0}", "{0}", "{0} {1}", "{0} {1}"};
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AccessRuleSet)) {
            return false;
        }
        AccessRuleSet accessRuleSet = (AccessRuleSet)object;
        if (this.messageTemplates.length != 4 || accessRuleSet.messageTemplates.length != 4) {
            return false;
        }
        int n = 0;
        while (n < 4) {
            if (!this.messageTemplates[n].equals(accessRuleSet.messageTemplates[n])) {
                return false;
            }
            ++n;
        }
        n = this.accessRules.length;
        if (n != accessRuleSet.accessRules.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (!this.accessRules[n2].equals(accessRuleSet.accessRules[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public AccessRule[] getAccessRules() {
        return this.accessRules;
    }

    public AccessRestriction getViolatedRestriction(char[] cArray) {
        int n = 0;
        int n2 = this.accessRules.length;
        while (n < n2) {
            AccessRule accessRule = this.accessRules[n];
            if (CharOperation.pathMatch(accessRule.pattern, cArray, true, '/')) {
                switch (accessRule.getProblemId()) {
                    case 0x1000118: 
                    case 0x1000133: {
                        return new AccessRestriction(accessRule, this.messageTemplates);
                    }
                }
                return null;
            }
            ++n;
        }
        return null;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("AccessRuleSet {");
        if (bl) {
            stringBuffer.append('\n');
        }
        int n = 0;
        int n2 = this.accessRules.length;
        while (n < n2) {
            if (bl) {
                stringBuffer.append('\t');
            }
            AccessRule accessRule = this.accessRules[n];
            stringBuffer.append(accessRule);
            if (bl) {
                stringBuffer.append('\n');
            } else if (n < n2 - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        stringBuffer.append("} [templates:\"");
        n = 0;
        while (n < this.messageTemplates.length) {
            stringBuffer.append(this.messageTemplates[n]);
            ++n;
        }
        stringBuffer.append("\"]");
        return stringBuffer.toString();
    }
}

