/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.lookup;

import java.util.ArrayList;
import org.eclipse.wst.jsdt.core.UnimplementedException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.env.ClassSignature;
import org.eclipse.wst.jsdt.internal.compiler.env.EnumConstantSignature;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryElementValuePair;
import org.eclipse.wst.jsdt.internal.compiler.env.ISourceField;
import org.eclipse.wst.jsdt.internal.compiler.env.ISourceMethod;
import org.eclipse.wst.jsdt.internal.compiler.env.ISourceType;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SignatureWrapper;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.UnresolvedAnnotationBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.wst.jsdt.internal.core.SourceField;
import org.eclipse.wst.jsdt.internal.core.SourceMethod;

public class BinaryTypeBinding
extends ReferenceBinding {
    protected ReferenceBinding superclass;
    protected ReferenceBinding enclosingType;
    protected ReferenceBinding[] superInterfaces;
    protected FieldBinding[] fields;
    protected MethodBinding[] methods;
    protected ReferenceBinding[] memberTypes;
    protected TypeVariableBinding[] typeVariables;
    protected LookupEnvironment environment;
    protected SimpleLookupTable storedAnnotations = null;

    static Object convertMemberValue(Object object, LookupEnvironment lookupEnvironment) {
        if (object == null) {
            return null;
        }
        if (object instanceof Constant) {
            return object;
        }
        if (object instanceof ClassSignature) {
            return lookupEnvironment.getTypeFromSignature(((ClassSignature)object).getTypeName(), 0, -1, false, null);
        }
        if (object instanceof IBinaryAnnotation) {
            return BinaryTypeBinding.createAnnotation((IBinaryAnnotation)object, lookupEnvironment);
        }
        if (object instanceof EnumConstantSignature) {
            EnumConstantSignature enumConstantSignature = (EnumConstantSignature)object;
            ReferenceBinding referenceBinding = (ReferenceBinding)lookupEnvironment.getTypeFromSignature(enumConstantSignature.getTypeName(), 0, -1, false, null);
            referenceBinding = BinaryTypeBinding.resolveType(referenceBinding, lookupEnvironment, false);
            return referenceBinding.getField(enumConstantSignature.getEnumConstantName(), false);
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            if (n == 0) {
                return objectArray;
            }
            Object[] objectArray2 = new Object[n];
            int n2 = 0;
            while (n2 < n) {
                objectArray2[n2] = BinaryTypeBinding.convertMemberValue(objectArray[n2], lookupEnvironment);
                ++n2;
            }
            return objectArray2;
        }
        throw new IllegalStateException();
    }

    static AnnotationBinding createAnnotation(IBinaryAnnotation iBinaryAnnotation, LookupEnvironment lookupEnvironment) {
        IBinaryElementValuePair[] iBinaryElementValuePairArray = iBinaryAnnotation.getElementValuePairs();
        int n = iBinaryElementValuePairArray == null ? 0 : iBinaryElementValuePairArray.length;
        ElementValuePair[] elementValuePairArray = n == 0 ? Binding.NO_ELEMENT_VALUE_PAIRS : new ElementValuePair[n];
        int n2 = 0;
        while (n2 < n) {
            elementValuePairArray[n2] = new ElementValuePair(iBinaryElementValuePairArray[n2].getName(), BinaryTypeBinding.convertMemberValue(iBinaryElementValuePairArray[n2].getValue(), lookupEnvironment), null);
            ++n2;
        }
        char[] cArray = iBinaryAnnotation.getTypeName();
        ReferenceBinding referenceBinding = lookupEnvironment.getTypeFromConstantPoolName(cArray, 1, cArray.length - 1, false);
        return new UnresolvedAnnotationBinding(referenceBinding, elementValuePairArray, lookupEnvironment);
    }

    public static AnnotationBinding[] createAnnotations(IBinaryAnnotation[] iBinaryAnnotationArray, LookupEnvironment lookupEnvironment) {
        int n = iBinaryAnnotationArray == null ? 0 : iBinaryAnnotationArray.length;
        AnnotationBinding[] annotationBindingArray = n == 0 ? Binding.NO_ANNOTATIONS : new AnnotationBinding[n];
        int n2 = 0;
        while (n2 < n) {
            annotationBindingArray[n2] = BinaryTypeBinding.createAnnotation(iBinaryAnnotationArray[n2], lookupEnvironment);
            ++n2;
        }
        return annotationBindingArray;
    }

    public static ReferenceBinding resolveType(ReferenceBinding referenceBinding, LookupEnvironment lookupEnvironment, boolean bl) {
        if (referenceBinding instanceof UnresolvedReferenceBinding) {
            return ((UnresolvedReferenceBinding)referenceBinding).resolve(lookupEnvironment, bl);
        }
        if (bl) {
            return (ReferenceBinding)lookupEnvironment.convertUnresolvedBinaryToRawType(referenceBinding);
        }
        return referenceBinding;
    }

    public static TypeBinding resolveType(TypeBinding typeBinding, LookupEnvironment lookupEnvironment, ParameterizedTypeBinding parameterizedTypeBinding, int n) {
        switch (typeBinding.kind()) {
            case 260: {
                return ((ParameterizedTypeBinding)typeBinding).resolve();
            }
            case 516: {
                return ((WildcardBinding)typeBinding).resolve();
            }
            case 68: {
                BinaryTypeBinding.resolveType(((ArrayBinding)typeBinding).leafComponentType, lookupEnvironment, parameterizedTypeBinding, n);
                break;
            }
            case 4100: {
                ((TypeVariableBinding)typeBinding).resolve(lookupEnvironment);
                break;
            }
            case 2052: {
                if (parameterizedTypeBinding != null) break;
                return lookupEnvironment.convertUnresolvedBinaryToRawType(typeBinding);
            }
            default: {
                if (!(typeBinding instanceof UnresolvedReferenceBinding)) break;
                return ((UnresolvedReferenceBinding)typeBinding).resolve(lookupEnvironment, parameterizedTypeBinding == null);
            }
        }
        return typeBinding;
    }

    protected BinaryTypeBinding() {
    }

    public BinaryTypeBinding(PackageBinding packageBinding, ISourceType iSourceType, LookupEnvironment lookupEnvironment) {
        this.compoundName = CharOperation.splitOn('/', iSourceType.getName());
        this.fileName = iSourceType.getFileName();
        this.computeId();
        this.tagBits |= 0x40L;
        this.environment = lookupEnvironment;
        this.fPackage = packageBinding;
        this.sourceName = iSourceType.getFileName();
        this.modifiers = iSourceType.getModifiers();
    }

    public FieldBinding[] availableFields() {
        if ((this.tagBits & 0x2000L) != 0L) {
            return this.fields;
        }
        if ((this.tagBits & 0x1000L) == 0L) {
            int n = this.fields.length;
            if (n > 1) {
                ReferenceBinding.sortFields(this.fields, 0, n);
            }
            this.tagBits |= 0x1000L;
        }
        FieldBinding[] fieldBindingArray = new FieldBinding[this.fields.length];
        int n = 0;
        int n2 = 0;
        while (n2 < this.fields.length) {
            try {
                fieldBindingArray[n] = this.resolveTypeFor(this.fields[n2]);
                ++n;
            }
            catch (AbortCompilation abortCompilation) {}
            ++n2;
        }
        if (n < fieldBindingArray.length) {
            FieldBinding[] fieldBindingArray2 = fieldBindingArray;
            fieldBindingArray = new FieldBinding[n];
            System.arraycopy(fieldBindingArray2, 0, fieldBindingArray, 0, n);
        }
        return fieldBindingArray;
    }

    public MethodBinding[] availableMethods() {
        if ((this.tagBits & 0x8000L) != 0L) {
            return this.methods;
        }
        if ((this.tagBits & 0x4000L) == 0L) {
            int n = this.methods.length;
            if (n > 1) {
                ReferenceBinding.sortMethods(this.methods, 0, n);
            }
            this.tagBits |= 0x4000L;
        }
        MethodBinding[] methodBindingArray = new MethodBinding[this.methods.length];
        int n = 0;
        int n2 = 0;
        while (n2 < this.methods.length) {
            try {
                methodBindingArray[n] = this.resolveTypesFor(this.methods[n2]);
                ++n;
            }
            catch (AbortCompilation abortCompilation) {}
            ++n2;
        }
        if (n < methodBindingArray.length) {
            MethodBinding[] methodBindingArray2 = methodBindingArray;
            methodBindingArray = new MethodBinding[n];
            System.arraycopy(methodBindingArray2, 0, methodBindingArray, 0, n);
        }
        return methodBindingArray;
    }

    void cachePartsFrom(ISourceType iSourceType, boolean bl) {
        int n;
        this.typeVariables = Binding.NO_TYPE_VARIABLES;
        this.superInterfaces = Binding.NO_SUPERINTERFACES;
        this.memberTypes = Binding.NO_MEMBER_TYPES;
        ISourceType[] iSourceTypeArray = iSourceType.getMemberTypes();
        if (iSourceTypeArray != null && (n = iSourceTypeArray.length) > 0) {
            this.memberTypes = new ReferenceBinding[n];
            int n2 = 0;
            while (n2 < n) {
                this.memberTypes[n2] = this.environment.getTypeFromConstantPoolName(iSourceTypeArray[n2].getName(), 0, -1, false);
                ++n2;
            }
            this.tagBits |= 0x10000000L;
        }
        long l = this.environment.globalOptions.sourceLevel;
        char[] cArray = null;
        if (cArray == null) {
            int n3;
            char[] cArray2 = iSourceType.getSuperclassName();
            if (cArray2 != null) {
                this.superclass = this.environment.getTypeFromConstantPoolName(cArray2, 0, -1, false);
                this.tagBits |= 0x2000000L;
            }
            this.superInterfaces = Binding.NO_SUPERINTERFACES;
            char[][] cArray3 = iSourceType.getInterfaceNames();
            if (cArray3 != null && (n3 = cArray3.length) > 0) {
                this.superInterfaces = new ReferenceBinding[n3];
                int n4 = 0;
                while (n4 < n3) {
                    this.superInterfaces[n4] = this.environment.getTypeFromConstantPoolName(cArray3[n4], 0, -1, false);
                    ++n4;
                }
                this.tagBits |= 0x4000000L;
            }
        } else {
            SignatureWrapper signatureWrapper = new SignatureWrapper(cArray);
            if (signatureWrapper.signature[signatureWrapper.start] == '<') {
                ++signatureWrapper.start;
                this.typeVariables = this.createTypeVariables(signatureWrapper, true);
                ++signatureWrapper.start;
                this.tagBits |= 0x1000000L;
                this.modifiers |= 0x40000000;
            }
            this.superclass = (ReferenceBinding)this.environment.getTypeFromTypeSignature(signatureWrapper, Binding.NO_TYPE_VARIABLES, this);
            this.tagBits |= 0x2000000L;
            this.superInterfaces = Binding.NO_SUPERINTERFACES;
            if (!signatureWrapper.atEnd()) {
                ArrayList<TypeBinding> arrayList = new ArrayList<TypeBinding>(2);
                do {
                    arrayList.add(this.environment.getTypeFromTypeSignature(signatureWrapper, Binding.NO_TYPE_VARIABLES, this));
                } while (!signatureWrapper.atEnd());
                this.superInterfaces = new ReferenceBinding[arrayList.size()];
                arrayList.toArray(this.superInterfaces);
                this.tagBits |= 0x4000000L;
            }
        }
        if (bl) {
            this.createFields(iSourceType.getFields(), l);
            this.createMethods(iSourceType.getMethods(), l);
        } else {
            this.fields = Binding.NO_FIELDS;
            this.methods = Binding.NO_METHODS;
        }
    }

    private void createFields(ISourceField[] iSourceFieldArray, long l) {
        int n;
        this.fields = Binding.NO_FIELDS;
        if (iSourceFieldArray != null && (n = iSourceFieldArray.length) > 0) {
            this.fields = new FieldBinding[n];
            boolean bl = this.isViewedAsDeprecated();
            boolean bl2 = this.hasRestrictedAccess();
            int n2 = 0;
            while (n2 < n) {
                ISourceField iSourceField = iSourceFieldArray[n2];
                char[] cArray = null;
                TypeBinding typeBinding = cArray == null ? this.environment.getTypeFromSignature(iSourceField.getTypeName(), 0, -1, false, this) : this.environment.getTypeFromTypeSignature(new SignatureWrapper(cArray), Binding.NO_TYPE_VARIABLES, this);
                FieldBinding fieldBinding = new FieldBinding(((SourceField)((Object)iSourceField)).getElementName().toCharArray(), typeBinding, iSourceField.getModifiers() | 0x2000000, this, null);
                fieldBinding.id = n2;
                if (bl && !fieldBinding.isDeprecated()) {
                    fieldBinding.modifiers |= 0x200000;
                }
                if (bl2) {
                    fieldBinding.modifiers |= 0x40000;
                }
                if (cArray != null) {
                    fieldBinding.modifiers |= 0x40000000;
                }
                this.fields[n2] = fieldBinding;
                ++n2;
            }
        }
    }

    private MethodBinding createMethod(ISourceMethod iSourceMethod, long l) {
        int n = iSourceMethod.getModifiers() | 0x2000000;
        if (l < 0x310000L) {
            n &= 0xFFFFFF7F;
        }
        throw new UnimplementedException("fix compile errors for this code");
    }

    private void createMethods(ISourceMethod[] iSourceMethodArray, long l) {
        Object object;
        int n;
        boolean bl;
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        int[] nArray = null;
        if (iSourceMethodArray != null) {
            n2 = n3 = iSourceMethodArray.length;
            bl = l < 0x310000L && this.environment.globalOptions.complianceLevel >= 0x310000L;
            n = n2;
            while (--n >= 0) {
                ISourceMethod iSourceMethod = iSourceMethodArray[n];
                if ((iSourceMethod.getModifiers() & 0x1000) != 0) {
                    if (bl && (iSourceMethod.getModifiers() & 0x40) != 0) continue;
                    if (nArray == null) {
                        nArray = new int[iSourceMethodArray.length];
                    }
                    nArray[n] = -1;
                    --n2;
                    continue;
                }
                if (n4 != -1 || ((Object)(object = (Object)((SourceMethod)((Object)iSourceMethod)).getElementName().toCharArray())).length != 8 || object[0] != 60) continue;
                n4 = n;
                --n2;
            }
        }
        if (n2 == 0) {
            this.methods = Binding.NO_METHODS;
            return;
        }
        bl = this.isViewedAsDeprecated();
        n = this.hasRestrictedAccess();
        this.methods = new MethodBinding[n2];
        if (n2 == n3) {
            int n5 = 0;
            while (n5 < n3) {
                object = this.createMethod(iSourceMethodArray[n5], l);
                if (bl && !((MethodBinding)object).isDeprecated()) {
                    ((MethodBinding)object).modifiers |= 0x200000;
                }
                if (n != 0) {
                    ((MethodBinding)object).modifiers |= 0x40000;
                }
                this.methods[n5] = object;
                ++n5;
            }
        } else {
            int n6 = 0;
            int n7 = 0;
            while (n6 < n3) {
                if (n4 != n6 && (nArray == null || nArray[n6] != -1)) {
                    MethodBinding methodBinding = this.createMethod(iSourceMethodArray[n6], l);
                    if (bl && !methodBinding.isDeprecated()) {
                        methodBinding.modifiers |= 0x200000;
                    }
                    if (n != 0) {
                        methodBinding.modifiers |= 0x40000;
                    }
                    this.methods[n7++] = methodBinding;
                }
                ++n6;
            }
        }
    }

    private TypeVariableBinding[] createTypeVariables(SignatureWrapper signatureWrapper, boolean bl) {
        int n;
        char[] cArray = signatureWrapper.signature;
        int n2 = 0;
        int n3 = cArray.length;
        int n4 = 0;
        ArrayList<TypeVariableBinding> arrayList = new ArrayList<TypeVariableBinding>(1);
        n2 = 0;
        boolean bl2 = true;
        int n5 = 1;
        block5: while (n5 < n3) {
            switch (cArray[n5]) {
                case '<': {
                    ++n2;
                    break;
                }
                case '>': {
                    if (--n2 >= 0) break;
                    break block5;
                }
                case ';': {
                    if (n2 != 0 || n5 + 1 >= n3 || cArray[n5 + 1] == ':') break;
                    bl2 = true;
                    break;
                }
                default: {
                    if (!bl2) break;
                    bl2 = false;
                    n = CharOperation.indexOf(':', cArray, n5);
                    char[] cArray2 = CharOperation.subarray(cArray, n5, n);
                    arrayList.add(new TypeVariableBinding(cArray2, this, n4++));
                }
            }
            ++n5;
        }
        TypeVariableBinding[] typeVariableBindingArray = new TypeVariableBinding[n4];
        arrayList.toArray(typeVariableBindingArray);
        if (bl) {
            this.typeVariables = typeVariableBindingArray;
        }
        n = 0;
        while (n < n4) {
            this.initializeTypeVariable(typeVariableBindingArray[n], typeVariableBindingArray, signatureWrapper);
            ++n;
        }
        return typeVariableBindingArray;
    }

    public ReferenceBinding enclosingType() {
        if ((this.tagBits & 0x8000000L) == 0L) {
            return this.enclosingType;
        }
        this.enclosingType = BinaryTypeBinding.resolveType(this.enclosingType, this.environment, false);
        this.tagBits &= 0xFFFFFFFFF7FFFFFFL;
        return this.enclosingType;
    }

    public FieldBinding[] fields() {
        int n;
        if ((this.tagBits & 0x2000L) != 0L) {
            return this.fields;
        }
        if ((this.tagBits & 0x1000L) == 0L) {
            n = this.fields.length;
            if (n > 1) {
                ReferenceBinding.sortFields(this.fields, 0, n);
            }
            this.tagBits |= 0x1000L;
        }
        n = this.fields.length;
        while (--n >= 0) {
            this.resolveTypeFor(this.fields[n]);
        }
        this.tagBits |= 0x2000L;
        return this.fields;
    }

    public char[] genericTypeSignature() {
        return this.computeGenericTypeSignature(this.typeVariables);
    }

    public MethodBinding getExactConstructor(TypeBinding[] typeBindingArray) {
        int n;
        if ((this.tagBits & 0x4000L) == 0L) {
            n = this.methods.length;
            if (n > 1) {
                ReferenceBinding.sortMethods(this.methods, 0, n);
            }
            this.tagBits |= 0x4000L;
        }
        n = typeBindingArray.length;
        long l = ReferenceBinding.binarySearch(TypeConstants.INIT, this.methods);
        if (l >= 0L) {
            int n2 = (int)l;
            int n3 = (int)(l >> 32);
            while (n2 <= n3) {
                block7: {
                    MethodBinding methodBinding = this.methods[n2];
                    if (methodBinding.parameters.length == n) {
                        this.resolveTypesFor(methodBinding);
                        TypeBinding[] typeBindingArray2 = methodBinding.parameters;
                        int n4 = 0;
                        while (n4 < n) {
                            if (typeBindingArray2[n4] == typeBindingArray[n4]) {
                                ++n4;
                                continue;
                            }
                            break block7;
                        }
                        return methodBinding;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    public MethodBinding getExactMethod(char[] cArray, TypeBinding[] typeBindingArray, CompilationUnitScope compilationUnitScope) {
        int n;
        if ((this.tagBits & 0x4000L) == 0L) {
            n = this.methods.length;
            if (n > 1) {
                ReferenceBinding.sortMethods(this.methods, 0, n);
            }
            this.tagBits |= 0x4000L;
        }
        n = typeBindingArray.length;
        boolean bl = true;
        long l = ReferenceBinding.binarySearch(cArray, this.methods);
        if (l >= 0L) {
            int n2 = (int)l;
            int n3 = (int)(l >> 32);
            while (n2 <= n3) {
                block14: {
                    MethodBinding methodBinding = this.methods[n2];
                    bl = false;
                    if (methodBinding.parameters.length == n) {
                        this.resolveTypesFor(methodBinding);
                        TypeBinding[] typeBindingArray2 = methodBinding.parameters;
                        int n4 = 0;
                        while (n4 < n) {
                            if (typeBindingArray2[n4] == typeBindingArray[n4]) {
                                ++n4;
                                continue;
                            }
                            break block14;
                        }
                        return methodBinding;
                    }
                }
                ++n2;
            }
        }
        if (bl) {
            if (this.isInterface()) {
                if (this.superInterfaces().length == 1) {
                    if (compilationUnitScope != null) {
                        compilationUnitScope.recordTypeReference(this.superInterfaces[0]);
                    }
                    return this.superInterfaces[0].getExactMethod(cArray, typeBindingArray, compilationUnitScope);
                }
            } else if (this.superclass() != null) {
                if (compilationUnitScope != null) {
                    compilationUnitScope.recordTypeReference(this.superclass);
                }
                return this.superclass.getExactMethod(cArray, typeBindingArray, compilationUnitScope);
            }
        }
        return null;
    }

    public FieldBinding getField(char[] cArray, boolean bl) {
        if ((this.tagBits & 0x1000L) == 0L) {
            int n = this.fields.length;
            if (n > 1) {
                ReferenceBinding.sortFields(this.fields, 0, n);
            }
            this.tagBits |= 0x1000L;
        }
        FieldBinding fieldBinding = ReferenceBinding.binarySearch(cArray, this.fields);
        return bl && fieldBinding != null ? this.resolveTypeFor(fieldBinding) : fieldBinding;
    }

    public ReferenceBinding getMemberType(char[] cArray) {
        int n = this.memberTypes.length;
        while (--n >= 0) {
            ReferenceBinding referenceBinding = this.memberTypes[n];
            if (referenceBinding instanceof UnresolvedReferenceBinding) {
                char[] cArray2 = referenceBinding.sourceName;
                int n2 = this.compoundName[this.compoundName.length - 1].length + 1;
                if (cArray2.length != n2 + cArray.length || !CharOperation.fragmentEquals(cArray, cArray2, n2, true)) continue;
                this.memberTypes[n] = BinaryTypeBinding.resolveType(referenceBinding, this.environment, false);
                return this.memberTypes[n];
            }
            if (!CharOperation.equals(cArray, referenceBinding.sourceName)) continue;
            return referenceBinding;
        }
        return null;
    }

    public MethodBinding[] getMethods(char[] cArray) {
        long l;
        if ((this.tagBits & 0x8000L) != 0L) {
            long l2 = ReferenceBinding.binarySearch(cArray, this.methods);
            if (l2 >= 0L) {
                int n = (int)l2;
                int n2 = (int)(l2 >> 32);
                int n3 = n2 - n + 1;
                if ((this.tagBits & 0x8000L) != 0L) {
                    MethodBinding[] methodBindingArray = new MethodBinding[n3];
                    System.arraycopy(this.methods, n, methodBindingArray, 0, n3);
                    return methodBindingArray;
                }
            }
            return Binding.NO_METHODS;
        }
        if ((this.tagBits & 0x4000L) == 0L) {
            int n = this.methods.length;
            if (n > 1) {
                ReferenceBinding.sortMethods(this.methods, 0, n);
            }
            this.tagBits |= 0x4000L;
        }
        if ((l = ReferenceBinding.binarySearch(cArray, this.methods)) >= 0L) {
            int n = (int)l;
            int n4 = (int)(l >> 32);
            int n5 = n4 - n + 1;
            MethodBinding[] methodBindingArray = new MethodBinding[n5];
            int n6 = n;
            int n7 = 0;
            while (n6 <= n4) {
                methodBindingArray[n7] = this.resolveTypesFor(this.methods[n6]);
                ++n6;
                ++n7;
            }
            return methodBindingArray;
        }
        return Binding.NO_METHODS;
    }

    public boolean hasMemberTypes() {
        return this.memberTypes.length > 0;
    }

    public TypeVariableBinding getTypeVariable(char[] cArray) {
        TypeVariableBinding typeVariableBinding = super.getTypeVariable(cArray);
        typeVariableBinding.resolve(this.environment);
        return typeVariableBinding;
    }

    private void initializeTypeVariable(TypeVariableBinding typeVariableBinding, TypeVariableBinding[] typeVariableBindingArray, SignatureWrapper signatureWrapper) {
        ReferenceBinding referenceBinding;
        int n = CharOperation.indexOf(':', signatureWrapper.signature, signatureWrapper.start);
        signatureWrapper.start = n + 1;
        ReferenceBinding referenceBinding2 = null;
        if (signatureWrapper.signature[signatureWrapper.start] == ':') {
            referenceBinding = this.environment.getResolvedType(TypeConstants.JAVA_LANG_OBJECT, null);
        } else {
            referenceBinding2 = referenceBinding = (ReferenceBinding)this.environment.getTypeFromTypeSignature(signatureWrapper, typeVariableBindingArray, this);
        }
        typeVariableBinding.modifiers |= 0x2000000;
        typeVariableBinding.superclass = referenceBinding;
        ReferenceBinding[] referenceBindingArray = null;
        if (signatureWrapper.signature[signatureWrapper.start] == ':') {
            ArrayList<TypeBinding> arrayList = new ArrayList<TypeBinding>(2);
            do {
                ++signatureWrapper.start;
                arrayList.add(this.environment.getTypeFromTypeSignature(signatureWrapper, typeVariableBindingArray, this));
            } while (signatureWrapper.signature[signatureWrapper.start] == ':');
            referenceBindingArray = new ReferenceBinding[arrayList.size()];
            arrayList.toArray(referenceBindingArray);
        }
        ReferenceBinding[] referenceBindingArray2 = typeVariableBinding.superInterfaces = referenceBindingArray == null ? Binding.NO_SUPERINTERFACES : referenceBindingArray;
        if (referenceBinding2 == null) {
            referenceBinding2 = typeVariableBinding.superInterfaces.length == 0 ? null : typeVariableBinding.superInterfaces[0];
        }
        typeVariableBinding.firstBound = referenceBinding2;
    }

    public boolean isEquivalentTo(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return true;
        }
        if (typeBinding == null) {
            return false;
        }
        switch (typeBinding.kind()) {
            case 516: {
                return ((WildcardBinding)typeBinding).boundCheck(this);
            }
            case 1028: {
                return typeBinding.erasure() == this;
            }
        }
        return false;
    }

    public boolean isGenericType() {
        return this.typeVariables != Binding.NO_TYPE_VARIABLES;
    }

    public int kind() {
        if (this.typeVariables != Binding.NO_TYPE_VARIABLES) {
            return 2052;
        }
        return 4;
    }

    public ReferenceBinding[] memberTypes() {
        if ((this.tagBits & 0x10000000L) == 0L) {
            return this.memberTypes;
        }
        int n = this.memberTypes.length;
        while (--n >= 0) {
            this.memberTypes[n] = BinaryTypeBinding.resolveType(this.memberTypes[n], this.environment, false);
        }
        this.tagBits &= 0xFFFFFFFFEFFFFFFFL;
        return this.memberTypes;
    }

    public MethodBinding[] methods() {
        int n;
        if ((this.tagBits & 0x8000L) != 0L) {
            return this.methods;
        }
        if ((this.tagBits & 0x4000L) == 0L) {
            n = this.methods.length;
            if (n > 1) {
                ReferenceBinding.sortMethods(this.methods, 0, n);
            }
            this.tagBits |= 0x4000L;
        }
        n = this.methods.length;
        while (--n >= 0) {
            this.resolveTypesFor(this.methods[n]);
        }
        this.tagBits |= 0x8000L;
        return this.methods;
    }

    private FieldBinding resolveTypeFor(FieldBinding fieldBinding) {
        if ((fieldBinding.modifiers & 0x2000000) == 0) {
            return fieldBinding;
        }
        fieldBinding.type = BinaryTypeBinding.resolveType(fieldBinding.type, this.environment, null, 0);
        fieldBinding.modifiers &= 0xFDFFFFFF;
        return fieldBinding;
    }

    MethodBinding resolveTypesFor(MethodBinding methodBinding) {
        if ((methodBinding.modifiers & 0x2000000) == 0) {
            return methodBinding;
        }
        if (!methodBinding.isConstructor()) {
            methodBinding.returnType = BinaryTypeBinding.resolveType(methodBinding.returnType, this.environment, null, 0);
        }
        int n = methodBinding.parameters.length;
        while (--n >= 0) {
            methodBinding.parameters[n] = BinaryTypeBinding.resolveType(methodBinding.parameters[n], this.environment, null, 0);
        }
        n = methodBinding.thrownExceptions.length;
        while (--n >= 0) {
            methodBinding.thrownExceptions[n] = BinaryTypeBinding.resolveType(methodBinding.thrownExceptions[n], this.environment, true);
        }
        n = methodBinding.typeVariables.length;
        while (--n >= 0) {
            methodBinding.typeVariables[n].resolve(this.environment);
        }
        methodBinding.modifiers &= 0xFDFFFFFF;
        return methodBinding;
    }

    AnnotationBinding[] retrieveAnnotations(Binding binding) {
        return AnnotationBinding.addStandardAnnotations(super.retrieveAnnotations(binding), binding.getAnnotationTagBits(), this.environment);
    }

    SimpleLookupTable storedAnnotations(boolean bl) {
        if (bl && this.storedAnnotations == null) {
            if (!this.environment.globalOptions.storeAnnotations) {
                return null;
            }
            this.storedAnnotations = new SimpleLookupTable(3);
        }
        return this.storedAnnotations;
    }

    public ReferenceBinding superclass() {
        if ((this.tagBits & 0x2000000L) == 0L) {
            return this.superclass;
        }
        this.superclass = BinaryTypeBinding.resolveType(this.superclass, this.environment, true);
        this.tagBits &= 0xFFFFFFFFFDFFFFFFL;
        if (this.superclass.problemId() == 1) {
            this.tagBits |= 0x20000L;
        }
        return this.superclass;
    }

    public ReferenceBinding[] superInterfaces() {
        if ((this.tagBits & 0x4000000L) == 0L) {
            return this.superInterfaces;
        }
        int n = this.superInterfaces.length;
        while (--n >= 0) {
            this.superInterfaces[n] = BinaryTypeBinding.resolveType(this.superInterfaces[n], this.environment, true);
            if (this.superInterfaces[n].problemId() != 1) continue;
            this.tagBits |= 0x20000L;
        }
        this.tagBits &= 0xFFFFFFFFFBFFFFFFL;
        return this.superInterfaces;
    }

    public TypeVariableBinding[] typeVariables() {
        if ((this.tagBits & 0x1000000L) == 0L) {
            return this.typeVariables;
        }
        int n = this.typeVariables.length;
        while (--n >= 0) {
            this.typeVariables[n].resolve(this.environment);
        }
        this.tagBits &= 0xFFFFFFFFFEFFFFFFL;
        return this.typeVariables;
    }

    public String toString() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isDeprecated()) {
            stringBuffer.append("deprecated ");
        }
        if (this.isPublic()) {
            stringBuffer.append("public ");
        }
        if (this.isProtected()) {
            stringBuffer.append("protected ");
        }
        if (this.isPrivate()) {
            stringBuffer.append("private ");
        }
        if (this.isAbstract() && this.isClass()) {
            stringBuffer.append("abstract ");
        }
        if (this.isStatic() && this.isNestedType()) {
            stringBuffer.append("static ");
        }
        if (this.isFinal()) {
            stringBuffer.append("final ");
        }
        if (this.isEnum()) {
            stringBuffer.append("enum ");
        } else if (this.isAnnotationType()) {
            stringBuffer.append("@interface ");
        } else if (this.isClass()) {
            stringBuffer.append("class ");
        } else {
            stringBuffer.append("interface ");
        }
        stringBuffer.append(this.compoundName != null ? CharOperation.toString(this.compoundName) : "UNNAMED TYPE");
        stringBuffer.append("\n\textends ");
        stringBuffer.append(this.superclass != null ? this.superclass.debugName() : "NULL TYPE");
        if (this.superInterfaces != null) {
            if (this.superInterfaces != Binding.NO_SUPERINTERFACES) {
                stringBuffer.append("\n\timplements : ");
                n2 = 0;
                n = this.superInterfaces.length;
                while (n2 < n) {
                    if (n2 > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.superInterfaces[n2] != null ? this.superInterfaces[n2].debugName() : "NULL TYPE");
                    ++n2;
                }
            }
        } else {
            stringBuffer.append("NULL SUPERINTERFACES");
        }
        if (this.enclosingType != null) {
            stringBuffer.append("\n\tenclosing type : ");
            stringBuffer.append(this.enclosingType.debugName());
        }
        if (this.fields != null) {
            if (this.fields != Binding.NO_FIELDS) {
                stringBuffer.append("\n/*   fields   */");
                n2 = 0;
                n = this.fields.length;
                while (n2 < n) {
                    stringBuffer.append(this.fields[n2] != null ? "\n" + this.fields[n2].toString() : "\nNULL FIELD");
                    ++n2;
                }
            }
        } else {
            stringBuffer.append("NULL FIELDS");
        }
        if (this.methods != null) {
            if (this.methods != Binding.NO_METHODS) {
                stringBuffer.append("\n/*   methods   */");
                n2 = 0;
                n = this.methods.length;
                while (n2 < n) {
                    stringBuffer.append(this.methods[n2] != null ? "\n" + this.methods[n2].toString() : "\nNULL METHOD");
                    ++n2;
                }
            }
        } else {
            stringBuffer.append("NULL METHODS");
        }
        if (this.memberTypes != null) {
            if (this.memberTypes != Binding.NO_MEMBER_TYPES) {
                stringBuffer.append("\n/*   members   */");
                n2 = 0;
                n = this.memberTypes.length;
                while (n2 < n) {
                    stringBuffer.append(this.memberTypes[n2] != null ? "\n" + this.memberTypes[n2].toString() : "\nNULL TYPE");
                    ++n2;
                }
            }
        } else {
            stringBuffer.append("NULL MEMBER TYPES");
        }
        stringBuffer.append("\n\n\n");
        return stringBuffer.toString();
    }

    MethodBinding[] unResolvedMethods() {
        return this.methods;
    }
}

