/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.parser;

import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ProgramElement;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveredMethod;

public class RecoveredStatement
extends RecoveredElement {
    public Statement statement;
    public RecoveredElement[] childStatements;
    public int childCount;

    public RecoveredStatement(Statement statement, RecoveredElement recoveredElement, int n) {
        super(recoveredElement, n);
        this.statement = statement;
    }

    public ASTNode parseTree() {
        return this.statement;
    }

    public int sourceEnd() {
        return this.statement.sourceEnd;
    }

    public String toString(int n) {
        return String.valueOf(this.tabString(n)) + "Recovered statement:\n" + this.statement.print(n + 1, new StringBuffer(10));
    }

    public Statement updatedStatement() {
        int n = 0;
        while (n < this.childCount) {
            this.childStatements[n].updatedASTNode();
            ++n;
        }
        return this.statement;
    }

    public void updateParseTree() {
        this.updatedStatement();
    }

    public void updateSourceEndIfNecessary(int n, int n2) {
        if (this.statement.sourceEnd == 0) {
            this.statement.sourceEnd = n2;
        }
    }

    public ProgramElement updatedASTNode() {
        return this.updatedStatement();
    }

    public RecoveredElement add(AbstractMethodDeclaration abstractMethodDeclaration, int n) {
        RecoveredMethod recoveredMethod = new RecoveredMethod(abstractMethodDeclaration, this, n, this.recoveringParser);
        this.addChild(recoveredMethod);
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        if (abstractMethodDeclaration.declarationSourceEnd == 0) {
            return recoveredMethod;
        }
        return this;
    }

    private void addChild(RecoveredElement recoveredElement) {
        if (this.childStatements == null) {
            this.childStatements = new RecoveredElement[5];
            this.childCount = 0;
        } else if (this.childCount == this.childStatements.length) {
            this.childStatements = new RecoveredElement[2 * this.childCount];
            System.arraycopy(this.childStatements, 0, this.childStatements, 0, this.childCount);
        }
        this.childStatements[this.childCount++] = recoveredElement;
    }
}

