/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModelStatus;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.core.CreateElementInCUOperation;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.util.Messages;

public class CreatePackageDeclarationOperation
extends CreateElementInCUOperation {
    protected String name = null;

    public CreatePackageDeclarationOperation(String string, ICompilationUnit iCompilationUnit) {
        super(iCompilationUnit);
        this.name = string;
    }

    protected StructuralPropertyDescriptor getChildPropertyDescriptor(ASTNode aSTNode) {
        return CompilationUnit.PACKAGE_PROPERTY;
    }

    protected ASTNode generateElementAST(ASTRewrite aSTRewrite, IDocument iDocument, ICompilationUnit iCompilationUnit) throws JavaModelException {
        IJavaElement[] iJavaElementArray = this.getCompilationUnit().getChildren();
        int n = 0;
        while (n < iJavaElementArray.length) {
            if (iJavaElementArray[n].getElementType() == 11 && this.name.equals(iJavaElementArray[n].getElementName())) {
                this.creationOccurred = false;
                return null;
            }
            ++n;
        }
        AST aST = this.cuAST.getAST();
        PackageDeclaration packageDeclaration = aST.newPackageDeclaration();
        Name name = aST.newName(this.name);
        packageDeclaration.setName(name);
        return packageDeclaration;
    }

    protected IJavaElement generateResultHandle() {
        return this.getCompilationUnit().getPackageDeclaration(this.name);
    }

    public String getMainTaskName() {
        return Messages.operation_createPackageProgress;
    }

    protected void initializeDefaultPosition() {
        try {
            ICompilationUnit iCompilationUnit = this.getCompilationUnit();
            IImportDeclaration[] iImportDeclarationArray = iCompilationUnit.getImports();
            if (iImportDeclarationArray.length > 0) {
                this.createBefore(iImportDeclarationArray[0]);
                return;
            }
            IType[] iTypeArray = iCompilationUnit.getTypes();
            if (iTypeArray.length > 0) {
                this.createBefore(iTypeArray[0]);
                return;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    public IJavaModelStatus verify() {
        IJavaModelStatus iJavaModelStatus = super.verify();
        if (!iJavaModelStatus.isOK()) {
            return iJavaModelStatus;
        }
        IJavaProject iJavaProject = this.getParentElement().getJavaProject();
        if (JavaConventions.validatePackageName(this.name, iJavaProject.getOption("org.eclipse.wst.jsdt.core.compiler.source", true), iJavaProject.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true)).getSeverity() == 4) {
            return new JavaModelStatus(983, this.name);
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

