/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.JavaElementDelta;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaModelOperation;
import org.eclipse.wst.jsdt.internal.core.JavaProject;

public class DiscardWorkingCopyOperation
extends JavaModelOperation {
    public DiscardWorkingCopyOperation(IJavaElement iJavaElement) {
        super(new IJavaElement[]{iJavaElement});
    }

    protected void executeOperation() throws JavaModelException {
        CompilationUnit compilationUnit = this.getWorkingCopy();
        JavaModelManager javaModelManager = JavaModelManager.getJavaModelManager();
        int n = javaModelManager.discardPerWorkingCopyInfo(compilationUnit);
        if (n == 0) {
            IJavaProject iJavaProject = compilationUnit.getJavaProject();
            if (" ".equals(iJavaProject.getElementName())) {
                javaModelManager.removePerProjectInfo((JavaProject)iJavaProject);
                javaModelManager.containerRemove(iJavaProject);
            }
            if (!compilationUnit.isPrimary()) {
                JavaElementDelta javaElementDelta = new JavaElementDelta(this.getJavaModel());
                javaElementDelta.removed(compilationUnit);
                this.addDelta(javaElementDelta);
                this.removeReconcileDelta(compilationUnit);
            } else if (compilationUnit.getResource().isAccessible()) {
                JavaElementDelta javaElementDelta = new JavaElementDelta(this.getJavaModel());
                javaElementDelta.changed(compilationUnit, 65536);
                this.addDelta(javaElementDelta);
            } else {
                JavaElementDelta javaElementDelta = new JavaElementDelta(this.getJavaModel());
                javaElementDelta.removed(compilationUnit, 65536);
                this.addDelta(javaElementDelta);
            }
        }
    }

    protected CompilationUnit getWorkingCopy() {
        return (CompilationUnit)this.getElementToProcess();
    }

    public boolean isReadOnly() {
        return true;
    }
}

