/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.builder;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.internal.compiler.ClassFile;
import org.eclipse.wst.jsdt.internal.core.builder.AbstractImageBuilder;
import org.eclipse.wst.jsdt.internal.core.builder.ClasspathMultiDirectory;
import org.eclipse.wst.jsdt.internal.core.builder.CompilationParticipantResult;
import org.eclipse.wst.jsdt.internal.core.builder.IncrementalImageBuilder;
import org.eclipse.wst.jsdt.internal.core.builder.JavaBuilder;
import org.eclipse.wst.jsdt.internal.core.builder.SourceFile;
import org.eclipse.wst.jsdt.internal.core.builder.StringSet;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class BatchImageBuilder
extends AbstractImageBuilder {
    IncrementalImageBuilder incrementalBuilder;
    ArrayList secondaryTypes;
    StringSet typeLocatorsWithUndefinedTypes;

    protected BatchImageBuilder(JavaBuilder javaBuilder, boolean bl) {
        super(javaBuilder, bl, null);
        this.nameEnvironment.isIncrementalBuild = false;
        this.incrementalBuilder = null;
        this.secondaryTypes = null;
        this.typeLocatorsWithUndefinedTypes = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void build() {
        if (JavaBuilder.DEBUG) {
            System.out.println("FULL build");
        }
        try {
            try {
                JavaBuilder.removeProblemsAndTasksFor((IResource)this.javaBuilder.currentProject);
                this.notifier.updateProgressDelta(0.05f);
                this.notifier.subTask(Messages.build_analyzingSources);
                ArrayList arrayList = new ArrayList(33);
                this.addAllSourceFiles(arrayList);
                this.notifier.updateProgressDelta(0.1f);
                if (arrayList.size() > 0) {
                    SourceFile[] sourceFileArray = new SourceFile[arrayList.size()];
                    arrayList.toArray(sourceFileArray);
                    this.notifier.setProgressPerCompilationUnit(0.75f / (float)sourceFileArray.length);
                    this.workQueue.addAll(sourceFileArray);
                    this.compile(sourceFileArray);
                    if (this.typeLocatorsWithUndefinedTypes != null && this.secondaryTypes != null && !this.secondaryTypes.isEmpty()) {
                        this.rebuildTypesAffectedBySecondaryTypes();
                    }
                    if (this.incrementalBuilder != null) {
                        this.incrementalBuilder.buildAfterBatchBuild();
                    }
                }
                if (this.javaBuilder.javaProject.hasCycleMarker()) {
                    this.javaBuilder.mustPropagateStructuralChanges();
                }
            }
            catch (CoreException coreException) {
                throw this.internalException(coreException);
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.cleanUp();
            throw throwable;
        }
        {
            Object var3_6 = null;
            this.cleanUp();
            return;
        }
    }

    protected void acceptSecondaryType(ClassFile classFile) {
        if (this.secondaryTypes != null) {
            this.secondaryTypes.add(classFile.fileName());
        }
    }

    protected void cleanUp() {
        this.incrementalBuilder = null;
        this.secondaryTypes = null;
        this.typeLocatorsWithUndefinedTypes = null;
        super.cleanUp();
    }

    protected void compile(SourceFile[] sourceFileArray, SourceFile[] sourceFileArray2, boolean bl) {
        if (sourceFileArray2 != null && this.secondaryTypes == null) {
            this.secondaryTypes = new ArrayList(7);
        }
        super.compile(sourceFileArray, sourceFileArray2, bl);
    }

    protected void copyExtraResourcesBack(ClasspathMultiDirectory classpathMultiDirectory, final boolean bl) throws CoreException {
        this.notifier.subTask(Messages.build_copyingResources);
        final int n = classpathMultiDirectory.sourceFolder.getFullPath().segmentCount();
        final char[][] cArray = classpathMultiDirectory.exclusionPatterns;
        final char[][] cArray2 = classpathMultiDirectory.inclusionPatterns;
        final IContainer iContainer = classpathMultiDirectory.binaryFolder;
        final boolean bl2 = classpathMultiDirectory.sourceFolder.equals((Object)this.javaBuilder.currentProject);
        classpathMultiDirectory.sourceFolder.accept(new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy iResourceProxy) throws CoreException {
                IResource iResource = null;
                switch (iResourceProxy.getType()) {
                    case 1: {
                        if (Util.isJavaLikeFileName(iResourceProxy.getName()) || org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(iResourceProxy.getName())) {
                            return false;
                        }
                        iResource = iResourceProxy.requestResource();
                        if (BatchImageBuilder.this.javaBuilder.filterExtraResource(iResource)) {
                            return false;
                        }
                        if ((cArray != null || cArray2 != null) && Util.isExcluded(iResource.getFullPath(), cArray2, cArray, false)) {
                            return false;
                        }
                        IPath iPath = iResource.getFullPath().removeFirstSegments(n);
                        IFile iFile = iContainer.getFile(iPath);
                        if (iFile.exists()) {
                            if (bl) {
                                IResource iResource2 = BatchImageBuilder.this.findOriginalResource(iPath);
                                String string = iResource2.getFullPath().removeFirstSegments(1).toString();
                                BatchImageBuilder.this.createProblemFor(iResource, null, Messages.bind(Messages.build_duplicateResource, string), BatchImageBuilder.this.javaBuilder.javaProject.getOption("org.eclipse.wst.jsdt.core.builder.duplicateResourceTask", true));
                                return false;
                            }
                            iFile.delete(1, null);
                        }
                        BatchImageBuilder.this.createFolder(iPath.removeLastSegments(1), iContainer);
                        iResource.copy(iFile.getFullPath(), 1025, null);
                        Util.setReadOnly((IResource)iFile, false);
                        return false;
                    }
                    case 2: {
                        iResource = iResourceProxy.requestResource();
                        if (BatchImageBuilder.this.javaBuilder.filterExtraResource(iResource)) {
                            return false;
                        }
                        if (bl2 && BatchImageBuilder.this.isExcludedFromProject(iResource.getFullPath())) {
                            return false;
                        }
                        if (cArray == null || cArray2 != null || !Util.isExcluded(iResource.getFullPath(), null, cArray, true)) break;
                        return false;
                    }
                }
                return true;
            }
        }, 0);
    }

    protected IResource findOriginalResource(IPath iPath) {
        int n = 0;
        int n2 = this.sourceLocations.length;
        while (n < n2) {
            IFile iFile;
            ClasspathMultiDirectory classpathMultiDirectory = this.sourceLocations[n];
            if (classpathMultiDirectory.hasIndependentOutputFolder && (iFile = classpathMultiDirectory.sourceFolder.getFile(iPath)).exists()) {
                return iFile;
            }
            ++n;
        }
        return null;
    }

    protected void processAnnotationResults(CompilationParticipantResult[] compilationParticipantResultArray) {
        if (this.incrementalBuilder == null) {
            this.incrementalBuilder = new IncrementalImageBuilder(this);
        }
        this.incrementalBuilder.processAnnotationResults(compilationParticipantResultArray);
    }

    protected void rebuildTypesAffectedBySecondaryTypes() {
        if (this.incrementalBuilder == null) {
            this.incrementalBuilder = new IncrementalImageBuilder(this);
        }
        int n = this.secondaryTypes.size();
        while (--n >= 0) {
            char[] cArray = (char[])this.secondaryTypes.get(n);
            Path path = new Path(null, new String(cArray));
            this.incrementalBuilder.addDependentsOf((IPath)path, false);
        }
        this.incrementalBuilder.addAffectedSourceFiles(this.incrementalBuilder.qualifiedStrings, this.incrementalBuilder.simpleStrings, this.typeLocatorsWithUndefinedTypes);
    }

    protected void storeProblemsFor(SourceFile sourceFile, CategorizedProblem[] categorizedProblemArray) throws CoreException {
        if (sourceFile == null || categorizedProblemArray == null || categorizedProblemArray.length == 0) {
            return;
        }
        int n = categorizedProblemArray.length;
        while (--n >= 0) {
            CategorizedProblem categorizedProblem = categorizedProblemArray[n];
            if (categorizedProblem == null || categorizedProblem.getID() != 0x1000002) continue;
            if (this.typeLocatorsWithUndefinedTypes == null) {
                this.typeLocatorsWithUndefinedTypes = new StringSet(3);
            }
            this.typeLocatorsWithUndefinedTypes.add(sourceFile.typeLocator());
            break;
        }
        super.storeProblemsFor(sourceFile, categorizedProblemArray);
    }

    public String toString() {
        return "batch image builder for:\n\tnew state: " + this.newState;
    }
}

