/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.builder;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.wst.jsdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.wst.jsdt.internal.core.builder.AbortIncrementalBuildException;
import org.eclipse.wst.jsdt.internal.core.builder.AbstractImageBuilder;
import org.eclipse.wst.jsdt.internal.core.builder.BatchImageBuilder;
import org.eclipse.wst.jsdt.internal.core.builder.ClasspathJar;
import org.eclipse.wst.jsdt.internal.core.builder.ClasspathLocation;
import org.eclipse.wst.jsdt.internal.core.builder.ClasspathMultiDirectory;
import org.eclipse.wst.jsdt.internal.core.builder.CompilationParticipantResult;
import org.eclipse.wst.jsdt.internal.core.builder.JavaBuilder;
import org.eclipse.wst.jsdt.internal.core.builder.ReferenceCollection;
import org.eclipse.wst.jsdt.internal.core.builder.SourceFile;
import org.eclipse.wst.jsdt.internal.core.builder.State;
import org.eclipse.wst.jsdt.internal.core.builder.StringSet;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class IncrementalImageBuilder
extends AbstractImageBuilder {
    protected ArrayList sourceFiles;
    protected ArrayList previousSourceFiles;
    protected StringSet qualifiedStrings;
    protected StringSet simpleStrings;
    protected SimpleLookupTable secondaryTypesToRemove;
    protected boolean hasStructuralChanges;
    protected int compileLoop;
    protected boolean makeOutputFolderConsistent;
    public static int MaxCompileLoop = 5;

    protected IncrementalImageBuilder(JavaBuilder javaBuilder, State state) {
        super(javaBuilder, true, state);
        this.nameEnvironment.isIncrementalBuild = true;
        this.makeOutputFolderConsistent = "enabled".equals(javaBuilder.javaProject.getOption("org.eclipse.wst.jsdt.core.builder.recreateModifiedClassFileInOutputFolder", true));
    }

    protected IncrementalImageBuilder(JavaBuilder javaBuilder) {
        this(javaBuilder, null);
        this.newState.copyFrom(javaBuilder.lastState);
    }

    protected IncrementalImageBuilder(BatchImageBuilder batchImageBuilder) {
        this(batchImageBuilder.javaBuilder, batchImageBuilder.newState);
        this.resetCollections();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean build(SimpleLookupTable simpleLookupTable) {
        if (JavaBuilder.DEBUG) {
            System.out.println("INCREMENTAL build");
        }
        try {
            block19: {
                block18: {
                    try {
                        Object[] objectArray;
                        this.resetCollections();
                        this.notifier.subTask(Messages.build_analyzingDeltas);
                        if (this.javaBuilder.hasBuildpathErrors()) {
                            this.javaBuilder.currentProject.deleteMarkers("org.eclipse.wst.jsdt.core.problem", false, 0);
                            this.addAllSourceFiles(this.sourceFiles);
                            this.notifier.updateProgressDelta(0.25f);
                        } else {
                            IResourceDelta iResourceDelta = (IResourceDelta)simpleLookupTable.get(this.javaBuilder.currentProject);
                            if (iResourceDelta != null && !this.findSourceFiles(iResourceDelta)) {
                                break block18;
                            }
                            this.notifier.updateProgressDelta(0.1f);
                            objectArray = simpleLookupTable.keyTable;
                            Object[] objectArray2 = simpleLookupTable.valueTable;
                            int n = 0;
                            int n2 = objectArray2.length;
                            while (true) {
                                IProject iProject;
                                ClasspathLocation[] classpathLocationArray;
                                if (n >= n2) {
                                    this.notifier.updateProgressDelta(0.1f);
                                    this.notifier.subTask(Messages.build_analyzingSources);
                                    this.addAffectedSourceFiles();
                                    this.notifier.updateProgressDelta(0.05f);
                                    break;
                                }
                                IResourceDelta iResourceDelta2 = (IResourceDelta)objectArray2[n];
                                if (iResourceDelta2 == null || (classpathLocationArray = (ClasspathLocation[])this.javaBuilder.binaryLocationsPerProject.get(iProject = (IProject)objectArray[n])) == null || this.findAffectedSourceFiles(iResourceDelta2, classpathLocationArray, iProject)) {
                                    ++n;
                                    continue;
                                }
                                break block18;
                                break;
                            }
                        }
                        this.compileLoop = 0;
                        float f = 0.4f;
                        while (true) {
                            if (this.sourceFiles.size() <= 0) {
                                if (this.hasStructuralChanges && this.javaBuilder.javaProject.hasCycleMarker()) {
                                    this.javaBuilder.mustPropagateStructuralChanges();
                                }
                                break block19;
                            }
                            if (++this.compileLoop > MaxCompileLoop) {
                                if (JavaBuilder.DEBUG) {
                                    System.out.println("ABORTING incremental build... exceeded loop count");
                                }
                                break;
                            }
                            this.notifier.checkCancel();
                            objectArray = new SourceFile[this.sourceFiles.size()];
                            this.sourceFiles.toArray(objectArray);
                            this.resetCollections();
                            this.workQueue.addAll((SourceFile[])objectArray);
                            this.notifier.setProgressPerCompilationUnit(f / (float)objectArray.length);
                            f /= 2.0f;
                            this.compile((SourceFile[])objectArray);
                            this.addAffectedSourceFiles();
                        }
                    }
                    catch (AbortIncrementalBuildException abortIncrementalBuildException) {
                        if (!JavaBuilder.DEBUG) break block18;
                        System.out.println("ABORTING incremental build... problem with " + abortIncrementalBuildException.qualifiedTypeName + ". Likely renamed inside its existing source file.");
                    }
                }
                Object var10_6 = null;
                this.cleanUp();
                return false;
                catch (CoreException coreException) {
                    throw this.internalException(coreException);
                }
            }
            Object var10_8 = null;
            this.cleanUp();
            return true;
        }
        catch (Throwable throwable) {
            Object var10_7 = null;
            this.cleanUp();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void buildAfterBatchBuild() {
        if (JavaBuilder.DEBUG) {
            System.out.println("INCREMENTAL build after batch build @ " + new Date(System.currentTimeMillis()));
        }
        try {
            this.addAffectedSourceFiles();
            while (this.sourceFiles.size() > 0) {
                this.notifier.checkCancel();
                SourceFile[] sourceFileArray = new SourceFile[this.sourceFiles.size()];
                this.sourceFiles.toArray(sourceFileArray);
                this.resetCollections();
                this.notifier.setProgressPerCompilationUnit(0.08f / (float)sourceFileArray.length);
                this.workQueue.addAll(sourceFileArray);
                this.compile(sourceFileArray);
                this.addAffectedSourceFiles();
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.cleanUp();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.cleanUp();
            return;
        }
    }

    protected void addAffectedSourceFiles() {
        if (this.qualifiedStrings.elementSize == 0 && this.simpleStrings.elementSize == 0) {
            return;
        }
        this.addAffectedSourceFiles(this.qualifiedStrings, this.simpleStrings, null);
    }

    protected void addAffectedSourceFiles(StringSet stringSet, StringSet stringSet2, StringSet stringSet3) {
        char[][] cArray;
        char[][][] cArray2 = ReferenceCollection.internQualifiedNames(stringSet);
        if (cArray2.length < stringSet.elementSize) {
            cArray2 = null;
        }
        if ((cArray = ReferenceCollection.internSimpleNames(stringSet2)).length < stringSet2.elementSize) {
            cArray = null;
        }
        Object[] objectArray = this.newState.references.keyTable;
        Object[] objectArray2 = this.newState.references.valueTable;
        int n = 0;
        int n2 = objectArray2.length;
        while (n < n2) {
            IFile iFile;
            SourceFile sourceFile;
            ReferenceCollection referenceCollection;
            String string = (String)objectArray[n];
            if (!(string == null || stringSet3 != null && !stringSet3.includes(string) || !(referenceCollection = (ReferenceCollection)objectArray2[n]).includes(cArray2, cArray) || (sourceFile = this.findSourceFile(iFile = this.javaBuilder.currentProject.getFile(string), true)) == null || this.sourceFiles.contains(sourceFile) || this.compiledAllAtOnce && this.previousSourceFiles != null && this.previousSourceFiles.contains(sourceFile))) {
                if (JavaBuilder.DEBUG) {
                    System.out.println("  adding affected source file " + string);
                }
                this.sourceFiles.add(sourceFile);
            }
            ++n;
        }
    }

    protected void addDependentsOf(IPath iPath, boolean bl) {
        if (bl && !this.hasStructuralChanges) {
            this.newState.tagAsStructurallyChanged();
            this.hasStructuralChanges = true;
        }
        iPath = iPath.setDevice(null);
        String string = iPath.removeLastSegments(1).toString();
        this.qualifiedStrings.add(string);
        String string2 = iPath.lastSegment();
        int n = string2.indexOf(36);
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        if (this.simpleStrings.add(string2) && JavaBuilder.DEBUG) {
            System.out.println("  will look for dependents of " + string2 + " in " + string);
        }
    }

    protected boolean checkForClassFileChanges(IResourceDelta iResourceDelta, ClasspathMultiDirectory classpathMultiDirectory, int n) throws CoreException {
        IResource iResource = iResourceDelta.getResource();
        boolean bl = (classpathMultiDirectory.exclusionPatterns != null || classpathMultiDirectory.inclusionPatterns != null) && Util.isExcluded(iResource, classpathMultiDirectory.inclusionPatterns, classpathMultiDirectory.exclusionPatterns);
        switch (iResource.getType()) {
            case 2: {
                if (bl && classpathMultiDirectory.inclusionPatterns == null) {
                    return true;
                }
                IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren();
                int n2 = 0;
                int n3 = iResourceDeltaArray.length;
                while (n2 < n3) {
                    if (!this.checkForClassFileChanges(iResourceDeltaArray[n2], classpathMultiDirectory, n)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            case 1: {
                if (bl || !org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(iResource.getName())) break;
                IPath iPath = iResource.getFullPath().removeFirstSegments(n).removeFileExtension();
                if (this.newState.isKnownType(iPath.toString())) {
                    if (JavaBuilder.DEBUG) {
                        System.out.println("MUST DO FULL BUILD. Found change to class file " + iPath);
                    }
                    return false;
                }
                return true;
            }
        }
        return true;
    }

    protected void cleanUp() {
        super.cleanUp();
        this.sourceFiles = null;
        this.previousSourceFiles = null;
        this.qualifiedStrings = null;
        this.simpleStrings = null;
        this.secondaryTypesToRemove = null;
        this.hasStructuralChanges = false;
        this.compileLoop = 0;
    }

    protected void compile(SourceFile[] sourceFileArray, SourceFile[] sourceFileArray2, boolean bl) {
        if (bl && sourceFileArray2 != null) {
            ArrayList<SourceFile> arrayList = null;
            int n = 0;
            int n2 = sourceFileArray2.length;
            while (n < n2) {
                SourceFile sourceFile = sourceFileArray2[n];
                if (sourceFile != null && this.newState.getDefinedTypeNamesFor(sourceFile.typeLocator()) != null) {
                    if (JavaBuilder.DEBUG) {
                        System.out.println("About to compile file with secondary types " + sourceFile.typeLocator());
                    }
                    if (arrayList == null) {
                        arrayList = new ArrayList<SourceFile>(3);
                    }
                    arrayList.add(sourceFile);
                }
                ++n;
            }
            if (arrayList != null) {
                n = sourceFileArray.length;
                n2 = arrayList.size();
                SourceFile[] sourceFileArray3 = sourceFileArray;
                sourceFileArray = new SourceFile[n + n2];
                System.arraycopy(sourceFileArray3, 0, sourceFileArray, 0, n);
                int n3 = 0;
                while (n3 < n2) {
                    sourceFileArray[n++] = (SourceFile)arrayList.get(n3);
                    ++n3;
                }
            }
        }
        super.compile(sourceFileArray, sourceFileArray2, bl);
    }

    protected void deleteGeneratedFiles(IFile[] iFileArray) {
        try {
            int n = iFileArray.length;
            while (--n >= 0) {
                IFile iFile = iFileArray[n];
                if (iFile.exists()) continue;
                SourceFile sourceFile = this.findSourceFile(iFile, false);
                String string = sourceFile.typeLocator();
                int n2 = sourceFile.sourceLocation.sourceFolder.getFullPath().segmentCount();
                IPath iPath = sourceFile.resource.getFullPath().removeFirstSegments(n2).removeFileExtension();
                this.addDependentsOf(iPath, true);
                this.previousSourceFiles = null;
                char[][] cArray = this.newState.getDefinedTypeNamesFor(string);
                if (cArray == null) {
                    this.removeClassFile(iPath, sourceFile.sourceLocation.binaryFolder);
                } else if (cArray.length > 0) {
                    IPath iPath2 = iPath.removeLastSegments(1);
                    int n3 = 0;
                    int n4 = cArray.length;
                    while (n3 < n4) {
                        this.removeClassFile(iPath2.append(new String(cArray[n3])), sourceFile.sourceLocation.binaryFolder);
                        ++n3;
                    }
                }
                this.newState.removeLocator(string);
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    protected boolean findAffectedSourceFiles(IResourceDelta iResourceDelta, ClasspathLocation[] classpathLocationArray, IProject iProject) {
        int n = 0;
        int n2 = classpathLocationArray.length;
        while (n < n2) {
            IResourceDelta iResourceDelta2;
            IPath iPath;
            ClasspathLocation classpathLocation = classpathLocationArray[n];
            if (classpathLocation != null && (iPath = classpathLocation.getProjectRelativePath()) != null && (iResourceDelta2 = iResourceDelta.findMember(iPath)) != null) {
                if (classpathLocation instanceof ClasspathJar) {
                    if (JavaBuilder.DEBUG) {
                        System.out.println("ABORTING incremental build... found delta to jar/zip file");
                    }
                    return false;
                }
                if (iResourceDelta2.getKind() == 1 || iResourceDelta2.getKind() == 2) {
                    if (JavaBuilder.DEBUG) {
                        System.out.println("ABORTING incremental build... found added/removed binary folder");
                    }
                    return false;
                }
                int n3 = iResourceDelta2.getFullPath().segmentCount();
                IResourceDelta[] iResourceDeltaArray = iResourceDelta2.getAffectedChildren();
                StringSet stringSet = null;
                if (classpathLocation.isOutputFolder()) {
                    stringSet = this.newState.getStructurallyChangedTypes(this.javaBuilder.getLastState(iProject));
                }
                int n4 = 0;
                int n5 = iResourceDeltaArray.length;
                while (n4 < n5) {
                    this.findAffectedSourceFiles(iResourceDeltaArray[n4], n3, stringSet);
                    ++n4;
                }
                this.notifier.checkCancel();
            }
            ++n;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected void findAffectedSourceFiles(IResourceDelta var1_1, int var2_2, StringSet var3_3) {
        var4_4 = var1_1.getResource();
        switch (var4_4.getType()) {
            case 2: {
                switch (var1_1.getKind()) {
                    case 1: 
                    case 2: {
                        var5_5 = var4_4.getFullPath().removeFirstSegments(var2_2);
                        var6_7 = var5_5.toString();
                        if (var1_1.getKind() != 1) ** GOTO lbl17
                        if (!this.newState.isKnownPackage(var6_7)) {
                            if (JavaBuilder.DEBUG) {
                                System.out.println("Found added package " + var6_7);
                            }
                            this.addDependentsOf(var5_5, false);
                            return;
                        }
                        if (JavaBuilder.DEBUG) {
                            System.out.println("Skipped dependents of added package " + var6_7);
                        }
                        ** GOTO lbl24
lbl17:
                        // 1 sources

                        if (!this.nameEnvironment.isPackage(var6_7)) {
                            if (JavaBuilder.DEBUG) {
                                System.out.println("Found removed package " + var6_7);
                            }
                            this.addDependentsOf(var5_5, false);
                            return;
                        }
                        if (JavaBuilder.DEBUG) {
                            System.out.println("Skipped dependents of removed package " + var6_7);
                        }
                    }
lbl24:
                    // 5 sources

                    case 4: {
                        var7_8 = var1_1.getAffectedChildren();
                        var8_9 = 0;
                        var9_10 = var7_8.length;
                        while (var8_9 < var9_10) {
                            this.findAffectedSourceFiles(var7_8[var8_9], var2_2, var3_3);
                            ++var8_9;
                        }
                        break;
                    }
                }
                return;
            }
            case 1: {
                if (!org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(var4_4.getName())) break;
                var5_6 = var4_4.getFullPath().removeFirstSegments(var2_2).removeFileExtension();
                switch (var1_1.getKind()) {
                    case 1: 
                    case 2: {
                        if (JavaBuilder.DEBUG) {
                            System.out.println("Found added/removed class file " + var5_6);
                        }
                        this.addDependentsOf(var5_6, false);
                        return;
                    }
                    case 4: {
                        if ((var1_1.getFlags() & 256) == 0) {
                            return;
                        }
                        if (var3_3 != null && !var3_3.includes(var5_6.toString())) {
                            return;
                        }
                        if (JavaBuilder.DEBUG) {
                            System.out.println("Found changed class file " + var5_6);
                        }
                        this.addDependentsOf(var5_6, false);
                    }
                }
                return;
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected boolean findSourceFiles(IResourceDelta iResourceDelta) throws CoreException {
        ArrayList<IContainer> arrayList = this.makeOutputFolderConsistent ? new ArrayList<IContainer>(this.sourceLocations.length) : null;
        int n = 0;
        int n2 = this.sourceLocations.length;
        while (n < n2) {
            int n3;
            int n4;
            IResourceDelta[] iResourceDeltaArray;
            int n5;
            IResourceDelta iResourceDelta2;
            ClasspathMultiDirectory classpathMultiDirectory = this.sourceLocations[n];
            if (this.makeOutputFolderConsistent && classpathMultiDirectory.hasIndependentOutputFolder && !arrayList.contains(classpathMultiDirectory.binaryFolder)) {
                arrayList.add(classpathMultiDirectory.binaryFolder);
                iResourceDelta2 = iResourceDelta.findMember(classpathMultiDirectory.binaryFolder.getProjectRelativePath());
                if (iResourceDelta2 != null) {
                    n5 = iResourceDelta2.getFullPath().segmentCount();
                    iResourceDeltaArray = iResourceDelta2.getAffectedChildren();
                    n4 = 0;
                    n3 = iResourceDeltaArray.length;
                    while (n4 < n3) {
                        if (!this.checkForClassFileChanges(iResourceDeltaArray[n4], classpathMultiDirectory, n5)) {
                            return false;
                        }
                        ++n4;
                    }
                }
            }
            if (classpathMultiDirectory.sourceFolder.equals((Object)this.javaBuilder.currentProject)) {
                int n6 = iResourceDelta.getFullPath().segmentCount();
                IResourceDelta[] iResourceDeltaArray2 = iResourceDelta.getAffectedChildren();
                int n7 = 0;
                n4 = iResourceDeltaArray2.length;
                while (n7 < n4) {
                    if (!this.isExcludedFromProject(iResourceDeltaArray2[n7].getFullPath()) && !this.findSourceFiles(iResourceDeltaArray2[n7], classpathMultiDirectory, n6)) {
                        return false;
                    }
                    ++n7;
                }
            } else {
                iResourceDelta2 = iResourceDelta.findMember(classpathMultiDirectory.sourceFolder.getProjectRelativePath());
                if (iResourceDelta2 != null) {
                    if (iResourceDelta2.getKind() == 2) {
                        if (JavaBuilder.DEBUG) {
                            System.out.println("ABORTING incremental build... found removed source folder");
                        }
                        return false;
                    }
                    n5 = iResourceDelta2.getFullPath().segmentCount();
                    iResourceDeltaArray = iResourceDelta2.getAffectedChildren();
                    try {
                        n4 = 0;
                        n3 = iResourceDeltaArray.length;
                        while (n4 < n3) {
                            if (!this.findSourceFiles(iResourceDeltaArray[n4], classpathMultiDirectory, n5)) {
                                return false;
                            }
                            ++n4;
                        }
                    }
                    catch (CoreException coreException) {
                        if (coreException.getStatus().getCode() == 275) {
                            if (JavaBuilder.DEBUG) {
                                System.out.println("ABORTING incremental build... found renamed package");
                            }
                            return false;
                        }
                        throw coreException;
                    }
                }
            }
            this.notifier.checkCancel();
            ++n;
        }
        return true;
    }

    protected boolean findSourceFiles(IResourceDelta iResourceDelta, ClasspathMultiDirectory classpathMultiDirectory, int n) throws CoreException {
        IResource iResource = iResourceDelta.getResource();
        boolean bl = (classpathMultiDirectory.exclusionPatterns != null || classpathMultiDirectory.inclusionPatterns != null) && Util.isExcluded(iResource, classpathMultiDirectory.inclusionPatterns, classpathMultiDirectory.exclusionPatterns);
        switch (iResource.getType()) {
            case 2: {
                if (bl && classpathMultiDirectory.inclusionPatterns == null) {
                    return true;
                }
                switch (iResourceDelta.getKind()) {
                    case 1: {
                        IPath iPath;
                        if (!bl) {
                            iPath = iResource.getFullPath().removeFirstSegments(n);
                            this.createFolder(iPath, classpathMultiDirectory.binaryFolder);
                            if (JavaBuilder.DEBUG) {
                                System.out.println("Found added package " + iPath);
                            }
                            this.addDependentsOf(iPath, true);
                        }
                    }
                    case 4: {
                        IPath iPath = iResourceDelta.getAffectedChildren();
                        int n2 = 0;
                        int n3 = ((IPath)iPath).length;
                        while (n2 < n3) {
                            if (!this.findSourceFiles((IResourceDelta)iPath[n2], classpathMultiDirectory, n)) {
                                return false;
                            }
                            ++n2;
                        }
                        return true;
                    }
                    case 2: {
                        IFolder iFolder;
                        if (bl) {
                            IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren();
                            int n4 = 0;
                            int n5 = iResourceDeltaArray.length;
                            while (n4 < n5) {
                                if (!this.findSourceFiles(iResourceDeltaArray[n4], classpathMultiDirectory, n)) {
                                    return false;
                                }
                                ++n4;
                            }
                            return true;
                        }
                        IPath iPath = iResource.getFullPath().removeFirstSegments(n);
                        if (this.sourceLocations.length > 1) {
                            int n6 = 0;
                            int n7 = this.sourceLocations.length;
                            while (n6 < n7) {
                                if (this.sourceLocations[n6].sourceFolder.getFolder(iPath).exists()) {
                                    this.createFolder(iPath, classpathMultiDirectory.binaryFolder);
                                    IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren();
                                    int n8 = 0;
                                    int n9 = iResourceDeltaArray.length;
                                    while (n8 < n9) {
                                        if (!this.findSourceFiles(iResourceDeltaArray[n8], classpathMultiDirectory, n)) {
                                            return false;
                                        }
                                        ++n8;
                                    }
                                    return true;
                                }
                                ++n6;
                            }
                        }
                        if ((iFolder = classpathMultiDirectory.binaryFolder.getFolder(iPath)).exists()) {
                            iFolder.delete(1, null);
                        }
                        if (JavaBuilder.DEBUG) {
                            System.out.println("Found removed package " + iPath);
                        }
                        this.addDependentsOf(iPath, true);
                        this.newState.removePackage(iResourceDelta);
                    }
                }
                return true;
            }
            case 1: {
                if (bl) {
                    return true;
                }
                String string = iResource.getName();
                if (Util.isJavaLikeFileName(string)) {
                    IPath iPath = iResource.getFullPath().removeFirstSegments(n).removeFileExtension();
                    String string2 = iResource.getProjectRelativePath().toString();
                    switch (iResourceDelta.getKind()) {
                        case 1: {
                            if (JavaBuilder.DEBUG) {
                                System.out.println("Compile this added source file " + string2);
                            }
                            this.sourceFiles.add(new SourceFile((IFile)iResource, classpathMultiDirectory, true));
                            String string3 = iPath.toString();
                            if (!this.newState.isDuplicateLocator(string3, string2)) {
                                if (JavaBuilder.DEBUG) {
                                    System.out.println("Found added source file " + string3);
                                }
                                this.addDependentsOf(iPath, true);
                            }
                            return true;
                        }
                        case 2: {
                            char[][] cArray = this.newState.getDefinedTypeNamesFor(string2);
                            if (cArray == null) {
                                this.removeClassFile(iPath, classpathMultiDirectory.binaryFolder);
                                if ((iResourceDelta.getFlags() & 0x2000) != 0) {
                                    IFile iFile = this.javaBuilder.workspaceRoot.getFile(iResourceDelta.getMovedToPath());
                                    JavaBuilder.removeProblemsAndTasksFor((IResource)iFile);
                                }
                            } else {
                                if (JavaBuilder.DEBUG) {
                                    System.out.println("Found removed source file " + iPath.toString());
                                }
                                this.addDependentsOf(iPath, true);
                                if (cArray.length > 0) {
                                    IPath iPath2 = iPath.removeLastSegments(1);
                                    int n10 = 0;
                                    int n11 = cArray.length;
                                    while (n10 < n11) {
                                        this.removeClassFile(iPath2.append(new String(cArray[n10])), classpathMultiDirectory.binaryFolder);
                                        ++n10;
                                    }
                                }
                            }
                            this.newState.removeLocator(string2);
                            return true;
                        }
                        case 4: {
                            if ((iResourceDelta.getFlags() & 0x100) == 0 && (iResourceDelta.getFlags() & 0x100000) == 0) {
                                return true;
                            }
                            if (JavaBuilder.DEBUG) {
                                System.out.println("Compile this changed source file " + string2);
                            }
                            this.sourceFiles.add(new SourceFile((IFile)iResource, classpathMultiDirectory, true));
                        }
                    }
                    return true;
                }
                if (org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(string)) {
                    IPath iPath;
                    if (this.makeOutputFolderConsistent && this.newState.isKnownType((iPath = iResource.getFullPath().removeFirstSegments(n).removeFileExtension()).toString())) {
                        if (JavaBuilder.DEBUG) {
                            System.out.println("MUST DO FULL BUILD. Found change to class file " + iPath);
                        }
                        return false;
                    }
                    return true;
                }
                if (!classpathMultiDirectory.hasIndependentOutputFolder) break;
                if (this.javaBuilder.filterExtraResource(iResource)) {
                    return true;
                }
                IPath iPath = iResource.getFullPath().removeFirstSegments(n);
                IFile iFile = classpathMultiDirectory.binaryFolder.getFile(iPath);
                switch (iResourceDelta.getKind()) {
                    case 1: {
                        if (iFile.exists()) {
                            if (JavaBuilder.DEBUG) {
                                System.out.println("Deleting existing file " + iPath);
                            }
                            iFile.delete(1, null);
                        }
                        if (JavaBuilder.DEBUG) {
                            System.out.println("Copying added file " + iPath);
                        }
                        this.createFolder(iPath.removeLastSegments(1), classpathMultiDirectory.binaryFolder);
                        iResource.copy(iFile.getFullPath(), 1025, null);
                        Util.setReadOnly((IResource)iFile, false);
                        return true;
                    }
                    case 2: {
                        if (iFile.exists()) {
                            if (JavaBuilder.DEBUG) {
                                System.out.println("Deleting removed file " + iPath);
                            }
                            iFile.delete(1, null);
                        }
                        return true;
                    }
                    case 4: {
                        if ((iResourceDelta.getFlags() & 0x100) == 0 && (iResourceDelta.getFlags() & 0x100000) == 0) {
                            return true;
                        }
                        if (iFile.exists()) {
                            if (JavaBuilder.DEBUG) {
                                System.out.println("Deleting existing file " + iPath);
                            }
                            iFile.delete(1, null);
                        }
                        if (!JavaBuilder.DEBUG) break;
                        System.out.println("Copying changed file " + iPath);
                    }
                }
                return true;
            }
        }
        return true;
    }

    protected void finishedWith(String string, CompilationResult compilationResult, char[] cArray, ArrayList arrayList, ArrayList arrayList2) {
        Object object = this.newState.getDefinedTypeNamesFor(string);
        if (object == null) {
            object = new char[][]{cArray};
        }
        IPath iPath = null;
        int n = 0;
        int n2 = ((char[][])object).length;
        while (n < n2) {
            block7: {
                ArrayList<IPath> arrayList3;
                char[] cArray2 = object[n];
                int n3 = 0;
                int n4 = arrayList.size();
                while (n3 < n4) {
                    if (!CharOperation.equals(cArray2, (char[])arrayList.get(n3))) {
                        ++n3;
                        continue;
                    }
                    break block7;
                }
                SourceFile sourceFile = (SourceFile)compilationResult.getCompilationUnit();
                if (iPath == null) {
                    n4 = sourceFile.sourceLocation.sourceFolder.getFullPath().segmentCount();
                    iPath = sourceFile.resource.getFullPath().removeFirstSegments(n4).removeLastSegments(1);
                }
                if (this.secondaryTypesToRemove == null) {
                    this.secondaryTypesToRemove = new SimpleLookupTable();
                }
                if ((arrayList3 = (ArrayList<IPath>)this.secondaryTypesToRemove.get(sourceFile.sourceLocation.binaryFolder)) == null) {
                    arrayList3 = new ArrayList<IPath>(arrayList.size());
                }
                arrayList3.add(iPath.append(new String(cArray2)));
                this.secondaryTypesToRemove.put(sourceFile.sourceLocation.binaryFolder, arrayList3);
            }
            ++n;
        }
        super.finishedWith(string, compilationResult, cArray, arrayList, arrayList2);
    }

    protected void processAnnotationResults(CompilationParticipantResult[] compilationParticipantResultArray) {
        int n = compilationParticipantResultArray.length;
        while (--n >= 0) {
            IFile[] iFileArray;
            CompilationParticipantResult compilationParticipantResult = compilationParticipantResultArray[n];
            if (compilationParticipantResult == null) continue;
            IFile[] iFileArray2 = compilationParticipantResult.deletedFiles;
            if (iFileArray2 != null) {
                this.deleteGeneratedFiles(iFileArray2);
            }
            if ((iFileArray = compilationParticipantResult.addedFiles) != null) {
                int n2 = iFileArray.length;
                while (--n2 >= 0) {
                    SourceFile sourceFile = this.findSourceFile(iFileArray[n2], true);
                    if (sourceFile == null || this.sourceFiles.contains(sourceFile)) continue;
                    this.sourceFiles.add(sourceFile);
                }
            }
            this.recordParticipantResult(compilationParticipantResult);
        }
    }

    protected void removeClassFile(IPath iPath, IContainer iContainer) throws CoreException {
        IFile iFile;
        if (iPath.lastSegment().indexOf(36) == -1) {
            this.newState.removeQualifiedTypeName(iPath.toString());
            if (JavaBuilder.DEBUG) {
                System.out.println("Found removed type " + iPath);
            }
            this.addDependentsOf(iPath, true);
        }
        if ((iFile = iContainer.getFile(iPath.addFileExtension("js"))).exists()) {
            if (JavaBuilder.DEBUG) {
                System.out.println("Deleting class file of removed type " + iPath);
            }
            iFile.delete(1, null);
        }
    }

    protected void removeSecondaryTypes() throws CoreException {
        if (this.secondaryTypesToRemove != null) {
            Object[] objectArray = this.secondaryTypesToRemove.keyTable;
            Object[] objectArray2 = this.secondaryTypesToRemove.valueTable;
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                IContainer iContainer = (IContainer)objectArray[n];
                if (iContainer != null) {
                    ArrayList arrayList = (ArrayList)objectArray2[n];
                    int n3 = 0;
                    int n4 = arrayList.size();
                    while (n3 < n4) {
                        this.removeClassFile((IPath)arrayList.get(n3), iContainer);
                        ++n3;
                    }
                }
                ++n;
            }
            this.secondaryTypesToRemove = null;
            if (this.previousSourceFiles != null) {
                this.previousSourceFiles = null;
            }
        }
    }

    protected void resetCollections() {
        if (this.sourceFiles == null) {
            this.sourceFiles = new ArrayList(33);
            this.previousSourceFiles = null;
            this.qualifiedStrings = new StringSet(3);
            this.simpleStrings = new StringSet(3);
            this.hasStructuralChanges = false;
            this.compileLoop = 0;
        } else {
            this.previousSourceFiles = this.sourceFiles.isEmpty() ? null : (ArrayList)this.sourceFiles.clone();
            this.sourceFiles.clear();
            this.qualifiedStrings.clear();
            this.simpleStrings.clear();
            this.workQueue.clear();
        }
    }

    protected void updateProblemsFor(SourceFile sourceFile, CompilationResult compilationResult) throws CoreException {
        IMarker[] iMarkerArray = JavaBuilder.getProblemsFor((IResource)sourceFile.resource);
        CategorizedProblem[] categorizedProblemArray = compilationResult.getProblems();
        if (categorizedProblemArray == null && iMarkerArray.length == 0) {
            return;
        }
        this.notifier.updateProblemCounts(iMarkerArray, categorizedProblemArray);
        JavaBuilder.removeProblemsFor((IResource)sourceFile.resource);
        this.storeProblemsFor(sourceFile, categorizedProblemArray);
    }

    protected void updateTasksFor(SourceFile sourceFile, CompilationResult compilationResult) throws CoreException {
        IMarker[] iMarkerArray = JavaBuilder.getTasksFor((IResource)sourceFile.resource);
        CategorizedProblem[] categorizedProblemArray = compilationResult.getTasks();
        if (categorizedProblemArray == null && iMarkerArray.length == 0) {
            return;
        }
        JavaBuilder.removeTasksFor((IResource)sourceFile.resource);
        this.storeTasksFor(sourceFile, categorizedProblemArray);
    }

    /*
     * Unable to fully structure code
     */
    protected void writeClassFileBytes(byte[] var1_1, IFile var2_2, String var3_3, boolean var4_4, SourceFile var5_5) throws CoreException {
        block18: {
            if (var2_2.exists()) {
                if (this.writeClassFileCheck(var2_2, var3_3, var1_1) || var5_5.updateClassFile) {
                    if (JavaBuilder.DEBUG) {
                        System.out.println("Writing changed class file " + var2_2.getName());
                    }
                    if (!var2_2.isDerived()) {
                        var2_2.setDerived(true);
                    }
                    var2_2.setContents((InputStream)new ByteArrayInputStream(var1_1), true, false, null);
                } else if (JavaBuilder.DEBUG) {
                    System.out.println("Skipped over unchanged class file " + var2_2.getName());
                }
            } else {
                block19: {
                    block20: {
                        block21: {
                            if (var4_4) {
                                this.addDependentsOf((IPath)new Path(var3_3), true);
                            }
                            if (JavaBuilder.DEBUG) {
                                System.out.println("Writing new class file " + var2_2.getName());
                            }
                            try {
                                var2_2.create((InputStream)new ByteArrayInputStream(var1_1), 1025, null);
                                break block18;
                            }
                            catch (CoreException var6_6) {
                                if (var6_6.getStatus().getCode() != 275) break block19;
                                var7_7 = var6_6.getStatus();
                                if (!(var7_7 instanceof IResourceStatus)) break block20;
                                var8_8 = ((IResourceStatus)var7_7).getPath();
                                var9_9 = var8_8.removeFileExtension().lastSegment().toCharArray();
                                var10_10 = this.newState.getDefinedTypeNamesFor(var5_5.typeLocator());
                                var11_11 = false;
                                if (var10_10 == null) {
                                    var11_11 = CharOperation.equals(var5_5.getMainTypeName(), var9_9);
                                    break block21;
                                }
                                var12_12 = 0;
                                var13_14 = var10_10.length;
                                ** while (var12_12 < var13_14)
                            }
lbl-1000:
                            // 1 sources

                            {
                                if (CharOperation.equals(var10_10[var12_12], var9_9)) {
                                    var11_11 = true;
                                    break;
                                }
                                ++var12_12;
                                continue;
                            }
                        }
                        if (var11_11) {
                            var12_13 = var2_2.getParent().getFile((IPath)new Path(var8_8.lastSegment()));
                            var12_13.delete(true, false, null);
                            var13_14 = 0;
                            try {
                                var2_2.create((InputStream)new ByteArrayInputStream(var1_1), 1025, null);
                                var13_14 = 1;
                            }
                            catch (CoreException v0) {}
                            if (var13_14 != 0) {
                                return;
                            }
                        }
                    }
                    throw new AbortCompilation(true, new AbortIncrementalBuildException(var3_3));
                }
                throw var6_6;
            }
        }
    }

    protected boolean writeClassFileCheck(IFile iFile, String string, byte[] byArray) throws CoreException {
        URI uRI;
        byte[] byArray2;
        block9: {
            block8: {
                byArray2 = Util.getResourceContentsAsByteArray(iFile);
                if (byArray.length != byArray2.length) break block8;
                int n = byArray.length;
                while (--n >= 0) {
                    if (byArray[n] == byArray2[n]) {
                        continue;
                    }
                    break block8;
                }
                return false;
            }
            uRI = iFile.getLocationURI();
            if (uRI != null) break block9;
            return false;
        }
        try {
            String string2 = uRI.getSchemeSpecificPart();
            ClassFileReader classFileReader = new ClassFileReader(byArray2, string2.toCharArray());
            if (!classFileReader.isLocal() && !classFileReader.isAnonymous() && classFileReader.hasStructuralChanges(byArray)) {
                if (JavaBuilder.DEBUG) {
                    System.out.println("Type has structural changes " + string);
                }
                this.addDependentsOf((IPath)new Path(string), true);
                this.newState.wasStructurallyChanged(string);
            }
        }
        catch (ClassFormatException classFormatException) {
            this.addDependentsOf((IPath)new Path(string), true);
            this.newState.wasStructurallyChanged(string);
        }
        return true;
    }

    public String toString() {
        return "incremental image builder for:\n\tnew state: " + this.newState;
    }
}

