/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.index;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleSet;
import org.eclipse.wst.jsdt.internal.core.index.DiskIndex;
import org.eclipse.wst.jsdt.internal.core.index.EntryResult;
import org.eclipse.wst.jsdt.internal.core.index.MemoryIndex;
import org.eclipse.wst.jsdt.internal.core.search.indexing.ReadWriteMonitor;

public class Index {
    public String containerPath;
    public ReadWriteMonitor monitor;
    protected DiskIndex diskIndex;
    protected MemoryIndex memoryIndex;
    static final int MATCH_RULE_INDEX_MASK = 143;

    public static boolean isMatch(char[] cArray, char[] cArray2, int n) {
        boolean bl;
        if (cArray == null) {
            return true;
        }
        int n2 = cArray.length;
        int n3 = cArray2.length;
        if (n2 == 0) {
            return n != 0;
        }
        if (n3 == 0) {
            return (n & 2) != 0 && n2 == 1 && cArray[0] == '*';
        }
        boolean bl2 = bl = (n & 0x80) != 0;
        if (bl && cArray[0] == cArray2[0] && CharOperation.camelCaseMatch(cArray, cArray2)) {
            return true;
        }
        switch ((n &= 0xFFFFFF7F) & 0x8F) {
            case 0: {
                if (!bl) {
                    return n2 == n3 && CharOperation.equals(cArray, cArray2, false);
                }
            }
            case 1: {
                return n2 <= n3 && CharOperation.prefixEquals(cArray, cArray2, false);
            }
            case 2: {
                return CharOperation.match(cArray, cArray2, false);
            }
            case 8: {
                if (!bl) {
                    return cArray[0] == cArray2[0] && n2 == n3 && CharOperation.equals(cArray, cArray2);
                }
            }
            case 9: {
                return cArray[0] == cArray2[0] && n2 <= n3 && CharOperation.prefixEquals(cArray, cArray2);
            }
            case 10: {
                return CharOperation.match(cArray, cArray2, true);
            }
        }
        return false;
    }

    public Index(String string, String string2, boolean bl) throws IOException {
        this.containerPath = string2;
        this.monitor = new ReadWriteMonitor();
        this.memoryIndex = new MemoryIndex();
        this.diskIndex = new DiskIndex(string);
        this.diskIndex.initialize(bl);
    }

    public void addIndexEntry(char[] cArray, char[] cArray2, String string) {
        this.memoryIndex.addIndexEntry(cArray, cArray2, string);
    }

    public String containerRelativePath(String string) {
        int n = string.indexOf("|");
        if (n == -1) {
            Path path = new Path(this.containerPath);
            Path path2 = new Path(string);
            if (path.makeAbsolute().equals((Object)path2.makeAbsolute())) {
                return string;
            }
            n = this.containerPath.length();
            if (string.length() < n) {
                throw new IllegalArgumentException("Document path " + string + " must be relative to " + this.containerPath);
            }
            if (string.length() == n) {
                --n;
            }
        }
        return string.substring(n + 1);
    }

    public File getIndexFile() {
        return this.diskIndex == null ? null : this.diskIndex.indexFile;
    }

    public boolean hasChanged() {
        return this.memoryIndex.hasChanged();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EntryResult[] query(char[][] cArray, char[] cArray2, int n) throws IOException {
        HashtableOfObject hashtableOfObject;
        if (this.memoryIndex.shouldMerge() && this.monitor.exitReadEnterWrite()) {
            try {
                this.save();
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.monitor.exitWriteEnterRead();
                throw throwable;
            }
            {
                hashtableOfObject = null;
                this.monitor.exitWriteEnterRead();
            }
        }
        int n2 = n & 0x8F;
        if (this.memoryIndex.hasChanged()) {
            hashtableOfObject = this.diskIndex.addQueryResults(cArray, cArray2, n2, this.memoryIndex);
            hashtableOfObject = this.memoryIndex.addQueryResults(cArray, cArray2, n2, hashtableOfObject);
        } else {
            hashtableOfObject = this.diskIndex.addQueryResults(cArray, cArray2, n2, null);
        }
        if (hashtableOfObject == null) {
            return null;
        }
        EntryResult[] entryResultArray = new EntryResult[hashtableOfObject.elementSize];
        int n3 = 0;
        Object[] objectArray = hashtableOfObject.valueTable;
        int n4 = 0;
        int n5 = objectArray.length;
        while (n4 < n5) {
            EntryResult entryResult = (EntryResult)objectArray[n4];
            if (entryResult != null) {
                entryResultArray[n3++] = entryResult;
            }
            ++n4;
        }
        return entryResultArray;
    }

    public String[] queryDocumentNames(String string) throws IOException {
        SimpleSet simpleSet;
        if (this.memoryIndex.hasChanged()) {
            simpleSet = this.diskIndex.addDocumentNames(string, this.memoryIndex);
            this.memoryIndex.addDocumentNames(string, simpleSet);
        } else {
            simpleSet = this.diskIndex.addDocumentNames(string, null);
        }
        if (simpleSet.elementSize == 0) {
            return null;
        }
        String[] stringArray = new String[simpleSet.elementSize];
        int n = 0;
        Object[] objectArray = simpleSet.values;
        int n2 = 0;
        int n3 = objectArray.length;
        while (n2 < n3) {
            if (objectArray[n2] != null) {
                stringArray[n++] = (String)objectArray[n2];
            }
            ++n2;
        }
        return stringArray;
    }

    public void remove(String string) {
        this.memoryIndex.remove(string);
    }

    public void save() throws IOException {
        if (!this.hasChanged()) {
            return;
        }
        int n = this.memoryIndex.docsToReferences.elementSize;
        this.diskIndex = this.diskIndex.mergeWith(this.memoryIndex);
        this.memoryIndex = new MemoryIndex();
        if (n > 1000) {
            System.gc();
        }
    }

    public void startQuery() {
        if (this.diskIndex != null) {
            this.diskIndex.startQuery();
        }
    }

    public void stopQuery() {
        if (this.diskIndex != null) {
            this.diskIndex.stopQuery();
        }
    }

    public String toString() {
        return "Index for " + this.containerPath;
    }
}

