/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.UnimplementedException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.FieldDeclarationMatch;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.ImportReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.NameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Reference;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryType;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ParameterizedFieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleSet;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.search.matching.DeclarationOfAccessedFieldsPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.FieldPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.wst.jsdt.internal.core.search.matching.VariableLocator;
import org.eclipse.wst.jsdt.internal.infer.InferredAttribute;

public class FieldLocator
extends VariableLocator {
    protected boolean isDeclarationOfAccessedFieldsPattern;
    FieldPattern fieldPattern;

    public FieldLocator(FieldPattern fieldPattern) {
        super(fieldPattern);
        this.fieldPattern = fieldPattern;
        this.isDeclarationOfAccessedFieldsPattern = this.pattern instanceof DeclarationOfAccessedFieldsPattern;
    }

    public int match(ASTNode aSTNode, MatchingNodeSet matchingNodeSet) {
        int n = 0;
        if (this.pattern.findReferences && aSTNode instanceof ImportReference) {
            ImportReference importReference = (ImportReference)aSTNode;
            int n2 = importReference.tokens.length - 1;
            if (importReference.isStatic() && (importReference.bits & 0x20000) == 0 && this.matchesName(this.pattern.name, importReference.tokens[n2])) {
                char[][] cArrayArray = new char[n2][];
                System.arraycopy(importReference.tokens, 0, cArrayArray, 0, n2);
                FieldPattern fieldPattern = (FieldPattern)this.pattern;
                char[] cArray = CharOperation.concat(fieldPattern.declaringQualification, fieldPattern.declaringSimpleName, '.');
                if (this.matchesName(cArray, CharOperation.concatWith(cArrayArray, '.'))) {
                    n = this.pattern.mustResolve ? 2 : 3;
                }
            }
        }
        return matchingNodeSet.addMatch(aSTNode, n);
    }

    public int match(FieldDeclaration fieldDeclaration, MatchingNodeSet matchingNodeSet) {
        int n = 0;
        if (this.pattern.findReferences && this.pattern.writeAccess && !this.pattern.readAccess && fieldDeclaration.initialization != null && this.matchesName(this.pattern.name, fieldDeclaration.name)) {
            n = this.pattern.mustResolve ? 2 : 3;
        }
        int n2 = 0;
        if (this.pattern.findDeclarations) {
            switch (fieldDeclaration.getKind()) {
                case 1: 
                case 3: {
                    if (!this.matchesName(this.pattern.name, fieldDeclaration.name) || !this.matchesTypeReference(((FieldPattern)this.pattern).typeSimpleName, fieldDeclaration.type)) break;
                    n2 = this.pattern.mustResolve ? 2 : 3;
                }
            }
        }
        return matchingNodeSet.addMatch(fieldDeclaration, n >= n2 ? n : n2);
    }

    public int match(LocalDeclaration localDeclaration, MatchingNodeSet matchingNodeSet) {
        if (!this.fieldPattern.isVar) {
            return 0;
        }
        int n = 0;
        if (this.pattern.findReferences && this.pattern.writeAccess && !this.pattern.readAccess && localDeclaration.initialization != null && this.matchesName(this.pattern.name, localDeclaration.name)) {
            n = this.pattern.mustResolve ? 2 : 3;
        }
        int n2 = 0;
        if (this.pattern.findDeclarations && this.matchesName(this.pattern.name, localDeclaration.name)) {
            n2 = this.pattern.mustResolve ? 2 : 3;
        }
        return matchingNodeSet.addMatch(localDeclaration, n >= n2 ? n : n2);
    }

    public int match(InferredAttribute inferredAttribute, MatchingNodeSet matchingNodeSet) {
        if (this.fieldPattern.isVar) {
            return 0;
        }
        int n = 0;
        if (this.pattern.findReferences && this.pattern.writeAccess && !this.pattern.readAccess && this.matchesName(this.pattern.name, inferredAttribute.name)) {
            n = this.pattern.mustResolve ? 2 : 3;
        }
        int n2 = 0;
        if (this.pattern.findDeclarations && this.matchesName(this.pattern.name, inferredAttribute.name)) {
            n2 = this.pattern.mustResolve ? 2 : 3;
        }
        return matchingNodeSet.addMatch(inferredAttribute, n >= n2 ? n : n2);
    }

    protected int matchContainer() {
        if (this.pattern.findReferences) {
            return 15;
        }
        return this.fieldPattern.isVar ? 1 : 2;
    }

    protected int matchField(FieldBinding fieldBinding, boolean bl) {
        int n;
        if (fieldBinding == null) {
            return 1;
        }
        if (bl && !this.matchesName(this.pattern.name, fieldBinding.readableName())) {
            return 0;
        }
        FieldPattern fieldPattern = (FieldPattern)this.pattern;
        ReferenceBinding referenceBinding = fieldBinding.declaringClass;
        if (referenceBinding == null) {
            if (fieldBinding == ArrayBinding.ArrayLength) {
                return fieldPattern.declaringQualification == null && fieldPattern.declaringSimpleName == null ? 3 : 0;
            }
            return 1;
        }
        int n2 = this.resolveLevelForType(fieldPattern.declaringSimpleName, fieldPattern.declaringQualification, referenceBinding);
        if (n2 == 0) {
            return 0;
        }
        if (fieldPattern.declaringSimpleName == null) {
            return n2;
        }
        FieldBinding fieldBinding2 = fieldBinding;
        if (fieldBinding instanceof ParameterizedFieldBinding) {
            fieldBinding2 = ((ParameterizedFieldBinding)fieldBinding).originalField;
        }
        return n2 > (n = this.resolveLevelForType(fieldBinding2.type)) ? n : n2;
    }

    protected int matchLocalVariable(LocalVariableBinding localVariableBinding, boolean bl) {
        if (localVariableBinding == null) {
            return 1;
        }
        if (bl && !this.matchesName(this.pattern.name, localVariableBinding.readableName())) {
            return 0;
        }
        return 3;
    }

    protected void matchLevelAndReportImportRef(ImportReference importReference, Binding binding, MatchLocator matchLocator) throws CoreException {
        if (importReference.isStatic() && binding instanceof FieldBinding) {
            super.matchLevelAndReportImportRef(importReference, binding, matchLocator);
        }
    }

    protected int matchReference(Reference reference, MatchingNodeSet matchingNodeSet, boolean bl) {
        if (reference instanceof FieldReference) {
            if (this.matchesName(this.pattern.name, ((FieldReference)reference).token)) {
                return matchingNodeSet.addMatch(reference, this.pattern.mustResolve ? 2 : 3);
            }
            return 0;
        }
        return super.matchReference(reference, matchingNodeSet, bl);
    }

    protected void matchReportReference(ASTNode aSTNode, IJavaElement iJavaElement, Binding binding, int n, MatchLocator matchLocator) throws CoreException {
        if (this.isDeclarationOfAccessedFieldsPattern) {
            if (n != 0) {
                return;
            }
            DeclarationOfAccessedFieldsPattern declarationOfAccessedFieldsPattern = (DeclarationOfAccessedFieldsPattern)this.pattern;
            while (iJavaElement != null && !declarationOfAccessedFieldsPattern.enclosingElement.equals(iJavaElement)) {
                iJavaElement = iJavaElement.getParent();
            }
            if (iJavaElement != null) {
                if (aSTNode instanceof FieldReference) {
                    this.reportDeclaration(((FieldReference)aSTNode).binding, matchLocator, declarationOfAccessedFieldsPattern.knownFields);
                } else if (aSTNode instanceof QualifiedNameReference) {
                    QualifiedNameReference qualifiedNameReference = (QualifiedNameReference)aSTNode;
                    Binding binding2 = qualifiedNameReference.binding;
                    if (binding2 instanceof FieldBinding) {
                        this.reportDeclaration((FieldBinding)binding2, matchLocator, declarationOfAccessedFieldsPattern.knownFields);
                    }
                    int n2 = qualifiedNameReference.otherBindings == null ? 0 : qualifiedNameReference.otherBindings.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        this.reportDeclaration(qualifiedNameReference.otherBindings[n3], matchLocator, declarationOfAccessedFieldsPattern.knownFields);
                        ++n3;
                    }
                } else if (aSTNode instanceof SingleNameReference) {
                    this.reportDeclaration((FieldBinding)((SingleNameReference)aSTNode).binding, matchLocator, declarationOfAccessedFieldsPattern.knownFields);
                }
            }
        } else if (aSTNode instanceof ImportReference) {
            ImportReference importReference = (ImportReference)aSTNode;
            long[] lArray = importReference.sourcePositions;
            int n4 = importReference.tokens.length - 1;
            int n5 = (int)(lArray[n4] >>> 32);
            int n6 = (int)lArray[n4];
            this.match = matchLocator.newFieldReferenceMatch(iJavaElement, binding, n, n5, n6 - n5 + 1, importReference);
            matchLocator.report(this.match);
        } else if (aSTNode instanceof FieldReference) {
            FieldReference fieldReference = (FieldReference)aSTNode;
            long l = fieldReference.nameSourcePosition;
            int n7 = (int)(l >>> 32);
            int n8 = (int)l;
            this.match = matchLocator.newFieldReferenceMatch(iJavaElement, binding, n, n7, n8 - n7 + 1, fieldReference);
            matchLocator.report(this.match);
        } else if (aSTNode instanceof SingleNameReference) {
            int n9 = aSTNode.sourceStart;
            this.match = matchLocator.newFieldReferenceMatch(iJavaElement, binding, n, n9, aSTNode.sourceEnd - n9 + 1, aSTNode);
            matchLocator.report(this.match);
        } else if (aSTNode instanceof QualifiedNameReference) {
            int n10;
            QualifiedNameReference qualifiedNameReference = (QualifiedNameReference)aSTNode;
            int n11 = qualifiedNameReference.tokens.length;
            SearchMatch[] searchMatchArray = new SearchMatch[n11];
            Binding binding3 = qualifiedNameReference.binding;
            int n12 = n10 = qualifiedNameReference.indexOfFirstFieldBinding > 0 ? qualifiedNameReference.indexOfFirstFieldBinding - 1 : 0;
            if (this.matchesName(this.pattern.name, qualifiedNameReference.tokens[n10]) && !(binding3 instanceof LocalVariableBinding)) {
                FieldBinding fieldBinding;
                FieldBinding fieldBinding2 = fieldBinding = binding3 instanceof FieldBinding ? (FieldBinding)binding3 : null;
                if (fieldBinding == null) {
                    searchMatchArray[n10] = matchLocator.newFieldReferenceMatch(iJavaElement, binding, n, -1, -1, aSTNode);
                } else {
                    switch (this.matchField(fieldBinding, false)) {
                        case 3: {
                            searchMatchArray[n10] = matchLocator.newFieldReferenceMatch(iJavaElement, binding, 0, -1, -1, aSTNode);
                            break;
                        }
                        case 1: {
                            this.match = matchLocator.newFieldReferenceMatch(iJavaElement, binding, 1, -1, -1, aSTNode);
                            if (fieldBinding.type != null && fieldBinding.type.isParameterizedType() && this.pattern.hasTypeArguments()) {
                                this.updateMatch((ParameterizedTypeBinding)fieldBinding.type, this.pattern.getTypeArguments(), matchLocator);
                            }
                            searchMatchArray[n10] = this.match;
                        }
                    }
                }
            }
            int n13 = n10 + 1;
            while (n13 < n11) {
                char[] cArray = qualifiedNameReference.tokens[n13];
                if (this.matchesName(this.pattern.name, cArray)) {
                    FieldBinding fieldBinding;
                    FieldBinding fieldBinding3 = fieldBinding = qualifiedNameReference.otherBindings == null ? null : qualifiedNameReference.otherBindings[n13 - (n10 + 1)];
                    if (fieldBinding == null) {
                        searchMatchArray[n13] = matchLocator.newFieldReferenceMatch(iJavaElement, binding, n, -1, -1, aSTNode);
                    } else {
                        switch (this.matchField(fieldBinding, false)) {
                            case 3: {
                                searchMatchArray[n13] = matchLocator.newFieldReferenceMatch(iJavaElement, binding, 0, -1, -1, aSTNode);
                                break;
                            }
                            case 1: {
                                this.match = matchLocator.newFieldReferenceMatch(iJavaElement, binding, 1, -1, -1, aSTNode);
                                if (fieldBinding.type != null && fieldBinding.type.isParameterizedType() && this.pattern.hasTypeArguments()) {
                                    this.updateMatch((ParameterizedTypeBinding)fieldBinding.type, this.pattern.getTypeArguments(), matchLocator);
                                }
                                searchMatchArray[n13] = this.match;
                            }
                        }
                    }
                }
                ++n13;
            }
            matchLocator.reportAccurateFieldReference(searchMatchArray, qualifiedNameReference);
        }
    }

    protected void updateMatch(ParameterizedTypeBinding parameterizedTypeBinding, char[][][] cArray, MatchLocator matchLocator) {
        if (matchLocator.unitScope == null) {
            return;
        }
        this.updateMatch(parameterizedTypeBinding, cArray, false, 0, matchLocator);
        if (!this.match.isExact()) {
            this.match.setRule(0);
        }
    }

    protected void reportDeclaration(FieldBinding fieldBinding, MatchLocator matchLocator, SimpleSet simpleSet) throws CoreException {
        if (fieldBinding == ArrayBinding.ArrayLength) {
            return;
        }
        ReferenceBinding referenceBinding = fieldBinding.declaringClass;
        IType iType = matchLocator.lookupType(referenceBinding);
        if (iType == null) {
            return;
        }
        char[] cArray = fieldBinding.name;
        IField iField = iType.getField(new String(cArray));
        if (simpleSet.addIfNotIncluded(iField) == null) {
            return;
        }
        IResource iResource = iType.getResource();
        boolean bl = iType.isBinary();
        IBinaryType iBinaryType = null;
        if (bl) {
            if (iResource == null) {
                iResource = iType.getJavaProject().getProject();
            }
            iBinaryType = matchLocator.getBinaryInfo((ClassFile)iType.getClassFile(), iResource);
            matchLocator.reportBinaryMemberDeclaration(iResource, iField, fieldBinding, iBinaryType, 0);
        } else {
            Scope scope;
            if (referenceBinding instanceof ParameterizedTypeBinding) {
                referenceBinding = ((ParameterizedTypeBinding)referenceBinding).genericType();
            }
            if ((scope = ((SourceTypeBinding)referenceBinding).scope) instanceof ClassScope) {
                ClassScope classScope = (ClassScope)scope;
                TypeDeclaration typeDeclaration = classScope.referenceContext;
                if (typeDeclaration != null) {
                    FieldDeclaration fieldDeclaration = null;
                    FieldDeclaration[] fieldDeclarationArray = typeDeclaration.fields;
                    int n = 0;
                    int n2 = fieldDeclarationArray.length;
                    while (n < n2) {
                        if (CharOperation.equals(cArray, fieldDeclarationArray[n].name)) {
                            fieldDeclaration = fieldDeclarationArray[n];
                            break;
                        }
                        ++n;
                    }
                    if (fieldDeclaration != null) {
                        n = fieldDeclaration.sourceStart;
                        this.match = new FieldDeclarationMatch(((JavaElement)((Object)iField)).resolved(fieldBinding), 0, n, fieldDeclaration.sourceEnd - n + 1, matchLocator.getParticipant(), iResource);
                        matchLocator.report(this.match);
                    }
                } else if (classScope.inferredType != null) {
                    InferredAttribute inferredAttribute = null;
                    int n = 0;
                    while (n < classScope.inferredType.numberAttributes) {
                        InferredAttribute inferredAttribute2 = classScope.inferredType.attributes[n];
                        if (CharOperation.equals(cArray, inferredAttribute2.name)) {
                            inferredAttribute = inferredAttribute2;
                            break;
                        }
                        ++n;
                    }
                    if (inferredAttribute != null) {
                        n = inferredAttribute.sourceStart;
                        this.match = new FieldDeclarationMatch(((JavaElement)((Object)iField)).resolved(fieldBinding), 0, n, inferredAttribute.sourceEnd - n + 1, matchLocator.getParticipant(), iResource);
                        matchLocator.report(this.match);
                    }
                }
            } else if (scope != null) {
                throw new UnimplementedException();
            }
        }
    }

    protected int referenceType() {
        return 8;
    }

    public int resolveLevel(ASTNode aSTNode) {
        if (this.pattern.findReferences) {
            if (aSTNode instanceof FieldReference) {
                if (!this.fieldPattern.isVar) {
                    return this.matchField(((FieldReference)aSTNode).binding, true);
                }
                return 0;
            }
            if (aSTNode instanceof NameReference) {
                return this.resolveLevel((NameReference)aSTNode);
            }
        }
        if (aSTNode instanceof FieldDeclaration) {
            return this.matchField(((FieldDeclaration)aSTNode).binding, true);
        }
        if (aSTNode instanceof LocalDeclaration) {
            return this.matchLocalVariable(((LocalDeclaration)aSTNode).binding, true);
        }
        return 0;
    }

    public int resolveLevel(Binding binding) {
        if (binding == null) {
            return 1;
        }
        if (this.fieldPattern.isVar) {
            if (!(binding instanceof LocalVariableBinding)) {
                return 0;
            }
            LocalVariableBinding localVariableBinding = (LocalVariableBinding)binding;
            if (localVariableBinding.declaringScope.kind != 4) {
                return 0;
            }
            return this.matchLocalVariable((LocalVariableBinding)binding, true);
        }
        if (!(binding instanceof FieldBinding)) {
            return 0;
        }
        return this.matchField((FieldBinding)binding, true);
    }

    protected int resolveLevel(NameReference nameReference) {
        int n;
        if (nameReference instanceof SingleNameReference) {
            return this.resolveLevel(nameReference.binding);
        }
        Binding binding = nameReference.binding;
        QualifiedNameReference qualifiedNameReference = (QualifiedNameReference)nameReference;
        FieldBinding fieldBinding = null;
        if (binding instanceof FieldBinding) {
            int n2;
            fieldBinding = (FieldBinding)binding;
            char[] cArray = fieldBinding.name;
            n = CharOperation.lastIndexOf('.', cArray);
            if (n > -1) {
                cArray = CharOperation.subarray(cArray, n + 1, cArray.length);
            }
            if (this.matchesName(this.pattern.name, cArray) && (n2 = this.matchField(fieldBinding, false)) != 0) {
                return n2;
            }
        }
        int n3 = qualifiedNameReference.otherBindings == null ? 0 : qualifiedNameReference.otherBindings.length;
        n = 0;
        while (n < n3) {
            FieldBinding fieldBinding2;
            int n4;
            char[] cArray = qualifiedNameReference.tokens[n + qualifiedNameReference.indexOfFirstFieldBinding];
            if (this.matchesName(this.pattern.name, cArray) && (n4 = this.matchField(fieldBinding2 = qualifiedNameReference.otherBindings[n], false)) != 0) {
                return n4;
            }
            ++n;
        }
        return 0;
    }

    protected int resolveLevelForType(TypeBinding typeBinding) {
        FieldPattern fieldPattern = (FieldPattern)this.pattern;
        TypeBinding typeBinding2 = typeBinding;
        if (typeBinding2 != null && typeBinding2.isParameterizedType()) {
            typeBinding2 = typeBinding.erasure();
        }
        return this.resolveLevelForType(fieldPattern.typeSimpleName, fieldPattern.typeQualification, fieldPattern.getTypeArguments(), 0, typeBinding2);
    }

    public int matchLocalDeclaration(LocalDeclaration localDeclaration, MatchingNodeSet matchingNodeSet) {
        int n = 0;
        if (this.pattern.findReferences && this.pattern.writeAccess && !this.pattern.readAccess && localDeclaration.initialization != null && this.matchesName(this.pattern.name, localDeclaration.name)) {
            n = this.pattern.mustResolve ? 2 : 3;
        }
        int n2 = 0;
        if (this.pattern.findDeclarations && this.matchesName(this.pattern.name, localDeclaration.name)) {
            n2 = this.pattern.mustResolve ? 2 : 3;
        }
        return matchingNodeSet.addMatch(localDeclaration, n >= n2 ? n : n2);
    }
}

