/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.core.index.EntryResult;
import org.eclipse.wst.jsdt.internal.core.index.Index;
import org.eclipse.wst.jsdt.internal.core.search.matching.JavaSearchPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.QualifiedTypeDeclarationPattern;

public class MultiTypeDeclarationPattern
extends JavaSearchPattern {
    public char[][] simpleNames;
    public char[][] qualifications;
    public char typeSuffix;
    protected static char[][] CATEGORIES = new char[][]{TYPE_DECL};

    public MultiTypeDeclarationPattern(char[][] cArray, char[][] cArray2, char c, int n) {
        this(n);
        int n2;
        int n3;
        if (this.isCaseSensitive() || cArray == null) {
            this.qualifications = cArray;
        } else {
            n3 = cArray.length;
            this.qualifications = new char[n3][];
            n2 = 0;
            while (n2 < n3) {
                this.qualifications[n2] = CharOperation.toLowerCase(cArray[n2]);
                ++n2;
            }
        }
        if (cArray2 != null) {
            if (this.isCaseSensitive() || this.isCamelCase()) {
                this.simpleNames = cArray2;
            } else {
                n3 = cArray2.length;
                this.simpleNames = new char[n3][];
                n2 = 0;
                while (n2 < n3) {
                    this.simpleNames[n2] = CharOperation.toLowerCase(cArray2[n2]);
                    ++n2;
                }
            }
        }
        this.typeSuffix = c;
        this.mustResolve = c != '\u0000';
    }

    MultiTypeDeclarationPattern(int n) {
        super(8, n);
    }

    public SearchPattern getBlankPattern() {
        return new QualifiedTypeDeclarationPattern(8);
    }

    public char[][] getIndexCategories() {
        return CATEGORIES;
    }

    public boolean matchesDecodedKey(SearchPattern searchPattern) {
        int n;
        int n2;
        QualifiedTypeDeclarationPattern qualifiedTypeDeclarationPattern = (QualifiedTypeDeclarationPattern)searchPattern;
        if (this.typeSuffix != qualifiedTypeDeclarationPattern.typeSuffix && this.typeSuffix != '\u0000' && !this.matchDifferentTypeSuffixes(this.typeSuffix, qualifiedTypeDeclarationPattern.typeSuffix)) {
            return false;
        }
        if (this.qualifications != null) {
            n2 = 0;
            n = this.qualifications.length;
            if (n == 0 && qualifiedTypeDeclarationPattern.qualification.length > 0) {
                return false;
            }
            if (n > 0) {
                while (n2 < n) {
                    if (this.matchesName(this.qualifications[n2], qualifiedTypeDeclarationPattern.qualification)) break;
                    ++n2;
                }
                if (n2 == n) {
                    return false;
                }
            }
        }
        if (this.simpleNames == null) {
            return true;
        }
        n2 = 0;
        n = this.simpleNames.length;
        while (n2 < n) {
            if (this.matchesName(this.simpleNames[n2], qualifiedTypeDeclarationPattern.simpleName)) break;
            ++n2;
        }
        return n2 < n;
    }

    EntryResult[] queryIn(Index index) throws IOException {
        int n;
        if (this.simpleNames == null) {
            return index.query(this.getIndexCategories(), null, -1);
        }
        int n2 = -1;
        int n3 = this.simpleNames.length;
        EntryResult[][] entryResultArrayArray = n3 > 1 ? new EntryResult[n3][] : null;
        int n4 = 0;
        while (n4 < n3) {
            char[] cArray = this.simpleNames[n4];
            n = this.getMatchRule();
            switch (this.getMatchMode()) {
                case 1: {
                    break;
                }
                case 0: {
                    if (this.isCamelCase) break;
                    n &= 0xFFFFFFFF;
                    n |= 1;
                    cArray = CharOperation.append(cArray, '/');
                    break;
                }
                case 2: {
                    if (cArray[cArray.length - 1] == '*') break;
                    cArray = CharOperation.concat(cArray, ONE_STAR, '/');
                    break;
                }
            }
            EntryResult[] entryResultArray = index.query(this.getIndexCategories(), cArray, n);
            if (entryResultArray != null) {
                if (entryResultArrayArray == null) {
                    return entryResultArray;
                }
                entryResultArrayArray[++n2] = entryResultArray;
            }
            ++n4;
        }
        if (n2 == -1) {
            return null;
        }
        n4 = 0;
        int n5 = 0;
        while (n5 <= n2) {
            n4 += entryResultArrayArray[n5].length;
            ++n5;
        }
        EntryResult[] entryResultArray = new EntryResult[n4];
        n = 0;
        int n6 = 0;
        while (n6 <= n2) {
            EntryResult[] entryResultArray2 = entryResultArrayArray[n6];
            System.arraycopy(entryResultArray2, 0, entryResultArray, n, entryResultArray2.length);
            n += entryResultArray2.length;
            ++n6;
        }
        return entryResultArray;
    }

    protected StringBuffer print(StringBuffer stringBuffer) {
        int n;
        switch (this.typeSuffix) {
            case 'C': {
                stringBuffer.append("MultiClassDeclarationPattern: ");
                break;
            }
            case '\n': {
                stringBuffer.append("MultiClassAndInterfaceDeclarationPattern: ");
                break;
            }
            case '\t': {
                stringBuffer.append("MultiClassAndEnumDeclarationPattern: ");
                break;
            }
            case 'I': {
                stringBuffer.append("MultiInterfaceDeclarationPattern: ");
                break;
            }
            case '\u000b': {
                stringBuffer.append("MultiInterfaceAndAnnotationDeclarationPattern: ");
                break;
            }
            case 'E': {
                stringBuffer.append("MultiEnumDeclarationPattern: ");
                break;
            }
            case 'A': {
                stringBuffer.append("MultiAnnotationTypeDeclarationPattern: ");
                break;
            }
            default: {
                stringBuffer.append("MultiTypeDeclarationPattern: ");
            }
        }
        if (this.qualifications != null) {
            stringBuffer.append("qualifications: <");
            n = 0;
            while (n < this.qualifications.length) {
                stringBuffer.append(this.qualifications[n]);
                if (n < this.qualifications.length - 1) {
                    stringBuffer.append(", ");
                }
                ++n;
            }
            stringBuffer.append("> ");
        }
        if (this.simpleNames != null) {
            stringBuffer.append("simpleNames: <");
            n = 0;
            while (n < this.simpleNames.length) {
                stringBuffer.append(this.simpleNames[n]);
                if (n < this.simpleNames.length - 1) {
                    stringBuffer.append(", ");
                }
                ++n;
            }
            stringBuffer.append(">");
        }
        return super.print(stringBuffer);
    }
}

