/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.AndPattern;

public class PackageReferencePattern
extends AndPattern {
    protected char[] pkgName;
    protected char[][] segments;
    protected int currentSegment;
    protected static char[][] CATEGORIES = new char[][]{REF};

    public PackageReferencePattern(char[] cArray, int n) {
        this(n);
        if (cArray == null || cArray.length == 0) {
            this.pkgName = null;
            this.segments = new char[][]{CharOperation.NO_CHAR};
            this.mustResolve = false;
        } else {
            this.pkgName = this.isCaseSensitive() || this.isCamelCase() ? cArray : CharOperation.toLowerCase(cArray);
            this.segments = CharOperation.splitOn('.', this.pkgName);
            this.mustResolve = true;
        }
    }

    PackageReferencePattern(int n) {
        super(1, n);
    }

    public void decodeIndexKey(char[] cArray) {
        this.pkgName = cArray;
    }

    public SearchPattern getBlankPattern() {
        return new PackageReferencePattern(8);
    }

    public char[] getIndexKey() {
        if (this.currentSegment >= 0) {
            return this.segments[this.currentSegment];
        }
        return null;
    }

    public char[][] getIndexCategories() {
        return CATEGORIES;
    }

    protected boolean hasNextQuery() {
        return --this.currentSegment >= (this.segments.length >= 4 ? 2 : 0);
    }

    public boolean matchesDecodedKey(SearchPattern searchPattern) {
        return true;
    }

    protected void resetQuery() {
        this.currentSegment = this.segments.length - 1;
    }

    protected StringBuffer print(StringBuffer stringBuffer) {
        stringBuffer.append("PackageReferencePattern: <");
        if (this.pkgName != null) {
            stringBuffer.append(this.pkgName);
        } else {
            stringBuffer.append("*");
        }
        stringBuffer.append(">");
        return super.print(stringBuffer);
    }
}

