/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.util.ClassFormatException;
import org.eclipse.wst.jsdt.core.util.IAttributeNamesConstants;
import org.eclipse.wst.jsdt.core.util.IClassFileAttribute;
import org.eclipse.wst.jsdt.core.util.IClassFileReader;
import org.eclipse.wst.jsdt.core.util.IConstantPool;
import org.eclipse.wst.jsdt.core.util.IFieldInfo;
import org.eclipse.wst.jsdt.core.util.IInnerClassesAttribute;
import org.eclipse.wst.jsdt.core.util.IMethodInfo;
import org.eclipse.wst.jsdt.core.util.ISourceAttribute;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;
import org.eclipse.wst.jsdt.internal.core.util.ClassFileAttribute;
import org.eclipse.wst.jsdt.internal.core.util.ClassFileStruct;
import org.eclipse.wst.jsdt.internal.core.util.ConstantPool;
import org.eclipse.wst.jsdt.internal.core.util.EnclosingMethodAttribute;
import org.eclipse.wst.jsdt.internal.core.util.FieldInfo;
import org.eclipse.wst.jsdt.internal.core.util.InnerClassesAttribute;
import org.eclipse.wst.jsdt.internal.core.util.MethodInfo;
import org.eclipse.wst.jsdt.internal.core.util.RuntimeInvisibleAnnotationsAttribute;
import org.eclipse.wst.jsdt.internal.core.util.RuntimeVisibleAnnotationsAttribute;
import org.eclipse.wst.jsdt.internal.core.util.SignatureAttribute;
import org.eclipse.wst.jsdt.internal.core.util.SourceFileAttribute;

public class ClassFileReader
extends ClassFileStruct
implements IClassFileReader {
    private static final IFieldInfo[] NO_FIELD_INFOS = new IFieldInfo[0];
    private static final char[][] NO_INTERFACES_NAMES = CharOperation.NO_CHAR_CHAR;
    private static final IMethodInfo[] NO_METHOD_INFOS = new IMethodInfo[0];
    private int accessFlags;
    private IClassFileAttribute[] attributes;
    private int attributesCount;
    private char[] className;
    private int classNameIndex;
    private IConstantPool constantPool;
    private IFieldInfo[] fields;
    private int fieldsCount;
    private IInnerClassesAttribute innerClassesAttribute;
    private int[] interfaceIndexes;
    private char[][] interfaceNames;
    private int interfacesCount;
    private int magicNumber;
    private int majorVersion;
    private IMethodInfo[] methods;
    private int methodsCount;
    private int minorVersion;
    private ISourceAttribute sourceFileAttribute;
    private char[] superclassName;
    private int superclassNameIndex;

    public ClassFileReader(byte[] byArray, int n) throws ClassFormatException {
        try {
            int n2;
            int n3;
            int n4;
            this.magicNumber = (int)this.u4At(byArray, 0, 0);
            if (this.magicNumber != -889275714) {
                throw new ClassFormatException(8);
            }
            int n5 = 10;
            this.minorVersion = this.u2At(byArray, 4, 0);
            this.majorVersion = this.u2At(byArray, 6, 0);
            if ((n & 1) == 0) {
                return;
            }
            int n6 = this.u2At(byArray, 8, 0);
            int[] nArray = new int[n6];
            int n7 = 1;
            while (n7 < n6) {
                n4 = this.u1At(byArray, n5, 0);
                switch (n4) {
                    case 1: {
                        nArray[n7] = n5;
                        n5 += this.u2At(byArray, n5 + 1, 0);
                        n5 += 3;
                        break;
                    }
                    case 3: {
                        nArray[n7] = n5;
                        n5 += 5;
                        break;
                    }
                    case 4: {
                        nArray[n7] = n5;
                        n5 += 5;
                        break;
                    }
                    case 5: {
                        nArray[n7] = n5;
                        n5 += 9;
                        ++n7;
                        break;
                    }
                    case 6: {
                        nArray[n7] = n5;
                        n5 += 9;
                        ++n7;
                        break;
                    }
                    case 7: {
                        nArray[n7] = n5;
                        n5 += 3;
                        break;
                    }
                    case 8: {
                        nArray[n7] = n5;
                        n5 += 3;
                        break;
                    }
                    case 9: {
                        nArray[n7] = n5;
                        n5 += 5;
                        break;
                    }
                    case 10: {
                        nArray[n7] = n5;
                        n5 += 5;
                        break;
                    }
                    case 11: {
                        nArray[n7] = n5;
                        n5 += 5;
                        break;
                    }
                    case 12: {
                        nArray[n7] = n5;
                        n5 += 5;
                        break;
                    }
                    default: {
                        throw new ClassFormatException(7);
                    }
                }
                ++n7;
            }
            this.constantPool = new ConstantPool(byArray, nArray);
            this.accessFlags = this.u2At(byArray, n5, 0);
            this.classNameIndex = this.u2At(byArray, n5 += 2, 0);
            this.className = this.getConstantClassNameAt(byArray, nArray, this.classNameIndex);
            this.superclassNameIndex = this.u2At(byArray, n5 += 2, 0);
            n5 += 2;
            if (this.superclassNameIndex != 0) {
                this.superclassName = this.getConstantClassNameAt(byArray, nArray, this.superclassNameIndex);
            }
            this.interfacesCount = this.u2At(byArray, n5, 0);
            n5 += 2;
            this.interfaceNames = NO_INTERFACES_NAMES;
            this.interfaceIndexes = Util.EMPTY_INT_ARRAY;
            if (this.interfacesCount != 0) {
                if ((n & 9) != 1) {
                    this.interfaceNames = new char[this.interfacesCount][];
                    this.interfaceIndexes = new int[this.interfacesCount];
                    n7 = 0;
                    while (n7 < this.interfacesCount) {
                        this.interfaceIndexes[n7] = this.u2At(byArray, n5, 0);
                        this.interfaceNames[n7] = this.getConstantClassNameAt(byArray, nArray, this.interfaceIndexes[n7]);
                        n5 += 2;
                        ++n7;
                    }
                } else {
                    n5 += 2 * this.interfacesCount;
                }
            }
            this.fieldsCount = this.u2At(byArray, n5, 0);
            n5 += 2;
            this.fields = NO_FIELD_INFOS;
            if (this.fieldsCount != 0) {
                if ((n & 5) != 1) {
                    this.fields = new FieldInfo[this.fieldsCount];
                    n4 = 0;
                    while (n4 < this.fieldsCount) {
                        FieldInfo fieldInfo = new FieldInfo(byArray, this.constantPool, n5);
                        this.fields[n4] = fieldInfo;
                        n5 += fieldInfo.sizeInBytes();
                        ++n4;
                    }
                } else {
                    n7 = 0;
                    while (n7 < this.fieldsCount) {
                        n4 = this.u2At(byArray, 6, n5);
                        n5 += 8;
                        if (n4 != 0) {
                            n3 = 0;
                            while (n3 < n4) {
                                n2 = (int)this.u4At(byArray, 2, n5);
                                n5 += 6 + n2;
                                ++n3;
                            }
                        }
                        ++n7;
                    }
                }
            }
            this.methodsCount = this.u2At(byArray, n5, 0);
            n5 += 2;
            this.methods = NO_METHOD_INFOS;
            if (this.methodsCount != 0) {
                if ((n & 3) != 1) {
                    this.methods = new MethodInfo[this.methodsCount];
                    n4 = 0;
                    while (n4 < this.methodsCount) {
                        MethodInfo methodInfo = new MethodInfo(byArray, this.constantPool, n5, n);
                        this.methods[n4] = methodInfo;
                        n5 += methodInfo.sizeInBytes();
                        ++n4;
                    }
                } else {
                    int n8 = 0;
                    while (n8 < this.methodsCount) {
                        n4 = this.u2At(byArray, 6, n5);
                        n5 += 8;
                        if (n4 != 0) {
                            n3 = 0;
                            while (n3 < n4) {
                                n2 = (int)this.u4At(byArray, 2, n5);
                                n5 += 6 + n2;
                                ++n3;
                            }
                        }
                        ++n8;
                    }
                }
            }
            this.attributesCount = this.u2At(byArray, n5, 0);
            n5 += 2;
            int n9 = 0;
            this.attributes = ClassFileAttribute.NO_ATTRIBUTES;
            if (this.attributesCount != 0) {
                if ((n & 0x11) != 1) {
                    this.attributes = new IClassFileAttribute[this.attributesCount];
                    n4 = 0;
                    while (n4 < this.attributesCount) {
                        n3 = nArray[this.u2At(byArray, n5, 0)];
                        char[] cArray = this.utf8At(byArray, n3 + 3, 0, this.u2At(byArray, n3 + 1, 0));
                        if (this.equals(cArray, IAttributeNamesConstants.INNER_CLASSES)) {
                            this.innerClassesAttribute = new InnerClassesAttribute(byArray, this.constantPool, n5);
                            this.attributes[n9++] = this.innerClassesAttribute;
                        } else if (this.equals(cArray, IAttributeNamesConstants.SOURCE)) {
                            this.sourceFileAttribute = new SourceFileAttribute(byArray, this.constantPool, n5);
                            this.attributes[n9++] = this.sourceFileAttribute;
                        } else {
                            this.attributes[n9++] = this.equals(cArray, IAttributeNamesConstants.ENCLOSING_METHOD) ? new EnclosingMethodAttribute(byArray, this.constantPool, n5) : (this.equals(cArray, IAttributeNamesConstants.SIGNATURE) ? new SignatureAttribute(byArray, this.constantPool, n5) : (this.equals(cArray, IAttributeNamesConstants.RUNTIME_VISIBLE_ANNOTATIONS) ? new RuntimeVisibleAnnotationsAttribute(byArray, this.constantPool, n5) : (this.equals(cArray, IAttributeNamesConstants.RUNTIME_INVISIBLE_ANNOTATIONS) ? new RuntimeInvisibleAnnotationsAttribute(byArray, this.constantPool, n5) : new ClassFileAttribute(byArray, this.constantPool, n5))));
                        }
                        n5 = (int)((long)n5 + (6L + this.u4At(byArray, n5 + 2, 0)));
                        ++n4;
                    }
                } else {
                    n4 = 0;
                    while (n4 < this.attributesCount) {
                        n5 = (int)((long)n5 + (6L + this.u4At(byArray, n5 + 2, 0)));
                        ++n4;
                    }
                }
            }
            if (n5 != byArray.length) {
                throw new ClassFormatException(4);
            }
        }
        catch (ClassFormatException classFormatException) {
            throw classFormatException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ClassFormatException(2);
        }
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public int getAttributeCount() {
        return this.attributesCount;
    }

    public IClassFileAttribute[] getAttributes() {
        return this.attributes;
    }

    public int getClassIndex() {
        return this.classNameIndex;
    }

    public char[] getClassName() {
        return this.className;
    }

    private char[] getConstantClassNameAt(byte[] byArray, int[] nArray, int n) {
        int n2 = nArray[this.u2At(byArray, nArray[n] + 1, 0)];
        return this.utf8At(byArray, n2 + 3, 0, this.u2At(byArray, n2 + 1, 0));
    }

    public IConstantPool getConstantPool() {
        return this.constantPool;
    }

    public IFieldInfo[] getFieldInfos() {
        return this.fields;
    }

    public int getFieldsCount() {
        return this.fieldsCount;
    }

    public IInnerClassesAttribute getInnerClassesAttribute() {
        return this.innerClassesAttribute;
    }

    public int[] getInterfaceIndexes() {
        return this.interfaceIndexes;
    }

    public char[][] getInterfaceNames() {
        return this.interfaceNames;
    }

    public int getMagic() {
        return this.magicNumber;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public IMethodInfo[] getMethodInfos() {
        return this.methods;
    }

    public int getMethodsCount() {
        return this.methodsCount;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public ISourceAttribute getSourceFileAttribute() {
        return this.sourceFileAttribute;
    }

    public int getSuperclassIndex() {
        return this.superclassNameIndex;
    }

    public char[] getSuperclassName() {
        return this.superclassName;
    }

    public boolean isClass() {
        return !this.isInterface();
    }

    public boolean isInterface() {
        return (this.getAccessFlags() & 0x200) != 0;
    }
}

