/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.util.ClassFileBytesDisassembler;
import org.eclipse.wst.jsdt.core.util.ClassFormatException;
import org.eclipse.wst.jsdt.core.util.IAnnotation;
import org.eclipse.wst.jsdt.core.util.IAnnotationComponent;
import org.eclipse.wst.jsdt.core.util.IAnnotationComponentValue;
import org.eclipse.wst.jsdt.core.util.IAnnotationDefaultAttribute;
import org.eclipse.wst.jsdt.core.util.IAttributeNamesConstants;
import org.eclipse.wst.jsdt.core.util.IClassFileAttribute;
import org.eclipse.wst.jsdt.core.util.IClassFileReader;
import org.eclipse.wst.jsdt.core.util.ICodeAttribute;
import org.eclipse.wst.jsdt.core.util.IConstantPool;
import org.eclipse.wst.jsdt.core.util.IConstantPoolEntry;
import org.eclipse.wst.jsdt.core.util.IConstantValueAttribute;
import org.eclipse.wst.jsdt.core.util.IEnclosingMethodAttribute;
import org.eclipse.wst.jsdt.core.util.IExceptionAttribute;
import org.eclipse.wst.jsdt.core.util.IExceptionTableEntry;
import org.eclipse.wst.jsdt.core.util.IFieldInfo;
import org.eclipse.wst.jsdt.core.util.IInnerClassesAttribute;
import org.eclipse.wst.jsdt.core.util.IInnerClassesAttributeEntry;
import org.eclipse.wst.jsdt.core.util.ILineNumberAttribute;
import org.eclipse.wst.jsdt.core.util.ILocalVariableAttribute;
import org.eclipse.wst.jsdt.core.util.ILocalVariableTableEntry;
import org.eclipse.wst.jsdt.core.util.ILocalVariableTypeTableAttribute;
import org.eclipse.wst.jsdt.core.util.IMethodInfo;
import org.eclipse.wst.jsdt.core.util.IParameterAnnotation;
import org.eclipse.wst.jsdt.core.util.IRuntimeInvisibleAnnotationsAttribute;
import org.eclipse.wst.jsdt.core.util.IRuntimeInvisibleParameterAnnotationsAttribute;
import org.eclipse.wst.jsdt.core.util.IRuntimeVisibleAnnotationsAttribute;
import org.eclipse.wst.jsdt.core.util.IRuntimeVisibleParameterAnnotationsAttribute;
import org.eclipse.wst.jsdt.core.util.ISignatureAttribute;
import org.eclipse.wst.jsdt.core.util.ISourceAttribute;
import org.eclipse.wst.jsdt.core.util.IStackMapAttribute;
import org.eclipse.wst.jsdt.core.util.IStackMapFrame;
import org.eclipse.wst.jsdt.core.util.IStackMapTableAttribute;
import org.eclipse.wst.jsdt.core.util.IVerificationTypeInfo;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.core.util.ClassFileReader;
import org.eclipse.wst.jsdt.internal.core.util.DefaultBytecodeVisitor;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class Disassembler
extends ClassFileBytesDisassembler {
    private static final char[] ANY_EXCEPTION = Messages.classfileformat_anyexceptionhandler.toCharArray();
    private static final String VERSION_UNKNOWN = Messages.classfileformat_versionUnknown;

    private boolean appendModifier(StringBuffer stringBuffer, int n, int n2, String string, boolean bl) {
        if ((n & n2) != 0) {
            if (!bl) {
                stringBuffer.append(Messages.disassembler_space);
            }
            if (bl) {
                bl = false;
            }
            stringBuffer.append(string);
        }
        return bl;
    }

    private void decodeModifiers(StringBuffer stringBuffer, int n, int[] nArray) {
        this.decodeModifiers(stringBuffer, n, false, false, nArray);
    }

    private void decodeModifiers(StringBuffer stringBuffer, int n, boolean bl, boolean bl2, int[] nArray) {
        if (nArray == null) {
            return;
        }
        boolean bl3 = true;
        int n2 = 0;
        int n3 = nArray.length;
        while (n2 < n3) {
            switch (nArray[n2]) {
                case 1: {
                    bl3 = this.appendModifier(stringBuffer, n, 1, "public", bl3);
                    break;
                }
                case 4: {
                    bl3 = this.appendModifier(stringBuffer, n, 4, "protected", bl3);
                    break;
                }
                case 2: {
                    bl3 = this.appendModifier(stringBuffer, n, 2, "private", bl3);
                    break;
                }
                case 1024: {
                    bl3 = this.appendModifier(stringBuffer, n, 1024, "abstract", bl3);
                    break;
                }
                case 8: {
                    bl3 = this.appendModifier(stringBuffer, n, 8, "static", bl3);
                    break;
                }
                case 16: {
                    bl3 = this.appendModifier(stringBuffer, n, 16, "final", bl3);
                    break;
                }
                case 32: {
                    bl3 = this.appendModifier(stringBuffer, n, 32, "synchronized", bl3);
                    break;
                }
                case 256: {
                    bl3 = this.appendModifier(stringBuffer, n, 256, "native", bl3);
                    break;
                }
                case 2048: {
                    bl3 = this.appendModifier(stringBuffer, n, 2048, "strictfp", bl3);
                    break;
                }
                case 128: {
                    bl3 = this.appendModifier(stringBuffer, n, 128, "transient", bl3);
                    break;
                }
                case 64: {
                    if (bl2) {
                        bl3 = this.appendModifier(stringBuffer, n, 64, "bridge", bl3);
                        break;
                    }
                    bl3 = this.appendModifier(stringBuffer, n, 64, "volatile", bl3);
                    break;
                }
                case 16384: {
                    bl3 = this.appendModifier(stringBuffer, n, 16384, "enum", bl3);
                }
            }
            ++n2;
        }
        if (!bl3) {
            if (!bl) {
                stringBuffer.append(Messages.disassembler_space);
            }
        } else if (bl) {
            stringBuffer.append("default");
        }
    }

    private void decodeModifiersForField(StringBuffer stringBuffer, int n) {
        this.decodeModifiers(stringBuffer, n, new int[]{1, 4, 2, 8, 16, 128, 64, 16384});
    }

    private void decodeModifiersForFieldForWorkingCopy(StringBuffer stringBuffer, int n) {
        this.decodeModifiers(stringBuffer, n, new int[]{1, 4, 2, 8, 16, 128, 64});
    }

    private final void decodeModifiersForInnerClasses(StringBuffer stringBuffer, int n, boolean bl) {
        this.decodeModifiers(stringBuffer, n, bl, false, new int[]{1, 4, 2, 1024, 8, 16});
    }

    private final void decodeModifiersForMethod(StringBuffer stringBuffer, int n) {
        this.decodeModifiers(stringBuffer, n, false, true, new int[]{1, 4, 2, 1024, 8, 16, 32, 256, 2048, 64});
    }

    private final void decodeModifiersForType(StringBuffer stringBuffer, int n) {
        this.decodeModifiers(stringBuffer, n, new int[]{1, 1024, 16});
    }

    public static String escapeString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            switch (c) {
                case '\b': {
                    stringBuffer.append("\\b");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\u0000': {
                    stringBuffer.append("\\0");
                    break;
                }
                case '\u0001': {
                    stringBuffer.append("\\1");
                    break;
                }
                case '\u0002': {
                    stringBuffer.append("\\2");
                    break;
                }
                case '\u0003': {
                    stringBuffer.append("\\3");
                    break;
                }
                case '\u0004': {
                    stringBuffer.append("\\4");
                    break;
                }
                case '\u0005': {
                    stringBuffer.append("\\5");
                    break;
                }
                case '\u0006': {
                    stringBuffer.append("\\6");
                    break;
                }
                case '\u0007': {
                    stringBuffer.append("\\7");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static String decodeStringValue(char[] cArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = cArray.length;
        while (n < n2) {
            char c = cArray[n];
            switch (c) {
                case '\b': {
                    stringBuffer.append("\\b");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\u0000': {
                    stringBuffer.append("\\0");
                    break;
                }
                case '\u0001': {
                    stringBuffer.append("\\1");
                    break;
                }
                case '\u0002': {
                    stringBuffer.append("\\2");
                    break;
                }
                case '\u0003': {
                    stringBuffer.append("\\3");
                    break;
                }
                case '\u0004': {
                    stringBuffer.append("\\4");
                    break;
                }
                case '\u0005': {
                    stringBuffer.append("\\5");
                    break;
                }
                case '\u0006': {
                    stringBuffer.append("\\6");
                    break;
                }
                case '\u0007': {
                    stringBuffer.append("\\7");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static String decodeStringValue(String string) {
        return Disassembler.decodeStringValue(string.toCharArray());
    }

    public String disassemble(byte[] byArray, String string) throws ClassFormatException {
        try {
            return this.disassemble(new ClassFileReader(byArray, 65535), string, 2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            arrayIndexOutOfBoundsException.printStackTrace(printWriter);
            printWriter.flush();
            printWriter.close();
            throw new ClassFormatException(String.valueOf(stringWriter.getBuffer()));
        }
    }

    public String disassemble(byte[] byArray, String string, int n) throws ClassFormatException {
        try {
            return this.disassemble(new ClassFileReader(byArray, 65535), string, n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            arrayIndexOutOfBoundsException.printStackTrace(printWriter);
            printWriter.flush();
            printWriter.close();
            throw new ClassFormatException(String.valueOf(stringWriter.getBuffer()));
        }
    }

    private void disassemble(IAnnotation iAnnotation, StringBuffer stringBuffer, String string, int n) {
        this.writeNewLine(stringBuffer, string, n + 1);
        int n2 = iAnnotation.getTypeIndex();
        char[] cArray = CharOperation.replaceOnCopy(iAnnotation.getTypeName(), '/', '.');
        stringBuffer.append(Messages.bind(Messages.disassembler_annotationentrystart, new String[]{Integer.toString(n2), new String(Signature.toCharArray(cArray))}));
        IAnnotationComponent[] iAnnotationComponentArray = iAnnotation.getComponents();
        int n3 = 0;
        int n4 = iAnnotationComponentArray.length;
        while (n3 < n4) {
            this.disassemble(iAnnotationComponentArray[n3], stringBuffer, string, n + 1);
            ++n3;
        }
        this.writeNewLine(stringBuffer, string, n + 1);
        stringBuffer.append(Messages.disassembler_annotationentryend);
    }

    private void disassemble(IAnnotationComponent iAnnotationComponent, StringBuffer stringBuffer, String string, int n) {
        this.writeNewLine(stringBuffer, string, n + 1);
        stringBuffer.append(Messages.bind(Messages.disassembler_annotationcomponent, new String[]{Integer.toString(iAnnotationComponent.getComponentNameIndex()), new String(iAnnotationComponent.getComponentName())}));
        this.disassemble(iAnnotationComponent.getComponentValue(), stringBuffer, string, n + 1);
    }

    private void disassemble(IAnnotationComponentValue iAnnotationComponentValue, StringBuffer stringBuffer, String string, int n) {
        switch (iAnnotationComponentValue.getTag()) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                IConstantPoolEntry iConstantPoolEntry = iAnnotationComponentValue.getConstantValue();
                String string2 = null;
                switch (iConstantPoolEntry.getKind()) {
                    case 5: {
                        string2 = String.valueOf(iConstantPoolEntry.getLongValue()) + "L";
                        break;
                    }
                    case 4: {
                        string2 = String.valueOf(iConstantPoolEntry.getFloatValue()) + "f";
                        break;
                    }
                    case 6: {
                        string2 = Double.toString(iConstantPoolEntry.getDoubleValue());
                        break;
                    }
                    case 3: {
                        switch (iAnnotationComponentValue.getTag()) {
                            case 67: {
                                string2 = "'" + (char)iConstantPoolEntry.getIntegerValue() + "'";
                                break;
                            }
                            case 90: {
                                string2 = iConstantPoolEntry.getIntegerValue() == 1 ? "true" : "false";
                                break;
                            }
                            case 66: {
                                string2 = "(byte) " + iConstantPoolEntry.getIntegerValue();
                                break;
                            }
                            case 83: {
                                string2 = "(short) " + iConstantPoolEntry.getIntegerValue();
                                break;
                            }
                            case 73: {
                                string2 = "(int) " + iConstantPoolEntry.getIntegerValue();
                            }
                        }
                        break;
                    }
                    case 1: {
                        string2 = "\"" + Disassembler.decodeStringValue(iConstantPoolEntry.getUtf8Value()) + "\"";
                    }
                }
                stringBuffer.append(Messages.bind(Messages.disassembler_annotationdefaultvalue, string2));
                break;
            }
            case 101: {
                int n2 = iAnnotationComponentValue.getEnumConstantTypeNameIndex();
                char[] cArray = CharOperation.replaceOnCopy(iAnnotationComponentValue.getEnumConstantTypeName(), '/', '.');
                int n3 = iAnnotationComponentValue.getEnumConstantNameIndex();
                char[] cArray2 = iAnnotationComponentValue.getEnumConstantName();
                stringBuffer.append(Messages.bind(Messages.disassembler_annotationenumvalue, new String[]{Integer.toString(n2), Integer.toString(n3), new String(Signature.toCharArray(cArray)), new String(cArray2)}));
                break;
            }
            case 99: {
                int n4 = iAnnotationComponentValue.getClassInfoIndex();
                IConstantPoolEntry iConstantPoolEntry = iAnnotationComponentValue.getClassInfo();
                char[] cArray = CharOperation.replaceOnCopy(iConstantPoolEntry.getUtf8Value(), '/', '.');
                stringBuffer.append(Messages.bind(Messages.disassembler_annotationclassvalue, new String[]{Integer.toString(n4), new String(Signature.toCharArray(cArray))}));
                break;
            }
            case 64: {
                stringBuffer.append(Messages.disassembler_annotationannotationvalue);
                IAnnotation iAnnotation = iAnnotationComponentValue.getAnnotationValue();
                this.disassemble(iAnnotation, stringBuffer, string, n + 1);
                break;
            }
            case 91: {
                stringBuffer.append(Messages.disassembler_annotationarrayvaluestart);
                IAnnotationComponentValue[] iAnnotationComponentValueArray = iAnnotationComponentValue.getAnnotationComponentValues();
                int n5 = 0;
                int n6 = iAnnotationComponentValueArray.length;
                while (n5 < n6) {
                    this.writeNewLine(stringBuffer, string, n + 1);
                    this.disassemble(iAnnotationComponentValueArray[n5], stringBuffer, string, n + 1);
                    ++n5;
                }
                this.writeNewLine(stringBuffer, string, n + 1);
                stringBuffer.append(Messages.disassembler_annotationarrayvalueend);
            }
        }
    }

    private void disassemble(IAnnotationDefaultAttribute iAnnotationDefaultAttribute, StringBuffer stringBuffer, String string, int n) {
        this.writeNewLine(stringBuffer, string, n + 1);
        stringBuffer.append(Messages.disassembler_annotationdefaultheader);
        IAnnotationComponentValue iAnnotationComponentValue = iAnnotationDefaultAttribute.getMemberValue();
        this.writeNewLine(stringBuffer, string, n + 2);
        this.disassemble(iAnnotationComponentValue, stringBuffer, string, n + 1);
    }

    private void disassemble(IClassFileAttribute iClassFileAttribute, StringBuffer stringBuffer, String string, int n) {
        this.writeNewLine(stringBuffer, string, n + 1);
        stringBuffer.append(Messages.bind(Messages.disassembler_genericattributeheader, new String[]{new String(iClassFileAttribute.getAttributeName()), Long.toString(iClassFileAttribute.getAttributeLength())}));
    }

    private void disassembleEnumConstructor(IClassFileReader iClassFileReader, char[] cArray, IMethodInfo iMethodInfo, StringBuffer stringBuffer, String string, int n, int n2) {
        Object object;
        this.writeNewLine(stringBuffer, string, n);
        ICodeAttribute iCodeAttribute = iMethodInfo.getCodeAttribute();
        char[] cArray2 = iMethodInfo.getDescriptor();
        IClassFileAttribute iClassFileAttribute = Util.getAttribute(iMethodInfo, IAttributeNamesConstants.RUNTIME_VISIBLE_ANNOTATIONS);
        IClassFileAttribute iClassFileAttribute2 = Util.getAttribute(iMethodInfo, IAttributeNamesConstants.RUNTIME_INVISIBLE_ANNOTATIONS);
        if (iClassFileAttribute2 != null) {
            this.disassembleAsModifier((IRuntimeInvisibleAnnotationsAttribute)iClassFileAttribute2, stringBuffer, string, n + 1, n2);
            this.writeNewLine(stringBuffer, string, n);
        }
        if (iClassFileAttribute != null) {
            this.disassembleAsModifier((IRuntimeVisibleAnnotationsAttribute)iClassFileAttribute, stringBuffer, string, n + 1, n2);
            this.writeNewLine(stringBuffer, string, n);
        }
        int n3 = iMethodInfo.getAccessFlags();
        this.decodeModifiersForMethod(stringBuffer, n3 & 2);
        CharOperation.replace(cArray2, '/', '.');
        boolean bl = (n3 & 0x80) != 0;
        char[] cArray3 = Signature.toCharArray(cArray2, this.returnClassName(cArray, '.', 8), this.getParameterNames(cArray2, iCodeAttribute, n3), !this.checkMode(n2, 8), false, bl);
        int n4 = CharOperation.indexOf(',', cArray3);
        n4 = CharOperation.indexOf(',', cArray3, n4 + 1);
        stringBuffer.append(cArray3, 0, CharOperation.indexOf('(', cArray3) + 1);
        stringBuffer.append(cArray3, n4 + 2, cArray3.length - n4 - 2);
        IExceptionAttribute iExceptionAttribute = iMethodInfo.getExceptionAttribute();
        if (iExceptionAttribute != null) {
            stringBuffer.append(" throws ");
            object = iExceptionAttribute.getExceptionNames();
            int n5 = ((char[][])object).length;
            int n6 = 0;
            while (n6 < n5) {
                if (n6 != 0) {
                    stringBuffer.append(Messages.disassembler_comma).append(Messages.disassembler_space);
                }
                char[] cArray4 = object[n6];
                CharOperation.replace(cArray4, '/', '.');
                stringBuffer.append(this.returnClassName(cArray4, '.', n2));
                ++n6;
            }
        }
        if ((n3 & 0x100) == 0 && (n3 & 0x400) == 0) {
            stringBuffer.append(" {");
            object = Signature.getReturnType(cArray2);
            if (((char[][])object).length == 1) {
                switch (object[0]) {
                    case 86: {
                        this.writeNewLine(stringBuffer, string, n);
                        break;
                    }
                    case 66: 
                    case 67: 
                    case 68: 
                    case 70: 
                    case 73: 
                    case 74: 
                    case 83: {
                        this.writeNewLine(stringBuffer, string, n + 1);
                        stringBuffer.append("return 0;");
                        this.writeNewLine(stringBuffer, string, n);
                        break;
                    }
                    default: {
                        this.writeNewLine(stringBuffer, string, n + 1);
                        stringBuffer.append("return false;");
                        this.writeNewLine(stringBuffer, string, n);
                        break;
                    }
                }
            } else {
                this.writeNewLine(stringBuffer, string, n + 1);
                stringBuffer.append("return null;");
                this.writeNewLine(stringBuffer, string, n);
            }
            stringBuffer.append('}');
        } else {
            stringBuffer.append(';');
        }
    }

    private void disassemble(IClassFileReader iClassFileReader, char[] cArray, IMethodInfo iMethodInfo, StringBuffer stringBuffer, String string, int n, int n2) {
        char[] cArray2;
        int n3;
        int n4;
        Object object;
        Object object2;
        this.writeNewLine(stringBuffer, string, n);
        ICodeAttribute iCodeAttribute = iMethodInfo.getCodeAttribute();
        char[] cArray3 = iMethodInfo.getDescriptor();
        ISignatureAttribute iSignatureAttribute = (ISignatureAttribute)Util.getAttribute(iMethodInfo, IAttributeNamesConstants.SIGNATURE);
        IClassFileAttribute iClassFileAttribute = Util.getAttribute(iMethodInfo, IAttributeNamesConstants.RUNTIME_VISIBLE_ANNOTATIONS);
        IClassFileAttribute iClassFileAttribute2 = Util.getAttribute(iMethodInfo, IAttributeNamesConstants.RUNTIME_INVISIBLE_ANNOTATIONS);
        IClassFileAttribute iClassFileAttribute3 = Util.getAttribute(iMethodInfo, IAttributeNamesConstants.RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS);
        IClassFileAttribute iClassFileAttribute4 = Util.getAttribute(iMethodInfo, IAttributeNamesConstants.RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS);
        IClassFileAttribute iClassFileAttribute5 = Util.getAttribute(iMethodInfo, IAttributeNamesConstants.ANNOTATION_DEFAULT);
        if (this.checkMode(n2, 5)) {
            stringBuffer.append(Messages.bind(Messages.classfileformat_methoddescriptor, new String[]{Integer.toString(iMethodInfo.getDescriptorIndex()), new String(cArray3)}));
            if (iMethodInfo.isDeprecated()) {
                stringBuffer.append(Messages.disassembler_deprecated);
            }
            this.writeNewLine(stringBuffer, string, n);
            if (iSignatureAttribute != null) {
                stringBuffer.append(Messages.bind(Messages.disassembler_signatureattributeheader, new String(iSignatureAttribute.getSignature())));
                this.writeNewLine(stringBuffer, string, n);
            }
            if (iCodeAttribute != null) {
                stringBuffer.append(Messages.bind(Messages.classfileformat_stacksAndLocals, new String[]{Integer.toString(iCodeAttribute.getMaxStack()), Integer.toString(iCodeAttribute.getMaxLocals())}));
                this.writeNewLine(stringBuffer, string, n);
            }
        }
        if (this.checkMode(n2, 1)) {
            if (iClassFileAttribute2 != null) {
                this.disassembleAsModifier((IRuntimeInvisibleAnnotationsAttribute)iClassFileAttribute2, stringBuffer, string, n + 1, n2);
                this.writeNewLine(stringBuffer, string, n);
            }
            if (iClassFileAttribute != null) {
                this.disassembleAsModifier((IRuntimeVisibleAnnotationsAttribute)iClassFileAttribute, stringBuffer, string, n + 1, n2);
                this.writeNewLine(stringBuffer, string, n);
            }
        }
        int n5 = iMethodInfo.getAccessFlags();
        this.decodeModifiersForMethod(stringBuffer, n5);
        if (iMethodInfo.isSynthetic() && !this.checkMode(n2, 16)) {
            stringBuffer.append("synthetic");
            stringBuffer.append(Messages.disassembler_space);
        }
        CharOperation.replace(cArray3, '/', '.');
        boolean bl = this.isVarArgs(iMethodInfo);
        if (iMethodInfo.isConstructor()) {
            if (this.checkMode(n2, 16) && iSignatureAttribute != null) {
                object2 = iSignatureAttribute.getSignature();
                CharOperation.replace((char[])object2, '/', '.');
                this.disassembleGenericSignature(n2, stringBuffer, (char[])object2);
                stringBuffer.append(' ');
                stringBuffer.append(Signature.toCharArray((char[])object2, this.returnClassName(cArray, '.', 8), this.getParameterNames(cArray3, iCodeAttribute, n5), !this.checkMode(n2, 8), false, bl));
            } else {
                stringBuffer.append(Signature.toCharArray(cArray3, this.returnClassName(cArray, '.', 8), this.getParameterNames(cArray3, iCodeAttribute, n5), !this.checkMode(n2, 8), false, bl));
            }
        } else if (iMethodInfo.isClinit()) {
            stringBuffer.append(Messages.bind(Messages.classfileformat_clinitname));
        } else if (this.checkMode(n2, 16) && iSignatureAttribute != null) {
            object2 = iSignatureAttribute.getSignature();
            CharOperation.replace((char[])object2, '/', '.');
            this.disassembleGenericSignature(n2, stringBuffer, (char[])object2);
            stringBuffer.append(' ');
            stringBuffer.append(Signature.toCharArray((char[])object2, iMethodInfo.getName(), this.getParameterNames(cArray3, iCodeAttribute, n5), !this.checkMode(n2, 8), true, bl));
        } else {
            stringBuffer.append(Signature.toCharArray(cArray3, iMethodInfo.getName(), this.getParameterNames(cArray3, iCodeAttribute, n5), !this.checkMode(n2, 8), true, bl));
        }
        object2 = iMethodInfo.getExceptionAttribute();
        if (object2 != null) {
            stringBuffer.append(" throws ");
            object = object2.getExceptionNames();
            n4 = ((char[][])object).length;
            n3 = 0;
            while (n3 < n4) {
                if (n3 != 0) {
                    stringBuffer.append(Messages.disassembler_comma).append(Messages.disassembler_space);
                }
                cArray2 = object[n3];
                CharOperation.replace(cArray2, '/', '.');
                stringBuffer.append(this.returnClassName(cArray2, '.', n2));
                ++n3;
            }
        }
        if (this.checkMode(n2, 1) && iClassFileAttribute5 != null) {
            stringBuffer.append(" default ");
            this.disassembleAsModifier((IAnnotationDefaultAttribute)iClassFileAttribute5, stringBuffer, string, n, n2);
        }
        if (this.checkMode(n2, 16)) {
            if (iClassFileAttribute5 != null) {
                stringBuffer.append(" default ");
                this.disassembleAsModifier((IAnnotationDefaultAttribute)iClassFileAttribute5, stringBuffer, string, n, n2);
            }
            if ((n5 & 0x100) == 0 && (n5 & 0x400) == 0) {
                stringBuffer.append(" {");
                object = Signature.getReturnType(cArray3);
                if (((char[][])object).length == 1) {
                    switch (object[0]) {
                        case 86: {
                            this.writeNewLine(stringBuffer, string, n);
                            break;
                        }
                        case 66: 
                        case 67: 
                        case 68: 
                        case 70: 
                        case 73: 
                        case 74: 
                        case 83: {
                            this.writeNewLine(stringBuffer, string, n + 1);
                            stringBuffer.append("return 0;");
                            this.writeNewLine(stringBuffer, string, n);
                            break;
                        }
                        default: {
                            this.writeNewLine(stringBuffer, string, n + 1);
                            stringBuffer.append("return false;");
                            this.writeNewLine(stringBuffer, string, n);
                            break;
                        }
                    }
                } else {
                    this.writeNewLine(stringBuffer, string, n + 1);
                    stringBuffer.append("return null;");
                    this.writeNewLine(stringBuffer, string, n);
                }
                stringBuffer.append('}');
            } else {
                stringBuffer.append(';');
            }
        } else {
            stringBuffer.append(Messages.disassembler_endofmethodheader);
        }
        if (this.checkMode(n2, 5) && iCodeAttribute != null) {
            this.disassemble(iCodeAttribute, stringBuffer, string, n, n2);
        }
        if (this.checkMode(n2, 4)) {
            object = iMethodInfo.getAttributes();
            n4 = ((char[][])object).length;
            if (n4 != 0) {
                n3 = 0;
                while (n3 < n4) {
                    cArray2 = object[n3];
                    if (cArray2 != iCodeAttribute && cArray2 != object2 && cArray2 != iSignatureAttribute && cArray2 != iClassFileAttribute5 && cArray2 != iClassFileAttribute2 && cArray2 != iClassFileAttribute && cArray2 != iClassFileAttribute4 && cArray2 != iClassFileAttribute3 && !CharOperation.equals(cArray2.getAttributeName(), IAttributeNamesConstants.DEPRECATED) && !CharOperation.equals(cArray2.getAttributeName(), IAttributeNamesConstants.SYNTHETIC)) {
                        this.disassemble((IClassFileAttribute)cArray2, stringBuffer, string, n);
                        this.writeNewLine(stringBuffer, string, n);
                    }
                    ++n3;
                }
            }
            if (iClassFileAttribute5 != null) {
                this.disassemble((IAnnotationDefaultAttribute)iClassFileAttribute5, stringBuffer, string, n);
            }
            if (iClassFileAttribute != null) {
                this.disassemble((IRuntimeVisibleAnnotationsAttribute)iClassFileAttribute, stringBuffer, string, n);
            }
            if (iClassFileAttribute2 != null) {
                this.disassemble((IRuntimeInvisibleAnnotationsAttribute)iClassFileAttribute2, stringBuffer, string, n);
            }
            if (iClassFileAttribute3 != null) {
                this.disassemble((IRuntimeVisibleParameterAnnotationsAttribute)iClassFileAttribute3, stringBuffer, string, n);
            }
            if (iClassFileAttribute4 != null) {
                this.disassemble((IRuntimeInvisibleParameterAnnotationsAttribute)iClassFileAttribute4, stringBuffer, string, n);
            }
        }
    }

    public String disassemble(IClassFileReader iClassFileReader, String string) {
        return this.disassemble(iClassFileReader, string, 2);
    }

    public String disassemble(IClassFileReader iClassFileReader, String string, int n) {
        int n2;
        char[] cArray;
        Object object;
        int n3;
        int n4;
        Object object2;
        int n5;
        if (iClassFileReader == null) {
            return org.eclipse.wst.jsdt.internal.compiler.util.Util.EMPTY_STRING;
        }
        char[] cArray2 = iClassFileReader.getClassName();
        if (cArray2 == null) {
            return org.eclipse.wst.jsdt.internal.compiler.util.Util.EMPTY_STRING;
        }
        cArray2 = CharOperation.replaceOnCopy(cArray2, '/', '.');
        int n6 = cArray2.length;
        int n7 = iClassFileReader.getAccessFlags();
        boolean bl = (n7 & 0x4000) != 0;
        StringBuffer stringBuffer = new StringBuffer();
        ISourceAttribute iSourceAttribute = iClassFileReader.getSourceFileAttribute();
        IClassFileAttribute iClassFileAttribute = Util.getAttribute(iClassFileReader, IAttributeNamesConstants.SIGNATURE);
        ISignatureAttribute iSignatureAttribute = (ISignatureAttribute)iClassFileAttribute;
        if (this.checkMode(n, 5)) {
            n5 = iClassFileReader.getMinorVersion();
            int n8 = iClassFileReader.getMajorVersion();
            stringBuffer.append(Messages.disassembler_begincommentline);
            if (iSourceAttribute != null) {
                stringBuffer.append(Messages.disassembler_sourceattributeheader);
                stringBuffer.append(iSourceAttribute.getSourceFileName());
            }
            object2 = VERSION_UNKNOWN;
            if (n5 == 3 && n8 == 45) {
                object2 = "1.1";
            } else if (n5 == 0 && n8 == 46) {
                object2 = "1.2";
            } else if (n5 == 0 && n8 == 47) {
                object2 = "1.3";
            } else if (n5 == 0 && n8 == 48) {
                object2 = "1.4";
            } else if (n5 == 0 && n8 == 49) {
                object2 = "1.5";
            } else if (n5 == 0 && n8 == 50) {
                object2 = "1.6";
            } else if (n5 == 0 && n8 == 51) {
                object2 = "1.7";
            }
            stringBuffer.append(Messages.bind(Messages.classfileformat_versiondetails, new String[]{object2, Integer.toString(n8), Integer.toString(n5), String.valueOf((n7 & 0x20) != 0 ? Messages.classfileformat_superflagisset : Messages.classfileformat_superflagisnotset) + (this.isDeprecated(iClassFileReader) ? ", deprecated" : org.eclipse.wst.jsdt.internal.compiler.util.Util.EMPTY_STRING)}));
            this.writeNewLine(stringBuffer, string, 0);
            if (iSignatureAttribute != null) {
                stringBuffer.append(Messages.bind(Messages.disassembler_signatureattributeheader, new String(iSignatureAttribute.getSignature())));
                this.writeNewLine(stringBuffer, string, 0);
            }
        }
        n5 = CharOperation.lastIndexOf('.', cArray2);
        if (this.checkMode(n, 16) && n5 != -1) {
            stringBuffer.append("package ");
            stringBuffer.append(cArray2, 0, n5);
            stringBuffer.append(';');
            this.writeNewLine(stringBuffer, string, 0);
        }
        IInnerClassesAttribute iInnerClassesAttribute = iClassFileReader.getInnerClassesAttribute();
        object2 = Util.getAttribute(iClassFileReader, IAttributeNamesConstants.RUNTIME_VISIBLE_ANNOTATIONS);
        IClassFileAttribute iClassFileAttribute2 = Util.getAttribute(iClassFileReader, IAttributeNamesConstants.RUNTIME_INVISIBLE_ANNOTATIONS);
        if (this.checkMode(n, 1)) {
            if (iClassFileAttribute2 != null) {
                this.disassembleAsModifier((IRuntimeInvisibleAnnotationsAttribute)iClassFileAttribute2, stringBuffer, string, 1, n);
                this.writeNewLine(stringBuffer, string, 0);
            }
            if (object2 != null) {
                this.disassembleAsModifier((IRuntimeVisibleAnnotationsAttribute)object2, stringBuffer, string, 1, n);
                this.writeNewLine(stringBuffer, string, 0);
            }
        }
        boolean bl2 = false;
        if (bl && this.checkMode(n, 16)) {
            this.decodeModifiersForType(stringBuffer, n7 & 1);
        } else {
            if (iInnerClassesAttribute != null) {
                IInnerClassesAttributeEntry[] iInnerClassesAttributeEntryArray = iInnerClassesAttribute.getInnerClassAttributesEntries();
                n4 = 0;
                n3 = iInnerClassesAttributeEntryArray.length;
                while (n4 < n3) {
                    object = iInnerClassesAttributeEntryArray[n4];
                    char[] cArray3 = object.getInnerClassName();
                    if (cArray3 != null && CharOperation.equals(iClassFileReader.getClassName(), cArray3)) {
                        this.decodeModifiersForInnerClasses(stringBuffer, object.getAccessFlags(), false);
                        bl2 = true;
                    }
                    ++n4;
                }
            }
            if (!bl2) {
                this.decodeModifiersForType(stringBuffer, n7);
                if (this.isSynthetic(iClassFileReader)) {
                    stringBuffer.append("synthetic");
                    stringBuffer.append(Messages.disassembler_space);
                }
            }
        }
        boolean bl3 = (n7 & 0x2000) != 0;
        n4 = 0;
        if (bl) {
            stringBuffer.append("enum ");
        } else if (iClassFileReader.isClass()) {
            stringBuffer.append("class ");
        } else {
            if (bl3) {
                stringBuffer.append("@");
            }
            stringBuffer.append("interface ");
            n4 = 1;
        }
        if (this.checkMode(n, 16)) {
            n3 = n5 + 1;
            stringBuffer.append(cArray2, n3, n6 - n3);
            cArray2 = CharOperation.subarray(cArray2, n3, n6);
            if (iSignatureAttribute != null) {
                this.disassembleGenericSignature(n, stringBuffer, iSignatureAttribute.getSignature());
            }
        } else {
            stringBuffer.append(cArray2);
        }
        if ((cArray = iClassFileReader.getSuperclassName()) != null) {
            CharOperation.replace(cArray, '/', '.');
            if (!this.isJavaLangObject(cArray) && !bl) {
                stringBuffer.append(" extends ");
                stringBuffer.append(this.returnClassName(cArray, '.', n));
            }
        }
        if (!(bl3 && this.checkMode(n, 16) || (n2 = ((Object)(object = (Object)iClassFileReader.getInterfaceNames())).length) == 0)) {
            if (n4 != 0) {
                stringBuffer.append(" extends ");
            } else {
                stringBuffer.append(" implements ");
            }
            int n9 = 0;
            while (n9 < n2) {
                if (n9 != 0) {
                    stringBuffer.append(Messages.disassembler_comma).append(Messages.disassembler_space);
                }
                Object object3 = object[n9];
                CharOperation.replace((char[])object3, '/', '.');
                stringBuffer.append(this.returnClassName((char[])object3, '.', n));
                ++n9;
            }
        }
        stringBuffer.append(Messages.bind(Messages.disassembler_opentypedeclaration));
        if (this.checkMode(n, 4)) {
            this.disassemble(iClassFileReader.getConstantPool(), stringBuffer, string, 1);
        }
        this.disassembleTypeMembers(iClassFileReader, cArray2, stringBuffer, string, 1, n, bl);
        if (this.checkMode(n, 5)) {
            object = iClassFileReader.getAttributes();
            int n10 = ((IClassFileAttribute[])object).length;
            IEnclosingMethodAttribute iEnclosingMethodAttribute = this.getEnclosingMethodAttribute(iClassFileReader);
            int n11 = n10;
            if (iInnerClassesAttribute != null) {
                --n11;
            }
            if (iEnclosingMethodAttribute != null) {
                --n11;
            }
            if (iSourceAttribute != null) {
                --n11;
            }
            if (iSignatureAttribute != null) {
                --n11;
            }
            if (iInnerClassesAttribute != null || iEnclosingMethodAttribute != null || n11 != 0) {
                this.writeNewLine(stringBuffer, string, 0);
            }
            if (iInnerClassesAttribute != null) {
                this.disassemble(iInnerClassesAttribute, stringBuffer, string, 1);
            }
            if (iEnclosingMethodAttribute != null) {
                this.disassemble(iEnclosingMethodAttribute, stringBuffer, string, 0);
            }
            if (this.checkMode(n, 4)) {
                if (object2 != null) {
                    this.disassemble((IRuntimeVisibleAnnotationsAttribute)object2, stringBuffer, string, 0);
                }
                if (iClassFileAttribute2 != null) {
                    this.disassemble((IRuntimeInvisibleAnnotationsAttribute)iClassFileAttribute2, stringBuffer, string, 0);
                }
                if (n10 != 0) {
                    int n12 = 0;
                    while (n12 < n10) {
                        IClassFileAttribute iClassFileAttribute3 = object[n12];
                        if (iClassFileAttribute3 != iInnerClassesAttribute && iClassFileAttribute3 != iSourceAttribute && iClassFileAttribute3 != iSignatureAttribute && iClassFileAttribute3 != iEnclosingMethodAttribute && iClassFileAttribute3 != iClassFileAttribute2 && iClassFileAttribute3 != object2 && !CharOperation.equals(iClassFileAttribute3.getAttributeName(), IAttributeNamesConstants.DEPRECATED) && !CharOperation.equals(iClassFileAttribute3.getAttributeName(), IAttributeNamesConstants.SYNTHETIC)) {
                            this.disassemble(iClassFileAttribute3, stringBuffer, string, 0);
                        }
                        ++n12;
                    }
                }
            }
        }
        this.writeNewLine(stringBuffer, string, 0);
        stringBuffer.append(Messages.disassembler_closetypedeclaration);
        return stringBuffer.toString();
    }

    private void disassembleGenericSignature(int n, StringBuffer stringBuffer, char[] cArray) {
        CharOperation.replace(cArray, '/', '.');
        char[][] cArray2 = Signature.getTypeParameters(cArray);
        int n2 = cArray2.length;
        if (n2 != 0) {
            stringBuffer.append('<');
            int n3 = 0;
            while (n3 < n2) {
                if (n3 != 0) {
                    stringBuffer.append(Messages.disassembler_comma);
                }
                stringBuffer.append(cArray2[n3], 0, CharOperation.indexOf(':', cArray2[n3]));
                char[][] cArray3 = Signature.getTypeParameterBounds(cArray2[n3]);
                int n4 = cArray3.length;
                if (n4 != 0) {
                    if (n4 == 1) {
                        char[] cArray4 = cArray3[0];
                        if (!this.isJavaLangObject(Signature.toCharArray(cArray4))) {
                            stringBuffer.append(" extends ");
                            stringBuffer.append(this.returnClassName(Signature.toCharArray(cArray4), '.', n));
                        }
                    } else {
                        stringBuffer.append(" extends ");
                        int n5 = 0;
                        while (n5 < n4) {
                            if (n5 != 0) {
                                stringBuffer.append(" & ");
                            }
                            stringBuffer.append(this.returnClassName(Signature.toCharArray(cArray3[n5]), '.', n));
                            ++n5;
                        }
                    }
                }
                ++n3;
            }
            stringBuffer.append('>');
        }
    }

    private boolean isJavaLangObject(char[] cArray) {
        return CharOperation.equals(TypeConstants.JAVA_LANG_OBJECT, CharOperation.splitOn('.', cArray));
    }

    private boolean isVarArgs(IMethodInfo iMethodInfo) {
        return false;
    }

    private void disassemble(ICodeAttribute iCodeAttribute, StringBuffer stringBuffer, String string, int n, int n2) {
        ILocalVariableTypeTableAttribute iLocalVariableTypeTableAttribute;
        int n3;
        int n4;
        int n5;
        Object object;
        int n6;
        ILocalVariableAttribute iLocalVariableAttribute;
        int n7;
        ILineNumberAttribute iLineNumberAttribute;
        int n8;
        Object object2;
        int n9;
        this.writeNewLine(stringBuffer, string, n - 1);
        DefaultBytecodeVisitor defaultBytecodeVisitor = new DefaultBytecodeVisitor(iCodeAttribute, stringBuffer, string, n, n2);
        try {
            iCodeAttribute.traverse(defaultBytecodeVisitor);
        }
        catch (ClassFormatException classFormatException) {
            this.dumpTab(n + 2, stringBuffer);
            stringBuffer.append(Messages.classformat_classformatexception);
            this.writeNewLine(stringBuffer, string, n + 1);
        }
        int n10 = iCodeAttribute.getExceptionTableLength();
        boolean bl = true;
        if (n10 != 0) {
            int n11 = n + 2;
            bl = false;
            this.dumpTab(n11, stringBuffer);
            IExceptionTableEntry[] iExceptionTableEntryArray = iCodeAttribute.getExceptionTable();
            stringBuffer.append(Messages.disassembler_exceptiontableheader);
            this.writeNewLine(stringBuffer, string, n11 + 1);
            n9 = 0;
            while (n9 < n10) {
                char[] cArray;
                if (n9 != 0) {
                    this.writeNewLine(stringBuffer, string, n11 + 1);
                }
                if ((object2 = iExceptionTableEntryArray[n9]).getCatchTypeIndex() != 0) {
                    cArray = object2.getCatchType();
                    CharOperation.replace(cArray, '/', '.');
                    cArray = this.returnClassName(cArray, '.', n2);
                } else {
                    cArray = ANY_EXCEPTION;
                }
                stringBuffer.append(Messages.bind(Messages.classfileformat_exceptiontableentry, new String[]{Integer.toString(object2.getStartPC()), Integer.toString(object2.getEndPC()), Integer.toString(object2.getHandlerPC()), new String(cArray)}));
                ++n9;
            }
        }
        int n12 = n8 = (iLineNumberAttribute = iCodeAttribute.getLineNumberAttribute()) == null ? 0 : iLineNumberAttribute.getLineNumberTableLength();
        if (n8 != 0) {
            n9 = n + 2;
            if (!bl) {
                this.writeNewLine(stringBuffer, string, n9);
            } else {
                this.dumpTab(n9, stringBuffer);
                bl = false;
            }
            stringBuffer.append(Messages.disassembler_linenumberattributeheader);
            this.writeNewLine(stringBuffer, string, n9 + 1);
            object2 = iLineNumberAttribute.getLineNumberTable();
            int n13 = 0;
            while (n13 < n8) {
                if (n13 != 0) {
                    this.writeNewLine(stringBuffer, string, n9 + 1);
                }
                stringBuffer.append(Messages.bind(Messages.classfileformat_linenumbertableentry, new String[]{Integer.toString((int)object2[n13][0]), Integer.toString((int)object2[n13][1])}));
                ++n13;
            }
        }
        int n14 = n7 = (iLocalVariableAttribute = iCodeAttribute.getLocalVariableAttribute()) == null ? 0 : iLocalVariableAttribute.getLocalVariableTableLength();
        if (n7 != 0) {
            int n15 = n + 2;
            if (!bl) {
                this.writeNewLine(stringBuffer, string, n15);
            } else {
                bl = false;
                this.dumpTab(n15, stringBuffer);
            }
            stringBuffer.append(Messages.disassembler_localvariabletableattributeheader);
            this.writeNewLine(stringBuffer, string, n15 + 1);
            ILocalVariableTableEntry[] iLocalVariableTableEntryArray = iLocalVariableAttribute.getLocalVariableTable();
            n6 = 0;
            while (n6 < n7) {
                if (n6 != 0) {
                    this.writeNewLine(stringBuffer, string, n15 + 1);
                }
                object = iLocalVariableTableEntryArray[n6];
                n5 = object.getIndex();
                int n16 = object.getStartPC();
                n4 = object.getLength();
                char[] cArray = Signature.toCharArray(object.getDescriptor());
                CharOperation.replace(cArray, '/', '.');
                stringBuffer.append(Messages.bind(Messages.classfileformat_localvariabletableentry, new String[]{Integer.toString(n16), Integer.toString(n16 + n4), new String(object.getName()), Integer.toString(n5), new String(this.returnClassName(cArray, '.', n2))}));
                ++n6;
            }
        }
        int n17 = n3 = (iLocalVariableTypeTableAttribute = (ILocalVariableTypeTableAttribute)this.getAttribute(IAttributeNamesConstants.LOCAL_VARIABLE_TYPE_TABLE, iCodeAttribute)) == null ? 0 : iLocalVariableTypeTableAttribute.getLocalVariableTypeTableLength();
        if (n3 != 0) {
            n6 = n + 2;
            if (!bl) {
                this.writeNewLine(stringBuffer, string, n6);
            } else {
                bl = false;
                this.dumpTab(n6, stringBuffer);
            }
            stringBuffer.append(Messages.disassembler_localvariabletypetableattributeheader);
            this.writeNewLine(stringBuffer, string, n6 + 1);
            object = iLocalVariableTypeTableAttribute.getLocalVariableTypeTable();
            n5 = 0;
            while (n5 < n3) {
                if (n5 != 0) {
                    this.writeNewLine(stringBuffer, string, n6 + 1);
                }
                Object object3 = object[n5];
                n4 = object3.getIndex();
                int n18 = object3.getStartPC();
                int n19 = object3.getLength();
                char[] cArray = Signature.toCharArray(object3.getSignature());
                CharOperation.replace(cArray, '/', '.');
                stringBuffer.append(Messages.bind(Messages.classfileformat_localvariabletableentry, new String[]{Integer.toString(n18), Integer.toString(n18 + n19), new String(object3.getName()), Integer.toString(n4), new String(this.returnClassName(cArray, '.', n2))}));
                ++n5;
            }
        }
        if ((n6 = iCodeAttribute.getAttributesCount()) != 0) {
            object = iCodeAttribute.getAttributes();
            n5 = 0;
            while (n5 < n6) {
                IClassFileAttribute iClassFileAttribute = object[n5];
                if (CharOperation.equals(iClassFileAttribute.getAttributeName(), IAttributeNamesConstants.STACK_MAP_TABLE)) {
                    IStackMapTableAttribute iStackMapTableAttribute = (IStackMapTableAttribute)iClassFileAttribute;
                    if (!bl) {
                        this.writeNewLine(stringBuffer, string, n + 2);
                    } else {
                        bl = false;
                        this.dumpTab(n + 1, stringBuffer);
                    }
                    int n20 = iStackMapTableAttribute.getNumberOfEntries();
                    stringBuffer.append(Messages.bind(Messages.disassembler_stackmaptableattributeheader, Integer.toString(n20)));
                    if (n20 != 0) {
                        this.disassemble(iStackMapTableAttribute, stringBuffer, string, n, n2);
                    }
                } else if (CharOperation.equals(iClassFileAttribute.getAttributeName(), IAttributeNamesConstants.STACK_MAP)) {
                    IStackMapAttribute iStackMapAttribute = (IStackMapAttribute)iClassFileAttribute;
                    if (!bl) {
                        this.writeNewLine(stringBuffer, string, n + 2);
                    } else {
                        bl = false;
                        this.dumpTab(n + 1, stringBuffer);
                    }
                    int n21 = iStackMapAttribute.getNumberOfEntries();
                    stringBuffer.append(Messages.bind(Messages.disassembler_stackmapattributeheader, Integer.toString(n21)));
                    if (n21 != 0) {
                        this.disassemble(iStackMapAttribute, stringBuffer, string, n, n2);
                    }
                } else if (iClassFileAttribute != iLineNumberAttribute && iClassFileAttribute != iLocalVariableAttribute && iClassFileAttribute != iLocalVariableTypeTableAttribute) {
                    if (!bl) {
                        this.writeNewLine(stringBuffer, string, n + 2);
                    } else {
                        bl = false;
                        this.dumpTab(n + 1, stringBuffer);
                    }
                    stringBuffer.append(Messages.bind(Messages.disassembler_genericattributeheader, new String[]{new String(iClassFileAttribute.getAttributeName()), Long.toString(iClassFileAttribute.getAttributeLength())}));
                }
                ++n5;
            }
        }
    }

    private void disassemble(IStackMapTableAttribute iStackMapTableAttribute, StringBuffer stringBuffer, String string, int n, int n2) {
        this.writeNewLine(stringBuffer, string, n + 3);
        int n3 = iStackMapTableAttribute.getNumberOfEntries();
        IStackMapFrame[] iStackMapFrameArray = iStackMapTableAttribute.getStackMapFrame();
        int n4 = -1;
        int n5 = 0;
        while (n5 < n3) {
            if (n5 > 0) {
                this.writeNewLine(stringBuffer, string, n + 3);
            }
            IStackMapFrame iStackMapFrame = iStackMapFrameArray[n5];
            int n6 = iStackMapFrame.getFrameType();
            int n7 = iStackMapFrame.getOffsetDelta();
            n4 = n4 == -1 ? n7 : (n4 += n7 + 1);
            switch (n6) {
                case 247: {
                    stringBuffer.append(Messages.bind(Messages.disassembler_frame_same_locals_1_stack_item_extended, Integer.toString(n4), this.disassemble(iStackMapFrame.getStackItems(), n2)));
                    break;
                }
                case 248: 
                case 249: 
                case 250: {
                    stringBuffer.append(Messages.bind(Messages.disassembler_frame_chop, Integer.toString(n4), Integer.toString(251 - n6)));
                    break;
                }
                case 251: {
                    stringBuffer.append(Messages.bind(Messages.disassembler_frame_same_frame_extended, Integer.toString(n4)));
                    break;
                }
                case 252: 
                case 253: 
                case 254: {
                    stringBuffer.append(Messages.bind(Messages.disassembler_frame_append, Integer.toString(n4), this.disassemble(iStackMapFrame.getLocals(), n2)));
                    break;
                }
                case 255: {
                    stringBuffer.append(Messages.bind(Messages.disassembler_frame_full_frame, new String[]{Integer.toString(n4), Integer.toString(iStackMapFrame.getNumberOfLocals()), this.disassemble(iStackMapFrame.getLocals(), n2), Integer.toString(iStackMapFrame.getNumberOfStackItems()), this.disassemble(iStackMapFrame.getStackItems(), n2), this.dumpNewLineWithTabs(string, n + 5)}));
                    break;
                }
                default: {
                    if (n6 <= 63) {
                        n7 = n6;
                        stringBuffer.append(Messages.bind(Messages.disassembler_frame_same_frame, Integer.toString(n4)));
                        break;
                    }
                    if (n6 > 127) break;
                    n7 = n6 - 64;
                    stringBuffer.append(Messages.bind(Messages.disassembler_frame_same_locals_1_stack_item, Integer.toString(n4), this.disassemble(iStackMapFrame.getStackItems(), n2)));
                }
            }
            ++n5;
        }
    }

    private void disassemble(IStackMapAttribute iStackMapAttribute, StringBuffer stringBuffer, String string, int n, int n2) {
        this.writeNewLine(stringBuffer, string, n + 3);
        int n3 = iStackMapAttribute.getNumberOfEntries();
        IStackMapFrame[] iStackMapFrameArray = iStackMapAttribute.getStackMapFrame();
        int n4 = -1;
        int n5 = 0;
        while (n5 < n3) {
            if (n5 > 0) {
                this.writeNewLine(stringBuffer, string, n + 3);
            }
            IStackMapFrame iStackMapFrame = iStackMapFrameArray[n5];
            int n6 = iStackMapFrame.getOffsetDelta();
            n4 = n4 == -1 ? n6 : (n4 += n6 + 1);
            stringBuffer.append(Messages.bind(Messages.disassembler_frame_full_frame, new String[]{Integer.toString(n4), Integer.toString(iStackMapFrame.getNumberOfLocals()), this.disassemble(iStackMapFrame.getLocals(), n2), Integer.toString(iStackMapFrame.getNumberOfStackItems()), this.disassemble(iStackMapFrame.getStackItems(), n2), this.dumpNewLineWithTabs(string, n + 5)}));
            ++n5;
        }
    }

    private void disassemble(IConstantPool iConstantPool, StringBuffer stringBuffer, String string, int n) {
        this.writeNewLine(stringBuffer, string, n);
        int n2 = iConstantPool.getConstantPoolCount();
        stringBuffer.append(Messages.disassembler_constantpoolheader);
        this.writeNewLine(stringBuffer, string, n + 1);
        int n3 = 1;
        while (n3 < n2) {
            if (n3 != 1) {
                this.writeNewLine(stringBuffer, string, n + 1);
            }
            IConstantPoolEntry iConstantPoolEntry = iConstantPool.decodeEntry(n3);
            switch (iConstantPool.getEntryKind(n3)) {
                case 7: {
                    stringBuffer.append(Messages.bind(Messages.disassembler_constantpool_class, new String[]{Integer.toString(n3), Integer.toString(iConstantPoolEntry.getClassInfoNameIndex()), new String(iConstantPoolEntry.getClassInfoName())}));
                    break;
                }
                case 6: {
                    stringBuffer.append(Messages.bind(Messages.disassembler_constantpool_double, new String[]{Integer.toString(n3), Double.toString(iConstantPoolEntry.getDoubleValue())}));
                    break;
                }
                case 9: {
                    stringBuffer.append(Messages.bind(Messages.disassembler_constantpool_fieldref, new String[]{Integer.toString(n3), Integer.toString(iConstantPoolEntry.getClassIndex()), Integer.toString(iConstantPoolEntry.getNameAndTypeIndex()), new String(iConstantPoolEntry.getClassName()), new String(iConstantPoolEntry.getFieldName()), new String(iConstantPoolEntry.getFieldDescriptor())}));
                    break;
                }
                case 4: {
                    stringBuffer.append(Messages.bind(Messages.disassembler_constantpool_float, new String[]{Integer.toString(n3), Float.toString(iConstantPoolEntry.getFloatValue())}));
                    break;
                }
                case 3: {
                    stringBuffer.append(Messages.bind(Messages.disassembler_constantpool_integer, new String[]{Integer.toString(n3), Integer.toString(iConstantPoolEntry.getIntegerValue())}));
                    break;
                }
                case 11: {
                    stringBuffer.append(Messages.bind(Messages.disassembler_constantpool_interfacemethodref, new String[]{Integer.toString(n3), Integer.toString(iConstantPoolEntry.getClassIndex()), Integer.toString(iConstantPoolEntry.getNameAndTypeIndex()), new String(iConstantPoolEntry.getClassName()), new String(iConstantPoolEntry.getMethodName()), new String(iConstantPoolEntry.getMethodDescriptor())}));
                    break;
                }
                case 5: {
                    stringBuffer.append(Messages.bind(Messages.disassembler_constantpool_long, new String[]{Integer.toString(n3), Long.toString(iConstantPoolEntry.getLongValue())}));
                    break;
                }
                case 10: {
                    stringBuffer.append(Messages.bind(Messages.disassembler_constantpool_methodref, new String[]{Integer.toString(n3), Integer.toString(iConstantPoolEntry.getClassIndex()), Integer.toString(iConstantPoolEntry.getNameAndTypeIndex()), new String(iConstantPoolEntry.getClassName()), new String(iConstantPoolEntry.getMethodName()), new String(iConstantPoolEntry.getMethodDescriptor())}));
                    break;
                }
                case 12: {
                    int n4 = iConstantPoolEntry.getNameAndTypeInfoNameIndex();
                    int n5 = iConstantPoolEntry.getNameAndTypeInfoDescriptorIndex();
                    IConstantPoolEntry iConstantPoolEntry2 = iConstantPool.decodeEntry(n4);
                    char[] cArray = iConstantPoolEntry2.getUtf8Value();
                    iConstantPoolEntry2 = iConstantPool.decodeEntry(n5);
                    char[] cArray2 = iConstantPoolEntry2.getUtf8Value();
                    stringBuffer.append(Messages.bind(Messages.disassembler_constantpool_name_and_type, new String[]{Integer.toString(n3), Integer.toString(n4), Integer.toString(n5), String.valueOf(cArray), String.valueOf(cArray2)}));
                    break;
                }
                case 8: {
                    stringBuffer.append(Messages.bind(Messages.disassembler_constantpool_string, new String[]{Integer.toString(n3), Integer.toString(iConstantPoolEntry.getStringIndex()), Disassembler.decodeStringValue(iConstantPoolEntry.getStringValue())}));
                    break;
                }
                case 1: {
                    stringBuffer.append(Messages.bind(Messages.disassembler_constantpool_utf8, new String[]{Integer.toString(n3), Disassembler.decodeStringValue(new String(iConstantPoolEntry.getUtf8Value()))}));
                }
            }
            ++n3;
        }
    }

    private void disassemble(IEnclosingMethodAttribute iEnclosingMethodAttribute, StringBuffer stringBuffer, String string, int n) {
        this.writeNewLine(stringBuffer, string, n + 1);
        stringBuffer.append(Messages.disassembler_enclosingmethodheader);
        stringBuffer.append(Messages.disassembler_constantpoolindex).append(iEnclosingMethodAttribute.getEnclosingClassIndex()).append(" ").append(Messages.disassembler_constantpoolindex).append(iEnclosingMethodAttribute.getMethodNameAndTypeIndex()).append(" ").append(iEnclosingMethodAttribute.getEnclosingClass());
        if (iEnclosingMethodAttribute.getMethodNameAndTypeIndex() != 0) {
            stringBuffer.append(".").append(iEnclosingMethodAttribute.getMethodName()).append(iEnclosingMethodAttribute.getMethodDescriptor());
        }
    }

    private void disassembleEnumConstants(IFieldInfo iFieldInfo, StringBuffer stringBuffer, String string, int n, char[][] cArray, int n2) {
        this.writeNewLine(stringBuffer, string, n);
        IClassFileAttribute iClassFileAttribute = Util.getAttribute(iFieldInfo, IAttributeNamesConstants.RUNTIME_VISIBLE_ANNOTATIONS);
        IClassFileAttribute iClassFileAttribute2 = Util.getAttribute(iFieldInfo, IAttributeNamesConstants.RUNTIME_INVISIBLE_ANNOTATIONS);
        if (iClassFileAttribute2 != null) {
            this.disassembleAsModifier((IRuntimeInvisibleAnnotationsAttribute)iClassFileAttribute2, stringBuffer, string, n + 1, n2);
            this.writeNewLine(stringBuffer, string, n);
        }
        if (iClassFileAttribute != null) {
            this.disassembleAsModifier((IRuntimeVisibleAnnotationsAttribute)iClassFileAttribute, stringBuffer, string, n + 1, n2);
            this.writeNewLine(stringBuffer, string, n);
        }
        stringBuffer.append(new String(iFieldInfo.getName()));
        stringBuffer.append('(');
        int n3 = cArray.length;
        if (n3 != 0) {
            int n4 = 0;
            while (n4 < n3) {
                if (n4 != 0) {
                    stringBuffer.append(Messages.disassembler_comma);
                }
                char[] cArray2 = cArray[n4];
                switch (cArray2.length) {
                    case 1: {
                        switch (cArray2[0]) {
                            case 'B': 
                            case 'D': 
                            case 'F': 
                            case 'I': 
                            case 'J': 
                            case 'S': {
                                stringBuffer.append('0');
                                break;
                            }
                            case 'Z': {
                                stringBuffer.append("false");
                                break;
                            }
                            case 'C': {
                                stringBuffer.append("' '");
                            }
                        }
                        break;
                    }
                    default: {
                        stringBuffer.append("null");
                    }
                }
                ++n4;
            }
        }
        stringBuffer.append(')').append(Messages.disassembler_comma);
    }

    private void disassemble(IFieldInfo iFieldInfo, StringBuffer stringBuffer, String string, int n, int n2) {
        IClassFileAttribute[] iClassFileAttributeArray;
        this.writeNewLine(stringBuffer, string, n);
        char[] cArray = iFieldInfo.getDescriptor();
        ISignatureAttribute iSignatureAttribute = (ISignatureAttribute)Util.getAttribute(iFieldInfo, IAttributeNamesConstants.SIGNATURE);
        if (this.checkMode(n2, 5)) {
            stringBuffer.append(Messages.bind(Messages.classfileformat_fieldddescriptor, new String[]{Integer.toString(iFieldInfo.getDescriptorIndex()), new String(cArray)}));
            if (iFieldInfo.isDeprecated()) {
                stringBuffer.append(Messages.disassembler_deprecated);
            }
            this.writeNewLine(stringBuffer, string, n);
            if (iSignatureAttribute != null) {
                stringBuffer.append(Messages.bind(Messages.disassembler_signatureattributeheader, new String(iSignatureAttribute.getSignature())));
                this.writeNewLine(stringBuffer, string, n);
            }
        }
        IClassFileAttribute iClassFileAttribute = Util.getAttribute(iFieldInfo, IAttributeNamesConstants.RUNTIME_VISIBLE_ANNOTATIONS);
        IClassFileAttribute iClassFileAttribute2 = Util.getAttribute(iFieldInfo, IAttributeNamesConstants.RUNTIME_INVISIBLE_ANNOTATIONS);
        if (this.checkMode(n2, 1)) {
            if (iClassFileAttribute2 != null) {
                this.disassembleAsModifier((IRuntimeInvisibleAnnotationsAttribute)iClassFileAttribute2, stringBuffer, string, n + 1, n2);
                this.writeNewLine(stringBuffer, string, n);
            }
            if (iClassFileAttribute != null) {
                this.disassembleAsModifier((IRuntimeVisibleAnnotationsAttribute)iClassFileAttribute, stringBuffer, string, n + 1, n2);
                this.writeNewLine(stringBuffer, string, n);
            }
        }
        if (this.checkMode(n2, 16)) {
            this.decodeModifiersForFieldForWorkingCopy(stringBuffer, iFieldInfo.getAccessFlags());
            if (iSignatureAttribute != null) {
                stringBuffer.append(this.returnClassName(this.getSignatureForField(iSignatureAttribute.getSignature()), '.', n2));
            } else {
                stringBuffer.append(this.returnClassName(this.getSignatureForField(cArray), '.', n2));
            }
        } else {
            this.decodeModifiersForField(stringBuffer, iFieldInfo.getAccessFlags());
            if (iFieldInfo.isSynthetic()) {
                stringBuffer.append("synthetic");
                stringBuffer.append(Messages.disassembler_space);
            }
            stringBuffer.append(this.returnClassName(this.getSignatureForField(cArray), '.', n2));
        }
        stringBuffer.append(' ');
        stringBuffer.append(new String(iFieldInfo.getName()));
        IConstantValueAttribute iConstantValueAttribute = iFieldInfo.getConstantValueAttribute();
        if (iConstantValueAttribute != null) {
            stringBuffer.append(Messages.disassembler_fieldhasconstant);
            iClassFileAttributeArray = iConstantValueAttribute.getConstantValue();
            switch (iClassFileAttributeArray.getKind()) {
                case 5: {
                    stringBuffer.append(String.valueOf(iClassFileAttributeArray.getLongValue()) + "L");
                    break;
                }
                case 4: {
                    stringBuffer.append(String.valueOf(iClassFileAttributeArray.getFloatValue()) + "f");
                    break;
                }
                case 6: {
                    double d = iClassFileAttributeArray.getDoubleValue();
                    if (this.checkMode(n2, 16)) {
                        if (d == Double.POSITIVE_INFINITY) {
                            stringBuffer.append("1.0 / 0.0");
                            break;
                        }
                        if (d == Double.NEGATIVE_INFINITY) {
                            stringBuffer.append("-1.0 / 0.0");
                            break;
                        }
                        stringBuffer.append(iClassFileAttributeArray.getDoubleValue());
                        break;
                    }
                    stringBuffer.append(iClassFileAttributeArray.getDoubleValue());
                    break;
                }
                case 3: {
                    switch (cArray[0]) {
                        case 'C': {
                            stringBuffer.append("'" + (char)iClassFileAttributeArray.getIntegerValue() + "'");
                            break;
                        }
                        case 'Z': {
                            stringBuffer.append(iClassFileAttributeArray.getIntegerValue() == 1 ? "true" : "false");
                            break;
                        }
                        case 'B': {
                            stringBuffer.append(iClassFileAttributeArray.getIntegerValue());
                            break;
                        }
                        case 'S': {
                            stringBuffer.append(iClassFileAttributeArray.getIntegerValue());
                            break;
                        }
                        case 'I': {
                            stringBuffer.append(iClassFileAttributeArray.getIntegerValue());
                        }
                    }
                    break;
                }
                case 8: {
                    stringBuffer.append("\"" + Disassembler.decodeStringValue(iClassFileAttributeArray.getStringValue()) + "\"");
                }
            }
        }
        stringBuffer.append(Messages.disassembler_endoffieldheader);
        if (this.checkMode(n2, 4)) {
            iClassFileAttributeArray = iFieldInfo.getAttributes();
            int n3 = iClassFileAttributeArray.length;
            if (n3 != 0) {
                int n4 = 0;
                while (n4 < n3) {
                    IClassFileAttribute iClassFileAttribute3 = iClassFileAttributeArray[n4];
                    if (iClassFileAttribute3 != iConstantValueAttribute && iClassFileAttribute3 != iSignatureAttribute && iClassFileAttribute3 != iClassFileAttribute2 && iClassFileAttribute3 != iClassFileAttribute && !CharOperation.equals(iClassFileAttribute3.getAttributeName(), IAttributeNamesConstants.DEPRECATED) && !CharOperation.equals(iClassFileAttribute3.getAttributeName(), IAttributeNamesConstants.SYNTHETIC)) {
                        this.disassemble(iClassFileAttribute3, stringBuffer, string, n);
                    }
                    ++n4;
                }
            }
            if (iClassFileAttribute != null) {
                this.disassemble((IRuntimeVisibleAnnotationsAttribute)iClassFileAttribute, stringBuffer, string, n);
            }
            if (iClassFileAttribute2 != null) {
                this.disassemble((IRuntimeInvisibleAnnotationsAttribute)iClassFileAttribute2, stringBuffer, string, n);
            }
        }
    }

    private void disassemble(IInnerClassesAttribute iInnerClassesAttribute, StringBuffer stringBuffer, String string, int n) {
        this.writeNewLine(stringBuffer, string, n);
        stringBuffer.append(Messages.disassembler_innerattributesheader);
        this.writeNewLine(stringBuffer, string, n + 1);
        IInnerClassesAttributeEntry[] iInnerClassesAttributeEntryArray = iInnerClassesAttribute.getInnerClassAttributesEntries();
        int n2 = iInnerClassesAttributeEntryArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (n3 != 0) {
                stringBuffer.append(Messages.disassembler_comma);
                this.writeNewLine(stringBuffer, string, n + 1);
            }
            IInnerClassesAttributeEntry iInnerClassesAttributeEntry = iInnerClassesAttributeEntryArray[n3];
            int n4 = iInnerClassesAttributeEntry.getInnerClassNameIndex();
            int n5 = iInnerClassesAttributeEntry.getOuterClassNameIndex();
            int n6 = iInnerClassesAttributeEntry.getInnerNameIndex();
            int n7 = iInnerClassesAttributeEntry.getAccessFlags();
            stringBuffer.append(Messages.disassembler_openinnerclassentry).append(Messages.disassembler_inner_class_info_name).append(Messages.disassembler_constantpoolindex).append(n4);
            if (n4 != 0) {
                stringBuffer.append(Messages.disassembler_space).append(iInnerClassesAttributeEntry.getInnerClassName());
            }
            stringBuffer.append(Messages.disassembler_comma).append(Messages.disassembler_space).append(Messages.disassembler_outer_class_info_name).append(Messages.disassembler_constantpoolindex).append(n5);
            if (n5 != 0) {
                stringBuffer.append(Messages.disassembler_space).append(iInnerClassesAttributeEntry.getOuterClassName());
            }
            this.writeNewLine(stringBuffer, string, n);
            this.dumpTab(n, stringBuffer);
            stringBuffer.append(Messages.disassembler_space);
            stringBuffer.append(Messages.disassembler_inner_name).append(Messages.disassembler_constantpoolindex).append(n6);
            if (n6 != 0) {
                stringBuffer.append(Messages.disassembler_space).append(iInnerClassesAttributeEntry.getInnerName());
            }
            stringBuffer.append(Messages.disassembler_comma).append(Messages.disassembler_space).append(Messages.disassembler_inner_accessflags).append(n7).append(Messages.disassembler_space);
            this.decodeModifiersForInnerClasses(stringBuffer, n7, true);
            stringBuffer.append(Messages.disassembler_closeinnerclassentry);
            ++n3;
        }
    }

    private void disassemble(int n, IParameterAnnotation iParameterAnnotation, StringBuffer stringBuffer, String string, int n2) {
        IAnnotation[] iAnnotationArray = iParameterAnnotation.getAnnotations();
        this.writeNewLine(stringBuffer, string, n2 + 1);
        stringBuffer.append(Messages.bind(Messages.disassembler_parameterannotationentrystart, new String[]{Integer.toString(n), Integer.toString(iAnnotationArray.length)}));
        int n3 = 0;
        int n4 = iAnnotationArray.length;
        while (n3 < n4) {
            this.disassemble(iAnnotationArray[n3], stringBuffer, string, n2 + 1);
            ++n3;
        }
    }

    private void disassemble(IRuntimeInvisibleAnnotationsAttribute iRuntimeInvisibleAnnotationsAttribute, StringBuffer stringBuffer, String string, int n) {
        this.writeNewLine(stringBuffer, string, n + 1);
        stringBuffer.append(Messages.disassembler_runtimeinvisibleannotationsattributeheader);
        IAnnotation[] iAnnotationArray = iRuntimeInvisibleAnnotationsAttribute.getAnnotations();
        int n2 = 0;
        int n3 = iAnnotationArray.length;
        while (n2 < n3) {
            this.disassemble(iAnnotationArray[n2], stringBuffer, string, n + 1);
            ++n2;
        }
    }

    private void disassemble(IRuntimeInvisibleParameterAnnotationsAttribute iRuntimeInvisibleParameterAnnotationsAttribute, StringBuffer stringBuffer, String string, int n) {
        this.writeNewLine(stringBuffer, string, n + 1);
        stringBuffer.append(Messages.disassembler_runtimeinvisibleparameterannotationsattributeheader);
        IParameterAnnotation[] iParameterAnnotationArray = iRuntimeInvisibleParameterAnnotationsAttribute.getParameterAnnotations();
        int n2 = 0;
        int n3 = iParameterAnnotationArray.length;
        while (n2 < n3) {
            this.disassemble(n2, iParameterAnnotationArray[n2], stringBuffer, string, n + 1);
            ++n2;
        }
    }

    private void disassemble(IRuntimeVisibleAnnotationsAttribute iRuntimeVisibleAnnotationsAttribute, StringBuffer stringBuffer, String string, int n) {
        this.writeNewLine(stringBuffer, string, n + 1);
        stringBuffer.append(Messages.disassembler_runtimevisibleannotationsattributeheader);
        IAnnotation[] iAnnotationArray = iRuntimeVisibleAnnotationsAttribute.getAnnotations();
        int n2 = 0;
        int n3 = iAnnotationArray.length;
        while (n2 < n3) {
            this.disassemble(iAnnotationArray[n2], stringBuffer, string, n + 1);
            ++n2;
        }
    }

    private void disassemble(IRuntimeVisibleParameterAnnotationsAttribute iRuntimeVisibleParameterAnnotationsAttribute, StringBuffer stringBuffer, String string, int n) {
        this.writeNewLine(stringBuffer, string, n + 1);
        stringBuffer.append(Messages.disassembler_runtimevisibleparameterannotationsattributeheader);
        IParameterAnnotation[] iParameterAnnotationArray = iRuntimeVisibleParameterAnnotationsAttribute.getParameterAnnotations();
        int n2 = 0;
        int n3 = iParameterAnnotationArray.length;
        while (n2 < n3) {
            this.disassemble(n2, iParameterAnnotationArray[n2], stringBuffer, string, n + 1);
            ++n2;
        }
    }

    private String disassemble(IVerificationTypeInfo[] iVerificationTypeInfoArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        int n2 = 0;
        int n3 = iVerificationTypeInfoArray.length;
        while (n2 < n3) {
            if (n2 != 0) {
                stringBuffer.append(Messages.disassembler_comma).append(Messages.disassembler_space);
            }
            switch (iVerificationTypeInfoArray[n2].getTag()) {
                case 3: {
                    stringBuffer.append("double");
                    break;
                }
                case 2: {
                    stringBuffer.append("float");
                    break;
                }
                case 1: {
                    stringBuffer.append("int");
                    break;
                }
                case 4: {
                    stringBuffer.append("long");
                    break;
                }
                case 5: {
                    stringBuffer.append("null");
                    break;
                }
                case 7: {
                    char[] cArray = iVerificationTypeInfoArray[n2].getClassTypeName();
                    CharOperation.replace(cArray, '/', '.');
                    if (cArray.length > 0 && cArray[0] == '[') {
                        cArray = Signature.toCharArray(cArray);
                    }
                    stringBuffer.append(this.returnClassName(cArray, '.', n));
                    break;
                }
                case 0: {
                    stringBuffer.append("_");
                    break;
                }
                case 8: {
                    stringBuffer.append("uninitialized(");
                    stringBuffer.append(iVerificationTypeInfoArray[n2].getOffset());
                    stringBuffer.append(')');
                    break;
                }
                case 6: {
                    stringBuffer.append("uninitialized_this");
                }
            }
            ++n2;
        }
        stringBuffer.append('}');
        return String.valueOf(stringBuffer);
    }

    private void disassembleAsModifier(IAnnotation iAnnotation, StringBuffer stringBuffer, String string, int n, int n2) {
        char[] cArray = CharOperation.replaceOnCopy(iAnnotation.getTypeName(), '/', '.');
        stringBuffer.append('@').append(this.returnClassName(Signature.toCharArray(cArray), '.', n2));
        IAnnotationComponent[] iAnnotationComponentArray = iAnnotation.getComponents();
        int n3 = iAnnotationComponentArray.length;
        if (n3 != 0) {
            stringBuffer.append('(');
            int n4 = 0;
            while (n4 < n3) {
                if (n4 > 0) {
                    stringBuffer.append(',');
                    this.writeNewLine(stringBuffer, string, n);
                }
                this.disassembleAsModifier(iAnnotationComponentArray[n4], stringBuffer, string, n + 1, n2);
                ++n4;
            }
            stringBuffer.append(')');
        }
    }

    private void disassembleAsModifier(IAnnotationComponent iAnnotationComponent, StringBuffer stringBuffer, String string, int n, int n2) {
        stringBuffer.append(iAnnotationComponent.getComponentName()).append('=');
        this.disassembleAsModifier(iAnnotationComponent.getComponentValue(), stringBuffer, string, n + 1, n2);
    }

    private void disassembleAsModifier(IAnnotationComponentValue iAnnotationComponentValue, StringBuffer stringBuffer, String string, int n, int n2) {
        switch (iAnnotationComponentValue.getTag()) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                IConstantPoolEntry iConstantPoolEntry = iAnnotationComponentValue.getConstantValue();
                String string2 = null;
                switch (iConstantPoolEntry.getKind()) {
                    case 5: {
                        string2 = String.valueOf(iConstantPoolEntry.getLongValue()) + "L";
                        break;
                    }
                    case 4: {
                        string2 = String.valueOf(iConstantPoolEntry.getFloatValue()) + "f";
                        break;
                    }
                    case 6: {
                        string2 = Double.toString(iConstantPoolEntry.getDoubleValue());
                        break;
                    }
                    case 3: {
                        switch (iAnnotationComponentValue.getTag()) {
                            case 67: {
                                string2 = "'" + (char)iConstantPoolEntry.getIntegerValue() + "'";
                                break;
                            }
                            case 90: {
                                string2 = iConstantPoolEntry.getIntegerValue() == 1 ? "true" : "false";
                                break;
                            }
                            case 66: {
                                string2 = "(byte) " + iConstantPoolEntry.getIntegerValue();
                                break;
                            }
                            case 83: {
                                string2 = "(short) " + iConstantPoolEntry.getIntegerValue();
                                break;
                            }
                            case 73: {
                                string2 = "(int) " + iConstantPoolEntry.getIntegerValue();
                            }
                        }
                        break;
                    }
                    case 1: {
                        string2 = "\"" + Disassembler.decodeStringValue(iConstantPoolEntry.getUtf8Value()) + "\"";
                    }
                }
                stringBuffer.append(string2);
                break;
            }
            case 101: {
                char[] cArray = CharOperation.replaceOnCopy(iAnnotationComponentValue.getEnumConstantTypeName(), '/', '.');
                char[] cArray2 = iAnnotationComponentValue.getEnumConstantName();
                stringBuffer.append(Signature.toCharArray(cArray)).append('.').append(cArray2);
                break;
            }
            case 99: {
                IConstantPoolEntry iConstantPoolEntry = iAnnotationComponentValue.getClassInfo();
                char[] cArray = CharOperation.replaceOnCopy(iConstantPoolEntry.getUtf8Value(), '/', '.');
                stringBuffer.append(Signature.toCharArray(cArray));
                break;
            }
            case 64: {
                IAnnotation iAnnotation = iAnnotationComponentValue.getAnnotationValue();
                this.disassembleAsModifier(iAnnotation, stringBuffer, string, n + 1, n2);
                break;
            }
            case 91: {
                IAnnotationComponentValue[] iAnnotationComponentValueArray = iAnnotationComponentValue.getAnnotationComponentValues();
                stringBuffer.append('{');
                int n3 = 0;
                int n4 = iAnnotationComponentValueArray.length;
                while (n3 < n4) {
                    if (n3 > 0) {
                        stringBuffer.append(',');
                    }
                    this.disassembleAsModifier(iAnnotationComponentValueArray[n3], stringBuffer, string, n + 1, n2);
                    ++n3;
                }
                stringBuffer.append('}');
            }
        }
    }

    private void disassembleAsModifier(IAnnotationDefaultAttribute iAnnotationDefaultAttribute, StringBuffer stringBuffer, String string, int n, int n2) {
        IAnnotationComponentValue iAnnotationComponentValue = iAnnotationDefaultAttribute.getMemberValue();
        this.disassembleAsModifier(iAnnotationComponentValue, stringBuffer, string, n + 1, n2);
    }

    private void disassembleAsModifier(IRuntimeInvisibleAnnotationsAttribute iRuntimeInvisibleAnnotationsAttribute, StringBuffer stringBuffer, String string, int n, int n2) {
        IAnnotation[] iAnnotationArray = iRuntimeInvisibleAnnotationsAttribute.getAnnotations();
        int n3 = 0;
        int n4 = iAnnotationArray.length;
        while (n3 < n4) {
            this.disassembleAsModifier(iAnnotationArray[n3], stringBuffer, string, n + 1, n2);
            ++n3;
        }
    }

    private void disassembleAsModifier(IRuntimeVisibleAnnotationsAttribute iRuntimeVisibleAnnotationsAttribute, StringBuffer stringBuffer, String string, int n, int n2) {
        IAnnotation[] iAnnotationArray = iRuntimeVisibleAnnotationsAttribute.getAnnotations();
        int n3 = 0;
        int n4 = iAnnotationArray.length;
        while (n3 < n4) {
            this.disassembleAsModifier(iAnnotationArray[n3], stringBuffer, string, n + 1, n2);
            ++n3;
        }
    }

    private void disassembleTypeMembers(IClassFileReader iClassFileReader, char[] cArray, StringBuffer stringBuffer, String string, int n, int n2, boolean bl) {
        IFieldInfo[] iFieldInfoArray = iClassFileReader.getFieldInfos();
        if (bl && this.checkMode(n2, 16)) {
            int n3;
            int n4 = 0;
            int n5 = iFieldInfoArray.length;
            IMethodInfo[] iMethodInfoArray = iClassFileReader.getMethodInfos();
            char[][] cArray2 = this.getConstructorArgumentsForEnum(iMethodInfoArray);
            while (n4 < n5) {
                IFieldInfo iFieldInfo = iFieldInfoArray[n4];
                n3 = iFieldInfo.getAccessFlags();
                if ((n3 & 0x4000) == 0) break;
                this.writeNewLine(stringBuffer, string, n);
                this.disassembleEnumConstants(iFieldInfoArray[n4], stringBuffer, string, n, cArray2, n2);
                ++n4;
            }
            stringBuffer.append(';');
            boolean bl2 = false;
            while (n4 < n5) {
                if (!bl2 && CharOperation.equals(TypeConstants.SYNTHETIC_ENUM_VALUES, iFieldInfoArray[n4].getName())) {
                    bl2 = true;
                } else {
                    this.writeNewLine(stringBuffer, string, n);
                    this.disassemble(iFieldInfoArray[n4], stringBuffer, string, n, n2);
                }
                ++n4;
            }
            n3 = 0;
            int n6 = iMethodInfoArray.length;
            while (n3 < n6) {
                char[] cArray3;
                IMethodInfo iMethodInfo = iMethodInfoArray[n3];
                if (CharOperation.equals(iMethodInfo.getName(), TypeConstants.VALUES)) {
                    cArray3 = iMethodInfo.getDescriptor();
                    CharOperation.replace(cArray3, '/', '.');
                    if (Signature.getParameterCount(cArray3) == 0 && CharOperation.equals(this.returnClassName(Signature.getReturnType(cArray3), '.', n2), CharOperation.concat(new char[]{'[', 'L'}, cArray, new char[]{';'}))) {
                        // empty if block
                    }
                } else if (CharOperation.equals(iMethodInfo.getName(), TypeConstants.VALUEOF)) {
                    cArray3 = iMethodInfo.getDescriptor();
                    CharOperation.replace(cArray3, '/', '.');
                    char[][] cArray4 = Signature.getParameterTypes(cArray3);
                    if (cArray4.length == 1 && CharOperation.equals(cArray4[0], "Ljava.lang.String;".toCharArray()) && CharOperation.equals(this.returnClassName(Signature.getReturnType(cArray3), '.', n2), CharOperation.concat('L', cArray, ';'))) {
                        // empty if block
                    }
                } else if (!iMethodInfo.isClinit() && !iMethodInfo.isSynthetic()) {
                    if (iMethodInfo.isConstructor()) {
                        this.writeNewLine(stringBuffer, string, n);
                        this.disassembleEnumConstructor(iClassFileReader, cArray, iMethodInfo, stringBuffer, string, n, n2);
                    } else {
                        this.writeNewLine(stringBuffer, string, n);
                        this.disassemble(iClassFileReader, cArray, iMethodInfo, stringBuffer, string, n, n2);
                    }
                }
                ++n3;
            }
        } else {
            int n7 = 0;
            int n8 = iFieldInfoArray.length;
            while (n7 < n8) {
                this.writeNewLine(stringBuffer, string, n);
                this.disassemble(iFieldInfoArray[n7], stringBuffer, string, n, n2);
                ++n7;
            }
            IMethodInfo[] iMethodInfoArray = iClassFileReader.getMethodInfos();
            n8 = 0;
            int n9 = iMethodInfoArray.length;
            while (n8 < n9) {
                this.writeNewLine(stringBuffer, string, n);
                this.disassemble(iClassFileReader, cArray, iMethodInfoArray[n8], stringBuffer, string, n, n2);
                ++n8;
            }
        }
    }

    private char[][] getConstructorArgumentsForEnum(IMethodInfo[] iMethodInfoArray) {
        int n = 0;
        int n2 = iMethodInfoArray.length;
        while (n < n2) {
            char[][] cArray;
            int n3;
            IMethodInfo iMethodInfo = iMethodInfoArray[n];
            if (iMethodInfo.isConstructor() && (n3 = (cArray = Signature.getParameterTypes(iMethodInfo.getDescriptor())).length) >= 2) {
                return CharOperation.subarray(cArray, 2, n3);
            }
            ++n;
        }
        return null;
    }

    private final void dumpTab(int n, StringBuffer stringBuffer) {
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(Messages.disassembler_indentation);
            ++n2;
        }
    }

    private final String dumpNewLineWithTabs(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        this.writeNewLine(stringBuffer, string, n);
        return String.valueOf(stringBuffer);
    }

    public String getDescription() {
        return Messages.disassembler_description;
    }

    private IEnclosingMethodAttribute getEnclosingMethodAttribute(IClassFileReader iClassFileReader) {
        IClassFileAttribute[] iClassFileAttributeArray = iClassFileReader.getAttributes();
        int n = 0;
        int n2 = iClassFileAttributeArray.length;
        while (n < n2) {
            if (CharOperation.equals(iClassFileAttributeArray[n].getAttributeName(), IAttributeNamesConstants.ENCLOSING_METHOD)) {
                return (IEnclosingMethodAttribute)iClassFileAttributeArray[n];
            }
            ++n;
        }
        return null;
    }

    private IClassFileAttribute getAttribute(char[] cArray, ICodeAttribute iCodeAttribute) {
        IClassFileAttribute[] iClassFileAttributeArray = iCodeAttribute.getAttributes();
        int n = 0;
        int n2 = iClassFileAttributeArray.length;
        while (n < n2) {
            if (CharOperation.equals(iClassFileAttributeArray[n].getAttributeName(), cArray)) {
                return iClassFileAttributeArray[n];
            }
            ++n;
        }
        return null;
    }

    private char[][] getParameterNames(char[] cArray, ICodeAttribute iCodeAttribute, int n) {
        int n2 = Signature.getParameterCount(cArray);
        char[][] cArrayArray = new char[n2][];
        if (iCodeAttribute != null) {
            ILocalVariableAttribute iLocalVariableAttribute = iCodeAttribute.getLocalVariableAttribute();
            if (iLocalVariableAttribute != null) {
                ILocalVariableTableEntry[] iLocalVariableTableEntryArray = iLocalVariableAttribute.getLocalVariableTable();
                int n3 = (n & 8) != 0 ? 0 : 1;
                int n4 = 0;
                while (n4 < n2) {
                    ILocalVariableTableEntry iLocalVariableTableEntry = this.getEntryFor(this.getLocalIndex(n3, n4, cArray), iLocalVariableTableEntryArray);
                    cArrayArray[n4] = iLocalVariableTableEntry != null ? iLocalVariableTableEntry.getName() : CharOperation.concat(Messages.disassembler_parametername.toCharArray(), Integer.toString(n4).toCharArray());
                    ++n4;
                }
            } else {
                int n5 = 0;
                while (n5 < n2) {
                    cArrayArray[n5] = CharOperation.concat(Messages.disassembler_parametername.toCharArray(), Integer.toString(n5).toCharArray());
                    ++n5;
                }
            }
        } else {
            int n6 = 0;
            while (n6 < n2) {
                cArrayArray[n6] = CharOperation.concat(Messages.disassembler_parametername.toCharArray(), Integer.toString(n6).toCharArray());
                ++n6;
            }
        }
        return cArrayArray;
    }

    private int getLocalIndex(int n, int n2, char[] cArray) {
        int n3 = n;
        char[][] cArray2 = Signature.getParameterTypes(cArray);
        int n4 = 0;
        while (n4 < n2) {
            char[] cArray3 = cArray2[n4];
            block0 : switch (cArray3.length) {
                case 1: {
                    switch (cArray3[0]) {
                        case 'D': 
                        case 'J': {
                            n3 += 2;
                            break block0;
                        }
                    }
                    ++n3;
                    break;
                }
                default: {
                    ++n3;
                }
            }
            ++n4;
        }
        return n3;
    }

    private ILocalVariableTableEntry getEntryFor(int n, ILocalVariableTableEntry[] iLocalVariableTableEntryArray) {
        int n2 = 0;
        int n3 = iLocalVariableTableEntryArray.length;
        while (n2 < n3) {
            ILocalVariableTableEntry iLocalVariableTableEntry = iLocalVariableTableEntryArray[n2];
            if (n == iLocalVariableTableEntry.getIndex()) {
                return iLocalVariableTableEntry;
            }
            ++n2;
        }
        return null;
    }

    private char[] getSignatureForField(char[] cArray) {
        char[] cArray2 = CharOperation.replaceOnCopy(cArray, '/', '.');
        cArray2 = CharOperation.replaceOnCopy(cArray2, '$', '%');
        char[] cArray3 = Signature.toCharArray(cArray2);
        CharOperation.replace(cArray3, '%', '$');
        return cArray3;
    }

    private boolean isDeprecated(IClassFileReader iClassFileReader) {
        IClassFileAttribute[] iClassFileAttributeArray = iClassFileReader.getAttributes();
        int n = 0;
        int n2 = iClassFileAttributeArray.length;
        while (n < n2) {
            if (CharOperation.equals(iClassFileAttributeArray[n].getAttributeName(), IAttributeNamesConstants.DEPRECATED)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isSynthetic(IClassFileReader iClassFileReader) {
        int n = iClassFileReader.getAccessFlags();
        if ((n & 0x1000) != 0) {
            return true;
        }
        IClassFileAttribute[] iClassFileAttributeArray = iClassFileReader.getAttributes();
        int n2 = 0;
        int n3 = iClassFileAttributeArray.length;
        while (n2 < n3) {
            if (CharOperation.equals(iClassFileAttributeArray[n2].getAttributeName(), IAttributeNamesConstants.SYNTHETIC)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean checkMode(int n, int n2) {
        return (n & n2) != 0;
    }

    private boolean isCompact(int n) {
        return (n & 8) != 0;
    }

    private char[] returnClassName(char[] cArray, char c, int n) {
        int n2;
        if (cArray.length == 0) {
            return CharOperation.NO_CHAR;
        }
        if (this.isCompact(n) && (n2 = CharOperation.lastIndexOf(c, cArray)) != -1) {
            return CharOperation.subarray(cArray, n2 + 1, cArray.length);
        }
        return cArray;
    }

    private void writeNewLine(StringBuffer stringBuffer, String string, int n) {
        stringBuffer.append(string);
        this.dumpTab(n, stringBuffer);
    }
}

