/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import org.eclipse.wst.jsdt.core.util.ClassFormatException;
import org.eclipse.wst.jsdt.core.util.IConstantPool;
import org.eclipse.wst.jsdt.core.util.IConstantPoolEntry;
import org.eclipse.wst.jsdt.core.util.IEnclosingMethodAttribute;
import org.eclipse.wst.jsdt.internal.core.util.ClassFileAttribute;

public class EnclosingMethodAttribute
extends ClassFileAttribute
implements IEnclosingMethodAttribute {
    private int enclosingClassIndex;
    private char[] enclosingClassName;
    private int methodDescriptorIndex;
    private char[] methodDescriptor;
    private int methodNameIndex;
    private char[] methodName;
    private int methodNameAndTypeIndex;

    EnclosingMethodAttribute(byte[] byArray, IConstantPool iConstantPool, int n) throws ClassFormatException {
        super(byArray, iConstantPool, n);
        int n2;
        this.enclosingClassIndex = n2 = this.u2At(byArray, 6, n);
        IConstantPoolEntry iConstantPoolEntry = iConstantPool.decodeEntry(n2);
        if (iConstantPoolEntry.getKind() != 7) {
            throw new ClassFormatException(3);
        }
        this.enclosingClassName = iConstantPoolEntry.getClassInfoName();
        this.methodNameAndTypeIndex = this.u2At(byArray, 8, n);
        if (this.methodNameAndTypeIndex != 0) {
            iConstantPoolEntry = iConstantPool.decodeEntry(this.methodNameAndTypeIndex);
            if (iConstantPoolEntry.getKind() != 12) {
                throw new ClassFormatException(3);
            }
            this.methodDescriptorIndex = iConstantPoolEntry.getNameAndTypeInfoDescriptorIndex();
            this.methodNameIndex = iConstantPoolEntry.getNameAndTypeInfoNameIndex();
            iConstantPoolEntry = iConstantPool.decodeEntry(this.methodDescriptorIndex);
            if (iConstantPoolEntry.getKind() != 1) {
                throw new ClassFormatException(3);
            }
            this.methodDescriptor = iConstantPoolEntry.getUtf8Value();
            iConstantPoolEntry = iConstantPool.decodeEntry(this.methodNameIndex);
            if (iConstantPoolEntry.getKind() != 1) {
                throw new ClassFormatException(3);
            }
            this.methodName = iConstantPoolEntry.getUtf8Value();
        }
    }

    public char[] getEnclosingClass() {
        return this.enclosingClassName;
    }

    public int getEnclosingClassIndex() {
        return this.enclosingClassIndex;
    }

    public char[] getMethodDescriptor() {
        return this.methodDescriptor;
    }

    public int getMethodDescriptorIndex() {
        return this.methodDescriptorIndex;
    }

    public char[] getMethodName() {
        return this.methodName;
    }

    public int getMethodNameIndex() {
        return this.methodNameIndex;
    }

    public int getMethodNameAndTypeIndex() {
        return this.methodNameAndTypeIndex;
    }
}

