/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import org.eclipse.wst.jsdt.core.util.ClassFormatException;
import org.eclipse.wst.jsdt.core.util.IAttributeNamesConstants;
import org.eclipse.wst.jsdt.core.util.IClassFileAttribute;
import org.eclipse.wst.jsdt.core.util.IConstantPool;
import org.eclipse.wst.jsdt.core.util.IConstantPoolEntry;
import org.eclipse.wst.jsdt.core.util.IConstantValueAttribute;
import org.eclipse.wst.jsdt.core.util.IFieldInfo;
import org.eclipse.wst.jsdt.internal.core.util.ClassFileAttribute;
import org.eclipse.wst.jsdt.internal.core.util.ClassFileStruct;
import org.eclipse.wst.jsdt.internal.core.util.ConstantValueAttribute;
import org.eclipse.wst.jsdt.internal.core.util.RuntimeInvisibleAnnotationsAttribute;
import org.eclipse.wst.jsdt.internal.core.util.RuntimeVisibleAnnotationsAttribute;
import org.eclipse.wst.jsdt.internal.core.util.SignatureAttribute;

public class FieldInfo
extends ClassFileStruct
implements IFieldInfo {
    private int accessFlags;
    private int attributeBytes;
    private IClassFileAttribute[] attributes;
    private int attributesCount;
    private IConstantValueAttribute constantValueAttribute;
    private char[] descriptor;
    private int descriptorIndex;
    private boolean isDeprecated;
    private boolean isSynthetic;
    private char[] name;
    private int nameIndex;

    public FieldInfo(byte[] byArray, IConstantPool iConstantPool, int n) throws ClassFormatException {
        int n2;
        this.accessFlags = n2 = this.u2At(byArray, 0, n);
        if ((n2 & 0x1000) != 0) {
            this.isSynthetic = true;
        }
        this.nameIndex = this.u2At(byArray, 2, n);
        IConstantPoolEntry iConstantPoolEntry = iConstantPool.decodeEntry(this.nameIndex);
        if (iConstantPoolEntry.getKind() != 1) {
            throw new ClassFormatException(3);
        }
        this.name = iConstantPoolEntry.getUtf8Value();
        this.descriptorIndex = this.u2At(byArray, 4, n);
        iConstantPoolEntry = iConstantPool.decodeEntry(this.descriptorIndex);
        if (iConstantPoolEntry.getKind() != 1) {
            throw new ClassFormatException(3);
        }
        this.descriptor = iConstantPoolEntry.getUtf8Value();
        this.attributesCount = this.u2At(byArray, 6, n);
        this.attributes = ClassFileAttribute.NO_ATTRIBUTES;
        int n3 = 8;
        if (this.attributesCount != 0) {
            this.attributes = new IClassFileAttribute[this.attributesCount];
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.attributesCount) {
            iConstantPoolEntry = iConstantPool.decodeEntry(this.u2At(byArray, n3, n));
            if (iConstantPoolEntry.getKind() != 1) {
                throw new ClassFormatException(3);
            }
            char[] cArray = iConstantPoolEntry.getUtf8Value();
            if (this.equals(cArray, IAttributeNamesConstants.DEPRECATED)) {
                this.isDeprecated = true;
                this.attributes[n4++] = new ClassFileAttribute(byArray, iConstantPool, n + n3);
            } else if (this.equals(cArray, IAttributeNamesConstants.SYNTHETIC)) {
                this.isSynthetic = true;
                this.attributes[n4++] = new ClassFileAttribute(byArray, iConstantPool, n + n3);
            } else if (this.equals(cArray, IAttributeNamesConstants.CONSTANT_VALUE)) {
                this.constantValueAttribute = new ConstantValueAttribute(byArray, iConstantPool, n + n3);
                this.attributes[n4++] = this.constantValueAttribute;
            } else {
                this.attributes[n4++] = this.equals(cArray, IAttributeNamesConstants.SIGNATURE) ? new SignatureAttribute(byArray, iConstantPool, n + n3) : (this.equals(cArray, IAttributeNamesConstants.RUNTIME_VISIBLE_ANNOTATIONS) ? new RuntimeVisibleAnnotationsAttribute(byArray, iConstantPool, n + n3) : (this.equals(cArray, IAttributeNamesConstants.RUNTIME_INVISIBLE_ANNOTATIONS) ? new RuntimeInvisibleAnnotationsAttribute(byArray, iConstantPool, n + n3) : new ClassFileAttribute(byArray, iConstantPool, n + n3)));
            }
            n3 = (int)((long)n3 + (6L + this.u4At(byArray, n3 + 2, n)));
            ++n5;
        }
        this.attributeBytes = n3;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public int getAttributeCount() {
        return this.attributesCount;
    }

    public IClassFileAttribute[] getAttributes() {
        return this.attributes;
    }

    public IConstantValueAttribute getConstantValueAttribute() {
        return this.constantValueAttribute;
    }

    public char[] getDescriptor() {
        return this.descriptor;
    }

    public int getDescriptorIndex() {
        return this.descriptorIndex;
    }

    public char[] getName() {
        return this.name;
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public boolean hasConstantValueAttribute() {
        return this.constantValueAttribute != null;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    int sizeInBytes() {
        return this.attributeBytes;
    }
}

