/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import org.eclipse.wst.jsdt.internal.core.util.Util;

public final class HashSetOfArray
implements Cloneable {
    public Object[][] set;
    public int elementSize = 0;
    int threshold;

    public HashSetOfArray() {
        this(13);
    }

    public HashSetOfArray(int n) {
        this.threshold = n;
        int n2 = (int)((float)n * 1.75f);
        if (this.threshold == n2) {
            ++n2;
        }
        this.set = new Object[n2][];
    }

    public Object clone() throws CloneNotSupportedException {
        HashSetOfArray hashSetOfArray = (HashSetOfArray)super.clone();
        hashSetOfArray.elementSize = this.elementSize;
        hashSetOfArray.threshold = this.threshold;
        int n = this.set.length;
        hashSetOfArray.set = new Object[n][];
        System.arraycopy(this.set, 0, hashSetOfArray.set, 0, n);
        return hashSetOfArray;
    }

    public boolean contains(Object[] objectArray) {
        Object[] objectArray2;
        int n = this.set.length;
        int n2 = this.hashCode(objectArray) % n;
        int n3 = objectArray.length;
        while ((objectArray2 = this.set[n2]) != null) {
            if (objectArray2.length == n3 && Util.equalArraysOrNull(objectArray2, objectArray)) {
                return true;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return false;
    }

    private int hashCode(Object[] objectArray) {
        return this.hashCode(objectArray, objectArray.length);
    }

    private int hashCode(Object[] objectArray, int n) {
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            n2 = Util.combineHashCodes(n2, objectArray[n3].hashCode());
            --n3;
        }
        return n2 & Integer.MAX_VALUE;
    }

    public Object add(Object[] objectArray) {
        Object[] objectArray2;
        int n = this.set.length;
        int n2 = this.hashCode(objectArray) % n;
        int n3 = objectArray.length;
        while ((objectArray2 = this.set[n2]) != null) {
            if (objectArray2.length == n3 && Util.equalArraysOrNull(objectArray2, objectArray)) {
                this.set[n2] = objectArray;
                return objectArray;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        this.set[n2] = objectArray;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return objectArray;
    }

    public Object remove(Object[] objectArray) {
        Object[] objectArray2;
        int n = this.set.length;
        int n2 = this.hashCode(objectArray) % n;
        int n3 = objectArray.length;
        while ((objectArray2 = this.set[n2]) != null) {
            if (objectArray2.length == n3 && Util.equalArraysOrNull(objectArray2, objectArray)) {
                Object[] objectArray3 = this.set[n2];
                --this.elementSize;
                this.set[n2] = null;
                this.rehash();
                return objectArray3;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return null;
    }

    private void rehash() {
        HashSetOfArray hashSetOfArray = new HashSetOfArray(this.elementSize * 2);
        int n = this.set.length;
        while (--n >= 0) {
            Object[] objectArray = this.set[n];
            if (objectArray == null) continue;
            hashSetOfArray.add(objectArray);
        }
        this.set = hashSetOfArray.set;
        this.threshold = hashSetOfArray.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = this.set.length;
        while (n < n2) {
            Object[] objectArray = this.set[n];
            if (objectArray != null) {
                stringBuffer.append('{');
                int n3 = 0;
                int n4 = objectArray.length;
                while (n3 < n4) {
                    stringBuffer.append(objectArray[n3]);
                    if (n3 != n4 - 1) {
                        stringBuffer.append(", ");
                    }
                    ++n3;
                }
                stringBuffer.append("}");
                if (n != n2 - 1) {
                    stringBuffer.append('\n');
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

