/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

public class WeakHashSet {
    HashableWeakReference[] values;
    public int elementSize = 0;
    int threshold;
    ReferenceQueue referenceQueue = new ReferenceQueue();

    public WeakHashSet() {
        this(5);
    }

    public WeakHashSet(int n) {
        this.threshold = n;
        int n2 = (int)((float)n * 1.75f);
        if (this.threshold == n2) {
            ++n2;
        }
        this.values = new HashableWeakReference[n2];
    }

    public Object add(Object object) {
        HashableWeakReference hashableWeakReference;
        this.cleanupGarbageCollectedValues();
        int n = this.values.length;
        int n2 = (object.hashCode() & Integer.MAX_VALUE) % n;
        while ((hashableWeakReference = this.values[n2]) != null) {
            Object t = hashableWeakReference.get();
            if (object.equals(t)) {
                return t;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        this.values[n2] = new HashableWeakReference(object, this.referenceQueue);
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return object;
    }

    private void addValue(HashableWeakReference hashableWeakReference) {
        HashableWeakReference hashableWeakReference2;
        Object t = hashableWeakReference.get();
        if (t == null) {
            return;
        }
        int n = this.values.length;
        int n2 = (hashableWeakReference.hashCode & Integer.MAX_VALUE) % n;
        while ((hashableWeakReference2 = this.values[n2]) != null) {
            if (t.equals(hashableWeakReference2.get())) {
                return;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        this.values[n2] = hashableWeakReference;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
    }

    private void cleanupGarbageCollectedValues() {
        HashableWeakReference hashableWeakReference;
        block0: while ((hashableWeakReference = (HashableWeakReference)this.referenceQueue.poll()) != null) {
            HashableWeakReference hashableWeakReference2;
            int n = hashableWeakReference.hashCode;
            int n2 = this.values.length;
            int n3 = (n & Integer.MAX_VALUE) % n2;
            while ((hashableWeakReference2 = this.values[n3]) != null) {
                if (hashableWeakReference2 == hashableWeakReference) {
                    int n4;
                    int n5 = n3;
                    while ((hashableWeakReference2 = this.values[n4 = (n5 + 1) % n2]) != null && hashableWeakReference2.hashCode == n) {
                        n5 = n4;
                    }
                    this.values[n3] = this.values[n5];
                    this.values[n5] = null;
                    --this.elementSize;
                    continue block0;
                }
                if (++n3 != n2) continue;
                n3 = 0;
            }
        }
    }

    public boolean contains(Object object) {
        return this.get(object) != null;
    }

    public Object get(Object object) {
        HashableWeakReference hashableWeakReference;
        this.cleanupGarbageCollectedValues();
        int n = this.values.length;
        int n2 = (object.hashCode() & Integer.MAX_VALUE) % n;
        while ((hashableWeakReference = this.values[n2]) != null) {
            Object t = hashableWeakReference.get();
            if (object.equals(t)) {
                return t;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return null;
    }

    private void rehash() {
        WeakHashSet weakHashSet = new WeakHashSet(this.elementSize * 2);
        weakHashSet.referenceQueue = this.referenceQueue;
        int n = 0;
        int n2 = this.values.length;
        while (n < n2) {
            HashableWeakReference hashableWeakReference = this.values[n];
            if (hashableWeakReference != null) {
                weakHashSet.addValue(hashableWeakReference);
            }
            ++n;
        }
        this.values = weakHashSet.values;
        this.threshold = weakHashSet.threshold;
        this.elementSize = weakHashSet.elementSize;
    }

    public Object remove(Object object) {
        HashableWeakReference hashableWeakReference;
        this.cleanupGarbageCollectedValues();
        int n = this.values.length;
        int n2 = (object.hashCode() & Integer.MAX_VALUE) % n;
        while ((hashableWeakReference = this.values[n2]) != null) {
            Object t = hashableWeakReference.get();
            if (object.equals(t)) {
                --this.elementSize;
                this.values[n2] = null;
                this.rehash();
                return t;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return null;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        int n = 0;
        int n2 = this.values.length;
        while (n < n2) {
            Object t;
            HashableWeakReference hashableWeakReference = this.values[n];
            if (hashableWeakReference != null && (t = hashableWeakReference.get()) != null) {
                stringBuffer.append(t.toString());
                stringBuffer.append(", ");
            }
            ++n;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static class HashableWeakReference
    extends WeakReference {
        public int hashCode;

        public HashableWeakReference(Object object, ReferenceQueue referenceQueue) {
            super(object, referenceQueue);
            this.hashCode = object.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof HashableWeakReference)) {
                return false;
            }
            Object t = this.get();
            Object t2 = ((HashableWeakReference)object).get();
            if (t == null) {
                return t2 == null;
            }
            return t.equals(t2);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            Object t = this.get();
            if (t == null) {
                return "[hashCode=" + this.hashCode + "] <referent was garbage collected>";
            }
            return "[hashCode=" + this.hashCode + "] " + t.toString();
        }
    }
}

