/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.javascript.ui.internal.common.taginfo;

import org.eclipse.wst.xml.core.internal.contentmodel.annotation.AnnotationMap;

public class JavaScriptTagInfoProvider {
    public static final String JSAnnotationURI = "data/jsref.xml";
    protected static final char chEndBracket = ']';
    protected static final char chEndBrace = ')';
    protected static final char chBeginBracket = '[';
    protected static final char chBeginBrace = '(';
    protected static final char chPeriod = '.';
    protected static AnnotationMap fAnnotationMap = null;
    protected String fErrorMessage = null;

    public void setErrorMessage(String errorMessage) {
        this.fErrorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public AnnotationMap getAnnotationMap() {
        if (fAnnotationMap == null) {
            fAnnotationMap = new AnnotationMap();
            try {
                fAnnotationMap.load(JSAnnotationURI, "org.eclipse.wst.javascript.ui");
            }
            catch (Exception exception) {}
        }
        return fAnnotationMap;
    }

    public String getTagInfo(String spec) {
        int pathLength;
        if (spec == null || spec.length() == 0) {
            return null;
        }
        String result = null;
        String prevResult = null;
        int currPos = pathLength = spec.length();
        do {
            try {
                currPos = this.getParentPos(spec, currPos);
                String currString = spec.substring(currPos);
                prevResult = result;
                result = this.getAnnotationMap().getProperty(currString, "tagInfo");
                currPos -= 2;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        } while (result != null && currPos > 0);
        if (prevResult == null && result != null) {
            return result;
        }
        return prevResult;
    }

    protected int strPreviousPos(String estring, int sidx, char ch1, char ch2) {
        int idx11 = estring.lastIndexOf(ch1, sidx);
        int idx12 = estring.lastIndexOf(ch2, sidx);
        int idx1 = idx11 == -1 ? idx12 : (idx12 == -1 ? idx11 : (idx11 > idx12 ? idx11 : idx12));
        return idx1;
    }

    protected int getParentPos(String str, int endPos) {
        int idx4;
        int idx2;
        if (str == null || str.length() == 0 || endPos > str.length()) {
            return -1;
        }
        int idx1 = str.lastIndexOf(46, endPos);
        int idx3 = idx2 = endPos;
        do {
            idx2 = this.strPreviousPos(str, idx3, ')', ']');
            idx3 = this.strPreviousPos(str, idx2, '(', '[');
        } while (idx2 != -1 && idx3 != -1 && idx2 - 1 == idx3);
        int n = idx2 == -1 ? idx3 : (idx3 == -1 ? idx2 : (idx4 = idx2 > idx3 ? idx2 : idx3));
        int pos = idx1 == -1 ? idx4 : (idx4 == -1 ? idx1 : (idx1 > idx4 ? idx1 : idx4));
        return ++pos;
    }

    public void release() {
        fAnnotationMap = null;
    }
}

