/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.internal.java.refactoring;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.search.SearchDocument;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.web.core.internal.java.search.JSDTSearchDocumentDelegate;
import org.eclipse.wst.jsdt.web.core.internal.java.search.JsSearchSupport;
import org.eclipse.wst.jsdt.web.ui.internal.JsUIMessages;
import org.eclipse.wst.jsdt.web.ui.internal.Logger;
import org.eclipse.wst.sse.core.internal.document.DocumentReader;
import org.eclipse.wst.sse.core.internal.encoding.CodedStreamCreator;

public class BasicRefactorSearchRequestor
extends SearchRequestor {
    IJavaElement fElement = null;
    private String fNewName = "";
    private HashMap fSearchDocPath2JavaEditMap = null;
    static /* synthetic */ Class class$0;

    public BasicRefactorSearchRequestor(IJavaElement iJavaElement, String string) {
        this.fNewName = string;
        this.fElement = iJavaElement;
        this.fSearchDocPath2JavaEditMap = new HashMap();
    }

    public void acceptSearchMatch(SearchMatch searchMatch) throws CoreException {
        String string = searchMatch.getResource().getFullPath().toString();
        SearchDocument searchDocument = JsSearchSupport.getInstance().getSearchDocument(string);
        if (searchDocument != null && searchDocument instanceof JSDTSearchDocumentDelegate) {
            String string2 = this.getRenameText((JSDTSearchDocumentDelegate)searchDocument, searchMatch);
            this.addJavaEdit(searchDocument.getPath(), new ReplaceEdit(searchMatch.getOffset(), searchMatch.getLength(), string2));
        }
    }

    private void addJavaEdit(String string, ReplaceEdit replaceEdit) {
        Object v = this.fSearchDocPath2JavaEditMap.get(string);
        if (v != null) {
            MultiTextEdit multiTextEdit = (MultiTextEdit)v;
            multiTextEdit.addChild((TextEdit)replaceEdit);
        } else {
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            multiTextEdit.addChild((TextEdit)replaceEdit);
            this.fSearchDocPath2JavaEditMap.put(string, multiTextEdit);
        }
    }

    private Change createChange(JSDTSearchDocumentDelegate jSDTSearchDocumentDelegate, TextEdit textEdit) {
        IDocument iDocument = jSDTSearchDocumentDelegate.getJspTranslation().getHtmlDocument();
        String string = jSDTSearchDocumentDelegate.getFile().getName();
        String string2 = this.getDescription();
        try {
            String string3 = Integer.toString(iDocument.getLineOfOffset(textEdit.getOffset()) + 1);
            string2 = String.valueOf(string2) + " " + NLS.bind((String)JsUIMessages.BasicRefactorSearchRequestor_1, (Object[])new String[]{string, string3});
        }
        catch (BadLocationException badLocationException) {
            Logger.logException(badLocationException);
        }
        return new RenameChange(jSDTSearchDocumentDelegate.getFile(), iDocument, textEdit, string2);
    }

    public Change[] getChanges() {
        JsSearchSupport jsSearchSupport = JsSearchSupport.getInstance();
        ArrayList<Change> arrayList = new ArrayList<Change>();
        Iterator iterator = this.fSearchDocPath2JavaEditMap.keySet().iterator();
        String string = null;
        SearchDocument searchDocument = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            MultiTextEdit multiTextEdit = (MultiTextEdit)this.fSearchDocPath2JavaEditMap.get(string);
            searchDocument = jsSearchSupport.getSearchDocument(string);
            if (searchDocument == null || !(searchDocument instanceof JSDTSearchDocumentDelegate)) continue;
            JSDTSearchDocumentDelegate jSDTSearchDocumentDelegate = (JSDTSearchDocumentDelegate)searchDocument;
            arrayList.add(this.createChange(jSDTSearchDocumentDelegate, (TextEdit)multiTextEdit));
        }
        return arrayList.toArray(new Change[arrayList.size()]);
    }

    protected String getDescription() {
        return "";
    }

    public IJavaElement getElement() {
        return this.fElement;
    }

    public String getNewName() {
        return this.fNewName;
    }

    protected String getRenameText(JSDTSearchDocumentDelegate jSDTSearchDocumentDelegate, SearchMatch searchMatch) {
        return this.getNewName();
    }

    private class RenameChange
    extends DocumentChange {
        private String fDescription = JsUIMessages.BasicRefactorSearchRequestor_0;
        private TextEdit fEdit = null;
        private IDocument fJSPDoc = null;
        private IFile fJSPFile = null;

        public RenameChange(IFile iFile, IDocument iDocument, TextEdit textEdit, String string) {
            super(JsUIMessages.BasicRefactorSearchRequestor_6, iDocument);
            this.fEdit = textEdit;
            this.fJSPFile = iFile;
            this.fJSPDoc = iDocument;
            this.fDescription = string;
        }

        public Object getModifiedElement() {
            return BasicRefactorSearchRequestor.this.getElement();
        }

        public String getName() {
            return this.fDescription;
        }

        public IDocument getPreviewDocument(IProgressMonitor iProgressMonitor) throws CoreException {
            Document document = new Document(this.fJSPDoc.get());
            try {
                this.fEdit.apply((IDocument)document);
            }
            catch (MalformedTreeException malformedTreeException) {
            }
            catch (BadLocationException badLocationException) {}
            return document;
        }

        private boolean isOpenInEditor(IDocument iDocument) {
            IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
            IWorkbenchWindow iWorkbenchWindow = null;
            int n = 0;
            while (n < iWorkbenchWindowArray.length) {
                iWorkbenchWindow = iWorkbenchWindowArray[n];
                IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                if (iWorkbenchPage != null) {
                    IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
                    IEditorPart iEditorPart = null;
                    Object object = null;
                    IDocument iDocument2 = null;
                    int n2 = 0;
                    while (n2 < iEditorReferenceArray.length) {
                        iEditorPart = iEditorReferenceArray[n2].getEditor(true);
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((object = iEditorPart.getAdapter((Class)clazz)) != null && object instanceof ITextEditor && (iDocument2 = ((ITextEditor)object).getDocumentProvider().getDocument((Object)iEditorPart.getEditorInput())) != null && iDocument2.equals(iDocument)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            return false;
        }

        public RefactoringStatus isValid(IProgressMonitor iProgressMonitor) throws CoreException {
            return new RefactoringStatus();
        }

        public Change perform(IProgressMonitor iProgressMonitor) throws CoreException {
            RenameChange renameChange = null;
            try {
                if (!this.isOpenInEditor(this.fJSPDoc)) {
                    renameChange = new RenameChange(this.fJSPFile, this.fJSPDoc, (TextEdit)this.fEdit.apply(this.fJSPDoc), this.fDescription);
                    this.saveFile(this.fJSPFile, this.fJSPDoc);
                } else {
                    renameChange = new RenameChange(this.fJSPFile, this.fJSPDoc, (TextEdit)this.fEdit.apply(this.fJSPDoc), this.fDescription);
                }
            }
            catch (MalformedTreeException malformedTreeException) {
                Logger.logException(malformedTreeException);
            }
            catch (BadLocationException badLocationException) {
                Logger.logException(badLocationException);
            }
            return renameChange;
        }

        private void saveFile(IFile iFile, IDocument iDocument) {
            SaveJspFileOp saveJspFileOp = new SaveJspFileOp(iFile, iDocument);
            try {
                saveJspFileOp.run(JsSearchSupport.getInstance().getProgressMonitor());
            }
            catch (InvocationTargetException invocationTargetException) {
                Logger.logException(invocationTargetException);
            }
            catch (InterruptedException interruptedException) {
                Logger.logException(interruptedException);
            }
        }
    }

    private class SaveJspFileOp
    extends WorkspaceModifyOperation {
        private IDocument fJSPDoc = null;
        private IFile fJSPFile = null;

        public SaveJspFileOp(IFile iFile, IDocument iDocument) {
            this.fJSPDoc = iDocument;
            this.fJSPFile = iFile;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void execute(IProgressMonitor iProgressMonitor) throws CoreException, InvocationTargetException, InterruptedException {
            CodedStreamCreator codedStreamCreator = new CodedStreamCreator();
            DocumentReader documentReader = new DocumentReader(this.fJSPDoc);
            codedStreamCreator.set(this.fJSPFile, (Reader)documentReader);
            ByteArrayOutputStream byteArrayOutputStream = null;
            ByteArrayInputStream byteArrayInputStream = null;
            try {
                block12: {
                    try {
                        byteArrayOutputStream = codedStreamCreator.getCodedByteArrayOutputStream();
                        byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                        if (this.fJSPFile.exists()) {
                            this.fJSPFile.setContents((InputStream)byteArrayInputStream, true, true, null);
                            break block12;
                        }
                        this.fJSPFile.create((InputStream)byteArrayInputStream, false, null);
                    }
                    catch (CoreException coreException) {
                        Logger.logException(coreException);
                    }
                    catch (IOException iOException) {
                        Logger.logException(iOException);
                    }
                }
                Object var7_10 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (byteArrayOutputStream != null) {
                        byteArrayOutputStream.close();
                    }
                    if (byteArrayInputStream == null) throw throwable;
                    ((InputStream)byteArrayInputStream).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {
                return;
            }
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
            if (byteArrayInputStream == null) return;
            ((InputStream)byteArrayInputStream).close();
        }
    }
}

