/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.internal.java.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.jsdt.core.search.SearchDocument;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.web.core.internal.java.JsTranslation;
import org.eclipse.wst.jsdt.web.core.internal.java.search.JSDTSearchDocumentDelegate;
import org.eclipse.wst.jsdt.web.core.internal.java.search.JsSearchSupport;

public class BasicJsSearchRequestor
extends SearchRequestor {
    private static final boolean DEBUG;

    static {
        String string = Platform.getDebugOption((String)"org.eclipse.wst.jsdt.web.core/debug/jspsearch");
        DEBUG = string != null && string.equalsIgnoreCase("true");
    }

    public void acceptSearchMatch(SearchMatch searchMatch) throws CoreException {
        if (JsSearchSupport.getInstance().isCanceled()) {
            return;
        }
        String string = searchMatch.getResource().getFullPath().toString();
        SearchDocument searchDocument = JsSearchSupport.getInstance().getSearchDocument(string);
        if (searchDocument != null && searchDocument instanceof JSDTSearchDocumentDelegate) {
            JSDTSearchDocumentDelegate jSDTSearchDocumentDelegate = (JSDTSearchDocumentDelegate)searchDocument;
            int n = searchMatch.getOffset();
            int n2 = searchMatch.getOffset() + searchMatch.getLength();
            JsTranslation jsTranslation = jSDTSearchDocumentDelegate.getJspTranslation();
            String string2 = jsTranslation.getHtmlText();
            String string3 = jSDTSearchDocumentDelegate.getJavaText();
            if (DEBUG) {
                this.displayDebugInfo(searchMatch, n, n2, string2, string3);
            }
            if (n > -1 && n2 > -1) {
                this.addSearchMatch((IDocument)new Document(jsTranslation.getHtmlText()), jSDTSearchDocumentDelegate.getFile(), n, n2, string2);
            }
        }
    }

    protected void addSearchMatch(IDocument iDocument, IFile iFile, int n, int n2, String string) {
    }

    public void beginReporting() {
        if (DEBUG) {
            System.out.println("JSP Search requestor: beginReporting()");
        }
    }

    private void displayDebugInfo(SearchMatch searchMatch, int n, int n2, String string, String string2) {
        if (searchMatch == null || n == -1 || n2 == -1 || n2 < n || string == null || string2 == null) {
            return;
        }
        System.out.println("+-----------------------------------------+");
        System.out.println("accept possible match [jspDoc: " + searchMatch.getResource().getFullPath().toOSString() + " " + searchMatch.getOffset() + ":" + searchMatch.getOffset() + searchMatch.getLength() + "]?");
        System.out.println("match info:");
        System.out.println("the java text is:" + string2.substring(searchMatch.getOffset(), searchMatch.getOffset() + searchMatch.getLength()));
        System.out.println("java search match translates to jsp coords [start: " + n + " end:" + n2 + "]");
        System.out.println(" the jsp text is:" + string.substring(n, n2));
    }

    public void endReporting() {
        if (DEBUG) {
            System.out.println("JSP Search requestor: endReporting()");
        }
    }

    public void enterParticipant(SearchParticipant searchParticipant) {
        if (DEBUG) {
            System.out.println("JSP Search requestor: enterParticipant()");
        }
    }

    public void exitParticipant(SearchParticipant searchParticipant) {
        if (DEBUG) {
            System.out.println("JSP Search requestor: exitParticipant()");
        }
    }
}

