/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.internal.java.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchDocument;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.web.core.internal.java.search.JsSearchScope;
import org.eclipse.wst.jsdt.web.core.internal.java.search.JsSearchSupport;
import org.eclipse.wst.jsdt.web.ui.internal.JsUIMessages;
import org.eclipse.wst.jsdt.web.ui.internal.java.search.JsOccurrencesSearchResult;
import org.eclipse.wst.jsdt.web.ui.internal.java.search.JsSingleFileSearchRequestor;
import org.eclipse.wst.sse.ui.internal.search.BasicSearchQuery;

public class JsSearchQuery
extends BasicSearchQuery {
    private IJavaElement fElement = null;

    public JsSearchQuery(IFile iFile, IJavaElement iJavaElement) {
        super(iFile);
        this.fElement = iJavaElement;
    }

    public boolean canRerun() {
        return false;
    }

    public boolean canRunInBackground() {
        return true;
    }

    protected IStatus doQuery() {
        this.clearMatches();
        IStatus iStatus = Status.OK_STATUS;
        try {
            JsSearchSupport jsSearchSupport = JsSearchSupport.getInstance();
            SearchDocument searchDocument = jsSearchSupport.addJspFile(this.getFile());
            String string = searchDocument.getPath();
            JsSearchScope jsSearchScope = new JsSearchScope(new String[]{this.getFile().getFullPath().toString(), string});
            jsSearchSupport.searchRunnable(this.getJavaElement(), (IJavaSearchScope)jsSearchScope, (SearchRequestor)new JsSingleFileSearchRequestor(this.getInstance()));
        }
        catch (Exception exception) {
            iStatus = new Status(4, "org.eclipse.wst.sse.ui", 0, "", null);
        }
        return iStatus;
    }

    private String getFilename() {
        String string = JsUIMessages.OccurrencesSearchQuery_2;
        if (this.getFile() != null) {
            string = this.getFile().getName();
        }
        return string;
    }

    public JsSearchQuery getInstance() {
        return this;
    }

    public IJavaElement getJavaElement() {
        return this.fElement;
    }

    public String getLabel() {
        Object[] objectArray = new String[]{this.getSearchText(), this.getOccurrencesCountText(), this.getFilename()};
        return NLS.bind((String)JsUIMessages.OccurrencesSearchQuery_0, (Object[])objectArray);
    }

    private String getOccurrencesCountText() {
        String string = "";
        return string;
    }

    public ISearchResult getSearchResult() {
        return new JsOccurrencesSearchResult((ISearchQuery)this);
    }

    protected String getSearchText() {
        return this.fElement.getElementName();
    }
}

