/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.internal.java.search.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.ui.search.ElementQuerySpecification;
import org.eclipse.wst.jsdt.ui.search.IMatchPresentation;
import org.eclipse.wst.jsdt.ui.search.IQueryParticipant;
import org.eclipse.wst.jsdt.ui.search.ISearchRequestor;
import org.eclipse.wst.jsdt.ui.search.PatternQuerySpecification;
import org.eclipse.wst.jsdt.ui.search.QuerySpecification;
import org.eclipse.wst.jsdt.web.core.internal.java.search.JsSearchScope;
import org.eclipse.wst.jsdt.web.core.internal.java.search.JsSearchSupport;
import org.eclipse.wst.jsdt.web.ui.internal.java.search.JsSearchRequestor;
import org.eclipse.wst.jsdt.web.ui.internal.java.search.ui.JsMatchPresentation;

public class JsQueryParticipant
implements IQueryParticipant {
    private static final boolean DEBUG;

    static {
        String string = Platform.getDebugOption((String)"org.eclipse.wst.jsdt.web.core/debug/jspsearch");
        DEBUG = string != null && string.equalsIgnoreCase("true");
    }

    public int estimateTicks(QuerySpecification querySpecification) {
        return 0;
    }

    public IMatchPresentation getUIParticipant() {
        return new JsMatchPresentation();
    }

    public void search(ISearchRequestor iSearchRequestor, QuerySpecification querySpecification, IProgressMonitor iProgressMonitor) throws CoreException {
        if (querySpecification instanceof ElementQuerySpecification) {
            ElementQuerySpecification elementQuerySpecification = (ElementQuerySpecification)querySpecification;
            IJavaElement iJavaElement = elementQuerySpecification.getElement();
            if (DEBUG) {
                System.out.println("JSP Query Participant searching on ELEMENT: " + iJavaElement);
            }
            JsSearchRequestor jsSearchRequestor = new JsSearchRequestor(iSearchRequestor);
            JsSearchSupport.getInstance().search(iJavaElement, (IJavaSearchScope)new JsSearchScope(), (SearchRequestor)jsSearchRequestor);
        } else if (querySpecification instanceof PatternQuerySpecification) {
            PatternQuerySpecification patternQuerySpecification = (PatternQuerySpecification)querySpecification;
            String string = patternQuerySpecification.getPattern();
            if (DEBUG) {
                System.out.println("JSP Query Participant searching on PATTERN: " + string);
            }
            JsSearchRequestor jsSearchRequestor = new JsSearchRequestor(iSearchRequestor);
            JsSearchSupport.getInstance().search(string, (IJavaSearchScope)new JsSearchScope(), patternQuerySpecification.getSearchFor(), patternQuerySpecification.getLimitTo(), 2, false, (SearchRequestor)jsSearchRequestor);
        }
    }
}

