/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.internal.style.java;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;
import org.eclipse.wst.jsdt.web.ui.internal.JsUIPlugin;
import org.eclipse.wst.jsdt.web.ui.internal.style.java.JSDTCodeScanner;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ColorHelper;
import org.eclipse.wst.sse.ui.internal.provisional.style.Highlighter;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;

public class LineStyleProviderForJSDT
implements LineStyleProvider {
    private IDocument fDocument;
    private Highlighter fHighlighter;
    private boolean fIsInitialized = false;
    private PropertyChangeListener fPreferenceListener = new PropertyChangeListener();
    private JSDTCodeScanner fScanner = new JSDTCodeScanner();
    private HashMap fTextAttributes = null;

    private void addJavaTextAttribute(String string) {
        IPreferenceStore iPreferenceStore = this.getJavaColorPreferences();
        if (iPreferenceStore != null && string != null) {
            TextAttribute textAttribute = null;
            if (string == "keyword") {
                RGB rGB = PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"java_keyword");
                boolean bl = iPreferenceStore.getBoolean("java_keyword_bold");
                boolean bl2 = iPreferenceStore.getBoolean("java_keyword_italic");
                boolean bl3 = iPreferenceStore.getBoolean("java_keyword_strikethrough");
                boolean bl4 = iPreferenceStore.getBoolean("java_keyword_underline");
                int n = 0;
                if (bl) {
                    n |= 1;
                }
                if (bl2) {
                    n |= 2;
                }
                if (bl3) {
                    n |= 0x20000000;
                }
                if (bl4) {
                    n |= 0x40000000;
                }
                textAttribute = this.createTextAttribute(rGB, null, n);
            } else if (string == "string") {
                RGB rGB = PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"java_string");
                boolean bl = iPreferenceStore.getBoolean("java_string_bold");
                boolean bl5 = iPreferenceStore.getBoolean("java_string_italic");
                boolean bl6 = iPreferenceStore.getBoolean("java_string_strikethrough");
                boolean bl7 = iPreferenceStore.getBoolean("java_string_underline");
                int n = 0;
                if (bl) {
                    n |= 1;
                }
                if (bl5) {
                    n |= 2;
                }
                if (bl6) {
                    n |= 0x20000000;
                }
                if (bl7) {
                    n |= 0x40000000;
                }
                textAttribute = this.createTextAttribute(rGB, null, n);
            } else if (string == "single_line_comment") {
                RGB rGB = PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"java_single_line_comment");
                boolean bl = iPreferenceStore.getBoolean("java_single_line_comment_bold");
                boolean bl8 = iPreferenceStore.getBoolean("java_single_line_comment_italic");
                boolean bl9 = iPreferenceStore.getBoolean("java_single_line_comment_strikethrough");
                boolean bl10 = iPreferenceStore.getBoolean("java_single_line_comment_underline");
                int n = 0;
                if (bl) {
                    n |= 1;
                }
                if (bl8) {
                    n |= 2;
                }
                if (bl9) {
                    n |= 0x20000000;
                }
                if (bl10) {
                    n |= 0x40000000;
                }
                textAttribute = this.createTextAttribute(rGB, null, n);
            } else if (string == "default") {
                RGB rGB = PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"java_default");
                boolean bl = iPreferenceStore.getBoolean("java_default_bold");
                boolean bl11 = iPreferenceStore.getBoolean("java_default_italic");
                boolean bl12 = iPreferenceStore.getBoolean("java_default_strikethrough");
                boolean bl13 = iPreferenceStore.getBoolean("java_default_underline");
                int n = 0;
                if (bl) {
                    n |= 1;
                }
                if (bl11) {
                    n |= 2;
                }
                if (bl12) {
                    n |= 0x20000000;
                }
                if (bl13) {
                    n |= 0x40000000;
                }
                textAttribute = this.createTextAttribute(rGB, null, n);
            }
            if (textAttribute != null) {
                this.getTextAttributes().put(string, textAttribute);
                this.fScanner.setTokenData(string, textAttribute);
            }
        }
    }

    private void addRange(Collection collection, int n, int n2, TextAttribute textAttribute) {
        TextAttribute textAttribute2 = (TextAttribute)this.getTextAttributes().get("jsp_content");
        Color color = textAttribute2.getBackground();
        if (color == null) {
            color = textAttribute.getBackground();
        }
        StyleRange styleRange = new StyleRange(n, n2, textAttribute.getForeground(), color, textAttribute.getStyle());
        if ((textAttribute.getStyle() & 0x20000000) != 0) {
            styleRange.strikeout = true;
        }
        if ((textAttribute.getStyle() & 0x40000000) != 0) {
            styleRange.underline = true;
        }
        collection.add(styleRange);
    }

    private void addTextAttribute(String string) {
        String string2;
        String[] stringArray;
        if (this.getColorPreferences() != null && (stringArray = ColorHelper.unpackStylePreferences((String)(string2 = this.getColorPreferences().getString(string)))) != null) {
            RGB rGB = ColorHelper.toRGB((String)stringArray[0]);
            RGB rGB2 = ColorHelper.toRGB((String)stringArray[1]);
            boolean bl = Boolean.valueOf(stringArray[2]);
            boolean bl2 = Boolean.valueOf(stringArray[3]);
            boolean bl3 = Boolean.valueOf(stringArray[4]);
            boolean bl4 = Boolean.valueOf(stringArray[5]);
            int n = 0;
            if (bl) {
                n |= 1;
            }
            if (bl2) {
                n |= 2;
            }
            if (bl3) {
                n |= 0x20000000;
            }
            if (bl4) {
                n |= 0x40000000;
            }
            TextAttribute textAttribute = this.createTextAttribute(rGB, rGB2, n);
            this.getTextAttributes().put(string, textAttribute);
        }
    }

    private TextAttribute createTextAttribute(RGB rGB, RGB rGB2, int n) {
        return new TextAttribute(rGB != null ? EditorUtility.getColor((RGB)rGB) : null, rGB2 != null ? EditorUtility.getColor((RGB)rGB2) : null, n);
    }

    private IPreferenceStore getColorPreferences() {
        return JsUIPlugin.getDefault().getPreferenceStore();
    }

    private IPreferenceStore getJavaColorPreferences() {
        return PreferenceConstants.getPreferenceStore();
    }

    private HashMap getTextAttributes() {
        if (this.fTextAttributes == null) {
            this.fTextAttributes = new HashMap();
            this.loadColors();
        }
        return this.fTextAttributes;
    }

    private TextAttribute getTokenTextAttribute(IToken iToken) {
        TextAttribute textAttribute = null;
        Object object = iToken.getData();
        textAttribute = object instanceof TextAttribute ? (TextAttribute)object : (TextAttribute)this.getTextAttributes().get("default");
        return textAttribute;
    }

    protected void handlePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = null;
        String string2 = null;
        if (propertyChangeEvent != null) {
            String string3 = propertyChangeEvent.getProperty();
            if ("SCRIPT_AREA_BORDER".equals(string3)) {
                string = "SCRIPT_AREA_BORDER";
            } else if ("tagAttributeName".equals(string3)) {
                string = "tagAttributeName";
            } else if ("tagAttributeValue".equals(string3)) {
                string = "tagAttributeValue";
            } else if ("jsp_content".equals(string3)) {
                string = "jsp_content";
            } else if ("java_keyword".equals(string3) || "java_keyword_bold".equals(string3) || "java_keyword_italic".equals(string3)) {
                string2 = "keyword";
            } else if ("java_string".equals(string3) || "java_string_bold".equals(string3) || "java_string_italic".equals(string3)) {
                string2 = "string";
            } else if ("java_single_line_comment".equals(string3) || "java_single_line_comment_bold".equals(string3) || "java_single_line_comment_italic".equals(string3)) {
                string2 = "single_line_comment";
            } else if ("java_default".equals(string3) || "java_default_bold".equals(string3) || "java_default_italic".equals(string3)) {
                string2 = "default";
            }
        }
        if (string != null) {
            this.addTextAttribute(string);
        }
        if (string2 != null) {
            this.addJavaTextAttribute(string2);
            this.fScanner.initializeRules();
        }
        if (string != null || string2 != null) {
            this.fHighlighter.refreshDisplay();
        }
    }

    public void init(IStructuredDocument iStructuredDocument, Highlighter highlighter) {
        this.fDocument = iStructuredDocument;
        this.fHighlighter = highlighter;
        if (this.fIsInitialized) {
            return;
        }
        this.registerPreferenceListener();
        this.fIsInitialized = true;
    }

    private void loadColors() {
        this.addTextAttribute("SCRIPT_AREA_BORDER");
        this.addTextAttribute("tagAttributeName");
        this.addTextAttribute("tagAttributeValue");
        this.addTextAttribute("jsp_content");
        this.addJavaTextAttribute("keyword");
        this.addJavaTextAttribute("string");
        this.addJavaTextAttribute("single_line_comment");
        this.addJavaTextAttribute("default");
        this.fScanner.initializeRules();
    }

    public boolean prepareRegions(ITypedRegion iTypedRegion, int n, int n2, Collection collection) {
        boolean bl = true;
        try {
            int n3 = iTypedRegion.getOffset();
            String string = this.fDocument.get(iTypedRegion.getOffset(), iTypedRegion.getLength());
            Document document = new Document(string);
            int n4 = 0;
            int n5 = 0;
            IToken iToken = Token.UNDEFINED;
            int n6 = iTypedRegion.getLength();
            this.fScanner.setRange((IDocument)document, n4, n6);
            while (true) {
                IToken iToken2;
                if ((iToken2 = this.fScanner.nextToken()).isEOF()) {
                    if (!iToken.isUndefined() && n5 != 0) {
                        this.addRange(collection, n4 + n3, n5, this.getTokenTextAttribute(iToken));
                    }
                    break;
                }
                if (iToken2.isWhitespace()) {
                    n5 += this.fScanner.getTokenLength();
                    continue;
                }
                if (iToken.isUndefined()) {
                    iToken = iToken2;
                    n5 += this.fScanner.getTokenLength();
                    continue;
                }
                if (iToken2 != iToken) {
                    this.addRange(collection, n4 + n3, n5, this.getTokenTextAttribute(iToken));
                    iToken = iToken2;
                    n4 = this.fScanner.getTokenOffset();
                    n5 = this.fScanner.getTokenLength();
                    continue;
                }
                n5 += this.fScanner.getTokenLength();
            }
        }
        catch (BadLocationException badLocationException) {
            bl = false;
        }
        return bl;
    }

    private void registerPreferenceListener() {
        this.getColorPreferences().addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        this.getJavaColorPreferences().addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
    }

    public void release() {
        this.unregisterPreferenceManager();
        if (this.fTextAttributes != null) {
            this.fTextAttributes.clear();
            this.fTextAttributes = null;
        }
    }

    private void unregisterPreferenceManager() {
        this.getColorPreferences().removePropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        this.getJavaColorPreferences().removePropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
    }

    private class PropertyChangeListener
    implements IPropertyChangeListener {
        private PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            LineStyleProviderForJSDT.this.handlePropertyChange(propertyChangeEvent);
        }
    }
}

