/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ssh;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.optional.ssh.Directory;
import org.apache.tools.ant.taskdefs.optional.ssh.SSHBase;
import org.apache.tools.ant.taskdefs.optional.ssh.ScpFromMessage;
import org.apache.tools.ant.taskdefs.optional.ssh.ScpFromMessageBySftp;
import org.apache.tools.ant.taskdefs.optional.ssh.ScpToMessage;
import org.apache.tools.ant.taskdefs.optional.ssh.ScpToMessageBySftp;
import org.apache.tools.ant.types.FileSet;

public class Scp
extends SSHBase {
    private static final String[] FROM_ATTRS = new String[]{"file", "localfile", "remotefile"};
    private static final String[] TO_ATTRS = new String[]{"todir", "localtodir", "remotetodir", "localtofile", "remotetofile"};
    private String fromUri;
    private String toUri;
    private List fileSets = null;
    private boolean isFromRemote;
    private boolean isToRemote;
    private boolean isSftp = false;

    public void setFile(String aFromUri) {
        this.setFromUri(aFromUri);
        this.isFromRemote = this.isRemoteUri(this.fromUri);
    }

    public void setTodir(String aToUri) {
        this.setToUri(aToUri);
        this.isToRemote = this.isRemoteUri(this.toUri);
    }

    public void setLocalFile(String aFromUri) {
        this.setFromUri(aFromUri);
        this.isFromRemote = false;
    }

    public void setRemoteFile(String aFromUri) {
        this.setFromUri(aFromUri);
        this.isFromRemote = true;
    }

    public void setLocalTodir(String aToUri) {
        this.setToUri(aToUri);
        this.isToRemote = false;
    }

    public void setRemoteTodir(String aToUri) {
        this.setToUri(aToUri);
        this.isToRemote = true;
    }

    public void setLocalTofile(String aToUri) {
        this.setToUri(aToUri);
        this.isToRemote = false;
    }

    public void setRemoteTofile(String aToUri) {
        this.setToUri(aToUri);
        this.isToRemote = true;
    }

    public void setSftp(boolean yesOrNo) {
        this.isSftp = yesOrNo;
    }

    public void addFileset(FileSet set) {
        if (this.fileSets == null) {
            this.fileSets = new LinkedList();
        }
        this.fileSets.add(set);
    }

    public void init() throws BuildException {
        super.init();
        this.toUri = null;
        this.fromUri = null;
        this.fileSets = null;
    }

    public void execute() throws BuildException {
        block10: {
            if (this.toUri == null) {
                throw this.exactlyOne(TO_ATTRS);
            }
            if (this.fromUri == null && this.fileSets == null) {
                throw this.exactlyOne(FROM_ATTRS, "one or more nested filesets");
            }
            try {
                if (this.isFromRemote && !this.isToRemote) {
                    this.download(this.fromUri, this.toUri);
                    break block10;
                }
                if (!this.isFromRemote && this.isToRemote) {
                    if (this.fileSets != null) {
                        this.upload(this.fileSets, this.toUri);
                    } else {
                        this.upload(this.fromUri, this.toUri);
                    }
                    break block10;
                }
                if (this.isFromRemote && this.isToRemote) {
                    throw new BuildException("Copying from a remote server to a remote server is not supported.");
                }
                throw new BuildException("'todir' and 'file' attributes must have syntax like the following: user:password@host:/path");
            }
            catch (Exception e) {
                if (this.getFailonerror()) {
                    throw new BuildException((Throwable)e);
                }
                this.log("Caught exception: " + e.getMessage(), 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(String fromSshUri, String toPath) throws JSchException, IOException {
        String file = this.parseUri(fromSshUri);
        Session session = null;
        try {
            session = this.openSession();
            ScpFromMessage message = null;
            message = !this.isSftp ? new ScpFromMessage(this.getVerbose(), session, file, this.getProject().resolveFile(toPath), fromSshUri.endsWith("*")) : new ScpFromMessageBySftp(this.getVerbose(), session, file, this.getProject().resolveFile(toPath), fromSshUri.endsWith("*"));
            this.log("Receiving file: " + file);
            message.setLogListener(this);
            message.execute();
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upload(List fileSet, String toSshUri) throws IOException, JSchException {
        String file = this.parseUri(toSshUri);
        Session session = null;
        try {
            ArrayList<Directory> list = new ArrayList<Directory>(fileSet.size());
            Iterator i = fileSet.iterator();
            while (i.hasNext()) {
                FileSet set = (FileSet)i.next();
                Directory d = this.createDirectory(set);
                if (d == null) continue;
                list.add(d);
            }
            if (!list.isEmpty()) {
                session = this.openSession();
                ScpToMessage message = null;
                message = !this.isSftp ? new ScpToMessage(this.getVerbose(), session, list, file) : new ScpToMessageBySftp(this.getVerbose(), session, list, file);
                message.setLogListener(this);
                message.execute();
            }
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upload(String fromPath, String toSshUri) throws IOException, JSchException {
        String file = this.parseUri(toSshUri);
        Session session = null;
        try {
            session = this.openSession();
            ScpToMessage message = null;
            message = !this.isSftp ? new ScpToMessage(this.getVerbose(), session, this.getProject().resolveFile(fromPath), file) : new ScpToMessageBySftp(this.getVerbose(), session, this.getProject().resolveFile(fromPath), file);
            message.setLogListener(this);
            message.execute();
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
        }
    }

    private String parseUri(String uri) {
        int indexOfAt = uri.lastIndexOf(64);
        int indexOfColon = uri.indexOf(58);
        if (indexOfColon > -1 && indexOfColon < indexOfAt) {
            this.setUsername(uri.substring(0, indexOfColon));
            this.setPassword(uri.substring(indexOfColon + 1, indexOfAt));
        } else {
            this.setUsername(uri.substring(0, indexOfAt));
        }
        if (this.getUserInfo().getPassword() == null && this.getUserInfo().getPassphrase() == null) {
            throw new BuildException("neither password nor passphrase for user " + this.getUserInfo().getName() + " has been " + "given.  Can't authenticate.");
        }
        int indexOfPath = uri.indexOf(58, indexOfAt + 1);
        if (indexOfPath == -1) {
            throw new BuildException("no remote path in " + uri);
        }
        this.setHost(uri.substring(indexOfAt + 1, indexOfPath));
        String remotePath = uri.substring(indexOfPath + 1);
        if (remotePath.equals("")) {
            remotePath = ".";
        }
        return remotePath;
    }

    private boolean isRemoteUri(String uri) {
        boolean isRemote = true;
        int indexOfAt = uri.indexOf(64);
        if (indexOfAt < 0) {
            isRemote = false;
        }
        return isRemote;
    }

    private Directory createDirectory(FileSet set) {
        DirectoryScanner scanner = set.getDirectoryScanner(this.getProject());
        Directory root = new Directory(scanner.getBasedir());
        String[] files = scanner.getIncludedFiles();
        if (files.length != 0) {
            for (int j = 0; j < files.length; ++j) {
                String[] path = Directory.getPath(files[j]);
                Directory current = root;
                File currentParent = scanner.getBasedir();
                for (int i = 0; i < path.length; ++i) {
                    File file = new File(currentParent, path[i]);
                    if (file.isDirectory()) {
                        current.addDirectory(new Directory(file));
                        current = current.getChild(file);
                        currentParent = current.getDirectory();
                        continue;
                    }
                    if (!file.isFile()) continue;
                    current.addFile(file);
                }
            }
        } else {
            root = null;
        }
        return root;
    }

    private void setFromUri(String fromUri) {
        if (this.fromUri != null) {
            throw this.exactlyOne(FROM_ATTRS);
        }
        this.fromUri = fromUri;
    }

    private void setToUri(String toUri) {
        if (this.toUri != null) {
            throw this.exactlyOne(TO_ATTRS);
        }
        this.toUri = toUri;
    }

    private BuildException exactlyOne(String[] attrs) {
        return this.exactlyOne(attrs, null);
    }

    private BuildException exactlyOne(String[] attrs, String alt) {
        StringBuffer buf = new StringBuffer("Exactly one of ").append('[').append(attrs[0]);
        for (int i = 1; i < attrs.length; ++i) {
            buf.append('|').append(attrs[i]);
        }
        buf.append(']');
        if (alt != null) {
            buf.append(" or ").append(alt);
        }
        return new BuildException(buf.append(" is required.").toString());
    }
}

