/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.compatibility.jsdt;

import java.util.ArrayList;
import org.eclipse.atf.compatibility.jsdt.ATFLibrariesInitializer;
import org.eclipse.atf.project.ProjectUtils;
import org.eclipse.atf.runtime.IRuntimeInstance;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IAccessRule;
import org.eclipse.wst.jsdt.core.IClasspathAttribute;
import org.eclipse.wst.jsdt.core.IClasspathContainer;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.core.ClasspathAttribute;
import org.eclipse.wst.jsdt.internal.core.ClasspathEntry;
import org.eclipse.wst.jsdt.internal.core.JavaProject;

class ATFClasspathContainer
implements IClasspathContainer {
    private IProject project;
    private IPath webContentPath;

    public ATFClasspathContainer(IProject iProject) {
        this.project = iProject;
        this.webContentPath = ATFLibrariesInitializer.getWebContentRoot(iProject);
    }

    public IClasspathEntry[] getClasspathEntries() {
        IFolder[] iFolderArray;
        try {
            iFolderArray = this.getToolkitFolders();
        }
        catch (NullPointerException nullPointerException) {
            return new IClasspathEntry[0];
        }
        ArrayList<ClasspathEntry> arrayList = new ArrayList<ClasspathEntry>();
        IClasspathAttribute[] iClasspathAttributeArray = new IClasspathAttribute[]{new ClasspathAttribute("validate", "false")};
        IPath[] iPathArray = new IPath[]{new Path("*/*/**")};
        IPath[] iPathArray2 = new IPath[]{new Path("")};
        int n = 0;
        while (n < iFolderArray.length) {
            ClasspathEntry classpathEntry = new ClasspathEntry(2, 1, JavaProject.canonicalizedPath((IPath)iFolderArray[n].getFullPath()), iPathArray2, iPathArray, null, null, null, false, ClasspathEntry.NO_ACCESS_RULES, false, iClasspathAttributeArray);
            arrayList.add(classpathEntry);
            this.addToolkitJSFiles(this.project, arrayList, iFolderArray[n]);
            ++n;
        }
        IClasspathEntry[] iClasspathEntryArray = new IClasspathEntry[arrayList.size()];
        arrayList.toArray(iClasspathEntryArray);
        return iClasspathEntryArray;
    }

    protected IFolder[] getToolkitFolders() {
        Object[] objectArray = this.getToolkits();
        IFolder[] iFolderArray = new IFolder[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            IRuntimeInstance iRuntimeInstance = (IRuntimeInstance)objectArray[n];
            IPath iPath = iRuntimeInstance.getType().getInstaller().getProjectInstallPath(iRuntimeInstance);
            IPath iPath2 = this.webContentPath.append(iPath);
            iFolderArray[n] = (IFolder)this.project.findMember(iPath2);
            ++n;
        }
        return iFolderArray;
    }

    protected Object[] getToolkits() {
        Object[] objectArray = null;
        try {
            objectArray = ProjectUtils.loadSettings((IProject)this.project);
        }
        catch (CoreException coreException) {
            return new Object[0];
        }
        if (objectArray == null) {
            return new Object[0];
        }
        return objectArray;
    }

    private void addToolkitJSFiles(IProject iProject, final ArrayList arrayList, IFolder iFolder) {
        IResourceProxyVisitor iResourceProxyVisitor = new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy iResourceProxy) throws CoreException {
                if (iResourceProxy.getName().endsWith(".js")) {
                    IPath iPath = iResourceProxy.requestResource().getLocation();
                    IClasspathEntry iClasspathEntry = JavaCore.newLibraryEntry((IPath)iPath, null, null, (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])new IClasspathAttribute[0], (boolean)true);
                    arrayList.add(iClasspathEntry);
                    return false;
                }
                return true;
            }
        };
        try {
            iProject.findMember(iFolder.getProjectRelativePath()).accept(iResourceProxyVisitor, 0);
        }
        catch (CoreException coreException) {}
    }

    public String getDescription() {
        return "JavaScript Toolkits";
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return new Path("org.eclipse.atf.jsdt.ATFLibrariesInitializer");
    }
}

