/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.buildpath;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;

public class CPJavaProject {
    private final List fCPListElements;
    private IPath fDefaultOutputLocation;

    public static CPJavaProject createFromExisting(IJavaProject iJavaProject) throws CoreException {
        List list = ClasspathModifier.getExistingEntries(iJavaProject);
        return new CPJavaProject(list, iJavaProject.getOutputLocation());
    }

    public CPJavaProject(List list, IPath iPath) {
        this.fCPListElements = list;
        this.fDefaultOutputLocation = iPath;
    }

    public CPJavaProject createWorkingCopy() {
        ArrayList<CPListElement> arrayList = new ArrayList<CPListElement>(this.fCPListElements.size());
        Iterator iterator = this.fCPListElements.iterator();
        while (iterator.hasNext()) {
            CPListElement cPListElement = (CPListElement)iterator.next();
            arrayList.add(cPListElement.copy());
        }
        return new CPJavaProject(arrayList, this.fDefaultOutputLocation);
    }

    public CPListElement get(int n) {
        return (CPListElement)this.fCPListElements.get(n);
    }

    public IClasspathEntry[] getClasspathEntries() {
        IClasspathEntry[] iClasspathEntryArray = new IClasspathEntry[this.fCPListElements.size()];
        int n = 0;
        Iterator iterator = this.fCPListElements.iterator();
        while (iterator.hasNext()) {
            CPListElement cPListElement = (CPListElement)iterator.next();
            iClasspathEntryArray[n] = cPListElement.getClasspathEntry();
            ++n;
        }
        return iClasspathEntryArray;
    }

    public CPListElement getCPElement(CPListElement cPListElement) {
        return ClasspathModifier.getClasspathEntry(this.fCPListElements, cPListElement);
    }

    public List getCPListElements() {
        return this.fCPListElements;
    }

    public IPath getDefaultOutputLocation() {
        return this.fDefaultOutputLocation;
    }

    public IJavaProject getJavaProject() {
        return ((CPListElement)this.fCPListElements.get(0)).getJavaProject();
    }

    public int indexOf(CPListElement cPListElement) {
        return this.fCPListElements.indexOf(cPListElement);
    }

    public void setDefaultOutputLocation(IPath iPath) {
        this.fDefaultOutputLocation = iPath;
    }
}

