/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.codemanipulation;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.NamingConventions;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.CastExpression;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.formatter.IndentManipulation;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.template.java.CodeTemplateContext;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIStatus;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ProjectTemplateStore;
import org.eclipse.wst.jsdt.ui.CodeStyleConfiguration;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;

public class StubUtility {
    private static final String[] EMPTY = new String[0];
    private static final Set VALID_TYPE_BODY_TEMPLATES = new HashSet();
    public static final int STATIC_FIELD = 1;
    public static final int INSTANCE_FIELD = 2;
    public static final int CONSTANT_FIELD = 3;
    public static final int PARAMETER = 4;
    public static final int LOCAL = 5;
    private static final String[] KNOWN_METHOD_NAME_PREFIXES;
    private static final List BASE_TYPES;

    static {
        VALID_TYPE_BODY_TEMPLATES.add("org.eclipse.wst.jsdt.ui.text.codetemplates.classbody");
        VALID_TYPE_BODY_TEMPLATES.add("org.eclipse.wst.jsdt.ui.text.codetemplates.interfacebody");
        VALID_TYPE_BODY_TEMPLATES.add("org.eclipse.wst.jsdt.ui.text.codetemplates.enumbody");
        VALID_TYPE_BODY_TEMPLATES.add("org.eclipse.wst.jsdt.ui.text.codetemplates.annotationbody");
        KNOWN_METHOD_NAME_PREFIXES = new String[]{"get", "is", "to"};
        BASE_TYPES = Arrays.asList("boolean", "byte", "char", "double", "float", "int", "long", "short");
    }

    public static String getMethodBodyContent(boolean bl, IJavaProject iJavaProject, String string, String string2, String string3, String string4) throws CoreException {
        String string5 = bl ? "org.eclipse.wst.jsdt.ui.text.codetemplates.constructorbody" : "org.eclipse.wst.jsdt.ui.text.codetemplates.methodbody";
        Template template = StubUtility.getCodeTemplate(string5, iJavaProject);
        if (template == null) {
            return string3;
        }
        CodeTemplateContext codeTemplateContext = new CodeTemplateContext(template.getContextTypeId(), iJavaProject, string4);
        codeTemplateContext.setVariable("enclosing_method", string2);
        codeTemplateContext.setVariable("enclosing_type", string);
        codeTemplateContext.setVariable("body_statement", string3);
        String string6 = StubUtility.evaluateTemplate(codeTemplateContext, template, new String[]{"body_statement"});
        if (string6 == null && !Strings.containsOnlyWhitespaces(string3)) {
            return string3;
        }
        return string6;
    }

    public static String getGetterMethodBodyContent(IJavaProject iJavaProject, String string, String string2, String string3, String string4) throws CoreException {
        String string5 = "org.eclipse.wst.jsdt.ui.text.codetemplates.getterbody";
        Template template = StubUtility.getCodeTemplate(string5, iJavaProject);
        if (template == null) {
            return null;
        }
        CodeTemplateContext codeTemplateContext = new CodeTemplateContext(template.getContextTypeId(), iJavaProject, string4);
        codeTemplateContext.setVariable("enclosing_method", string2);
        codeTemplateContext.setVariable("enclosing_type", string);
        codeTemplateContext.setVariable("field", string3);
        return StubUtility.evaluateTemplate(codeTemplateContext, template);
    }

    public static String getSetterMethodBodyContent(IJavaProject iJavaProject, String string, String string2, String string3, String string4, String string5) throws CoreException {
        String string6 = "org.eclipse.wst.jsdt.ui.text.codetemplates.setterbody";
        Template template = StubUtility.getCodeTemplate(string6, iJavaProject);
        if (template == null) {
            return null;
        }
        CodeTemplateContext codeTemplateContext = new CodeTemplateContext(template.getContextTypeId(), iJavaProject, string5);
        codeTemplateContext.setVariable("enclosing_method", string2);
        codeTemplateContext.setVariable("enclosing_type", string);
        codeTemplateContext.setVariable("field", string3);
        codeTemplateContext.setVariable("field_type", string3);
        codeTemplateContext.setVariable("param", string4);
        return StubUtility.evaluateTemplate(codeTemplateContext, template);
    }

    public static String getCatchBodyContent(ICompilationUnit iCompilationUnit, String string, String string2, ASTNode aSTNode, String string3) throws CoreException {
        String string4 = "";
        String string5 = "";
        if (aSTNode != null) {
            ASTNode aSTNode2;
            MethodDeclaration methodDeclaration = ASTResolving.findParentMethodDeclaration(aSTNode);
            if (methodDeclaration != null) {
                string5 = methodDeclaration.getName().getIdentifier();
                aSTNode = methodDeclaration;
            }
            if ((aSTNode2 = ASTResolving.findParentType(aSTNode)) instanceof AbstractTypeDeclaration) {
                string4 = ((AbstractTypeDeclaration)aSTNode2).getName().getIdentifier();
            }
        }
        return StubUtility.getCatchBodyContent(iCompilationUnit, string, string2, string4, string5, string3);
    }

    public static String getCatchBodyContent(ICompilationUnit iCompilationUnit, String string, String string2, String string3, String string4, String string5) throws CoreException {
        Template template = StubUtility.getCodeTemplate("org.eclipse.wst.jsdt.ui.text.codetemplates.catchblock", iCompilationUnit.getJavaProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext codeTemplateContext = new CodeTemplateContext(template.getContextTypeId(), iCompilationUnit.getJavaProject(), string5);
        codeTemplateContext.setVariable("enclosing_type", string3);
        codeTemplateContext.setVariable("enclosing_method", string4);
        codeTemplateContext.setVariable("exception_type", string);
        codeTemplateContext.setVariable("exception_var", string2);
        return StubUtility.evaluateTemplate(codeTemplateContext, template);
    }

    public static String getCompilationUnitContent(ICompilationUnit iCompilationUnit, String string, String string2, String string3, String string4) throws CoreException {
        IPackageFragment iPackageFragment = (IPackageFragment)iCompilationUnit.getParent();
        String string5 = iPackageFragment.isDefaultPackage() ? "" : "package " + iPackageFragment.getElementName() + ';';
        return StubUtility.getCompilationUnitContent(iCompilationUnit, string5, string, string2, string3, string4);
    }

    public static String getCompilationUnitContent(ICompilationUnit iCompilationUnit, String string, String string2, String string3, String string4, String string5) throws CoreException {
        Template template = StubUtility.getCodeTemplate("org.eclipse.wst.jsdt.ui.text.codetemplates.newtype", iCompilationUnit.getJavaProject());
        if (template == null) {
            return null;
        }
        IJavaProject iJavaProject = iCompilationUnit.getJavaProject();
        CodeTemplateContext codeTemplateContext = new CodeTemplateContext(template.getContextTypeId(), iJavaProject, string5);
        codeTemplateContext.setCompilationUnitVariables(iCompilationUnit);
        codeTemplateContext.setVariable("package_declaration", string);
        codeTemplateContext.setVariable("typecomment", string3 != null ? string3 : "");
        codeTemplateContext.setVariable("filecomment", string2 != null ? string2 : "");
        codeTemplateContext.setVariable("type_declaration", string4);
        codeTemplateContext.setVariable("type_name", JavaCore.removeJavaLikeExtension((String)iCompilationUnit.getElementName()));
        String[] stringArray = new String[]{"package_declaration", "filecomment", "typecomment"};
        return StubUtility.evaluateTemplate(codeTemplateContext, template, stringArray);
    }

    public static String getFileComment(ICompilationUnit iCompilationUnit, String string) throws CoreException {
        Template template = StubUtility.getCodeTemplate("org.eclipse.wst.jsdt.ui.text.codetemplates.filecomment", iCompilationUnit.getJavaProject());
        if (template == null) {
            return null;
        }
        IJavaProject iJavaProject = iCompilationUnit.getJavaProject();
        CodeTemplateContext codeTemplateContext = new CodeTemplateContext(template.getContextTypeId(), iJavaProject, string);
        codeTemplateContext.setCompilationUnitVariables(iCompilationUnit);
        codeTemplateContext.setVariable("type_name", JavaCore.removeJavaLikeExtension((String)iCompilationUnit.getElementName()));
        return StubUtility.evaluateTemplate(codeTemplateContext, template);
    }

    public static String getTypeComment(ICompilationUnit iCompilationUnit, String string, String[] stringArray, String string2) throws CoreException {
        TemplateBuffer templateBuffer;
        Template template = StubUtility.getCodeTemplate("org.eclipse.wst.jsdt.ui.text.codetemplates.typecomment", iCompilationUnit.getJavaProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext codeTemplateContext = new CodeTemplateContext(template.getContextTypeId(), iCompilationUnit.getJavaProject(), string2);
        codeTemplateContext.setCompilationUnitVariables(iCompilationUnit);
        codeTemplateContext.setVariable("enclosing_type", Signature.getQualifier((String)string));
        codeTemplateContext.setVariable("type_name", Signature.getSimpleName((String)string));
        try {
            templateBuffer = codeTemplateContext.evaluate(template);
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException templateException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        String string3 = templateBuffer.getString();
        if (Strings.containsOnlyWhitespaces(string3)) {
            return null;
        }
        TemplateVariable templateVariable = StubUtility.findVariable(templateBuffer, "tags");
        if (templateVariable == null) {
            return string3;
        }
        Document document = new Document(string3);
        int[] nArray = templateVariable.getOffsets();
        int n = nArray.length - 1;
        while (n >= 0) {
            try {
                StubUtility.insertTag((IDocument)document, nArray[n], templateVariable.getLength(), EMPTY, EMPTY, null, stringArray, false, string2);
            }
            catch (BadLocationException badLocationException) {
                throw new CoreException(JavaUIStatus.createError(4, badLocationException));
            }
            --n;
        }
        return document.get();
    }

    public static String[] getParameterTypeNamesForSeeTag(IMethodBinding iMethodBinding) {
        ITypeBinding[] iTypeBindingArray = iMethodBinding.getParameterTypes();
        String[] stringArray = new String[iTypeBindingArray.length];
        int n = 0;
        while (n < stringArray.length) {
            ITypeBinding iTypeBinding = iTypeBindingArray[n];
            if (iTypeBinding.isTypeVariable()) {
                iTypeBinding = iTypeBinding.getErasure();
            }
            iTypeBinding = iTypeBinding.getTypeDeclaration();
            stringArray[n] = iTypeBinding.getQualifiedName();
            ++n;
        }
        return stringArray;
    }

    private static String[] getParameterTypeNamesForSeeTag(IMethod iMethod) {
        String[] stringArray;
        String[] stringArray2;
        try {
            stringArray2 = ASTParser.newParser((int)3);
            stringArray2.setProject(iMethod.getJavaProject());
            stringArray = stringArray2.createBindings(new IJavaElement[]{iMethod}, null);
            if (stringArray.length == 1 && stringArray[0] instanceof IMethodBinding) {
                return StubUtility.getParameterTypeNamesForSeeTag((IMethodBinding)stringArray[0]);
            }
        }
        catch (IllegalStateException illegalStateException) {}
        stringArray2 = iMethod.getParameterTypes();
        stringArray = new String[stringArray2.length];
        int n = 0;
        while (n < stringArray2.length) {
            stringArray[n] = Signature.toString((String)Signature.getTypeErasure((String)stringArray2[n]));
            ++n;
        }
        return stringArray;
    }

    private static String getSeeTag(String string, String string2, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("@see ");
        stringBuffer.append(string);
        stringBuffer.append('#');
        stringBuffer.append(string2);
        stringBuffer.append('(');
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static String[] getTypeParameterNames(ITypeParameter[] iTypeParameterArray) {
        String[] stringArray = new String[iTypeParameterArray.length];
        int n = 0;
        while (n < iTypeParameterArray.length) {
            stringArray[n] = iTypeParameterArray[n].getElementName();
            ++n;
        }
        return stringArray;
    }

    public static String getTypeBody(String string, ICompilationUnit iCompilationUnit, String string2, String string3) throws CoreException {
        if (!VALID_TYPE_BODY_TEMPLATES.contains(string)) {
            throw new IllegalArgumentException("Invalid code template ID: " + string);
        }
        Template template = StubUtility.getCodeTemplate(string, iCompilationUnit.getJavaProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext codeTemplateContext = new CodeTemplateContext(template.getContextTypeId(), iCompilationUnit.getJavaProject(), string3);
        codeTemplateContext.setCompilationUnitVariables(iCompilationUnit);
        codeTemplateContext.setVariable("type_name", string2);
        return StubUtility.evaluateTemplate(codeTemplateContext, template);
    }

    public static String getMethodComment(ICompilationUnit iCompilationUnit, String string, String string2, String[] stringArray, String[] stringArray2, String string3, String[] stringArray3, IMethod iMethod, boolean bl, String string4) throws CoreException {
        Object object;
        Object object2;
        String string5 = "org.eclipse.wst.jsdt.ui.text.codetemplates.methodcomment";
        if (string3 == null) {
            string5 = "org.eclipse.wst.jsdt.ui.text.codetemplates.constructorcomment";
        } else if (iMethod != null) {
            string5 = bl ? "org.eclipse.wst.jsdt.ui.text.codetemplates.delegatecomment" : "org.eclipse.wst.jsdt.ui.text.codetemplates.overridecomment";
        }
        Template template = StubUtility.getCodeTemplate(string5, iCompilationUnit.getJavaProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext codeTemplateContext = new CodeTemplateContext(template.getContextTypeId(), iCompilationUnit.getJavaProject(), string4);
        codeTemplateContext.setCompilationUnitVariables(iCompilationUnit);
        codeTemplateContext.setVariable("enclosing_type", string);
        codeTemplateContext.setVariable("enclosing_method", string2);
        if (string3 != null) {
            codeTemplateContext.setVariable("return_type", Signature.toString((String)string3));
        }
        if (iMethod != null && iMethod.getDeclaringType() != null) {
            object2 = iMethod.getDeclaringType().getFullyQualifiedName('.');
            object = StubUtility.getParameterTypeNamesForSeeTag(iMethod);
            if (bl) {
                codeTemplateContext.setVariable("see_to_target", StubUtility.getSeeTag((String)object2, string2, object));
            } else {
                codeTemplateContext.setVariable("see_to_overridden", StubUtility.getSeeTag((String)object2, string2, object));
            }
        }
        try {
            object2 = codeTemplateContext.evaluate(template);
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException templateException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (object2 == null) {
            return null;
        }
        object = object2.getString();
        if (Strings.containsOnlyWhitespaces((String)object)) {
            return null;
        }
        TemplateVariable templateVariable = StubUtility.findVariable(object2, "tags");
        if (templateVariable == null) {
            return object;
        }
        Document document = new Document((String)object);
        String[] stringArray4 = new String[stringArray2.length];
        int n = 0;
        while (n < stringArray2.length) {
            stringArray4[n] = Signature.toString((String)stringArray2[n]);
            ++n;
        }
        String string6 = string3 != null ? Signature.toString((String)string3) : null;
        int[] nArray = templateVariable.getOffsets();
        int n2 = nArray.length - 1;
        while (n2 >= 0) {
            try {
                StubUtility.insertTag((IDocument)document, nArray[n2], templateVariable.getLength(), stringArray, stringArray4, string6, stringArray3, false, string4);
            }
            catch (BadLocationException badLocationException) {
                throw new CoreException(JavaUIStatus.createError(4, badLocationException));
            }
            --n2;
        }
        return document.get();
    }

    private static String fixEmptyVariables(TemplateBuffer templateBuffer, String[] stringArray) throws MalformedTreeException, BadLocationException {
        Document document = new Document(templateBuffer.getString());
        int n = document.getNumberOfLines();
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n2 = 0;
        while (n2 < stringArray.length) {
            TemplateVariable templateVariable = StubUtility.findVariable(templateBuffer, stringArray[n2]);
            if (templateVariable != null && templateVariable.getLength() <= 0) {
                int[] nArray = templateVariable.getOffsets();
                int n3 = 0;
                while (n3 < nArray.length) {
                    int n4 = document.getLineOfOffset(nArray[n3]);
                    IRegion iRegion = document.getLineInformation(n4);
                    int n5 = iRegion.getOffset();
                    String string = document.get(n5, iRegion.getLength());
                    if (Strings.containsOnlyWhitespaces(string) && n > n4 + 1 && hashSet.add(new Integer(n4))) {
                        int n6 = document.getLineOffset(n4 + 1);
                        multiTextEdit.addChild((TextEdit)new DeleteEdit(n5, n6 - n5));
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        multiTextEdit.apply((IDocument)document, 0);
        return document.get();
    }

    public static String getFieldComment(ICompilationUnit iCompilationUnit, String string, String string2, String string3) throws CoreException {
        Template template = StubUtility.getCodeTemplate("org.eclipse.wst.jsdt.ui.text.codetemplates.fieldcomment", iCompilationUnit.getJavaProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext codeTemplateContext = new CodeTemplateContext(template.getContextTypeId(), iCompilationUnit.getJavaProject(), string3);
        codeTemplateContext.setCompilationUnitVariables(iCompilationUnit);
        codeTemplateContext.setVariable("field_type", string);
        codeTemplateContext.setVariable("field", string2);
        return StubUtility.evaluateTemplate(codeTemplateContext, template);
    }

    public static String getSetterComment(ICompilationUnit iCompilationUnit, String string, String string2, String string3, String string4, String string5, String string6, String string7) throws CoreException {
        String string8 = "org.eclipse.wst.jsdt.ui.text.codetemplates.settercomment";
        Template template = StubUtility.getCodeTemplate(string8, iCompilationUnit.getJavaProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext codeTemplateContext = new CodeTemplateContext(template.getContextTypeId(), iCompilationUnit.getJavaProject(), string7);
        codeTemplateContext.setCompilationUnitVariables(iCompilationUnit);
        codeTemplateContext.setVariable("enclosing_type", string);
        codeTemplateContext.setVariable("enclosing_method", string2);
        codeTemplateContext.setVariable("field", string3);
        codeTemplateContext.setVariable("field_type", string4);
        codeTemplateContext.setVariable("bare_field_name", string6);
        codeTemplateContext.setVariable("param", string5);
        return StubUtility.evaluateTemplate(codeTemplateContext, template);
    }

    public static String getGetterComment(ICompilationUnit iCompilationUnit, String string, String string2, String string3, String string4, String string5, String string6) throws CoreException {
        String string7 = "org.eclipse.wst.jsdt.ui.text.codetemplates.gettercomment";
        Template template = StubUtility.getCodeTemplate(string7, iCompilationUnit.getJavaProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext codeTemplateContext = new CodeTemplateContext(template.getContextTypeId(), iCompilationUnit.getJavaProject(), string6);
        codeTemplateContext.setCompilationUnitVariables(iCompilationUnit);
        codeTemplateContext.setVariable("enclosing_type", string);
        codeTemplateContext.setVariable("enclosing_method", string2);
        codeTemplateContext.setVariable("field", string3);
        codeTemplateContext.setVariable("field_type", string4);
        codeTemplateContext.setVariable("bare_field_name", string5);
        return StubUtility.evaluateTemplate(codeTemplateContext, template);
    }

    private static String evaluateTemplate(CodeTemplateContext codeTemplateContext, Template template) throws CoreException {
        TemplateBuffer templateBuffer;
        try {
            templateBuffer = codeTemplateContext.evaluate(template);
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException templateException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (templateBuffer == null) {
            return null;
        }
        String string = templateBuffer.getString();
        if (Strings.containsOnlyWhitespaces(string)) {
            return null;
        }
        return string;
    }

    private static String evaluateTemplate(CodeTemplateContext codeTemplateContext, Template template, String[] stringArray) throws CoreException {
        String string;
        block6: {
            TemplateBuffer templateBuffer;
            block5: {
                templateBuffer = codeTemplateContext.evaluate(template);
                if (templateBuffer != null) break block5;
                return null;
            }
            string = StubUtility.fixEmptyVariables(templateBuffer, stringArray);
            if (!Strings.containsOnlyWhitespaces(string)) break block6;
            return null;
        }
        try {
            return string;
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException templateException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }

    public static String getMethodComment(ICompilationUnit iCompilationUnit, String string, MethodDeclaration methodDeclaration, boolean bl, String string2, String string3, String[] stringArray, boolean bl2, String string4) throws CoreException {
        String[] stringArray2;
        String[] stringArray3;
        TemplateBuffer templateBuffer;
        if (string == null) {
            string = "";
        }
        boolean bl3 = string3 != null && stringArray != null;
        String string5 = "org.eclipse.wst.jsdt.ui.text.codetemplates.methodcomment";
        if (methodDeclaration.isConstructor()) {
            string5 = "org.eclipse.wst.jsdt.ui.text.codetemplates.constructorcomment";
        } else if (bl3) {
            string5 = bl2 ? "org.eclipse.wst.jsdt.ui.text.codetemplates.delegatecomment" : "org.eclipse.wst.jsdt.ui.text.codetemplates.overridecomment";
        }
        Template template = StubUtility.getCodeTemplate(string5, iCompilationUnit.getJavaProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext codeTemplateContext = new CodeTemplateContext(template.getContextTypeId(), iCompilationUnit.getJavaProject(), string4);
        codeTemplateContext.setCompilationUnitVariables(iCompilationUnit);
        codeTemplateContext.setVariable("enclosing_type", string);
        codeTemplateContext.setVariable("enclosing_method", methodDeclaration.getName().getIdentifier());
        if (!methodDeclaration.isConstructor() && StubUtility.getReturnType(methodDeclaration) != null) {
            codeTemplateContext.setVariable("return_type", ASTNodes.asString(StubUtility.getReturnType(methodDeclaration)));
        }
        if (bl3) {
            if (bl2) {
                codeTemplateContext.setVariable("see_to_target", StubUtility.getSeeTag(string3, string2, stringArray));
            } else {
                codeTemplateContext.setVariable("see_to_overridden", StubUtility.getSeeTag(string3, string2, stringArray));
            }
        }
        try {
            templateBuffer = codeTemplateContext.evaluate(template);
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException templateException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (templateBuffer == null) {
            return null;
        }
        String string6 = templateBuffer.getString();
        if (Strings.containsOnlyWhitespaces(string6)) {
            return null;
        }
        TemplateVariable templateVariable = StubUtility.findVariable(templateBuffer, "tags");
        if (templateVariable == null) {
            return string6;
        }
        Document document = new Document(string6);
        List list = methodDeclaration.typeParameters();
        String[] stringArray4 = new String[list.size()];
        int n = 0;
        while (n < stringArray4.length) {
            stringArray3 = (String[])list.get(n);
            stringArray4[n] = stringArray3.getName().getIdentifier();
            ++n;
        }
        List list2 = methodDeclaration.parameters();
        stringArray3 = new String[list2.size()];
        int n2 = 0;
        while (n2 < stringArray3.length) {
            stringArray2 = (String[])list2.get(n2);
            stringArray3[n2] = stringArray2.getName().getIdentifier();
            ++n2;
        }
        List list3 = methodDeclaration.thrownExceptions();
        stringArray2 = new String[list3.size()];
        int n3 = 0;
        while (n3 < stringArray2.length) {
            stringArray2[n3] = ASTNodes.getSimpleNameIdentifier((Name)list3.get(n3));
            ++n3;
        }
        String string7 = null;
        if (!methodDeclaration.isConstructor()) {
            string7 = ASTNodes.asString(StubUtility.getReturnType(methodDeclaration));
        }
        int[] nArray = templateVariable.getOffsets();
        int n4 = nArray.length - 1;
        while (n4 >= 0) {
            try {
                StubUtility.insertTag((IDocument)document, nArray[n4], templateVariable.getLength(), stringArray3, stringArray2, string7, stringArray4, bl, string4);
            }
            catch (BadLocationException badLocationException) {
                throw new CoreException(JavaUIStatus.createError(4, badLocationException));
            }
            --n4;
        }
        return document.get();
    }

    private static ASTNode getReturnType(MethodDeclaration methodDeclaration) {
        return methodDeclaration.getAST().apiLevel() == 2 ? methodDeclaration.getReturnType() : methodDeclaration.getReturnType2();
    }

    private static TemplateVariable findVariable(TemplateBuffer templateBuffer, String string) {
        TemplateVariable[] templateVariableArray = templateBuffer.getVariables();
        int n = 0;
        while (n < templateVariableArray.length) {
            TemplateVariable templateVariable = templateVariableArray[n];
            if (string.equals(templateVariable.getType())) {
                return templateVariable;
            }
            ++n;
        }
        return null;
    }

    private static void insertTag(IDocument iDocument, int n, int n2, String[] stringArray, String[] stringArray2, String string, String[] stringArray3, boolean bl, String string2) throws BadLocationException {
        IRegion iRegion = iDocument.getLineInformationOfOffset(n);
        if (iRegion == null) {
            return;
        }
        String string3 = iDocument.get(iRegion.getOffset(), n - iRegion.getOffset());
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < stringArray3.length) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(string2).append(string3);
            }
            stringBuffer.append("@param <").append(stringArray3[n3]).append('>');
            ++n3;
        }
        n3 = 0;
        while (n3 < stringArray.length) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(string2).append(string3);
            }
            stringBuffer.append("@param ").append(stringArray[n3]);
            ++n3;
        }
        if (string != null && !string.equals("void")) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(string2).append(string3);
            }
            stringBuffer.append("@return");
        }
        if (stringArray2 != null) {
            n3 = 0;
            while (n3 < stringArray2.length) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(string2).append(string3);
                }
                stringBuffer.append("@throws ").append(stringArray2[n3]);
                ++n3;
            }
        }
        if (bl) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(string2).append(string3);
            }
            stringBuffer.append("@deprecated");
        }
        if (stringBuffer.length() == 0 && StubUtility.isAllCommentWhitespace(string3) && (n3 = iDocument.getLineOfOffset(n) - 1) > 0) {
            IRegion iRegion2 = iDocument.getLineInformation(n3);
            int n4 = iRegion2.getOffset() + iRegion2.getLength();
            iDocument.replace(n4, n + n2 - n4, "");
            return;
        }
        iDocument.replace(n, n2, stringBuffer.toString());
    }

    private static boolean isAllCommentWhitespace(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!Character.isWhitespace(c) && c != '*') {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static String getLineDelimiterUsed(IJavaProject iJavaProject) {
        return StubUtility.getProjectLineDelimiter(iJavaProject);
    }

    private static String getProjectLineDelimiter(IJavaProject iJavaProject) {
        String string;
        IProject iProject = null;
        if (iJavaProject != null) {
            iProject = iJavaProject.getProject();
        }
        if ((string = StubUtility.getLineDelimiterPreference(iProject)) != null) {
            return string;
        }
        return System.getProperty("line.separator", "\n");
    }

    public static String getLineDelimiterPreference(IProject iProject) {
        String string;
        IScopeContext[] iScopeContextArray;
        if (iProject != null) {
            iScopeContextArray = new IScopeContext[]{new ProjectScope(iProject)};
            string = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, iScopeContextArray);
            if (string != null) {
                return string;
            }
        }
        iScopeContextArray = new IScopeContext[]{new InstanceScope()};
        string = System.getProperty("line.separator", "\n");
        return Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", string, iScopeContextArray);
    }

    public static String getLineDelimiterUsed(IJavaElement iJavaElement) {
        while (iJavaElement != null && !(iJavaElement instanceof IOpenable)) {
            iJavaElement = iJavaElement.getParent();
        }
        if (iJavaElement != null) {
            try {
                return ((IOpenable)iJavaElement).findRecommendedLineSeparator();
            }
            catch (JavaModelException javaModelException) {}
        }
        return StubUtility.getProjectLineDelimiter(null);
    }

    public static int getIndentUsed(IJavaElement iJavaElement) throws JavaModelException {
        ICompilationUnit iCompilationUnit;
        if (iJavaElement instanceof ISourceReference && (iCompilationUnit = (ICompilationUnit)iJavaElement.getAncestor(5)) != null) {
            int n;
            IBuffer iBuffer = iCompilationUnit.getBuffer();
            int n2 = n = ((ISourceReference)iJavaElement).getSourceRange().getOffset();
            while (n2 > 0 && !IndentManipulation.isLineDelimiterChar((char)iBuffer.getChar(n2 - 1))) {
                --n2;
            }
            return Strings.computeIndentUnits(iBuffer.getText(n2, n - n2), iJavaElement.getJavaProject());
        }
        return 0;
    }

    public static IJavaElement findNextSibling(IJavaElement iJavaElement) throws JavaModelException {
        IJavaElement iJavaElement2 = iJavaElement.getParent();
        if (iJavaElement2 instanceof IParent) {
            IJavaElement[] iJavaElementArray = ((IParent)iJavaElement2).getChildren();
            int n = iJavaElementArray.length - 2;
            while (n >= 0) {
                if (iJavaElement.equals(iJavaElementArray[n])) {
                    return iJavaElementArray[n + 1];
                }
                --n;
            }
        }
        return null;
    }

    public static String getTodoTaskTag(IJavaProject iJavaProject) {
        String string = null;
        string = iJavaProject == null ? JavaCore.getOption((String)"org.eclipse.wst.jsdt.core.compiler.taskTags") : iJavaProject.getOption("org.eclipse.wst.jsdt.core.compiler.taskTags", true);
        if (string != null && string.length() > 0) {
            int n = string.indexOf(44);
            if (n == -1) {
                return string;
            }
            return string.substring(0, n);
        }
        return null;
    }

    private static String removeTypeArguments(String string) {
        int n = string.indexOf(60);
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String[] getVariableNameSuggestions(int n, IJavaProject iJavaProject, ITypeBinding iTypeBinding, Expression expression, Collection collection) {
        String string;
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (expression != null && (string = StubUtility.getBaseNameFromExpression(iJavaProject, expression, n)) != null) {
            StubUtility.add(StubUtility.getVariableNameSuggestions(n, iJavaProject, string, 0, collection, false), linkedHashSet);
        }
        if (iTypeBinding != null && (iTypeBinding = Bindings.normalizeTypeBinding(iTypeBinding)) != null) {
            String string2;
            int n2 = 0;
            if (iTypeBinding.isArray()) {
                n2 = iTypeBinding.getDimensions();
                iTypeBinding = iTypeBinding.getElementType();
            }
            if (iTypeBinding.isParameterizedType()) {
                iTypeBinding = iTypeBinding.getTypeDeclaration();
            }
            if ((string2 = iTypeBinding.getQualifiedName()).length() > 0) {
                String[] stringArray = StubUtility.getVariableNameSuggestions(n, iJavaProject, string2, n2, collection, false);
                int n3 = 0;
                while (n3 < stringArray.length) {
                    linkedHashSet.add(stringArray[n3]);
                    ++n3;
                }
            }
        }
        if (expression != null && (string = StubUtility.getBaseNameFromLocationInParent(iJavaProject, expression)) != null) {
            StubUtility.add(StubUtility.getVariableNameSuggestions(n, iJavaProject, string, 0, collection, false), linkedHashSet);
        }
        if (linkedHashSet.isEmpty()) {
            return StubUtility.getDefaultVariableNameSuggestions(n, collection);
        }
        return linkedHashSet.toArray(new String[linkedHashSet.size()]);
    }

    public static String[] getVariableNameSuggestions(int n, IJavaProject iJavaProject, Type type, Expression expression, Collection collection) {
        String string;
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (expression != null && (string = StubUtility.getBaseNameFromExpression(iJavaProject, expression, n)) != null) {
            StubUtility.add(StubUtility.getVariableNameSuggestions(n, iJavaProject, string, 0, collection, false), linkedHashSet);
        }
        if (type != null) {
            Object object;
            int n2 = 0;
            if (type.isArrayType()) {
                object = (ArrayType)type;
                n2 = object.getDimensions();
                type = object.getElementType();
            }
            if (type.isParameterizedType()) {
                type = ((ParameterizedType)type).getType();
            }
            if (((String)(object = ASTNodes.asString((ASTNode)type))).length() > 0) {
                String[] stringArray = StubUtility.getVariableNameSuggestions(n, iJavaProject, (String)object, n2, collection, false);
                int n3 = 0;
                while (n3 < stringArray.length) {
                    linkedHashSet.add(stringArray[n3]);
                    ++n3;
                }
            }
        }
        if (expression != null && (string = StubUtility.getBaseNameFromLocationInParent(iJavaProject, expression)) != null) {
            StubUtility.add(StubUtility.getVariableNameSuggestions(n, iJavaProject, string, 0, collection, false), linkedHashSet);
        }
        if (linkedHashSet.isEmpty()) {
            return StubUtility.getDefaultVariableNameSuggestions(n, collection);
        }
        return linkedHashSet.toArray(new String[linkedHashSet.size()]);
    }

    private static String[] getDefaultVariableNameSuggestions(int n, Collection collection) {
        String string;
        String string2 = string = n == 3 ? "X" : "x";
        int n2 = 1;
        while (collection.contains(string2)) {
            string2 = String.valueOf(string) + n2++;
        }
        return new String[]{string2};
    }

    public static String[] getVariableNameSuggestions(int n, IJavaProject iJavaProject, String string, int n2, Collection collection, boolean bl) {
        String string2 = StubUtility.workaround38111(string);
        string2 = StubUtility.removeTypeArguments(string2);
        String string3 = new String();
        String[] stringArray = null;
        switch (n) {
            case 3: {
                stringArray = StubUtility.getConstantSuggestions(iJavaProject, string3, string2, n2, collection);
                break;
            }
            case 1: {
                stringArray = StubUtility.sortByLength(NamingConventions.suggestFieldNames((IJavaProject)iJavaProject, (String)string3, (String)string2, (int)n2, (int)8, (String[])StubUtility.getExcludedArray(collection)));
                break;
            }
            case 2: {
                stringArray = StubUtility.sortByLength(NamingConventions.suggestFieldNames((IJavaProject)iJavaProject, (String)string3, (String)string2, (int)n2, (int)0, (String[])StubUtility.getExcludedArray(collection)));
                break;
            }
            case 4: {
                stringArray = StubUtility.sortByLength(NamingConventions.suggestArgumentNames((IJavaProject)iJavaProject, (String)string3, (String)string2, (int)n2, (String[])StubUtility.getExcludedArray(collection)));
                break;
            }
            case 5: {
                stringArray = StubUtility.sortByLength(NamingConventions.suggestLocalVariableNames((IJavaProject)iJavaProject, (String)string3, (String)string2, (int)n2, (String[])StubUtility.getExcludedArray(collection)));
            }
        }
        if (bl) {
            if (stringArray.length == 0) {
                stringArray = StubUtility.getDefaultVariableNameSuggestions(n, collection);
            }
        } else if (n != 3) {
            String string4 = "NAME";
            if (!string2.toUpperCase().endsWith(string4) && stringArray[0].toUpperCase().endsWith(string4)) {
                return new String[0];
            }
        }
        return stringArray;
    }

    private static String[] getExcludedArray(Collection collection) {
        if (collection == null) {
            return null;
        }
        if (collection instanceof ExcludedCollection) {
            return ((ExcludedCollection)collection).getExcludedArray();
        }
        return collection.toArray(new String[collection.size()]);
    }

    private static void add(String[] stringArray, Set set) {
        int n = 0;
        while (n < stringArray.length) {
            set.add(stringArray[n]);
            ++n;
        }
    }

    private static String getBaseNameFromExpression(IJavaProject iJavaProject, Expression expression, int n) {
        CharSequence charSequence;
        Object object;
        String string = null;
        if (expression instanceof CastExpression) {
            expression = ((CastExpression)expression).getExpression();
        }
        if (expression instanceof Name) {
            Name name = (Name)expression;
            IBinding iBinding = name.resolveBinding();
            if (iBinding instanceof IVariableBinding) {
                return StubUtility.removePrefixAndSuffixForVariable(iJavaProject, (IVariableBinding)iBinding);
            }
            return ASTNodes.getSimpleNameIdentifier(name);
        }
        if (expression instanceof MethodInvocation) {
            object = ((MethodInvocation)expression).getName();
            if (object != null) {
                string = object.getIdentifier();
            }
        } else if (expression instanceof SuperMethodInvocation) {
            string = ((SuperMethodInvocation)expression).getName().getIdentifier();
        } else {
            if (expression instanceof FieldAccess) {
                return ((FieldAccess)expression).getName().getIdentifier();
            }
            if (n == 3 && (expression instanceof StringLiteral || expression instanceof NumberLiteral)) {
                object = expression instanceof StringLiteral ? ((StringLiteral)expression).getLiteralValue() : ((NumberLiteral)expression).getToken();
                charSequence = new StringBuffer();
                boolean bl = false;
                int n2 = 0;
                while (n2 < ((String)object).length()) {
                    char c = ((String)object).charAt(n2);
                    if (Character.isJavaIdentifierPart(c)) {
                        if (((StringBuffer)charSequence).length() == 0 && !Character.isJavaIdentifierStart(c) || bl) {
                            ((StringBuffer)charSequence).append('_');
                        }
                        ((StringBuffer)charSequence).append(c);
                        bl = false;
                    } else {
                        bl = ((StringBuffer)charSequence).length() > 0;
                    }
                    ++n2;
                }
                if (((StringBuffer)charSequence).length() > 0) {
                    return ((StringBuffer)charSequence).toString();
                }
            }
        }
        if (string != null) {
            int n3 = 0;
            while (n3 < KNOWN_METHOD_NAME_PREFIXES.length) {
                charSequence = KNOWN_METHOD_NAME_PREFIXES[n3];
                if (string.startsWith((String)charSequence)) {
                    if (string.equals(charSequence)) {
                        return null;
                    }
                    if (Character.isUpperCase(string.charAt(((String)charSequence).length()))) {
                        return string.substring(((String)charSequence).length());
                    }
                }
                ++n3;
            }
        }
        return string;
    }

    private static String getBaseNameFromLocationInParent(IJavaProject iJavaProject, Expression expression) {
        StructuralPropertyDescriptor structuralPropertyDescriptor = expression.getLocationInParent();
        if (structuralPropertyDescriptor == MethodInvocation.ARGUMENTS_PROPERTY) {
            MethodInvocation methodInvocation = (MethodInvocation)expression.getParent();
            IMethodBinding iMethodBinding = methodInvocation.resolveMethodBinding();
            int n = methodInvocation.arguments().indexOf(expression);
            if (iMethodBinding != null && n != -1) {
                return StubUtility.getParameterName(iMethodBinding, n);
            }
        } else if (structuralPropertyDescriptor == ClassInstanceCreation.ARGUMENTS_PROPERTY) {
            ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)expression.getParent();
            IMethodBinding iMethodBinding = classInstanceCreation.resolveConstructorBinding();
            int n = classInstanceCreation.arguments().indexOf(expression);
            if (iMethodBinding != null && n != -1) {
                return StubUtility.getParameterName(iMethodBinding, n);
            }
        } else if (structuralPropertyDescriptor == SuperMethodInvocation.ARGUMENTS_PROPERTY) {
            SuperMethodInvocation superMethodInvocation = (SuperMethodInvocation)expression.getParent();
            IMethodBinding iMethodBinding = superMethodInvocation.resolveMethodBinding();
            int n = superMethodInvocation.arguments().indexOf(expression);
            if (iMethodBinding != null && n != -1) {
                return StubUtility.getParameterName(iMethodBinding, n);
            }
        } else if (structuralPropertyDescriptor == ConstructorInvocation.ARGUMENTS_PROPERTY) {
            ConstructorInvocation constructorInvocation = (ConstructorInvocation)expression.getParent();
            IMethodBinding iMethodBinding = constructorInvocation.resolveConstructorBinding();
            int n = constructorInvocation.arguments().indexOf(expression);
            if (iMethodBinding != null && n != -1) {
                return StubUtility.getParameterName(iMethodBinding, n);
            }
        } else if (structuralPropertyDescriptor == SuperConstructorInvocation.ARGUMENTS_PROPERTY) {
            SuperConstructorInvocation superConstructorInvocation = (SuperConstructorInvocation)expression.getParent();
            IMethodBinding iMethodBinding = superConstructorInvocation.resolveConstructorBinding();
            int n = superConstructorInvocation.arguments().indexOf(expression);
            if (iMethodBinding != null && n != -1) {
                return StubUtility.getParameterName(iMethodBinding, n);
            }
        }
        return null;
    }

    private static String getParameterName(IMethodBinding iMethodBinding, int n) {
        try {
            String[] stringArray;
            IMethod iMethod;
            IJavaElement iJavaElement = iMethodBinding.getJavaElement();
            if (iJavaElement instanceof IMethod && (iMethod = (IMethod)iJavaElement).getOpenable().getBuffer() != null && n < (stringArray = iMethod.getParameterNames()).length) {
                return NamingConventions.removePrefixAndSuffixForArgumentName((IJavaProject)iMethod.getJavaProject(), (String)stringArray[n]);
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static String[] getArgumentNameSuggestions(IType iType, ICompilationUnit iCompilationUnit, String[] stringArray) {
        String string = iType != null ? JavaModelUtil.getFullyQualifiedName(iType) : iCompilationUnit.getElementName();
        return StubUtility.getVariableNameSuggestions(4, iCompilationUnit.getJavaProject(), string, 0, new ExcludedCollection(stringArray), true);
    }

    public static String[] getArgumentNameSuggestions(IType iType, String[] stringArray) {
        return StubUtility.getVariableNameSuggestions(4, iType.getJavaProject(), JavaModelUtil.getFullyQualifiedName(iType), 0, new ExcludedCollection(stringArray), true);
    }

    public static String[] getArgumentNameSuggestions(IJavaProject iJavaProject, Type type, String[] stringArray) {
        int n = 0;
        if (type.isArrayType()) {
            ArrayType arrayType = (ArrayType)type;
            n = arrayType.getDimensions();
            type = arrayType.getElementType();
        }
        if (type.isParameterizedType()) {
            type = ((ParameterizedType)type).getType();
        }
        return StubUtility.getVariableNameSuggestions(4, iJavaProject, ASTNodes.asString((ASTNode)type), n, new ExcludedCollection(stringArray), true);
    }

    public static String[] getArgumentNameSuggestions(IJavaProject iJavaProject, ITypeBinding iTypeBinding, String[] stringArray) {
        return StubUtility.getVariableNameSuggestions(4, iJavaProject, iTypeBinding, null, (Collection)new ExcludedCollection(stringArray));
    }

    public static String[] getArgumentNameSuggestions(IJavaProject iJavaProject, String string, int n, String[] stringArray) {
        return StubUtility.getVariableNameSuggestions(4, iJavaProject, string, n, new ExcludedCollection(stringArray), true);
    }

    public static String[] getFieldNameSuggestions(IType iType, int n, String[] stringArray) {
        return StubUtility.getFieldNameSuggestions(iType.getJavaProject(), JavaModelUtil.getFullyQualifiedName(iType), 0, n, stringArray);
    }

    public static String[] getFieldNameSuggestions(IJavaProject iJavaProject, String string, int n, int n2, String[] stringArray) {
        if (Flags.isFinal((int)n2) && Flags.isStatic((int)n2)) {
            return StubUtility.getVariableNameSuggestions(3, iJavaProject, string, n, new ExcludedCollection(stringArray), true);
        }
        if (Flags.isStatic((int)n2)) {
            return StubUtility.getVariableNameSuggestions(1, iJavaProject, string, n, new ExcludedCollection(stringArray), true);
        }
        return StubUtility.getVariableNameSuggestions(2, iJavaProject, string, n, new ExcludedCollection(stringArray), true);
    }

    private static String[] getConstantSuggestions(IJavaProject iJavaProject, String string, String string2, int n, Collection collection) {
        String string3 = Signature.getSimpleName((String)string2);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        int n2 = 0;
        while (n2 < string3.length()) {
            char c = string3.charAt(n2);
            if (Character.isUpperCase(c)) {
                if (!bl) {
                    stringBuffer.append('_');
                }
                stringBuffer.append(c);
            } else {
                stringBuffer.append(Character.toUpperCase(c));
                bl = c == '_';
            }
            ++n2;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string4 = iJavaProject.getOption("org.eclipse.wst.jsdt.core.compiler.source", true);
        String string5 = iJavaProject.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true);
        boolean bl2 = true;
        int n3 = 0;
        while (n3 < stringBuffer.length()) {
            char c;
            String string6;
            if (bl2 && !collection.contains(string6 = stringBuffer.substring(n3)) && JavaConventions.validateFieldName((String)string6, (String)string4, (String)string5).isOK()) {
                arrayList.add(string6);
            }
            bl2 = (c = stringBuffer.charAt(n3)) == '_';
            ++n3;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static String getCamelCaseFromUpper(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (Character.isUpperCase(c)) {
                if (!bl) {
                    c = Character.toLowerCase(c);
                }
                stringBuffer.append(c);
                bl = false;
            } else if (c == '_') {
                bl = true;
            } else {
                return string;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String[] getLocalNameSuggestions(IJavaProject iJavaProject, String string, int n, String[] stringArray) {
        return StubUtility.getVariableNameSuggestions(5, iJavaProject, string, n, new ExcludedCollection(stringArray), true);
    }

    private static String[] sortByLength(String[] stringArray) {
        Arrays.sort(stringArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((String)object2).length() - ((String)object).length();
            }
        });
        return stringArray;
    }

    private static String workaround38111(String string) {
        if (BASE_TYPES.contains(string)) {
            return string;
        }
        return String.valueOf(Character.toUpperCase(string.charAt(0))) + string.substring(1);
    }

    public static String suggestArgumentName(IJavaProject iJavaProject, String string, String[] stringArray) {
        return StubUtility.suggestVariableName(4, iJavaProject, string, 0, stringArray);
    }

    private static String suggestVariableName(int n, IJavaProject iJavaProject, String string, int n2, String[] stringArray) {
        return StubUtility.getVariableNameSuggestions(n, iJavaProject, string, n2, new ExcludedCollection(stringArray), true)[0];
    }

    public static String[][] suggestArgumentNamesWithProposals(IJavaProject iJavaProject, String[] stringArray) {
        String[][] stringArray2 = new String[stringArray.length][];
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            String string2 = NamingConventions.removePrefixAndSuffixForArgumentName((IJavaProject)iJavaProject, (String)string);
            String[] stringArray3 = StubUtility.getVariableNameSuggestions(4, iJavaProject, string, 0, arrayList, true);
            if (!string.equals(string2)) {
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                linkedHashSet.add(string);
                int n2 = 0;
                while (n2 < stringArray3.length) {
                    linkedHashSet.add(stringArray3[n2]);
                    ++n2;
                }
                stringArray3 = linkedHashSet.toArray(new String[linkedHashSet.size()]);
            }
            stringArray2[n] = stringArray3;
            arrayList.add(stringArray3[0]);
            ++n;
        }
        return stringArray2;
    }

    public static String[][] suggestArgumentNamesWithProposals(IJavaProject iJavaProject, IMethodBinding iMethodBinding) {
        IMethod iMethod;
        int n = iMethodBinding.getParameterTypes().length;
        if (n > 0) {
            try {
                iMethod = (IMethod)iMethodBinding.getMethodDeclaration().getJavaElement();
                if (iMethod != null) {
                    return StubUtility.suggestArgumentNamesWithProposals(iJavaProject, iMethod.getParameterNames());
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        iMethod = new String[n][];
        int n2 = 0;
        while (n2 < ((IMethod)iMethod).length) {
            iMethod[n2] = new String[]{"arg" + n2};
            ++n2;
        }
        return iMethod;
    }

    public static String[] suggestArgumentNames(IJavaProject iJavaProject, IMethodBinding iMethodBinding) {
        IMethod iMethod;
        int n = iMethodBinding.getParameterTypes().length;
        if (n > 0) {
            try {
                iMethod = (IMethod)iMethodBinding.getMethodDeclaration().getJavaElement();
                if (iMethod != null) {
                    String[] stringArray = iMethod.getParameterNames();
                    String[] stringArray2 = new String[]{};
                    ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        String string = stringArray[n2];
                        String string2 = NamingConventions.removePrefixAndSuffixForArgumentName((IJavaProject)iJavaProject, (String)string);
                        if (!string.equals(string2)) {
                            arrayList.add(string);
                        } else {
                            arrayList.add(StubUtility.suggestArgumentName(iJavaProject, string, stringArray2));
                        }
                        stringArray2 = arrayList.toArray(new String[arrayList.size()]);
                        ++n2;
                    }
                    return stringArray2;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        iMethod = new String[n];
        int n3 = 0;
        while (n3 < ((IMethod)iMethod).length) {
            iMethod[n3] = "arg" + n3;
            ++n3;
        }
        return iMethod;
    }

    public static String removePrefixAndSuffixForVariable(IJavaProject iJavaProject, IVariableBinding iVariableBinding) {
        if (iVariableBinding.isEnumConstant()) {
            return iVariableBinding.getName();
        }
        if (iVariableBinding.isField()) {
            if (Modifier.isStatic(iVariableBinding.getModifiers()) && Modifier.isFinal(iVariableBinding.getModifiers())) {
                return StubUtility.getCamelCaseFromUpper(iVariableBinding.getName());
            }
            return NamingConventions.removePrefixAndSuffixForFieldName((IJavaProject)iJavaProject, (String)iVariableBinding.getName(), (int)iVariableBinding.getModifiers());
        }
        if (iVariableBinding.isParameter()) {
            return NamingConventions.removePrefixAndSuffixForArgumentName((IJavaProject)iJavaProject, (String)iVariableBinding.getName());
        }
        return NamingConventions.removePrefixAndSuffixForLocalVariableName((IJavaProject)iJavaProject, (String)iVariableBinding.getName());
    }

    public static boolean hasFieldName(IJavaProject iJavaProject, String string) {
        String string2 = iJavaProject.getOption("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes", true);
        String string3 = iJavaProject.getOption("org.eclipse.wst.jsdt.core.codeComplete.fieldSuffixes", true);
        String string4 = iJavaProject.getOption("org.eclipse.wst.jsdt.core.codeComplete.staticFieldPrefixes", true);
        String string5 = iJavaProject.getOption("org.eclipse.wst.jsdt.core.codeComplete.staticFieldSuffixes", true);
        return StubUtility.hasPrefixOrSuffix(string2, string3, string) || StubUtility.hasPrefixOrSuffix(string4, string5, string);
    }

    public static boolean hasParameterName(IJavaProject iJavaProject, String string) {
        String string2 = iJavaProject.getOption("org.eclipse.wst.jsdt.core.codeComplete.argumentPrefixes", true);
        String string3 = iJavaProject.getOption("org.eclipse.wst.jsdt.core.codeComplete.argumentSuffixes", true);
        return StubUtility.hasPrefixOrSuffix(string2, string3, string);
    }

    public static boolean hasLocalVariableName(IJavaProject iJavaProject, String string) {
        String string2 = iJavaProject.getOption("org.eclipse.wst.jsdt.core.codeComplete.localPrefixes", true);
        String string3 = iJavaProject.getOption("org.eclipse.wst.jsdt.core.codeComplete.localSuffixes", true);
        return StubUtility.hasPrefixOrSuffix(string2, string3, string);
    }

    public static boolean hasConstantName(String string) {
        return Character.isUpperCase(string.charAt(0));
    }

    private static boolean hasPrefixOrSuffix(String string, String string2, String string3) {
        String string4;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
            if (!string3.startsWith(string4)) continue;
            return true;
        }
        stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
            if (!string3.endsWith(string4)) continue;
            return true;
        }
        return false;
    }

    public static boolean useThisForFieldAccess(IJavaProject iJavaProject) {
        return Boolean.valueOf(PreferenceConstants.getPreference("org.eclipse.wst.jsdt.ui.keywordthis", iJavaProject));
    }

    public static boolean useIsForBooleanGetters(IJavaProject iJavaProject) {
        return Boolean.valueOf(PreferenceConstants.getPreference("org.eclipse.wst.jsdt.ui.gettersetter.use.is", iJavaProject));
    }

    public static String getExceptionVariableName(IJavaProject iJavaProject) {
        return PreferenceConstants.getPreference("org.eclipse.wst.jsdt.ui.exception.name", iJavaProject);
    }

    public static boolean doAddComments(IJavaProject iJavaProject) {
        return Boolean.valueOf(PreferenceConstants.getPreference("org.eclipse.wst.jsdt.ui.javadoc", iJavaProject));
    }

    public static void setCodeTemplate(String string, String string2, IJavaProject iJavaProject) {
        TemplateStore templateStore = JavaPlugin.getDefault().getCodeTemplateStore();
        TemplatePersistenceData templatePersistenceData = templateStore.getTemplateData(string);
        Template template = templatePersistenceData.getTemplate();
        Template template2 = new Template(template.getName(), template.getDescription(), template.getContextTypeId(), string2, true);
        templatePersistenceData.setTemplate(template2);
    }

    private static Template getCodeTemplate(String string, IJavaProject iJavaProject) {
        if (iJavaProject == null) {
            return JavaPlugin.getDefault().getCodeTemplateStore().findTemplateById(string);
        }
        ProjectTemplateStore projectTemplateStore = new ProjectTemplateStore(iJavaProject.getProject());
        try {
            projectTemplateStore.load();
        }
        catch (IOException iOException) {
            JavaPlugin.log(iOException);
        }
        return projectTemplateStore.findTemplateById(string);
    }

    public static ImportRewrite createImportRewrite(ICompilationUnit iCompilationUnit, boolean bl) throws JavaModelException {
        return CodeStyleConfiguration.createImportRewrite(iCompilationUnit, bl);
    }

    public static ImportRewrite createImportRewrite(CompilationUnit compilationUnit, boolean bl) {
        return CodeStyleConfiguration.createImportRewrite(compilationUnit, bl);
    }

    private static class ExcludedCollection
    extends AbstractList {
        private String[] fExcluded;

        public ExcludedCollection(String[] stringArray) {
            this.fExcluded = stringArray;
        }

        public String[] getExcludedArray() {
            return this.fExcluded;
        }

        public int size() {
            return this.fExcluded.length;
        }

        public Object get(int n) {
            return this.fExcluded[n];
        }

        public int indexOf(Object object) {
            if (object instanceof String) {
                int n = 0;
                while (n < this.fExcluded.length) {
                    if (object.equals(this.fExcluded[n])) {
                        return n;
                    }
                    ++n;
                }
            }
            return -1;
        }

        public boolean contains(Object object) {
            return this.indexOf(object) != -1;
        }
    }
}

