/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.dom.fragments;

import org.eclipse.core.runtime.Assert;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.JdtASTMatcher;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.ASTFragment;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.ASTMatchingFragmentFinder;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.IASTFragment;

class SimpleFragment
extends ASTFragment {
    private final ASTNode fNode;

    SimpleFragment(ASTNode aSTNode) {
        Assert.isNotNull((Object)aSTNode);
        this.fNode = aSTNode;
    }

    public IASTFragment[] getMatchingFragmentsWithNode(ASTNode aSTNode) {
        if (!JdtASTMatcher.doNodesMatch(this.getAssociatedNode(), aSTNode)) {
            return new IASTFragment[0];
        }
        IASTFragment iASTFragment = ASTFragmentFactory.createFragmentForFullSubtree(aSTNode);
        Assert.isTrue((iASTFragment.matches(this) || this.matches(iASTFragment) ? 1 : 0) != 0);
        return new IASTFragment[]{iASTFragment};
    }

    public boolean matches(IASTFragment iASTFragment) {
        return iASTFragment.getClass().equals(this.getClass()) && JdtASTMatcher.doNodesMatch(iASTFragment.getAssociatedNode(), this.getAssociatedNode());
    }

    public IASTFragment[] getSubFragmentsMatching(IASTFragment iASTFragment) {
        return ASTMatchingFragmentFinder.findMatchingFragments(this.getAssociatedNode(), (ASTFragment)iASTFragment);
    }

    public int getStartPosition() {
        return this.fNode.getStartPosition();
    }

    public int getLength() {
        return this.fNode.getLength();
    }

    public ASTNode getAssociatedNode() {
        return this.fNode;
    }

    public void replace(ASTRewrite aSTRewrite, ASTNode aSTNode, TextEditGroup textEditGroup) {
        aSTRewrite.replace(this.fNode, aSTNode, textEditGroup);
    }

    public int hashCode() {
        return this.fNode.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SimpleFragment simpleFragment = (SimpleFragment)object;
        return this.fNode.equals((Object)simpleFragment.fNode);
    }
}

