/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.EnhancedForStatement;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.dom.WithStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.fix.AbstractFix;
import org.eclipse.wst.jsdt.internal.corext.fix.FixMessages;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.fix.IFixRewriteOperation;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;

public class ControlStatementsFix
extends AbstractFix {
    public static IFix[] createRemoveBlockFix(CompilationUnit compilationUnit, ASTNode aSTNode) {
        Object object;
        Object object2;
        Statement statement = ASTResolving.findParentStatement(aSTNode);
        if (statement == null) {
            return null;
        }
        if (statement instanceof Block) {
            object2 = (Block)statement;
            if (object2.statements().size() != 1) {
                return null;
            }
            object = object2.getParent();
            if (!(object instanceof Statement)) {
                return null;
            }
            statement = (Statement)object;
        }
        if (statement instanceof IfStatement) {
            IFixRewriteOperation[] iFixRewriteOperationArray;
            object2 = new ArrayList();
            object = new ArrayList();
            IfElseIterator ifElseIterator = new IfElseIterator((IfStatement)statement);
            IfStatement ifStatement = null;
            while (ifElseIterator.hasNext()) {
                ifStatement = ifElseIterator.next();
                if (!RemoveBlockOperation.satisfiesQuickAssistPrecondition((Statement)ifStatement, IfStatement.THEN_STATEMENT_PROPERTY)) continue;
                iFixRewriteOperationArray = new RemoveBlockOperation((Statement)ifStatement, IfStatement.THEN_STATEMENT_PROPERTY);
                object.add(iFixRewriteOperationArray);
                if (ifStatement != statement) continue;
                object2.add(new ControlStatementsFix(FixMessages.ControlStatementsFix_removeIfBlock_proposalDescription, compilationUnit, new IFixRewriteOperation[]{iFixRewriteOperationArray}));
            }
            if (RemoveBlockOperation.satisfiesQuickAssistPrecondition(ifStatement, IfStatement.ELSE_STATEMENT_PROPERTY)) {
                iFixRewriteOperationArray = new RemoveBlockOperation((Statement)ifStatement, IfStatement.ELSE_STATEMENT_PROPERTY);
                object.add(iFixRewriteOperationArray);
                if (ifStatement == statement) {
                    object2.add(new ControlStatementsFix(FixMessages.ControlStatementsFix_removeElseBlock_proposalDescription, compilationUnit, new IFixRewriteOperation[]{iFixRewriteOperationArray}));
                }
            }
            if (object.size() > 1) {
                iFixRewriteOperationArray = object.toArray(new IFixRewriteOperation[object.size()]);
                object2.add(new ControlStatementsFix(FixMessages.ControlStatementsFix_removeIfElseBlock_proposalDescription, compilationUnit, iFixRewriteOperationArray));
            }
            return object2.toArray(new IFix[object2.size()]);
        }
        if (statement instanceof WhileStatement) {
            if (RemoveBlockOperation.satisfiesQuickAssistPrecondition(statement, WhileStatement.BODY_PROPERTY)) {
                object2 = new RemoveBlockOperation(statement, WhileStatement.BODY_PROPERTY);
                return new IFix[]{new ControlStatementsFix(FixMessages.ControlStatementsFix_removeBrackets_proposalDescription, compilationUnit, new IFixRewriteOperation[]{object2})};
            }
        } else if (statement instanceof ForStatement) {
            if (RemoveBlockOperation.satisfiesQuickAssistPrecondition(statement, ForStatement.BODY_PROPERTY)) {
                object2 = new RemoveBlockOperation(statement, ForStatement.BODY_PROPERTY);
                return new IFix[]{new ControlStatementsFix(FixMessages.ControlStatementsFix_removeBrackets_proposalDescription, compilationUnit, new IFixRewriteOperation[]{object2})};
            }
        } else if (statement instanceof ForInStatement) {
            if (RemoveBlockOperation.satisfiesQuickAssistPrecondition(statement, ForInStatement.BODY_PROPERTY)) {
                object2 = new RemoveBlockOperation(statement, ForInStatement.BODY_PROPERTY);
                return new IFix[]{new ControlStatementsFix(FixMessages.ControlStatementsFix_removeBrackets_proposalDescription, compilationUnit, new IFixRewriteOperation[]{object2})};
            }
        } else if (statement instanceof EnhancedForStatement) {
            if (RemoveBlockOperation.satisfiesQuickAssistPrecondition(statement, EnhancedForStatement.BODY_PROPERTY)) {
                object2 = new RemoveBlockOperation(statement, EnhancedForStatement.BODY_PROPERTY);
                return new IFix[]{new ControlStatementsFix(FixMessages.ControlStatementsFix_removeBrackets_proposalDescription, compilationUnit, new IFixRewriteOperation[]{object2})};
            }
        } else if (statement instanceof DoStatement && RemoveBlockOperation.satisfiesQuickAssistPrecondition(statement, DoStatement.BODY_PROPERTY)) {
            object2 = new RemoveBlockOperation(statement, DoStatement.BODY_PROPERTY);
            return new IFix[]{new ControlStatementsFix(FixMessages.ControlStatementsFix_removeBrackets_proposalDescription, compilationUnit, new IFixRewriteOperation[]{object2})};
        }
        return null;
    }

    public static IFix createCleanUp(CompilationUnit compilationUnit, boolean bl, boolean bl2, boolean bl3) throws CoreException {
        if (!(bl || bl2 || bl3)) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        ControlStatementFinder controlStatementFinder = new ControlStatementFinder(bl, bl2, bl3, arrayList);
        compilationUnit.accept((ASTVisitor)controlStatementFinder);
        if (arrayList.isEmpty()) {
            return null;
        }
        IFixRewriteOperation[] iFixRewriteOperationArray = arrayList.toArray(new IFixRewriteOperation[arrayList.size()]);
        return new ControlStatementsFix(FixMessages.ControlStatementsFix_change_name, compilationUnit, iFixRewriteOperationArray);
    }

    protected ControlStatementsFix(String string, CompilationUnit compilationUnit, IFixRewriteOperation[] iFixRewriteOperationArray) {
        super(string, compilationUnit, iFixRewriteOperationArray);
    }

    private static final class AddBlockOperation
    extends AbstractFix.AbstractFixRewriteOperation {
        private final ChildPropertyDescriptor fBodyProperty;
        private final Statement fBody;
        private final Statement fControlStatement;

        public AddBlockOperation(ChildPropertyDescriptor childPropertyDescriptor, Statement statement, Statement statement2) {
            this.fBodyProperty = childPropertyDescriptor;
            this.fBody = statement;
            this.fControlStatement = statement2;
        }

        public void rewriteAST(CompilationUnitRewrite compilationUnitRewrite, List list) throws CoreException {
            ASTRewrite aSTRewrite = compilationUnitRewrite.getASTRewrite();
            String string = this.fBodyProperty == IfStatement.THEN_STATEMENT_PROPERTY ? FixMessages.CodeStyleFix_ChangeIfToBlock_desription : (this.fBodyProperty == IfStatement.ELSE_STATEMENT_PROPERTY ? FixMessages.CodeStyleFix_ChangeElseToBlock_description : FixMessages.CodeStyleFix_ChangeControlToBlock_description);
            TextEditGroup textEditGroup = this.createTextEditGroup(string);
            list.add(textEditGroup);
            ASTNode aSTNode = aSTRewrite.createMoveTarget((ASTNode)this.fBody);
            Block block = compilationUnitRewrite.getRoot().getAST().newBlock();
            block.statements().add(aSTNode);
            aSTRewrite.set((ASTNode)this.fControlStatement, (StructuralPropertyDescriptor)this.fBodyProperty, (Object)block, textEditGroup);
        }
    }

    private static final class ControlStatementFinder
    extends GenericVisitor {
        private final List fResult;
        private final boolean fFindControlStatementsWithoutBlock;
        private final boolean fRemoveUnnecessaryBlocks;
        private final boolean fRemoveUnnecessaryBlocksOnlyWhenReturnOrThrow;

        public ControlStatementFinder(boolean bl, boolean bl2, boolean bl3, List list) {
            this.fFindControlStatementsWithoutBlock = bl;
            this.fRemoveUnnecessaryBlocks = bl2;
            this.fRemoveUnnecessaryBlocksOnlyWhenReturnOrThrow = bl3;
            this.fResult = list;
        }

        public boolean visit(DoStatement doStatement) {
            if (this.fFindControlStatementsWithoutBlock) {
                Statement statement = doStatement.getBody();
                if (!(statement instanceof Block)) {
                    this.fResult.add(new AddBlockOperation(DoStatement.BODY_PROPERTY, statement, (Statement)doStatement));
                }
            } else if ((this.fRemoveUnnecessaryBlocks || this.fRemoveUnnecessaryBlocksOnlyWhenReturnOrThrow) && RemoveBlockOperation.satisfiesCleanUpPrecondition((Statement)doStatement, DoStatement.BODY_PROPERTY, this.fRemoveUnnecessaryBlocksOnlyWhenReturnOrThrow)) {
                this.fResult.add(new RemoveBlockOperation((Statement)doStatement, DoStatement.BODY_PROPERTY));
            }
            return super.visit(doStatement);
        }

        public boolean visit(ForStatement forStatement) {
            if (this.fFindControlStatementsWithoutBlock) {
                Statement statement = forStatement.getBody();
                if (!(statement instanceof Block)) {
                    this.fResult.add(new AddBlockOperation(ForStatement.BODY_PROPERTY, statement, (Statement)forStatement));
                }
            } else if ((this.fRemoveUnnecessaryBlocks || this.fRemoveUnnecessaryBlocksOnlyWhenReturnOrThrow) && RemoveBlockOperation.satisfiesCleanUpPrecondition((Statement)forStatement, ForStatement.BODY_PROPERTY, this.fRemoveUnnecessaryBlocksOnlyWhenReturnOrThrow)) {
                this.fResult.add(new RemoveBlockOperation((Statement)forStatement, ForStatement.BODY_PROPERTY));
            }
            return super.visit(forStatement);
        }

        public boolean visit(EnhancedForStatement enhancedForStatement) {
            if (this.fFindControlStatementsWithoutBlock) {
                Statement statement = enhancedForStatement.getBody();
                if (!(statement instanceof Block)) {
                    this.fResult.add(new AddBlockOperation(EnhancedForStatement.BODY_PROPERTY, statement, (Statement)enhancedForStatement));
                }
            } else if ((this.fRemoveUnnecessaryBlocks || this.fRemoveUnnecessaryBlocksOnlyWhenReturnOrThrow) && RemoveBlockOperation.satisfiesCleanUpPrecondition((Statement)enhancedForStatement, EnhancedForStatement.BODY_PROPERTY, this.fRemoveUnnecessaryBlocksOnlyWhenReturnOrThrow)) {
                this.fResult.add(new RemoveBlockOperation((Statement)enhancedForStatement, EnhancedForStatement.BODY_PROPERTY));
            }
            return super.visit(enhancedForStatement);
        }

        public boolean visit(IfStatement ifStatement) {
            if (this.fFindControlStatementsWithoutBlock) {
                Statement statement;
                Statement statement2 = ifStatement.getThenStatement();
                if (!(statement2 instanceof Block)) {
                    this.fResult.add(new AddBlockOperation(IfStatement.THEN_STATEMENT_PROPERTY, statement2, (Statement)ifStatement));
                }
                if ((statement = ifStatement.getElseStatement()) != null && !(statement instanceof Block) && !(statement instanceof IfStatement)) {
                    this.fResult.add(new AddBlockOperation(IfStatement.ELSE_STATEMENT_PROPERTY, statement, (Statement)ifStatement));
                }
            } else if (this.fRemoveUnnecessaryBlocks || this.fRemoveUnnecessaryBlocksOnlyWhenReturnOrThrow) {
                if (RemoveBlockOperation.satisfiesCleanUpPrecondition((Statement)ifStatement, IfStatement.THEN_STATEMENT_PROPERTY, this.fRemoveUnnecessaryBlocksOnlyWhenReturnOrThrow)) {
                    this.fResult.add(new RemoveBlockOperation((Statement)ifStatement, IfStatement.THEN_STATEMENT_PROPERTY));
                }
                if (!(ifStatement.getElseStatement() instanceof IfStatement) && RemoveBlockOperation.satisfiesCleanUpPrecondition((Statement)ifStatement, IfStatement.ELSE_STATEMENT_PROPERTY, this.fRemoveUnnecessaryBlocksOnlyWhenReturnOrThrow)) {
                    this.fResult.add(new RemoveBlockOperation((Statement)ifStatement, IfStatement.ELSE_STATEMENT_PROPERTY));
                }
            }
            return super.visit(ifStatement);
        }

        public boolean visit(WhileStatement whileStatement) {
            if (this.fFindControlStatementsWithoutBlock) {
                Statement statement = whileStatement.getBody();
                if (!(statement instanceof Block)) {
                    this.fResult.add(new AddBlockOperation(WhileStatement.BODY_PROPERTY, statement, (Statement)whileStatement));
                }
            } else if ((this.fRemoveUnnecessaryBlocks || this.fRemoveUnnecessaryBlocksOnlyWhenReturnOrThrow) && RemoveBlockOperation.satisfiesCleanUpPrecondition((Statement)whileStatement, WhileStatement.BODY_PROPERTY, this.fRemoveUnnecessaryBlocksOnlyWhenReturnOrThrow)) {
                this.fResult.add(new RemoveBlockOperation((Statement)whileStatement, WhileStatement.BODY_PROPERTY));
            }
            return super.visit(whileStatement);
        }

        public boolean visit(WithStatement withStatement) {
            if (this.fFindControlStatementsWithoutBlock) {
                Statement statement = withStatement.getBody();
                if (!(statement instanceof Block)) {
                    this.fResult.add(new AddBlockOperation(WithStatement.BODY_PROPERTY, statement, (Statement)withStatement));
                }
            } else if ((this.fRemoveUnnecessaryBlocks || this.fRemoveUnnecessaryBlocksOnlyWhenReturnOrThrow) && RemoveBlockOperation.satisfiesCleanUpPrecondition((Statement)withStatement, WithStatement.BODY_PROPERTY, this.fRemoveUnnecessaryBlocksOnlyWhenReturnOrThrow)) {
                this.fResult.add(new RemoveBlockOperation((Statement)withStatement, WithStatement.BODY_PROPERTY));
            }
            return super.visit(withStatement);
        }
    }

    private static class IfElseIterator {
        private IfStatement fCursor;

        public IfElseIterator(IfStatement ifStatement) {
            this.fCursor = this.findStart(ifStatement);
        }

        public IfStatement next() {
            if (!this.hasNext()) {
                return null;
            }
            IfStatement ifStatement = this.fCursor;
            this.fCursor = this.fCursor.getElseStatement() instanceof IfStatement ? (IfStatement)this.fCursor.getElseStatement() : null;
            return ifStatement;
        }

        public boolean hasNext() {
            return this.fCursor != null;
        }

        private IfStatement findStart(IfStatement ifStatement) {
            while (ifStatement.getLocationInParent() == IfStatement.ELSE_STATEMENT_PROPERTY) {
                ifStatement = (IfStatement)ifStatement.getParent();
            }
            return ifStatement;
        }
    }

    static class RemoveBlockOperation
    extends AbstractFix.AbstractFixRewriteOperation {
        private final Statement fStatement;
        private final ChildPropertyDescriptor fChild;

        public RemoveBlockOperation(Statement statement, ChildPropertyDescriptor childPropertyDescriptor) {
            this.fStatement = statement;
            this.fChild = childPropertyDescriptor;
        }

        public void rewriteAST(CompilationUnitRewrite compilationUnitRewrite, List list) throws CoreException {
            ASTRewrite aSTRewrite = compilationUnitRewrite.getASTRewrite();
            Block block = (Block)this.fStatement.getStructuralProperty((StructuralPropertyDescriptor)this.fChild);
            Statement statement = (Statement)block.statements().get(0);
            Statement statement2 = (Statement)aSTRewrite.createMoveTarget((ASTNode)statement);
            TextEditGroup textEditGroup = this.createTextEditGroup(FixMessages.ControlStatementsFix_removeBrackets_proposalDescription);
            list.add(textEditGroup);
            aSTRewrite.set((ASTNode)this.fStatement, (StructuralPropertyDescriptor)this.fChild, (Object)statement2, textEditGroup);
        }

        public static boolean satisfiesCleanUpPrecondition(Statement statement, ChildPropertyDescriptor childPropertyDescriptor, boolean bl) {
            return RemoveBlockOperation.satisfiesPrecondition(statement, childPropertyDescriptor, bl, true);
        }

        public static boolean satisfiesQuickAssistPrecondition(Statement statement, ChildPropertyDescriptor childPropertyDescriptor) {
            return RemoveBlockOperation.satisfiesPrecondition(statement, childPropertyDescriptor, false, false);
        }

        private static boolean satisfiesPrecondition(Statement statement, ChildPropertyDescriptor childPropertyDescriptor, boolean bl, boolean bl2) {
            Object object = statement.getStructuralProperty((StructuralPropertyDescriptor)childPropertyDescriptor);
            if (!(object instanceof Block)) {
                return false;
            }
            Block block = (Block)object;
            List list = block.statements();
            if (list.size() != 1) {
                return false;
            }
            ASTNode aSTNode = (ASTNode)list.get(0);
            if (bl && !(aSTNode instanceof ReturnStatement) && !(aSTNode instanceof ThrowStatement)) {
                return false;
            }
            if (statement instanceof IfStatement) {
                if (((IfStatement)statement).getThenStatement() != object) {
                    return true;
                }
                IfStatement ifStatement = (IfStatement)statement;
                if (ifStatement.getElseStatement() == null) {
                    return true;
                }
                return !RemoveBlockOperation.hasUnblockedIf((Statement)aSTNode, bl, bl2);
            }
            if (!RemoveBlockOperation.hasUnblockedIf((Statement)aSTNode, bl, bl2)) {
                return true;
            }
            Statement statement2 = statement;
            ASTNode aSTNode2 = statement2.getParent();
            while (true) {
                Statement statement3 = null;
                if (aSTNode2 instanceof IfStatement) {
                    statement3 = ((IfStatement)aSTNode2).getThenStatement();
                    if (statement3 == statement2 && ((IfStatement)aSTNode2).getElseStatement() != null) {
                        return false;
                    }
                } else if (aSTNode2 instanceof WhileStatement) {
                    statement3 = ((WhileStatement)aSTNode2).getBody();
                } else if (aSTNode2 instanceof WithStatement) {
                    statement3 = ((WithStatement)aSTNode2).getBody();
                } else if (aSTNode2 instanceof DoStatement) {
                    statement3 = ((DoStatement)aSTNode2).getBody();
                } else if (aSTNode2 instanceof ForStatement) {
                    statement3 = ((ForStatement)aSTNode2).getBody();
                } else if (aSTNode2 instanceof EnhancedForStatement) {
                    statement3 = ((EnhancedForStatement)aSTNode2).getBody();
                } else {
                    return true;
                }
                if (statement3 != statement2) {
                    return true;
                }
                statement2 = aSTNode2;
                aSTNode2 = statement2.getParent();
            }
        }

        private static boolean hasUnblockedIf(Statement statement, boolean bl, boolean bl2) {
            while (!(statement instanceof IfStatement)) {
                ChildPropertyDescriptor childPropertyDescriptor = null;
                if (statement instanceof WhileStatement) {
                    childPropertyDescriptor = WhileStatement.BODY_PROPERTY;
                } else if (statement instanceof WithStatement) {
                    childPropertyDescriptor = WithStatement.BODY_PROPERTY;
                } else if (statement instanceof ForStatement) {
                    childPropertyDescriptor = ForStatement.BODY_PROPERTY;
                } else if (statement instanceof EnhancedForStatement) {
                    childPropertyDescriptor = EnhancedForStatement.BODY_PROPERTY;
                } else if (statement instanceof DoStatement) {
                    childPropertyDescriptor = DoStatement.BODY_PROPERTY;
                } else {
                    return false;
                }
                Statement statement2 = (Statement)statement.getStructuralProperty((StructuralPropertyDescriptor)childPropertyDescriptor);
                if (statement2 instanceof Block) {
                    if (!bl2) {
                        return false;
                    }
                    if (!RemoveBlockOperation.satisfiesPrecondition(statement, childPropertyDescriptor, bl, bl2)) {
                        return false;
                    }
                    statement = (Statement)((Block)statement2).statements().get(0);
                    continue;
                }
                statement = statement2;
            }
            return true;
        }
    }
}

