/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring;

import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;

public class ParameterInfo {
    public static final int INDEX_FOR_ADDED = -1;
    public static final String ELLIPSIS = "...";
    private IVariableBinding fOldBinding;
    private ITypeBinding fOldTypeBinding;
    private final String fOldName;
    private final String fOldTypeName;
    private final int fOldIndex;
    private String fNewTypeName;
    private ITypeBinding fNewTypeBinding;
    private String fDefaultValue;
    private String fNewName;
    private boolean fIsDeleted;
    private boolean fCreateField = true;
    private boolean fInlined;
    private boolean fResolve = true;

    public ParameterInfo(String string, String string2, int n) {
        this(null, null, string, string2, n);
    }

    public ParameterInfo(IVariableBinding iVariableBinding, String string, String string2, int n) {
        this(iVariableBinding, null, string, string2, n);
    }

    private ParameterInfo(IVariableBinding iVariableBinding, ITypeBinding iTypeBinding, String string, String string2, int n) {
        this.fOldBinding = iVariableBinding;
        this.fOldTypeBinding = iTypeBinding;
        this.fNewTypeBinding = iTypeBinding;
        this.fOldTypeName = string;
        this.fNewTypeName = string;
        this.fOldName = string2;
        this.fNewName = string2;
        this.fOldIndex = n;
        this.fDefaultValue = "";
        this.fIsDeleted = false;
    }

    public static ParameterInfo createInfoForAddedParameter(String string, String string2) {
        ParameterInfo parameterInfo = new ParameterInfo("", "", -1);
        parameterInfo.setNewTypeName(string);
        parameterInfo.setNewName(string2);
        parameterInfo.setResolve(false);
        return parameterInfo;
    }

    private void setResolve(boolean bl) {
        this.fResolve = bl;
    }

    public static ParameterInfo createInfoForAddedParameter(String string, String string2, String string3) {
        ParameterInfo parameterInfo = new ParameterInfo("", "", -1);
        parameterInfo.setNewTypeName(string);
        parameterInfo.setNewName(string2);
        parameterInfo.setDefaultValue(string3);
        return parameterInfo;
    }

    public static ParameterInfo createInfoForAddedParameter(ITypeBinding iTypeBinding, String string, String string2, String string3) {
        ParameterInfo parameterInfo = new ParameterInfo(null, iTypeBinding, "", "", -1);
        parameterInfo.setNewTypeName(string);
        parameterInfo.setNewName(string2);
        parameterInfo.setDefaultValue(string3);
        return parameterInfo;
    }

    public int getOldIndex() {
        return this.fOldIndex;
    }

    public boolean isDeleted() {
        return this.fIsDeleted;
    }

    public void markAsDeleted() {
        Assert.isTrue((!this.isAdded() ? 1 : 0) != 0);
        this.fIsDeleted = true;
    }

    public boolean isAdded() {
        return this.fOldIndex == -1;
    }

    public boolean isTypeNameChanged() {
        return !this.fOldTypeName.equals(this.fNewTypeName);
    }

    public boolean isRenamed() {
        return !this.fOldName.equals(this.fNewName);
    }

    public boolean isVarargChanged() {
        return this.isOldVarargs() ^ this.isNewVarargs();
    }

    public IVariableBinding getOldBinding() {
        return this.fOldBinding;
    }

    public String getOldTypeName() {
        return this.fOldTypeName;
    }

    public String getNewTypeName() {
        return this.fNewTypeName;
    }

    public void setNewTypeName(String string) {
        Assert.isNotNull((Object)string);
        this.fNewTypeName = string;
    }

    public ITypeBinding getNewTypeBinding() {
        return this.fNewTypeBinding;
    }

    public void setNewTypeBinding(ITypeBinding iTypeBinding) {
        if (this.fResolve) {
            this.fNewTypeBinding = iTypeBinding;
        }
    }

    public boolean isOldVarargs() {
        return ParameterInfo.isVarargs(this.fOldTypeName);
    }

    public boolean isNewVarargs() {
        return ParameterInfo.isVarargs(this.fNewTypeName);
    }

    public String getOldName() {
        return this.fOldName;
    }

    public String getNewName() {
        return this.fNewName;
    }

    public void setNewName(String string) {
        Assert.isNotNull((Object)string);
        this.fNewName = string;
    }

    public String getDefaultValue() {
        return this.fDefaultValue;
    }

    public void setDefaultValue(String string) {
        Assert.isNotNull((Object)string);
        this.fDefaultValue = string;
    }

    public String toString() {
        return String.valueOf(this.fOldTypeName) + " " + this.fOldName + " @" + this.fOldIndex + " -> " + this.fNewTypeName + " " + this.fNewName + ": " + this.fDefaultValue + (this.fIsDeleted ? " (deleted)" : " (stays)");
    }

    public static String stripEllipsis(String string) {
        if (ParameterInfo.isVarargs(string)) {
            return string.substring(0, string.length() - 3);
        }
        return string;
    }

    public static boolean isVarargs(String string) {
        return string.endsWith(ELLIPSIS);
    }

    public ITypeBinding getOldTypeBinding() {
        return this.fOldTypeBinding;
    }

    public boolean isCreateField() {
        return this.fCreateField;
    }

    public void setCreateField(boolean bl) {
        this.fIsDeleted = bl;
        this.fCreateField = bl;
    }

    public void setOldBinding(IVariableBinding iVariableBinding) {
        this.fOldBinding = iVariableBinding;
        this.fOldTypeBinding = iVariableBinding.getType();
        this.fNewTypeBinding = iVariableBinding.getType();
    }

    public void setInlined(boolean bl) {
        this.fInlined = bl;
    }

    public boolean isInlined() {
        return this.fInlined;
    }
}

