/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.fix.CleanUpRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ConvertAnonymousToNestedRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.InlineConstantRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.InlineMethodRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.InlineTempRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.IntroduceFactoryRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.IntroduceIndirectionRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.IntroduceParameterRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ReplaceInvocationsRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.generics.InferTypeArgumentsRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.JavaRenameRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameResourceProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.JavaCopyProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.JavaCopyRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.JavaDeleteProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.JavaDeleteRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.JavaMoveProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.sef.SelfEncapsulateFieldRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ChangeSignatureRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ChangeTypeRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ExtractInterfaceProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ExtractInterfaceRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ExtractSupertypeProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ExtractSupertypeRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.JavaMoveRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.MoveInnerToTopRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.MoveInstanceMethodProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.MoveInstanceMethodRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.MoveStaticMembersProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.PullUpRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.PullUpRefactoringProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.PushDownRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.PushDownRefactoringProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.UseSuperTypeProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.UseSuperTypeRefactoring;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.fix.CleanUpRefactoringWizard;
import org.eclipse.wst.jsdt.internal.ui.fix.ICleanUp;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.wst.jsdt.internal.ui.refactoring.ChangeSignatureWizard;
import org.eclipse.wst.jsdt.internal.ui.refactoring.ChangeTypeWizard;
import org.eclipse.wst.jsdt.internal.ui.refactoring.ConvertAnonymousToNestedWizard;
import org.eclipse.wst.jsdt.internal.ui.refactoring.ExtractInterfaceWizard;
import org.eclipse.wst.jsdt.internal.ui.refactoring.ExtractSupertypeWizard;
import org.eclipse.wst.jsdt.internal.ui.refactoring.InferTypeArgumentsWizard;
import org.eclipse.wst.jsdt.internal.ui.refactoring.InlineConstantWizard;
import org.eclipse.wst.jsdt.internal.ui.refactoring.InlineTempWizard;
import org.eclipse.wst.jsdt.internal.ui.refactoring.IntroduceFactoryWizard;
import org.eclipse.wst.jsdt.internal.ui.refactoring.IntroduceIndirectionWizard;
import org.eclipse.wst.jsdt.internal.ui.refactoring.IntroduceParameterWizard;
import org.eclipse.wst.jsdt.internal.ui.refactoring.MoveInnerToTopWizard;
import org.eclipse.wst.jsdt.internal.ui.refactoring.MoveInstanceMethodWizard;
import org.eclipse.wst.jsdt.internal.ui.refactoring.MoveMembersWizard;
import org.eclipse.wst.jsdt.internal.ui.refactoring.PullUpWizard;
import org.eclipse.wst.jsdt.internal.ui.refactoring.PushDownWizard;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.UseSupertypeWizard;
import org.eclipse.wst.jsdt.internal.ui.refactoring.UserInterfaceStarter;
import org.eclipse.wst.jsdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.wst.jsdt.internal.ui.refactoring.code.InlineMethodWizard;
import org.eclipse.wst.jsdt.internal.ui.refactoring.code.ReplaceInvocationsWizard;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.CreateTargetQueries;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.DeleteUserInterfaceManager;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.NewNameQueries;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.RenameUserInterfaceManager;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgCopyWizard;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgMoveWizard;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgQueries;
import org.eclipse.wst.jsdt.internal.ui.refactoring.sef.SelfEncapsulateFieldWizard;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;
import org.eclipse.wst.jsdt.ui.refactoring.RenameSupport;

public final class RefactoringExecutionStarter {
    private static RenameSupport createRenameSupport(IJavaElement iJavaElement, String string, int n) throws CoreException {
        switch (iJavaElement.getElementType()) {
            case 2: {
                return RenameSupport.create((IJavaProject)iJavaElement, string, n);
            }
            case 3: {
                return RenameSupport.create((IPackageFragmentRoot)iJavaElement, string);
            }
            case 4: {
                return RenameSupport.create((IPackageFragment)iJavaElement, string, n);
            }
            case 5: {
                return RenameSupport.create((ICompilationUnit)iJavaElement, string, n);
            }
            case 7: {
                return RenameSupport.create((IType)iJavaElement, string, n);
            }
            case 9: {
                IMethod iMethod = (IMethod)iJavaElement;
                if (iMethod.isConstructor()) {
                    return RefactoringExecutionStarter.createRenameSupport((IJavaElement)iMethod.getDeclaringType(), string, n);
                }
                return RenameSupport.create((IMethod)iJavaElement, string, n);
            }
            case 8: {
                return RenameSupport.create((IField)iJavaElement, string, n);
            }
            case 15: {
                return RenameSupport.create((ITypeParameter)iJavaElement, string, n);
            }
            case 14: {
                return RenameSupport.create((ILocalVariable)iJavaElement, string, n);
            }
        }
        return null;
    }

    public static void startChangeSignatureRefactoring(IMethod iMethod, final SelectionDispatchAction selectionDispatchAction, final Shell shell) throws JavaModelException {
        if (!RefactoringAvailabilityTester.isChangeSignatureAvailable(iMethod)) {
            return;
        }
        ChangeSignatureRefactoring changeSignatureRefactoring = new ChangeSignatureRefactoring(iMethod);
        UserInterfaceStarter userInterfaceStarter = new UserInterfaceStarter(){

            public final boolean activate(Refactoring refactoring, Shell shell2, int n) throws CoreException {
                RefactoringStatusEntry refactoringStatusEntry;
                RefactoringStatus refactoringStatus = refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
                if (refactoringStatus.hasFatalError() && ((refactoringStatusEntry = refactoringStatus.getEntryMatchingSeverity(4)).getCode() == 1 || refactoringStatusEntry.getCode() == 2)) {
                    String string = refactoringStatusEntry.getMessage();
                    Object object = refactoringStatusEntry.getData();
                    string = String.valueOf(string) + RefactoringMessages.RefactoringErrorDialogUtil_okToPerformQuestion;
                    if (object != null && MessageDialog.openQuestion((Shell)shell, (String)RefactoringMessages.OpenRefactoringWizardAction_refactoring, (String)string)) {
                        StructuredSelection structuredSelection = new StructuredSelection(object);
                        boolean bl = selectionDispatchAction.isEnabled();
                        selectionDispatchAction.selectionChanged((IStructuredSelection)structuredSelection);
                        if (selectionDispatchAction.isEnabled()) {
                            selectionDispatchAction.run((IStructuredSelection)structuredSelection);
                        } else {
                            MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ModifyParameterAction_problem_title, (String)ActionMessages.ModifyParameterAction_problem_message);
                        }
                        selectionDispatchAction.setEnabled(bl);
                    }
                    return false;
                }
                return super.activate(refactoring, shell2, n);
            }
        };
        userInterfaceStarter.initialize(new ChangeSignatureWizard(changeSignatureRefactoring));
        try {
            userInterfaceStarter.activate(changeSignatureRefactoring, shell, 4);
        }
        catch (CoreException coreException) {
            ExceptionHandler.handle(coreException, RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.RefactoringStarter_unexpected_exception);
        }
    }

    public static void startChangeTypeRefactoring(ICompilationUnit iCompilationUnit, Shell shell, int n, int n2) throws JavaModelException {
        ChangeTypeRefactoring changeTypeRefactoring = new ChangeTypeRefactoring(iCompilationUnit, n, n2);
        new RefactoringStarter().activate(changeTypeRefactoring, new ChangeTypeWizard(changeTypeRefactoring), shell, RefactoringMessages.ChangeTypeAction_dialog_title, 4);
    }

    public static void startCleanupRefactoring(ICompilationUnit[] iCompilationUnitArray, ICleanUp[] iCleanUpArray, Shell shell, boolean bl, String string) throws InvocationTargetException, JavaModelException {
        CleanUpRefactoring cleanUpRefactoring = new CleanUpRefactoring(string);
        int n = 0;
        while (n < iCompilationUnitArray.length) {
            cleanUpRefactoring.addCompilationUnit(iCompilationUnitArray[n]);
            ++n;
        }
        if (!bl) {
            n = 0;
            while (n < iCleanUpArray.length) {
                cleanUpRefactoring.addCleanUp(iCleanUpArray[n]);
                ++n;
            }
            Object object = cleanUpRefactoring.getCompilationUnits().length > 1 ? new ProgressMonitorDialog(shell) : PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            RefactoringExecutionHelper refactoringExecutionHelper = new RefactoringExecutionHelper(cleanUpRefactoring, 1, 4, shell, (IRunnableContext)object);
            try {
                refactoringExecutionHelper.perform(true, true);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            CleanUpRefactoringWizard cleanUpRefactoringWizard = new CleanUpRefactoringWizard(cleanUpRefactoring, 2);
            RefactoringStarter refactoringStarter = new RefactoringStarter();
            refactoringStarter.activate(cleanUpRefactoring, cleanUpRefactoringWizard, shell, string, 4);
        }
    }

    public static void startConvertAnonymousRefactoring(ICompilationUnit iCompilationUnit, int n, int n2, Shell shell) throws JavaModelException {
        ConvertAnonymousToNestedRefactoring convertAnonymousToNestedRefactoring = new ConvertAnonymousToNestedRefactoring(iCompilationUnit, n, n2);
        new RefactoringStarter().activate(convertAnonymousToNestedRefactoring, new ConvertAnonymousToNestedWizard(convertAnonymousToNestedRefactoring), shell, RefactoringMessages.ConvertAnonymousToNestedAction_dialog_title, 4);
    }

    public static void startCopyRefactoring(IResource[] iResourceArray, IJavaElement[] iJavaElementArray, Shell shell) throws JavaModelException {
        IReorgPolicy.ICopyPolicy iCopyPolicy = ReorgPolicyFactory.createCopyPolicy(iResourceArray, iJavaElementArray);
        if (iCopyPolicy.canEnable()) {
            JavaCopyProcessor javaCopyProcessor = new JavaCopyProcessor(iCopyPolicy);
            JavaCopyRefactoring javaCopyRefactoring = new JavaCopyRefactoring(javaCopyProcessor);
            ReorgCopyWizard reorgCopyWizard = new ReorgCopyWizard(javaCopyRefactoring);
            javaCopyProcessor.setNewNameQueries(new NewNameQueries((Wizard)reorgCopyWizard));
            javaCopyProcessor.setReorgQueries(new ReorgQueries((Wizard)reorgCopyWizard));
            new RefactoringStarter().activate((Refactoring)javaCopyRefactoring, reorgCopyWizard, shell, RefactoringMessages.OpenRefactoringWizardAction_refactoring, 5);
        }
    }

    public static void startCutRefactoring(Object[] objectArray, Shell shell) throws CoreException, InterruptedException, InvocationTargetException {
        JavaDeleteProcessor javaDeleteProcessor = new JavaDeleteProcessor(objectArray);
        javaDeleteProcessor.setSuggestGetterSetterDeletion(false);
        javaDeleteProcessor.setQueries(new ReorgQueries(shell));
        new RefactoringExecutionHelper((Refactoring)new JavaDeleteRefactoring(javaDeleteProcessor), RefactoringCore.getConditionCheckingFailedSeverity(), 5, shell, (IRunnableContext)new ProgressMonitorDialog(shell)).perform(false, false);
    }

    public static void startDeleteRefactoring(Object[] objectArray, Shell shell) throws CoreException {
        JavaDeleteRefactoring javaDeleteRefactoring = new JavaDeleteRefactoring(new JavaDeleteProcessor(objectArray));
        DeleteUserInterfaceManager.getDefault().getStarter((Refactoring)javaDeleteRefactoring).activate((Refactoring)javaDeleteRefactoring, shell, 5);
    }

    public static void startExtractInterfaceRefactoring(IType iType, Shell shell) throws JavaModelException {
        ExtractInterfaceRefactoring extractInterfaceRefactoring = new ExtractInterfaceRefactoring(new ExtractInterfaceProcessor(iType, JavaPreferencesSettings.getCodeGenerationSettings(iType.getJavaProject())));
        new RefactoringStarter().activate((Refactoring)extractInterfaceRefactoring, new ExtractInterfaceWizard(extractInterfaceRefactoring), shell, RefactoringMessages.OpenRefactoringWizardAction_refactoring, 4);
    }

    public static void startExtractSupertypeRefactoring(IMember[] iMemberArray, Shell shell) throws JavaModelException {
        if (!RefactoringAvailabilityTester.isExtractSupertypeAvailable(iMemberArray)) {
            return;
        }
        IJavaProject iJavaProject = null;
        if (iMemberArray != null && iMemberArray.length > 0) {
            iJavaProject = iMemberArray[0].getJavaProject();
        }
        ExtractSupertypeRefactoring extractSupertypeRefactoring = new ExtractSupertypeRefactoring(new ExtractSupertypeProcessor(iMemberArray, JavaPreferencesSettings.getCodeGenerationSettings(iJavaProject)));
        new RefactoringStarter().activate((Refactoring)extractSupertypeRefactoring, new ExtractSupertypeWizard((Refactoring)extractSupertypeRefactoring), shell, RefactoringMessages.OpenRefactoringWizardAction_refactoring, 4);
    }

    public static void startInferTypeArgumentsRefactoring(IJavaElement[] iJavaElementArray, Shell shell) {
        try {
            if (!RefactoringAvailabilityTester.isInferTypeArgumentsAvailable(iJavaElementArray)) {
                return;
            }
            InferTypeArgumentsRefactoring inferTypeArgumentsRefactoring = new InferTypeArgumentsRefactoring(iJavaElementArray);
            new RefactoringStarter().activate(inferTypeArgumentsRefactoring, new InferTypeArgumentsWizard(inferTypeArgumentsRefactoring), shell, RefactoringMessages.InferTypeArgumentsAction_dialog_title, 4);
        }
        catch (CoreException coreException) {
            ExceptionHandler.handle(coreException, RefactoringMessages.InferTypeArgumentsAction_dialog_title, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    public static boolean startInlineConstantRefactoring(ICompilationUnit iCompilationUnit, CompilationUnit compilationUnit, int n, int n2, Shell shell) throws JavaModelException {
        InlineConstantRefactoring inlineConstantRefactoring = new InlineConstantRefactoring(iCompilationUnit, compilationUnit, n, n2);
        if (!inlineConstantRefactoring.checkStaticFinalConstantNameSelected().hasFatalError()) {
            new RefactoringStarter().activate(inlineConstantRefactoring, new InlineConstantWizard(inlineConstantRefactoring), shell, RefactoringMessages.InlineConstantAction_dialog_title, 4);
            return true;
        }
        return false;
    }

    public static boolean startInlineMethodRefactoring(ITypeRoot iTypeRoot, CompilationUnit compilationUnit, int n, int n2, Shell shell) throws JavaModelException {
        InlineMethodRefactoring inlineMethodRefactoring = InlineMethodRefactoring.create(iTypeRoot, compilationUnit, n, n2);
        if (inlineMethodRefactoring != null) {
            new RefactoringStarter().activate(inlineMethodRefactoring, new InlineMethodWizard(inlineMethodRefactoring), shell, RefactoringMessages.InlineMethodAction_dialog_title, 4);
            return true;
        }
        return false;
    }

    public static boolean startInlineTempRefactoring(ICompilationUnit iCompilationUnit, CompilationUnit compilationUnit, ITextSelection iTextSelection, Shell shell) throws JavaModelException {
        InlineTempRefactoring inlineTempRefactoring = new InlineTempRefactoring(iCompilationUnit, compilationUnit, iTextSelection.getOffset(), iTextSelection.getLength());
        if (!inlineTempRefactoring.checkIfTempSelected().hasFatalError()) {
            new RefactoringStarter().activate(inlineTempRefactoring, new InlineTempWizard(inlineTempRefactoring), shell, RefactoringMessages.InlineTempAction_inline_temp, 5);
            return true;
        }
        return false;
    }

    public static void startIntroduceFactoryRefactoring(ICompilationUnit iCompilationUnit, ITextSelection iTextSelection, Shell shell) throws JavaModelException {
        IntroduceFactoryRefactoring introduceFactoryRefactoring = new IntroduceFactoryRefactoring(iCompilationUnit, iTextSelection.getOffset(), iTextSelection.getLength());
        new RefactoringStarter().activate(introduceFactoryRefactoring, new IntroduceFactoryWizard(introduceFactoryRefactoring, RefactoringMessages.IntroduceFactoryAction_use_factory), shell, RefactoringMessages.IntroduceFactoryAction_dialog_title, 4);
    }

    public static void startIntroduceIndirectionRefactoring(IClassFile iClassFile, int n, int n2, Shell shell) throws JavaModelException {
        IntroduceIndirectionRefactoring introduceIndirectionRefactoring = new IntroduceIndirectionRefactoring(iClassFile, n, n2);
        new RefactoringStarter().activate(introduceIndirectionRefactoring, new IntroduceIndirectionWizard(introduceIndirectionRefactoring, RefactoringMessages.IntroduceIndirectionAction_dialog_title), shell, RefactoringMessages.IntroduceIndirectionAction_dialog_title, 4);
    }

    public static void startIntroduceIndirectionRefactoring(ICompilationUnit iCompilationUnit, int n, int n2, Shell shell) throws JavaModelException {
        IntroduceIndirectionRefactoring introduceIndirectionRefactoring = new IntroduceIndirectionRefactoring(iCompilationUnit, n, n2);
        new RefactoringStarter().activate(introduceIndirectionRefactoring, new IntroduceIndirectionWizard(introduceIndirectionRefactoring, RefactoringMessages.IntroduceIndirectionAction_dialog_title), shell, RefactoringMessages.IntroduceIndirectionAction_dialog_title, 4);
    }

    public static void startIntroduceIndirectionRefactoring(IMethod iMethod, Shell shell) throws JavaModelException {
        IntroduceIndirectionRefactoring introduceIndirectionRefactoring = new IntroduceIndirectionRefactoring(iMethod);
        new RefactoringStarter().activate(introduceIndirectionRefactoring, new IntroduceIndirectionWizard(introduceIndirectionRefactoring, RefactoringMessages.IntroduceIndirectionAction_dialog_title), shell, RefactoringMessages.IntroduceIndirectionAction_dialog_title, 4);
    }

    public static void startIntroduceParameter(ICompilationUnit iCompilationUnit, int n, int n2, Shell shell) throws JavaModelException {
        IntroduceParameterRefactoring introduceParameterRefactoring = new IntroduceParameterRefactoring(iCompilationUnit, n, n2);
        new RefactoringStarter().activate(introduceParameterRefactoring, new IntroduceParameterWizard(introduceParameterRefactoring), shell, RefactoringMessages.IntroduceParameterAction_dialog_title, 4);
    }

    public static void startMoveInnerRefactoring(IType iType, Shell shell) throws JavaModelException {
        if (!RefactoringAvailabilityTester.isMoveInnerAvailable(iType)) {
            return;
        }
        MoveInnerToTopRefactoring moveInnerToTopRefactoring = new MoveInnerToTopRefactoring(iType, JavaPreferencesSettings.getCodeGenerationSettings(iType.getJavaProject()));
        new RefactoringStarter().activate(moveInnerToTopRefactoring, new MoveInnerToTopWizard(moveInnerToTopRefactoring), shell, RefactoringMessages.OpenRefactoringWizardAction_refactoring, 4);
    }

    public static void startMoveMethodRefactoring(IMethod iMethod, Shell shell) throws JavaModelException {
        MoveInstanceMethodRefactoring moveInstanceMethodRefactoring = new MoveInstanceMethodRefactoring(new MoveInstanceMethodProcessor(iMethod, JavaPreferencesSettings.getCodeGenerationSettings(iMethod.getJavaProject())));
        new RefactoringStarter().activate((Refactoring)moveInstanceMethodRefactoring, new MoveInstanceMethodWizard(moveInstanceMethodRefactoring), shell, RefactoringMessages.MoveInstanceMethodAction_dialog_title, 4);
    }

    public static void startMoveRefactoring(IResource[] iResourceArray, IJavaElement[] iJavaElementArray, Shell shell) throws JavaModelException {
        IReorgPolicy.IMovePolicy iMovePolicy = ReorgPolicyFactory.createMovePolicy(iResourceArray, iJavaElementArray);
        if (iMovePolicy.canEnable()) {
            JavaMoveProcessor javaMoveProcessor = new JavaMoveProcessor(iMovePolicy);
            JavaMoveRefactoring javaMoveRefactoring = new JavaMoveRefactoring(javaMoveProcessor);
            ReorgMoveWizard reorgMoveWizard = new ReorgMoveWizard(javaMoveRefactoring);
            javaMoveProcessor.setCreateTargetQueries(new CreateTargetQueries((Wizard)reorgMoveWizard));
            javaMoveProcessor.setReorgQueries(new ReorgQueries((Wizard)reorgMoveWizard));
            new RefactoringStarter().activate((Refactoring)javaMoveRefactoring, reorgMoveWizard, shell, RefactoringMessages.OpenRefactoringWizardAction_refactoring, 2);
        }
    }

    public static void startMoveStaticMembersRefactoring(IMember[] iMemberArray, Shell shell) throws JavaModelException {
        if (!RefactoringAvailabilityTester.isMoveStaticAvailable(iMemberArray)) {
            return;
        }
        HashSet<IMember> hashSet = new HashSet<IMember>();
        hashSet.addAll(Arrays.asList(iMemberArray));
        IMember[] iMemberArray2 = hashSet.toArray(new IMember[hashSet.size()]);
        IJavaProject iJavaProject = null;
        if (iMemberArray2.length > 0) {
            iJavaProject = iMemberArray2[0].getJavaProject();
        }
        JavaMoveRefactoring javaMoveRefactoring = new JavaMoveRefactoring(new MoveStaticMembersProcessor(iMemberArray2, JavaPreferencesSettings.getCodeGenerationSettings(iJavaProject)));
        new RefactoringStarter().activate((Refactoring)javaMoveRefactoring, new MoveMembersWizard(javaMoveRefactoring), shell, RefactoringMessages.OpenRefactoringWizardAction_refactoring, 3);
    }

    public static void startPullUpRefactoring(IMember[] iMemberArray, Shell shell) throws JavaModelException {
        if (!RefactoringAvailabilityTester.isPullUpAvailable(iMemberArray)) {
            return;
        }
        IJavaProject iJavaProject = null;
        if (iMemberArray != null && iMemberArray.length > 0) {
            iJavaProject = iMemberArray[0].getJavaProject();
        }
        PullUpRefactoring pullUpRefactoring = new PullUpRefactoring(new PullUpRefactoringProcessor(iMemberArray, JavaPreferencesSettings.getCodeGenerationSettings(iJavaProject)));
        new RefactoringStarter().activate((Refactoring)pullUpRefactoring, new PullUpWizard(pullUpRefactoring), shell, RefactoringMessages.OpenRefactoringWizardAction_refactoring, 4);
    }

    public static void startPushDownRefactoring(IMember[] iMemberArray, Shell shell) throws JavaModelException {
        if (!RefactoringAvailabilityTester.isPushDownAvailable(iMemberArray)) {
            return;
        }
        PushDownRefactoring pushDownRefactoring = new PushDownRefactoring(new PushDownRefactoringProcessor(iMemberArray));
        new RefactoringStarter().activate((Refactoring)pushDownRefactoring, new PushDownWizard(pushDownRefactoring), shell, RefactoringMessages.OpenRefactoringWizardAction_refactoring, 4);
    }

    public static void startRenameRefactoring(IJavaElement iJavaElement, Shell shell) throws CoreException {
        RenameSupport renameSupport = RefactoringExecutionStarter.createRenameSupport(iJavaElement, null, 1);
        if (renameSupport != null && renameSupport.preCheck().isOK()) {
            renameSupport.openDialog(shell);
        }
    }

    public static void startRenameResourceRefactoring(IResource iResource, Shell shell) throws CoreException {
        JavaRenameRefactoring javaRenameRefactoring = new JavaRenameRefactoring(new RenameResourceProcessor(iResource));
        RenameUserInterfaceManager.getDefault().getStarter((Refactoring)javaRenameRefactoring).activate((Refactoring)javaRenameRefactoring, shell, 2);
    }

    public static void startReplaceInvocationsRefactoring(ITypeRoot iTypeRoot, int n, int n2, Shell shell) throws JavaModelException {
        ReplaceInvocationsRefactoring replaceInvocationsRefactoring = new ReplaceInvocationsRefactoring(iTypeRoot, n, n2);
        new RefactoringStarter().activate(replaceInvocationsRefactoring, new ReplaceInvocationsWizard(replaceInvocationsRefactoring), shell, RefactoringMessages.ReplaceInvocationsAction_dialog_title, 4);
    }

    public static void startReplaceInvocationsRefactoring(IMethod iMethod, Shell shell) throws JavaModelException {
        ReplaceInvocationsRefactoring replaceInvocationsRefactoring = new ReplaceInvocationsRefactoring(iMethod);
        new RefactoringStarter().activate(replaceInvocationsRefactoring, new ReplaceInvocationsWizard(replaceInvocationsRefactoring), shell, RefactoringMessages.ReplaceInvocationsAction_dialog_title, 4);
    }

    public static void startSelfEncapsulateRefactoring(IField iField, Shell shell) {
        try {
            if (!RefactoringAvailabilityTester.isSelfEncapsulateAvailable(iField)) {
                return;
            }
            SelfEncapsulateFieldRefactoring selfEncapsulateFieldRefactoring = new SelfEncapsulateFieldRefactoring(iField);
            new RefactoringStarter().activate(selfEncapsulateFieldRefactoring, new SelfEncapsulateFieldWizard(selfEncapsulateFieldRefactoring), shell, "", 4);
        }
        catch (JavaModelException javaModelException) {
            ExceptionHandler.handle((CoreException)((Object)javaModelException), ActionMessages.SelfEncapsulateFieldAction_dialog_title, ActionMessages.SelfEncapsulateFieldAction_dialog_cannot_perform);
        }
    }

    public static void startUseSupertypeRefactoring(IType iType, Shell shell) throws JavaModelException {
        UseSuperTypeRefactoring useSuperTypeRefactoring = new UseSuperTypeRefactoring(new UseSuperTypeProcessor(iType));
        new RefactoringStarter().activate((Refactoring)useSuperTypeRefactoring, new UseSupertypeWizard(useSuperTypeRefactoring), shell, RefactoringMessages.OpenRefactoringWizardAction_refactoring, 4);
    }

    private RefactoringExecutionStarter() {
    }
}

