/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.internal.corext.util.SearchUtils;

public class SearchResultGroup {
    private final IResource fResouce;
    private final List fSearchMatches;

    public SearchResultGroup(IResource iResource, SearchMatch[] searchMatchArray) {
        Assert.isNotNull((Object)searchMatchArray);
        this.fResouce = iResource;
        this.fSearchMatches = new ArrayList<SearchMatch>(Arrays.asList(searchMatchArray));
    }

    public void add(SearchMatch searchMatch) {
        Assert.isNotNull((Object)searchMatch);
        this.fSearchMatches.add(searchMatch);
    }

    public IResource getResource() {
        return this.fResouce;
    }

    public SearchMatch[] getSearchResults() {
        return this.fSearchMatches.toArray(new SearchMatch[this.fSearchMatches.size()]);
    }

    public static IResource[] getResources(SearchResultGroup[] searchResultGroupArray) {
        HashSet<IResource> hashSet = new HashSet<IResource>(searchResultGroupArray.length);
        int n = 0;
        while (n < searchResultGroupArray.length) {
            hashSet.add(searchResultGroupArray[n].getResource());
            ++n;
        }
        return hashSet.toArray(new IResource[hashSet.size()]);
    }

    public ICompilationUnit getCompilationUnit() {
        if (this.getSearchResults() == null || this.getSearchResults().length == 0) {
            return null;
        }
        return SearchUtils.getCompilationUnit(this.getSearchResults()[0]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.fResouce.getFullPath().toString());
        stringBuffer.append('\n');
        int n = 0;
        while (n < this.fSearchMatches.size()) {
            SearchMatch searchMatch = (SearchMatch)this.fSearchMatches.get(n);
            stringBuffer.append("  ").append(searchMatch.getOffset()).append(", ").append(searchMatch.getLength());
            stringBuffer.append(searchMatch.getAccuracy() == 0 ? "; acc" : "; inacc");
            if (searchMatch.isInsideDocComment()) {
                stringBuffer.append("; inDoc");
            }
            if (searchMatch.getElement() instanceof IJavaElement) {
                stringBuffer.append("; in: ").append(((IJavaElement)searchMatch.getElement()).getElementName());
            }
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }
}

