/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.changes;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DeleteFromClasspathChange;

public class AddToClasspathChange
extends JDTChange {
    private IJavaProject fProjectHandle;
    private IClasspathEntry fEntryToAdd;

    public AddToClasspathChange(IJavaProject iJavaProject, IClasspathEntry iClasspathEntry) {
        this.fProjectHandle = iJavaProject;
        this.fEntryToAdd = iClasspathEntry;
    }

    public AddToClasspathChange(IJavaProject iJavaProject, String string) {
        this(iJavaProject, JavaCore.newSourceEntry((IPath)iJavaProject.getPath().append(string)));
    }

    public AddToClasspathChange(IJavaProject iJavaProject, IPath iPath) {
        this(iJavaProject, JavaCore.newProjectEntry((IPath)iPath));
    }

    public AddToClasspathChange(IJavaProject iJavaProject, int n, IPath iPath, IPath iPath2, IPath iPath3) {
        this(iJavaProject, AddToClasspathChange.createNewClasspathEntry(n, iPath, iPath2, iPath3));
    }

    public RefactoringStatus isValid(IProgressMonitor iProgressMonitor) throws CoreException {
        return super.isValid(iProgressMonitor, 3);
    }

    public Change perform(IProgressMonitor iProgressMonitor) throws CoreException {
        block3: {
            DeleteFromClasspathChange deleteFromClasspathChange;
            iProgressMonitor.beginTask(this.getName(), 1);
            try {
                if (!this.validateClasspath()) break block3;
                this.getJavaProject().setRawClasspath(this.getNewClasspathEntries(), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                IPath iPath = JavaCore.getResolvedClasspathEntry((IClasspathEntry)this.fEntryToAdd).getPath();
                deleteFromClasspathChange = new DeleteFromClasspathChange(iPath, this.getJavaProject());
                Object var3_5 = null;
            }
            catch (Throwable throwable) {
                Object var3_7 = null;
                iProgressMonitor.done();
                throw throwable;
            }
            iProgressMonitor.done();
            return deleteFromClasspathChange;
        }
        NullChange nullChange = new NullChange();
        Object var3_6 = null;
        iProgressMonitor.done();
        return nullChange;
    }

    public boolean validateClasspath() throws JavaModelException {
        IJavaProject iJavaProject = this.getJavaProject();
        IPath iPath = iJavaProject.getOutputLocation();
        IClasspathEntry[] iClasspathEntryArray = this.getNewClasspathEntries();
        return JavaConventions.validateClasspath((IJavaProject)iJavaProject, (IClasspathEntry[])iClasspathEntryArray, (IPath)iPath).isOK();
    }

    private IClasspathEntry[] getNewClasspathEntries() throws JavaModelException {
        IClasspathEntry[] iClasspathEntryArray = this.getJavaProject().getRawClasspath();
        ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>(iClasspathEntryArray.length + 1);
        arrayList.addAll(Arrays.asList(iClasspathEntryArray));
        arrayList.add(this.fEntryToAdd);
        return arrayList.toArray(new IClasspathEntry[arrayList.size()]);
    }

    private static IClasspathEntry createNewClasspathEntry(int n, IPath iPath, IPath iPath2, IPath iPath3) {
        switch (n) {
            case 1: {
                return JavaCore.newLibraryEntry((IPath)iPath, (IPath)iPath2, (IPath)iPath3);
            }
            case 2: {
                return JavaCore.newProjectEntry((IPath)iPath);
            }
            case 3: {
                return JavaCore.newSourceEntry((IPath)iPath);
            }
            case 4: {
                return JavaCore.newVariableEntry((IPath)iPath, (IPath)iPath2, (IPath)iPath3);
            }
            case 5: {
                return JavaCore.newContainerEntry((IPath)iPath);
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private IJavaProject getJavaProject() {
        return this.fProjectHandle;
    }

    public String getName() {
        return String.valueOf(RefactoringCoreMessages.AddToClasspathChange_add) + this.getJavaProject().getElementName();
    }

    public Object getModifiedElement() {
        return this.getJavaProject();
    }

    public IClasspathEntry getClasspathEntry() {
        return this.fEntryToAdd;
    }
}

