/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;
import org.eclipse.wst.jsdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

public class CodeRefactoringUtil {
    public static RefactoringStatus checkMethodSyntaxErrors(int n, int n2, CompilationUnit compilationUnit, String string) {
        SelectionAnalyzer selectionAnalyzer = new SelectionAnalyzer(Selection.createFromStartLength(n, n2), true);
        compilationUnit.accept((ASTVisitor)selectionAnalyzer);
        ASTNode aSTNode = selectionAnalyzer.getLastCoveringNode();
        if (!(aSTNode instanceof Block) || !(aSTNode.getParent() instanceof MethodDeclaration)) {
            return RefactoringStatus.createFatalErrorStatus((String)string);
        }
        if (ASTNodes.getMessages(aSTNode, 0).length == 0) {
            return RefactoringStatus.createFatalErrorStatus((String)string);
        }
        MethodDeclaration methodDeclaration = (MethodDeclaration)aSTNode.getParent();
        Object[] objectArray = new String[]{methodDeclaration.getName().getIdentifier()};
        String string2 = Messages.format(RefactoringCoreMessages.CodeRefactoringUtil_error_message, objectArray);
        return RefactoringStatus.createFatalErrorStatus((String)string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getIndentationLevel(ASTNode aSTNode, ICompilationUnit iCompilationUnit) throws CoreException {
        int n;
        IPath iPath = iCompilationUnit.getCorrespondingResource().getFullPath();
        try {
            FileBuffers.getTextFileBufferManager().connect(iPath, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
            ITextFileBuffer iTextFileBuffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(iPath, LocationKind.IFILE);
            try {
                IRegion iRegion = iTextFileBuffer.getDocument().getLineInformationOfOffset(aSTNode.getStartPosition());
                n = Strings.computeIndentUnits(iTextFileBuffer.getDocument().get(iRegion.getOffset(), iRegion.getLength()), iCompilationUnit.getJavaProject());
            }
            catch (BadLocationException badLocationException) {
                JavaPlugin.log(badLocationException);
                Object var5_8 = null;
                FileBuffers.getTextFileBufferManager().disconnect(iPath, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
                return 0;
            }
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            FileBuffers.getTextFileBufferManager().disconnect(iPath, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
            throw throwable;
        }
        FileBuffers.getTextFileBufferManager().disconnect(iPath, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
        return n;
    }

    private CodeRefactoringUtil() {
    }
}

