/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.ImportReferencesCollector;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.LocalVariableIndex;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.OperatorPrecedence;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ParameterData;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.InOutFlowAnalyzer;

class SourceAnalyzer {
    private ITypeRoot fTypeRoot;
    private MethodDeclaration fDeclaration;
    private Map fParameters;
    private Map fNames;
    private List fImplicitReceivers;
    private boolean fArrayAccess;
    private boolean fHasSuperMethodInvocation;
    private List fTypesToImport;
    private List fStaticsToImport;
    private List fTypeParameterReferences;
    private Map fTypeParameterMapping;
    private List fMethodTypeParameterReferences;
    private Map fMethodTypeParameterMapping;
    private boolean fInterruptedExecutionFlow;
    static /* synthetic */ Class class$0;

    public SourceAnalyzer(ITypeRoot iTypeRoot, MethodDeclaration methodDeclaration) {
        this.fTypeRoot = iTypeRoot;
        this.fDeclaration = methodDeclaration;
    }

    public boolean isExecutionFlowInterrupted() {
        return this.fInterruptedExecutionFlow;
    }

    public RefactoringStatus checkActivation() throws JavaModelException {
        ITypeBinding iTypeBinding;
        List list;
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if (!this.fTypeRoot.isStructureKnown()) {
            refactoringStatus.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_syntax_errors, JavaStatusContext.create(this.fTypeRoot));
            return refactoringStatus;
        }
        IProblem[] iProblemArray = ASTNodes.getProblems((ASTNode)this.fDeclaration, 0, 2);
        if (iProblemArray.length > 0) {
            refactoringStatus.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_declaration_has_errors, JavaStatusContext.create(this.fTypeRoot, (ASTNode)this.fDeclaration));
            return refactoringStatus;
        }
        IMethodBinding iMethodBinding = this.fDeclaration.resolveBinding();
        if (iMethodBinding != null) {
            int n = iMethodBinding.getModifiers();
            if (Modifier.isAbstract((int)n)) {
                refactoringStatus.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_abstract_methods, JavaStatusContext.create(this.fTypeRoot, (ASTNode)this.fDeclaration));
                return refactoringStatus;
            }
            if (Modifier.isNative((int)n)) {
                refactoringStatus.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_native_methods, JavaStatusContext.create(this.fTypeRoot, (ASTNode)this.fDeclaration));
                return refactoringStatus;
            }
        } else {
            refactoringStatus.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_methoddeclaration_has_errors, JavaStatusContext.create(this.fTypeRoot));
            return refactoringStatus;
        }
        ActivationAnalyzer activationAnalyzer = new ActivationAnalyzer();
        this.fDeclaration.accept((ASTVisitor)activationAnalyzer);
        refactoringStatus.merge(activationAnalyzer.status);
        if (!refactoringStatus.hasFatalError()) {
            ITypeBinding[] iTypeBindingArray;
            list = this.fDeclaration.parameters();
            this.fParameters = new HashMap(list.size() * 2);
            iTypeBinding = list.iterator();
            while (iTypeBinding.hasNext()) {
                iTypeBindingArray = (ITypeBinding[])iTypeBinding.next();
                IVariableBinding iVariableBinding = iTypeBindingArray.resolveBinding();
                if (iVariableBinding == null) {
                    refactoringStatus.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_declaration_has_errors, JavaStatusContext.create(this.fTypeRoot, (ASTNode)this.fDeclaration));
                    return refactoringStatus;
                }
                this.fParameters.put(iVariableBinding, iTypeBindingArray.getProperty(ParameterData.PROPERTY));
            }
            this.fNames = new HashMap();
            this.fImplicitReceivers = new ArrayList(2);
            this.fTypeParameterReferences = new ArrayList(0);
            this.fTypeParameterMapping = new HashMap();
            iTypeBinding = iMethodBinding.getDeclaringClass();
            if (iTypeBinding == null) {
                refactoringStatus.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_typedeclaration_has_errors, JavaStatusContext.create(this.fTypeRoot));
                return refactoringStatus;
            }
            iTypeBindingArray = iTypeBinding.getTypeParameters();
            int n = 0;
            while (n < iTypeBindingArray.length) {
                NameData nameData = new NameData(iTypeBindingArray[n].getName());
                this.fTypeParameterReferences.add(nameData);
                this.fTypeParameterMapping.put(iTypeBindingArray[n], nameData);
                ++n;
            }
            this.fMethodTypeParameterReferences = new ArrayList(0);
            this.fMethodTypeParameterMapping = new HashMap();
            IMethodBinding iMethodBinding2 = iMethodBinding;
            iTypeBindingArray = iMethodBinding2.getTypeParameters();
            int n2 = 0;
            while (n2 < iTypeBindingArray.length) {
                NameData nameData = new NameData(iTypeBindingArray[n2].getName());
                this.fMethodTypeParameterReferences.add(nameData);
                this.fMethodTypeParameterMapping.put(iTypeBindingArray[n2], nameData);
                ++n2;
            }
        }
        if (this.fDeclaration.isVarargs()) {
            list = this.fDeclaration.parameters();
            iTypeBinding = new VarargAnalyzer(((SingleVariableDeclaration)list.get(list.size() - 1)).getName().resolveBinding());
            this.fDeclaration.getBody().accept(iTypeBinding);
        }
        return refactoringStatus;
    }

    public void initialize() {
        Block block = this.fDeclaration.getBody();
        this.fTypesToImport = new ArrayList();
        this.fStaticsToImport = new ArrayList();
        ImportReferencesCollector importReferencesCollector = new ImportReferencesCollector(this.fTypeRoot.getJavaProject(), null, this.fTypesToImport, this.fStaticsToImport);
        block.accept((ASTVisitor)importReferencesCollector);
        block.accept((ASTVisitor)new UpdateCollector());
        int n = LocalVariableIndex.perform((BodyDeclaration)this.fDeclaration);
        FlowContext flowContext = new FlowContext(0, n + 1);
        flowContext.setConsiderAccessMode(true);
        flowContext.setComputeMode(FlowContext.MERGE);
        InOutFlowAnalyzer inOutFlowAnalyzer = new InOutFlowAnalyzer(flowContext);
        FlowInfo flowInfo = inOutFlowAnalyzer.perform(this.getStatements());
        Iterator iterator = this.fDeclaration.parameters().iterator();
        while (iterator.hasNext()) {
            SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)iterator.next();
            IVariableBinding iVariableBinding = singleVariableDeclaration.resolveBinding();
            ParameterData parameterData = (ParameterData)singleVariableDeclaration.getProperty(ParameterData.PROPERTY);
            parameterData.setAccessMode(flowInfo.getAccessMode(flowContext, iVariableBinding));
        }
    }

    public Collection getUsedNames() {
        return this.fNames.values();
    }

    public List getImplicitReceivers() {
        return this.fImplicitReceivers;
    }

    public List getTypesToImport() {
        return this.fTypesToImport;
    }

    public List getStaticsToImport() {
        return this.fStaticsToImport;
    }

    public List getTypeParameterReferences() {
        return this.fTypeParameterReferences;
    }

    public List getMethodTypeParameterReferences() {
        return this.fMethodTypeParameterReferences;
    }

    public boolean hasArrayAccess() {
        return this.fArrayAccess;
    }

    public boolean hasSuperMethodInvocation() {
        return this.fHasSuperMethodInvocation;
    }

    private ASTNode[] getStatements() {
        List list = this.fDeclaration.getBody().statements();
        return list.toArray(new ASTNode[list.size()]);
    }

    private class ActivationAnalyzer
    extends ASTVisitor {
        public RefactoringStatus status = new RefactoringStatus();
        private ASTNode fLastNode = this.getLastNode();
        private IMethodBinding fBinding = this.getBinding();

        private ActivationAnalyzer() {
        }

        public boolean visit(ReturnStatement returnStatement) {
            if (returnStatement != this.fLastNode) {
                SourceAnalyzer.this.fInterruptedExecutionFlow = true;
            }
            return true;
        }

        public boolean visit(EnumDeclaration enumDeclaration) {
            return false;
        }

        public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
            return false;
        }

        public boolean visit(TypeDeclaration typeDeclaration) {
            return false;
        }

        public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
            return false;
        }

        public boolean visit(MethodInvocation methodInvocation) {
            IMethodBinding iMethodBinding = methodInvocation.resolveMethodBinding();
            if (iMethodBinding != null) {
                iMethodBinding.getMethodDeclaration();
            }
            if (this.fBinding != null && iMethodBinding != null && this.fBinding.isEqualTo((IBinding)iMethodBinding) && !this.status.hasFatalError()) {
                this.status.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_recursive_call);
                return false;
            }
            return true;
        }

        public boolean visit(SimpleName simpleName) {
            IBinding iBinding = simpleName.resolveBinding();
            if (iBinding == null && !this.status.hasFatalError() && !ASTNodes.isLabel(simpleName)) {
                this.status.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_declaration_has_errors, JavaStatusContext.create(SourceAnalyzer.this.fTypeRoot, (ASTNode)SourceAnalyzer.this.fDeclaration));
                return false;
            }
            return true;
        }

        public boolean visit(ThisExpression thisExpression) {
            if (thisExpression.getQualifier() != null) {
                this.status.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_qualified_this_expressions, JavaStatusContext.create(SourceAnalyzer.this.fTypeRoot, (ASTNode)thisExpression));
                return false;
            }
            return true;
        }

        private ASTNode getLastNode() {
            List list = SourceAnalyzer.this.fDeclaration.getBody().statements();
            if (list.size() == 0) {
                return null;
            }
            return (ASTNode)list.get(list.size() - 1);
        }

        private IMethodBinding getBinding() {
            IMethodBinding iMethodBinding = SourceAnalyzer.this.fDeclaration.resolveBinding();
            if (iMethodBinding != null) {
                return iMethodBinding.getMethodDeclaration();
            }
            return iMethodBinding;
        }
    }

    public static class NameData {
        private String fName;
        private List fReferences;

        public NameData(String string) {
            this.fName = string;
            this.fReferences = new ArrayList(2);
        }

        public String getName() {
            return this.fName;
        }

        public void addReference(SimpleName simpleName) {
            this.fReferences.add(simpleName);
        }

        public List references() {
            return this.fReferences;
        }
    }

    private class UpdateCollector
    extends ASTVisitor {
        private int fTypeCounter;

        private UpdateCollector() {
        }

        public boolean visit(TypeDeclaration typeDeclaration) {
            return this.visitType((AbstractTypeDeclaration)typeDeclaration);
        }

        public void endVisit(TypeDeclaration typeDeclaration) {
            --this.fTypeCounter;
        }

        public boolean visit(EnumDeclaration enumDeclaration) {
            return this.visitType((AbstractTypeDeclaration)enumDeclaration);
        }

        public void endVisit(EnumDeclaration enumDeclaration) {
            --this.fTypeCounter;
        }

        public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
            return this.visitType((AbstractTypeDeclaration)annotationTypeDeclaration);
        }

        public void endVisit(AnnotationTypeDeclaration annotationTypeDeclaration) {
            --this.fTypeCounter;
        }

        private boolean visitType(AbstractTypeDeclaration abstractTypeDeclaration) {
            if (this.fTypeCounter++ == 0) {
                this.addNameReference(abstractTypeDeclaration.getName());
            }
            return true;
        }

        public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
            ++this.fTypeCounter;
            return true;
        }

        public void endVisit(AnonymousClassDeclaration anonymousClassDeclaration) {
            --this.fTypeCounter;
        }

        public boolean visit(FieldAccess fieldAccess) {
            fieldAccess.getExpression().accept((ASTVisitor)this);
            this.addReferencesToName(fieldAccess.getName());
            return false;
        }

        public boolean visit(MethodDeclaration methodDeclaration) {
            if (methodDeclaration.isConstructor()) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                AbstractTypeDeclaration abstractTypeDeclaration = (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)methodDeclaration, clazz);
                NameData nameData = (NameData)SourceAnalyzer.this.fNames.get(abstractTypeDeclaration.getName().resolveBinding());
                if (nameData != null) {
                    nameData.addReference(methodDeclaration.getName());
                }
            }
            return true;
        }

        public boolean visit(MethodInvocation methodInvocation) {
            Expression expression;
            if (this.fTypeCounter == 0 && (expression = methodInvocation.getExpression()) == null && !this.isStaticallyImported((Name)methodInvocation.getName())) {
                SourceAnalyzer.this.fImplicitReceivers.add(methodInvocation);
            }
            return true;
        }

        public boolean visit(SuperMethodInvocation superMethodInvocation) {
            if (this.fTypeCounter == 0) {
                SourceAnalyzer.this.fHasSuperMethodInvocation = true;
            }
            return true;
        }

        public boolean visist(SuperConstructorInvocation superConstructorInvocation) {
            if (this.fTypeCounter == 0) {
                SourceAnalyzer.this.fHasSuperMethodInvocation = true;
            }
            return true;
        }

        public boolean visit(ClassInstanceCreation classInstanceCreation) {
            Expression expression;
            if (this.fTypeCounter == 0 && (expression = classInstanceCreation.getExpression()) == null && classInstanceCreation.resolveTypeBinding().isLocal()) {
                SourceAnalyzer.this.fImplicitReceivers.add(classInstanceCreation);
            }
            return true;
        }

        public boolean visit(SingleVariableDeclaration singleVariableDeclaration) {
            if (this.fTypeCounter == 0) {
                this.addNameReference(singleVariableDeclaration.getName());
            }
            return true;
        }

        public boolean visit(VariableDeclarationFragment variableDeclarationFragment) {
            if (this.fTypeCounter == 0) {
                this.addNameReference(variableDeclarationFragment.getName());
            }
            return true;
        }

        public boolean visit(SimpleName simpleName) {
            this.addReferencesToName(simpleName);
            IBinding iBinding = simpleName.resolveBinding();
            if (iBinding instanceof ITypeBinding) {
                ITypeBinding iTypeBinding = (ITypeBinding)iBinding;
                if (iTypeBinding.isTypeVariable()) {
                    this.addTypeVariableReference(iTypeBinding, simpleName);
                }
            } else if (iBinding instanceof IVariableBinding) {
                int n;
                ASTNode aSTNode;
                ParameterData parameterData;
                IVariableBinding iVariableBinding = (IVariableBinding)iBinding;
                if (iVariableBinding.isField() && !this.isStaticallyImported((Name)simpleName)) {
                    StructuralPropertyDescriptor structuralPropertyDescriptor;
                    Name name = ASTNodes.getTopMostName((Name)simpleName);
                    if ((simpleName == name || simpleName == ASTNodes.getLeftMostSimpleName(name)) && (structuralPropertyDescriptor = simpleName.getLocationInParent()) != SingleVariableDeclaration.NAME_PROPERTY && structuralPropertyDescriptor != VariableDeclarationFragment.NAME_PROPERTY) {
                        SourceAnalyzer.this.fImplicitReceivers.add(simpleName);
                    }
                } else if (!iVariableBinding.isField() && (parameterData = (ParameterData)SourceAnalyzer.this.fParameters.get(iBinding)) != null && (aSTNode = simpleName.getParent()) instanceof Expression && (n = OperatorPrecedence.getValue((Expression)aSTNode)) != -1) {
                    parameterData.setOperatorPrecedence((ASTNode)simpleName, n);
                }
            }
            return true;
        }

        public boolean visit(ThisExpression thisExpression) {
            if (this.fTypeCounter == 0) {
                SourceAnalyzer.this.fImplicitReceivers.add(thisExpression);
            }
            return true;
        }

        private void addReferencesToName(SimpleName simpleName) {
            NameData nameData;
            IBinding iBinding = simpleName.resolveBinding();
            ParameterData parameterData = (ParameterData)SourceAnalyzer.this.fParameters.get(iBinding);
            if (parameterData != null) {
                parameterData.addReference((ASTNode)simpleName);
            }
            if ((nameData = (NameData)SourceAnalyzer.this.fNames.get(iBinding)) != null) {
                nameData.addReference(simpleName);
            }
        }

        private void addNameReference(SimpleName simpleName) {
            SourceAnalyzer.this.fNames.put(simpleName.resolveBinding(), new NameData(simpleName.getIdentifier()));
        }

        private void addTypeVariableReference(ITypeBinding iTypeBinding, SimpleName simpleName) {
            NameData nameData = (NameData)SourceAnalyzer.this.fTypeParameterMapping.get(iTypeBinding);
            if (nameData == null) {
                nameData = (NameData)SourceAnalyzer.this.fMethodTypeParameterMapping.get(iTypeBinding);
            }
            nameData.addReference(simpleName);
        }

        private boolean isStaticallyImported(Name name) {
            return SourceAnalyzer.this.fStaticsToImport.contains(name);
        }
    }

    private class VarargAnalyzer
    extends ASTVisitor {
        private IBinding fParameter;

        public VarargAnalyzer(IBinding iBinding) {
            this.fParameter = iBinding;
        }

        public boolean visit(ArrayAccess arrayAccess) {
            Expression expression = arrayAccess.getArray();
            if (expression instanceof SimpleName && this.fParameter.isEqualTo(((SimpleName)expression).resolveBinding())) {
                SourceAnalyzer.this.fArrayAccess = true;
            }
            return true;
        }
    }
}

