/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.ArrayCreation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.AssertStatement;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BooleanLiteral;
import org.eclipse.wst.jsdt.core.dom.BreakStatement;
import org.eclipse.wst.jsdt.core.dom.CastExpression;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.CharacterLiteral;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.ContinueStatement;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.EmptyStatement;
import org.eclipse.wst.jsdt.core.dom.EnhancedForStatement;
import org.eclipse.wst.jsdt.core.dom.EnumConstantDeclaration;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.InstanceofExpression;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.LabeledStatement;
import org.eclipse.wst.jsdt.core.dom.ListExpression;
import org.eclipse.wst.jsdt.core.dom.MarkerAnnotation;
import org.eclipse.wst.jsdt.core.dom.MemberValuePair;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NormalAnnotation;
import org.eclipse.wst.jsdt.core.dom.NullLiteral;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleMemberAnnotation;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.SynchronizedStatement;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.TypeLiteral;
import org.eclipse.wst.jsdt.core.dom.TypeParameter;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.dom.WildcardType;
import org.eclipse.wst.jsdt.core.dom.WithStatement;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.BlockFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.BranchFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.ConditionalFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.DoWhileFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.EnhancedForFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.ForFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.GenericSequentialFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.IfFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.LocalFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.MessageSendFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.ReturnFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.SwitchFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.ThrowFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.TryFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.TypeVariableFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.WhileFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.WithFlowInfo;

abstract class FlowAnalyzer
extends GenericVisitor {
    private HashMap fData = new HashMap(100);
    FlowContext fFlowContext = null;

    public FlowAnalyzer(FlowContext flowContext) {
        this.fFlowContext = flowContext;
    }

    protected abstract boolean createReturnFlowInfo(ReturnStatement var1);

    protected abstract boolean traverseNode(ASTNode var1);

    protected boolean skipNode(ASTNode aSTNode) {
        return !this.traverseNode(aSTNode);
    }

    protected final boolean visitNode(ASTNode aSTNode) {
        return this.traverseNode(aSTNode);
    }

    protected ReturnFlowInfo createReturn(ReturnStatement returnStatement) {
        return new ReturnFlowInfo(returnStatement);
    }

    protected ThrowFlowInfo createThrow() {
        return new ThrowFlowInfo();
    }

    protected BranchFlowInfo createBranch(SimpleName simpleName) {
        return new BranchFlowInfo(simpleName, this.fFlowContext);
    }

    protected GenericSequentialFlowInfo createSequential() {
        return new GenericSequentialFlowInfo();
    }

    protected ConditionalFlowInfo createConditional() {
        return new ConditionalFlowInfo();
    }

    protected EnhancedForFlowInfo createEnhancedFor() {
        return new EnhancedForFlowInfo();
    }

    protected ForFlowInfo createFor() {
        return new ForFlowInfo();
    }

    protected TryFlowInfo createTry() {
        return new TryFlowInfo();
    }

    protected WhileFlowInfo createWhile() {
        return new WhileFlowInfo();
    }

    protected WithFlowInfo createWith() {
        return new WithFlowInfo();
    }

    protected IfFlowInfo createIf() {
        return new IfFlowInfo();
    }

    protected DoWhileFlowInfo createDoWhile() {
        return new DoWhileFlowInfo();
    }

    protected SwitchFlowInfo createSwitch() {
        return new SwitchFlowInfo();
    }

    protected BlockFlowInfo createBlock() {
        return new BlockFlowInfo();
    }

    protected MessageSendFlowInfo createMessageSendFlowInfo() {
        return new MessageSendFlowInfo();
    }

    protected FlowContext getFlowContext() {
        return this.fFlowContext;
    }

    protected FlowInfo getFlowInfo(ASTNode aSTNode) {
        return (FlowInfo)this.fData.remove(aSTNode);
    }

    protected void setFlowInfo(ASTNode aSTNode, FlowInfo flowInfo) {
        this.fData.put(aSTNode, flowInfo);
    }

    protected FlowInfo assignFlowInfo(ASTNode aSTNode, ASTNode aSTNode2) {
        FlowInfo flowInfo = this.getFlowInfo(aSTNode2);
        this.setFlowInfo(aSTNode, flowInfo);
        return flowInfo;
    }

    protected FlowInfo accessFlowInfo(ASTNode aSTNode) {
        return (FlowInfo)this.fData.get(aSTNode);
    }

    protected GenericSequentialFlowInfo processSequential(ASTNode aSTNode, List list) {
        GenericSequentialFlowInfo genericSequentialFlowInfo = this.createSequential(aSTNode);
        this.process(genericSequentialFlowInfo, list);
        return genericSequentialFlowInfo;
    }

    protected GenericSequentialFlowInfo processSequential(ASTNode aSTNode, ASTNode aSTNode2) {
        GenericSequentialFlowInfo genericSequentialFlowInfo = this.createSequential(aSTNode);
        if (aSTNode2 != null) {
            genericSequentialFlowInfo.merge(this.getFlowInfo(aSTNode2), this.fFlowContext);
        }
        return genericSequentialFlowInfo;
    }

    protected GenericSequentialFlowInfo processSequential(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3) {
        GenericSequentialFlowInfo genericSequentialFlowInfo = this.createSequential(aSTNode);
        if (aSTNode2 != null) {
            genericSequentialFlowInfo.merge(this.getFlowInfo(aSTNode2), this.fFlowContext);
        }
        if (aSTNode3 != null) {
            genericSequentialFlowInfo.merge(this.getFlowInfo(aSTNode3), this.fFlowContext);
        }
        return genericSequentialFlowInfo;
    }

    protected GenericSequentialFlowInfo createSequential(ASTNode aSTNode) {
        GenericSequentialFlowInfo genericSequentialFlowInfo = this.createSequential();
        this.setFlowInfo(aSTNode, genericSequentialFlowInfo);
        return genericSequentialFlowInfo;
    }

    protected GenericSequentialFlowInfo createSequential(List list) {
        GenericSequentialFlowInfo genericSequentialFlowInfo = this.createSequential();
        this.process(genericSequentialFlowInfo, list);
        return genericSequentialFlowInfo;
    }

    protected void process(GenericSequentialFlowInfo genericSequentialFlowInfo, List list) {
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            genericSequentialFlowInfo.merge(this.getFlowInfo((ASTNode)iterator.next()), this.fFlowContext);
        }
    }

    protected void process(GenericSequentialFlowInfo genericSequentialFlowInfo, ASTNode aSTNode) {
        if (aSTNode != null) {
            genericSequentialFlowInfo.merge(this.getFlowInfo(aSTNode), this.fFlowContext);
        }
    }

    protected void process(GenericSequentialFlowInfo genericSequentialFlowInfo, ASTNode aSTNode, ASTNode aSTNode2) {
        if (aSTNode != null) {
            genericSequentialFlowInfo.merge(this.getFlowInfo(aSTNode), this.fFlowContext);
        }
        if (aSTNode2 != null) {
            genericSequentialFlowInfo.merge(this.getFlowInfo(aSTNode2), this.fFlowContext);
        }
    }

    public boolean visit(EmptyStatement emptyStatement) {
        return false;
    }

    public boolean visit(TryStatement tryStatement) {
        if (this.traverseNode((ASTNode)tryStatement)) {
            this.fFlowContext.pushExcptions(tryStatement);
            tryStatement.getBody().accept((ASTVisitor)this);
            this.fFlowContext.popExceptions();
            List list = tryStatement.catchClauses();
            Block block = list.iterator();
            while (block.hasNext()) {
                ((CatchClause)block.next()).accept((ASTVisitor)this);
            }
            block = tryStatement.getFinally();
            if (block != null) {
                block.accept((ASTVisitor)this);
            }
        }
        return false;
    }

    protected SwitchData createSwitchData(SwitchStatement switchStatement) {
        SwitchData switchData = new SwitchData();
        List list = switchStatement.statements();
        if (list.isEmpty()) {
            return switchData;
        }
        int n = -1;
        int n2 = -1;
        GenericSequentialFlowInfo genericSequentialFlowInfo = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            if (statement instanceof SwitchCase) {
                SwitchCase switchCase = (SwitchCase)statement;
                if (switchCase.isDefault()) {
                    switchData.setHasDefaultCase();
                }
                if (genericSequentialFlowInfo == null) {
                    genericSequentialFlowInfo = this.createSequential();
                    n = statement.getStartPosition();
                } else if (genericSequentialFlowInfo.isReturn() || genericSequentialFlowInfo.isPartialReturn() || genericSequentialFlowInfo.branches()) {
                    switchData.add((IRegion)new Region(n, n2 - n + 1), genericSequentialFlowInfo);
                    genericSequentialFlowInfo = this.createSequential();
                    n = statement.getStartPosition();
                }
            } else {
                genericSequentialFlowInfo.merge(this.getFlowInfo((ASTNode)statement), this.fFlowContext);
            }
            n2 = statement.getStartPosition() + statement.getLength() - 1;
        }
        switchData.add((IRegion)new Region(n, n2 - n + 1), genericSequentialFlowInfo);
        return switchData;
    }

    protected void endVisit(SwitchStatement switchStatement, SwitchData switchData) {
        SwitchFlowInfo switchFlowInfo = this.createSwitch();
        this.setFlowInfo((ASTNode)switchStatement, switchFlowInfo);
        switchFlowInfo.mergeTest(this.getFlowInfo((ASTNode)switchStatement.getExpression()), this.fFlowContext);
        FlowInfo[] flowInfoArray = switchData.getInfos();
        int n = 0;
        while (n < flowInfoArray.length) {
            switchFlowInfo.mergeCase(flowInfoArray[n], this.fFlowContext);
            ++n;
        }
        switchFlowInfo.mergeDefault(switchData.hasDefaultCase(), this.fFlowContext);
        switchFlowInfo.removeLabel(null);
    }

    public void endVisit(AnnotationTypeDeclaration annotationTypeDeclaration) {
        if (this.skipNode((ASTNode)annotationTypeDeclaration)) {
            return;
        }
        GenericSequentialFlowInfo genericSequentialFlowInfo = this.processSequential((ASTNode)annotationTypeDeclaration, annotationTypeDeclaration.bodyDeclarations());
        genericSequentialFlowInfo.setNoReturn();
    }

    public void endVisit(AnnotationTypeMemberDeclaration annotationTypeMemberDeclaration) {
        if (this.skipNode((ASTNode)annotationTypeMemberDeclaration)) {
            return;
        }
        GenericSequentialFlowInfo genericSequentialFlowInfo = this.processSequential((ASTNode)annotationTypeMemberDeclaration, (ASTNode)annotationTypeMemberDeclaration.getType(), (ASTNode)annotationTypeMemberDeclaration.getDefault());
        genericSequentialFlowInfo.setNoReturn();
    }

    public void endVisit(AnonymousClassDeclaration anonymousClassDeclaration) {
        if (this.skipNode((ASTNode)anonymousClassDeclaration)) {
            return;
        }
        GenericSequentialFlowInfo genericSequentialFlowInfo = this.processSequential((ASTNode)anonymousClassDeclaration, anonymousClassDeclaration.bodyDeclarations());
        genericSequentialFlowInfo.setNoReturn();
    }

    public void endVisit(ArrayAccess arrayAccess) {
        if (this.skipNode((ASTNode)arrayAccess)) {
            return;
        }
        this.processSequential((ASTNode)arrayAccess, (ASTNode)arrayAccess.getArray(), (ASTNode)arrayAccess.getIndex());
    }

    public void endVisit(ArrayCreation arrayCreation) {
        if (this.skipNode((ASTNode)arrayCreation)) {
            return;
        }
        GenericSequentialFlowInfo genericSequentialFlowInfo = this.processSequential((ASTNode)arrayCreation, (ASTNode)arrayCreation.getType());
        this.process(genericSequentialFlowInfo, arrayCreation.dimensions());
        this.process(genericSequentialFlowInfo, (ASTNode)arrayCreation.getInitializer());
    }

    public void endVisit(ArrayInitializer arrayInitializer) {
        if (this.skipNode((ASTNode)arrayInitializer)) {
            return;
        }
        this.processSequential((ASTNode)arrayInitializer, arrayInitializer.expressions());
    }

    public void endVisit(ArrayType arrayType) {
        if (this.skipNode((ASTNode)arrayType)) {
            return;
        }
        this.processSequential((ASTNode)arrayType, (ASTNode)arrayType.getElementType());
    }

    public void endVisit(AssertStatement assertStatement) {
        if (this.skipNode((ASTNode)assertStatement)) {
            return;
        }
        IfFlowInfo ifFlowInfo = new IfFlowInfo();
        this.setFlowInfo((ASTNode)assertStatement, ifFlowInfo);
        ifFlowInfo.mergeCondition(this.getFlowInfo((ASTNode)assertStatement.getExpression()), this.fFlowContext);
        ifFlowInfo.merge(this.getFlowInfo((ASTNode)assertStatement.getMessage()), null, this.fFlowContext);
    }

    public void endVisit(Assignment assignment) {
        FlowInfo flowInfo;
        if (this.skipNode((ASTNode)assignment)) {
            return;
        }
        FlowInfo flowInfo2 = this.getFlowInfo((ASTNode)assignment.getLeftHandSide());
        FlowInfo flowInfo3 = this.getFlowInfo((ASTNode)assignment.getRightHandSide());
        if (flowInfo2 instanceof LocalFlowInfo) {
            flowInfo = (LocalFlowInfo)flowInfo2;
            ((LocalFlowInfo)flowInfo).setWriteAccess(this.fFlowContext);
            if (assignment.getOperator() != Assignment.Operator.ASSIGN) {
                GenericSequentialFlowInfo genericSequentialFlowInfo = this.createSequential();
                genericSequentialFlowInfo.merge(new LocalFlowInfo((LocalFlowInfo)flowInfo, 2, this.fFlowContext), this.fFlowContext);
                genericSequentialFlowInfo.merge(flowInfo3, this.fFlowContext);
                flowInfo3 = genericSequentialFlowInfo;
            }
        }
        flowInfo = this.createSequential((ASTNode)assignment);
        ((GenericSequentialFlowInfo)flowInfo).merge(flowInfo3, this.fFlowContext);
        ((GenericSequentialFlowInfo)flowInfo).merge(flowInfo2, this.fFlowContext);
    }

    public void endVisit(Block block) {
        if (this.skipNode((ASTNode)block)) {
            return;
        }
        BlockFlowInfo blockFlowInfo = this.createBlock();
        this.setFlowInfo((ASTNode)block, blockFlowInfo);
        this.process((GenericSequentialFlowInfo)blockFlowInfo, block.statements());
    }

    public void endVisit(BooleanLiteral booleanLiteral) {
    }

    public void endVisit(BreakStatement breakStatement) {
        if (this.skipNode((ASTNode)breakStatement)) {
            return;
        }
        this.setFlowInfo((ASTNode)breakStatement, this.createBranch(breakStatement.getLabel()));
    }

    public void endVisit(CastExpression castExpression) {
        if (this.skipNode((ASTNode)castExpression)) {
            return;
        }
        this.processSequential((ASTNode)castExpression, (ASTNode)castExpression.getType(), (ASTNode)castExpression.getExpression());
    }

    public void endVisit(CatchClause catchClause) {
        if (this.skipNode((ASTNode)catchClause)) {
            return;
        }
        this.processSequential((ASTNode)catchClause, (ASTNode)catchClause.getException(), (ASTNode)catchClause.getBody());
    }

    public void endVisit(CharacterLiteral characterLiteral) {
    }

    public void endVisit(ClassInstanceCreation classInstanceCreation) {
        if (this.skipNode((ASTNode)classInstanceCreation)) {
            return;
        }
        GenericSequentialFlowInfo genericSequentialFlowInfo = this.processSequential((ASTNode)classInstanceCreation, (ASTNode)classInstanceCreation.getExpression());
        this.process(genericSequentialFlowInfo, (ASTNode)classInstanceCreation.getType());
        this.process(genericSequentialFlowInfo, classInstanceCreation.arguments());
        this.process(genericSequentialFlowInfo, (ASTNode)classInstanceCreation.getMember());
        this.process(genericSequentialFlowInfo, (ASTNode)classInstanceCreation.getAnonymousClassDeclaration());
    }

    public void endVisit(CompilationUnit compilationUnit) {
        if (this.skipNode((ASTNode)compilationUnit)) {
            return;
        }
        GenericSequentialFlowInfo genericSequentialFlowInfo = this.processSequential((ASTNode)compilationUnit, compilationUnit.imports());
        this.process(genericSequentialFlowInfo, compilationUnit.types());
    }

    public void endVisit(ConditionalExpression conditionalExpression) {
        if (this.skipNode((ASTNode)conditionalExpression)) {
            return;
        }
        ConditionalFlowInfo conditionalFlowInfo = this.createConditional();
        this.setFlowInfo((ASTNode)conditionalExpression, conditionalFlowInfo);
        conditionalFlowInfo.mergeCondition(this.getFlowInfo((ASTNode)conditionalExpression.getExpression()), this.fFlowContext);
        conditionalFlowInfo.merge(this.getFlowInfo((ASTNode)conditionalExpression.getThenExpression()), this.getFlowInfo((ASTNode)conditionalExpression.getElseExpression()), this.fFlowContext);
    }

    public void endVisit(ConstructorInvocation constructorInvocation) {
        if (this.skipNode((ASTNode)constructorInvocation)) {
            return;
        }
        this.processSequential((ASTNode)constructorInvocation, constructorInvocation.arguments());
    }

    public void endVisit(ContinueStatement continueStatement) {
        if (this.skipNode((ASTNode)continueStatement)) {
            return;
        }
        this.setFlowInfo((ASTNode)continueStatement, this.createBranch(continueStatement.getLabel()));
    }

    public void endVisit(DoStatement doStatement) {
        if (this.skipNode((ASTNode)doStatement)) {
            return;
        }
        DoWhileFlowInfo doWhileFlowInfo = this.createDoWhile();
        this.setFlowInfo((ASTNode)doStatement, doWhileFlowInfo);
        doWhileFlowInfo.mergeAction(this.getFlowInfo((ASTNode)doStatement.getBody()), this.fFlowContext);
        doWhileFlowInfo.mergeCondition(this.getFlowInfo((ASTNode)doStatement.getExpression()), this.fFlowContext);
        doWhileFlowInfo.removeLabel(null);
    }

    public void endVisit(EmptyStatement emptyStatement) {
    }

    public void endVisit(EnhancedForStatement enhancedForStatement) {
        if (this.skipNode((ASTNode)enhancedForStatement)) {
            return;
        }
        EnhancedForFlowInfo enhancedForFlowInfo = this.createEnhancedFor();
        this.setFlowInfo((ASTNode)enhancedForStatement, enhancedForFlowInfo);
        enhancedForFlowInfo.mergeParameter(this.getFlowInfo((ASTNode)enhancedForStatement.getParameter()), this.fFlowContext);
        enhancedForFlowInfo.mergeExpression(this.getFlowInfo((ASTNode)enhancedForStatement.getExpression()), this.fFlowContext);
        enhancedForFlowInfo.mergeAction(this.getFlowInfo((ASTNode)enhancedForStatement.getBody()), this.fFlowContext);
        enhancedForFlowInfo.removeLabel(null);
    }

    public void endVisit(EnumConstantDeclaration enumConstantDeclaration) {
        if (this.skipNode((ASTNode)enumConstantDeclaration)) {
            return;
        }
        GenericSequentialFlowInfo genericSequentialFlowInfo = this.processSequential((ASTNode)enumConstantDeclaration, enumConstantDeclaration.arguments());
        this.process(genericSequentialFlowInfo, (ASTNode)enumConstantDeclaration.getAnonymousClassDeclaration());
    }

    public void endVisit(EnumDeclaration enumDeclaration) {
        if (this.skipNode((ASTNode)enumDeclaration)) {
            return;
        }
        GenericSequentialFlowInfo genericSequentialFlowInfo = this.processSequential((ASTNode)enumDeclaration, enumDeclaration.superInterfaceTypes());
        this.process(genericSequentialFlowInfo, enumDeclaration.enumConstants());
        this.process(genericSequentialFlowInfo, enumDeclaration.bodyDeclarations());
        genericSequentialFlowInfo.setNoReturn();
    }

    public void endVisit(ExpressionStatement expressionStatement) {
        if (this.skipNode((ASTNode)expressionStatement)) {
            return;
        }
        this.assignFlowInfo((ASTNode)expressionStatement, (ASTNode)expressionStatement.getExpression());
    }

    public void endVisit(FieldAccess fieldAccess) {
        if (this.skipNode((ASTNode)fieldAccess)) {
            return;
        }
        this.processSequential((ASTNode)fieldAccess, (ASTNode)fieldAccess.getExpression(), (ASTNode)fieldAccess.getName());
    }

    public void endVisit(FieldDeclaration fieldDeclaration) {
        if (this.skipNode((ASTNode)fieldDeclaration)) {
            return;
        }
        GenericSequentialFlowInfo genericSequentialFlowInfo = this.processSequential((ASTNode)fieldDeclaration, (ASTNode)fieldDeclaration.getType());
        this.process(genericSequentialFlowInfo, fieldDeclaration.fragments());
    }

    public void endVisit(ForStatement forStatement) {
        if (this.skipNode((ASTNode)forStatement)) {
            return;
        }
        ForFlowInfo forFlowInfo = this.createFor();
        this.setFlowInfo((ASTNode)forStatement, forFlowInfo);
        forFlowInfo.mergeInitializer(this.createSequential(forStatement.initializers()), this.fFlowContext);
        forFlowInfo.mergeCondition(this.getFlowInfo((ASTNode)forStatement.getExpression()), this.fFlowContext);
        forFlowInfo.mergeAction(this.getFlowInfo((ASTNode)forStatement.getBody()), this.fFlowContext);
        forFlowInfo.mergeIncrement(this.createSequential(forStatement.updaters()), this.fFlowContext);
        forFlowInfo.removeLabel(null);
    }

    public void endVisit(ForInStatement forInStatement) {
        if (this.skipNode((ASTNode)forInStatement)) {
            return;
        }
        EnhancedForFlowInfo enhancedForFlowInfo = this.createEnhancedFor();
        this.setFlowInfo((ASTNode)forInStatement, enhancedForFlowInfo);
        enhancedForFlowInfo.mergeParameter(this.getFlowInfo((ASTNode)forInStatement.getIterationVariable()), this.fFlowContext);
        enhancedForFlowInfo.mergeExpression(this.getFlowInfo((ASTNode)forInStatement.getCollection()), this.fFlowContext);
        enhancedForFlowInfo.mergeAction(this.getFlowInfo((ASTNode)forInStatement.getBody()), this.fFlowContext);
        enhancedForFlowInfo.removeLabel(null);
    }

    public void endVisit(IfStatement ifStatement) {
        if (this.skipNode((ASTNode)ifStatement)) {
            return;
        }
        IfFlowInfo ifFlowInfo = this.createIf();
        this.setFlowInfo((ASTNode)ifStatement, ifFlowInfo);
        ifFlowInfo.mergeCondition(this.getFlowInfo((ASTNode)ifStatement.getExpression()), this.fFlowContext);
        ifFlowInfo.merge(this.getFlowInfo((ASTNode)ifStatement.getThenStatement()), this.getFlowInfo((ASTNode)ifStatement.getElseStatement()), this.fFlowContext);
    }

    public void endVisit(ImportDeclaration importDeclaration) {
        if (this.skipNode((ASTNode)importDeclaration)) {
            return;
        }
        this.assignFlowInfo((ASTNode)importDeclaration, (ASTNode)importDeclaration.getName());
    }

    public void endVisit(InfixExpression infixExpression) {
        if (this.skipNode((ASTNode)infixExpression)) {
            return;
        }
        GenericSequentialFlowInfo genericSequentialFlowInfo = this.processSequential((ASTNode)infixExpression, (ASTNode)infixExpression.getLeftOperand(), (ASTNode)infixExpression.getRightOperand());
        this.process(genericSequentialFlowInfo, infixExpression.extendedOperands());
    }

    public void endVisit(InstanceofExpression instanceofExpression) {
        if (this.skipNode((ASTNode)instanceofExpression)) {
            return;
        }
        this.processSequential((ASTNode)instanceofExpression, (ASTNode)instanceofExpression.getLeftOperand(), (ASTNode)instanceofExpression.getRightOperand());
    }

    public void endVisit(Initializer initializer) {
        if (this.skipNode((ASTNode)initializer)) {
            return;
        }
        this.assignFlowInfo((ASTNode)initializer, (ASTNode)initializer.getBody());
    }

    public void endVisit(Javadoc javadoc) {
    }

    public void endVisit(LabeledStatement labeledStatement) {
        if (this.skipNode((ASTNode)labeledStatement)) {
            return;
        }
        FlowInfo flowInfo = this.assignFlowInfo((ASTNode)labeledStatement, (ASTNode)labeledStatement.getBody());
        if (flowInfo != null) {
            flowInfo.removeLabel(labeledStatement.getLabel());
        }
    }

    public void endVisit(ListExpression listExpression) {
        if (this.skipNode((ASTNode)listExpression)) {
            return;
        }
        this.processSequential((ASTNode)listExpression, listExpression.expressions());
    }

    public void endVisit(MarkerAnnotation markerAnnotation) {
    }

    public void endVisit(MemberValuePair memberValuePair) {
        FlowInfo flowInfo;
        if (this.skipNode((ASTNode)memberValuePair)) {
            return;
        }
        FlowInfo flowInfo2 = this.getFlowInfo((ASTNode)memberValuePair.getName());
        FlowInfo flowInfo3 = this.getFlowInfo((ASTNode)memberValuePair.getValue());
        if (flowInfo2 instanceof LocalFlowInfo) {
            flowInfo = (LocalFlowInfo)flowInfo2;
            ((LocalFlowInfo)flowInfo).setWriteAccess(this.fFlowContext);
        }
        flowInfo = this.createSequential((ASTNode)memberValuePair);
        ((GenericSequentialFlowInfo)flowInfo).merge(flowInfo3, this.fFlowContext);
        ((GenericSequentialFlowInfo)flowInfo).merge(flowInfo2, this.fFlowContext);
    }

    public void endVisit(MethodDeclaration methodDeclaration) {
        if (this.skipNode((ASTNode)methodDeclaration)) {
            return;
        }
        GenericSequentialFlowInfo genericSequentialFlowInfo = this.processSequential((ASTNode)methodDeclaration, (ASTNode)methodDeclaration.getReturnType2());
        this.process(genericSequentialFlowInfo, methodDeclaration.parameters());
        this.process(genericSequentialFlowInfo, methodDeclaration.thrownExceptions());
        this.process(genericSequentialFlowInfo, (ASTNode)methodDeclaration.getBody());
    }

    public void endVisit(MethodInvocation methodInvocation) {
        this.endVisitMethodInvocation((ASTNode)methodInvocation, (ASTNode)methodInvocation.getExpression(), methodInvocation.arguments(), this.getMethodBinding((Name)methodInvocation.getName()));
    }

    public void endVisit(NormalAnnotation normalAnnotation) {
        if (this.skipNode((ASTNode)normalAnnotation)) {
            return;
        }
        GenericSequentialFlowInfo genericSequentialFlowInfo = this.processSequential((ASTNode)normalAnnotation, (ASTNode)normalAnnotation.getTypeName());
        this.process(genericSequentialFlowInfo, normalAnnotation.values());
    }

    public void endVisit(NullLiteral nullLiteral) {
    }

    public void endVisit(NumberLiteral numberLiteral) {
    }

    public void endVisit(PackageDeclaration packageDeclaration) {
        if (this.skipNode((ASTNode)packageDeclaration)) {
            return;
        }
        this.assignFlowInfo((ASTNode)packageDeclaration, (ASTNode)packageDeclaration.getName());
    }

    public void endVisit(ParameterizedType parameterizedType) {
        if (this.skipNode((ASTNode)parameterizedType)) {
            return;
        }
        GenericSequentialFlowInfo genericSequentialFlowInfo = this.processSequential((ASTNode)parameterizedType, (ASTNode)parameterizedType.getType());
        this.process(genericSequentialFlowInfo, parameterizedType.typeArguments());
    }

    public void endVisit(ParenthesizedExpression parenthesizedExpression) {
        if (this.skipNode((ASTNode)parenthesizedExpression)) {
            return;
        }
        this.assignFlowInfo((ASTNode)parenthesizedExpression, (ASTNode)parenthesizedExpression.getExpression());
    }

    public void endVisit(PostfixExpression postfixExpression) {
        this.endVisitIncDecOperation((Expression)postfixExpression, postfixExpression.getOperand());
    }

    public void endVisit(PrefixExpression prefixExpression) {
        PrefixExpression.Operator operator = prefixExpression.getOperator();
        if (PrefixExpression.Operator.INCREMENT.equals(operator) || PrefixExpression.Operator.DECREMENT.equals(operator)) {
            this.endVisitIncDecOperation((Expression)prefixExpression, prefixExpression.getOperand());
        } else {
            this.assignFlowInfo((ASTNode)prefixExpression, (ASTNode)prefixExpression.getOperand());
        }
    }

    public void endVisit(PrimitiveType primitiveType) {
    }

    public void endVisit(QualifiedName qualifiedName) {
        if (this.skipNode((ASTNode)qualifiedName)) {
            return;
        }
        this.processSequential((ASTNode)qualifiedName, (ASTNode)qualifiedName.getQualifier(), (ASTNode)qualifiedName.getName());
    }

    public void endVisit(QualifiedType qualifiedType) {
        if (this.skipNode((ASTNode)qualifiedType)) {
            return;
        }
        this.processSequential((ASTNode)qualifiedType, (ASTNode)qualifiedType.getQualifier(), (ASTNode)qualifiedType.getName());
    }

    public void endVisit(ReturnStatement returnStatement) {
        if (this.skipNode((ASTNode)returnStatement)) {
            return;
        }
        if (this.createReturnFlowInfo(returnStatement)) {
            ReturnFlowInfo returnFlowInfo = this.createReturn(returnStatement);
            this.setFlowInfo((ASTNode)returnStatement, returnFlowInfo);
            returnFlowInfo.merge(this.getFlowInfo((ASTNode)returnStatement.getExpression()), this.fFlowContext);
        } else {
            this.assignFlowInfo((ASTNode)returnStatement, (ASTNode)returnStatement.getExpression());
        }
    }

    public void endVisit(SimpleName simpleName) {
        ITypeBinding iTypeBinding;
        if (this.skipNode((ASTNode)simpleName) || simpleName.isDeclaration()) {
            return;
        }
        IBinding iBinding = simpleName.resolveBinding();
        if (iBinding instanceof IVariableBinding) {
            IVariableBinding iVariableBinding = (IVariableBinding)iBinding;
            if (!iVariableBinding.isField() && !iVariableBinding.isGlobal()) {
                this.setFlowInfo((ASTNode)simpleName, new LocalFlowInfo(iVariableBinding, 2, this.fFlowContext));
            }
        } else if (iBinding instanceof ITypeBinding && (iTypeBinding = (ITypeBinding)iBinding).isTypeVariable()) {
            this.setFlowInfo((ASTNode)simpleName, new TypeVariableFlowInfo(iTypeBinding, this.fFlowContext));
        }
    }

    public void endVisit(SimpleType simpleType) {
        if (this.skipNode((ASTNode)simpleType)) {
            return;
        }
        this.assignFlowInfo((ASTNode)simpleType, (ASTNode)simpleType.getName());
    }

    public void endVisit(SingleMemberAnnotation singleMemberAnnotation) {
        if (this.skipNode((ASTNode)singleMemberAnnotation)) {
            return;
        }
        this.assignFlowInfo((ASTNode)singleMemberAnnotation, (ASTNode)singleMemberAnnotation.getValue());
    }

    public void endVisit(SingleVariableDeclaration singleVariableDeclaration) {
        if (this.skipNode((ASTNode)singleVariableDeclaration)) {
            return;
        }
        IVariableBinding iVariableBinding = singleVariableDeclaration.resolveBinding();
        LocalFlowInfo localFlowInfo = null;
        Expression expression = singleVariableDeclaration.getInitializer();
        if (iVariableBinding != null && !iVariableBinding.isField() && expression != null) {
            localFlowInfo = new LocalFlowInfo(iVariableBinding, 8, this.fFlowContext);
        }
        GenericSequentialFlowInfo genericSequentialFlowInfo = this.processSequential((ASTNode)singleVariableDeclaration, (ASTNode)singleVariableDeclaration.getType(), (ASTNode)expression);
        genericSequentialFlowInfo.merge(localFlowInfo, this.fFlowContext);
    }

    public void endVisit(StringLiteral stringLiteral) {
    }

    public void endVisit(SuperConstructorInvocation superConstructorInvocation) {
        this.endVisitMethodInvocation((ASTNode)superConstructorInvocation, (ASTNode)superConstructorInvocation.getExpression(), superConstructorInvocation.arguments(), superConstructorInvocation.resolveConstructorBinding());
    }

    public void endVisit(SuperFieldAccess superFieldAccess) {
        if (this.skipNode((ASTNode)superFieldAccess)) {
            return;
        }
        this.processSequential((ASTNode)superFieldAccess, (ASTNode)superFieldAccess.getQualifier(), (ASTNode)superFieldAccess.getName());
    }

    public void endVisit(SuperMethodInvocation superMethodInvocation) {
        this.endVisitMethodInvocation((ASTNode)superMethodInvocation, (ASTNode)superMethodInvocation.getQualifier(), superMethodInvocation.arguments(), this.getMethodBinding((Name)superMethodInvocation.getName()));
    }

    public void endVisit(SwitchCase switchCase) {
        this.endVisitNode((ASTNode)switchCase);
    }

    public void endVisit(SwitchStatement switchStatement) {
        if (this.skipNode((ASTNode)switchStatement)) {
            return;
        }
        this.endVisit(switchStatement, this.createSwitchData(switchStatement));
    }

    public void endVisit(SynchronizedStatement synchronizedStatement) {
        if (this.skipNode((ASTNode)synchronizedStatement)) {
            return;
        }
        GenericSequentialFlowInfo genericSequentialFlowInfo = this.processSequential((ASTNode)synchronizedStatement, (ASTNode)synchronizedStatement.getExpression());
        this.process(genericSequentialFlowInfo, (ASTNode)synchronizedStatement.getBody());
    }

    public void endVisit(ThisExpression thisExpression) {
        if (this.skipNode((ASTNode)thisExpression)) {
            return;
        }
        this.assignFlowInfo((ASTNode)thisExpression, (ASTNode)thisExpression.getQualifier());
    }

    public void endVisit(ThrowStatement throwStatement) {
        if (this.skipNode((ASTNode)throwStatement)) {
            return;
        }
        ThrowFlowInfo throwFlowInfo = this.createThrow();
        this.setFlowInfo((ASTNode)throwStatement, throwFlowInfo);
        Expression expression = throwStatement.getExpression();
        throwFlowInfo.merge(this.getFlowInfo((ASTNode)expression), this.fFlowContext);
        throwFlowInfo.mergeException(expression.resolveTypeBinding(), this.fFlowContext);
    }

    public void endVisit(TryStatement tryStatement) {
        if (this.skipNode((ASTNode)tryStatement)) {
            return;
        }
        TryFlowInfo tryFlowInfo = this.createTry();
        this.setFlowInfo((ASTNode)tryStatement, tryFlowInfo);
        tryFlowInfo.mergeTry(this.getFlowInfo((ASTNode)tryStatement.getBody()), this.fFlowContext);
        tryFlowInfo.removeExceptions(tryStatement);
        Iterator iterator = tryStatement.catchClauses().iterator();
        while (iterator.hasNext()) {
            CatchClause catchClause = (CatchClause)iterator.next();
            tryFlowInfo.mergeCatch(this.getFlowInfo((ASTNode)catchClause), this.fFlowContext);
        }
        tryFlowInfo.mergeFinally(this.getFlowInfo((ASTNode)tryStatement.getFinally()), this.fFlowContext);
    }

    public void endVisit(TypeDeclaration typeDeclaration) {
        if (this.skipNode((ASTNode)typeDeclaration)) {
            return;
        }
        GenericSequentialFlowInfo genericSequentialFlowInfo = this.processSequential((ASTNode)typeDeclaration, (ASTNode)typeDeclaration.getSuperclassType());
        this.process(genericSequentialFlowInfo, typeDeclaration.superInterfaceTypes());
        this.process(genericSequentialFlowInfo, typeDeclaration.bodyDeclarations());
        genericSequentialFlowInfo.setNoReturn();
    }

    public void endVisit(TypeDeclarationStatement typeDeclarationStatement) {
        if (this.skipNode((ASTNode)typeDeclarationStatement)) {
            return;
        }
        this.assignFlowInfo((ASTNode)typeDeclarationStatement, (ASTNode)typeDeclarationStatement.getDeclaration());
    }

    public void endVisit(TypeLiteral typeLiteral) {
        if (this.skipNode((ASTNode)typeLiteral)) {
            return;
        }
        this.assignFlowInfo((ASTNode)typeLiteral, (ASTNode)typeLiteral.getType());
    }

    public void endVisit(TypeParameter typeParameter) {
        if (this.skipNode((ASTNode)typeParameter)) {
            return;
        }
        GenericSequentialFlowInfo genericSequentialFlowInfo = this.processSequential((ASTNode)typeParameter, (ASTNode)typeParameter.getName());
        this.process(genericSequentialFlowInfo, typeParameter.typeBounds());
    }

    public void endVisit(VariableDeclarationExpression variableDeclarationExpression) {
        if (this.skipNode((ASTNode)variableDeclarationExpression)) {
            return;
        }
        GenericSequentialFlowInfo genericSequentialFlowInfo = this.processSequential((ASTNode)variableDeclarationExpression, (ASTNode)variableDeclarationExpression.getType());
        this.process(genericSequentialFlowInfo, variableDeclarationExpression.fragments());
    }

    public void endVisit(VariableDeclarationStatement variableDeclarationStatement) {
        if (this.skipNode((ASTNode)variableDeclarationStatement)) {
            return;
        }
        GenericSequentialFlowInfo genericSequentialFlowInfo = this.processSequential((ASTNode)variableDeclarationStatement, (ASTNode)variableDeclarationStatement.getType());
        this.process(genericSequentialFlowInfo, variableDeclarationStatement.fragments());
    }

    public void endVisit(VariableDeclarationFragment variableDeclarationFragment) {
        if (this.skipNode((ASTNode)variableDeclarationFragment)) {
            return;
        }
        IVariableBinding iVariableBinding = variableDeclarationFragment.resolveBinding();
        LocalFlowInfo localFlowInfo = null;
        Expression expression = variableDeclarationFragment.getInitializer();
        if (iVariableBinding != null && !iVariableBinding.isField() && expression != null) {
            localFlowInfo = new LocalFlowInfo(iVariableBinding, 8, this.fFlowContext);
        }
        GenericSequentialFlowInfo genericSequentialFlowInfo = this.processSequential((ASTNode)variableDeclarationFragment, (ASTNode)expression);
        genericSequentialFlowInfo.merge(localFlowInfo, this.fFlowContext);
    }

    public void endVisit(WhileStatement whileStatement) {
        if (this.skipNode((ASTNode)whileStatement)) {
            return;
        }
        WhileFlowInfo whileFlowInfo = this.createWhile();
        this.setFlowInfo((ASTNode)whileStatement, whileFlowInfo);
        whileFlowInfo.mergeCondition(this.getFlowInfo((ASTNode)whileStatement.getExpression()), this.fFlowContext);
        whileFlowInfo.mergeAction(this.getFlowInfo((ASTNode)whileStatement.getBody()), this.fFlowContext);
        whileFlowInfo.removeLabel(null);
    }

    public void endVisit(WithStatement withStatement) {
        if (this.skipNode((ASTNode)withStatement)) {
            return;
        }
        WithFlowInfo withFlowInfo = this.createWith();
        this.setFlowInfo((ASTNode)withStatement, withFlowInfo);
        withFlowInfo.mergeCondition(this.getFlowInfo((ASTNode)withStatement.getExpression()), this.fFlowContext);
        withFlowInfo.mergeAction(this.getFlowInfo((ASTNode)withStatement.getBody()), this.fFlowContext);
        withFlowInfo.removeLabel(null);
    }

    public void endVisit(WildcardType wildcardType) {
        if (this.skipNode((ASTNode)wildcardType)) {
            return;
        }
        this.assignFlowInfo((ASTNode)wildcardType, (ASTNode)wildcardType.getBound());
    }

    private void endVisitMethodInvocation(ASTNode aSTNode, ASTNode aSTNode2, List list, IMethodBinding iMethodBinding) {
        if (this.skipNode(aSTNode)) {
            return;
        }
        MessageSendFlowInfo messageSendFlowInfo = this.createMessageSendFlowInfo();
        this.setFlowInfo(aSTNode, messageSendFlowInfo);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Expression expression = (Expression)iterator.next();
            messageSendFlowInfo.mergeArgument(this.getFlowInfo((ASTNode)expression), this.fFlowContext);
        }
        messageSendFlowInfo.mergeReceiver(this.getFlowInfo(aSTNode2), this.fFlowContext);
        messageSendFlowInfo.mergeExceptions(iMethodBinding, this.fFlowContext);
    }

    private void endVisitIncDecOperation(Expression expression, Expression expression2) {
        if (this.skipNode((ASTNode)expression)) {
            return;
        }
        FlowInfo flowInfo = this.getFlowInfo((ASTNode)expression2);
        if (flowInfo instanceof LocalFlowInfo) {
            GenericSequentialFlowInfo genericSequentialFlowInfo = this.createSequential((ASTNode)expression);
            genericSequentialFlowInfo.merge(flowInfo, this.fFlowContext);
            genericSequentialFlowInfo.merge(new LocalFlowInfo((LocalFlowInfo)flowInfo, 8, this.fFlowContext), this.fFlowContext);
        } else {
            this.setFlowInfo((ASTNode)expression, flowInfo);
        }
    }

    private IMethodBinding getMethodBinding(Name name) {
        if (name == null) {
            return null;
        }
        IBinding iBinding = name.resolveBinding();
        if (iBinding instanceof IMethodBinding) {
            return (IMethodBinding)iBinding;
        }
        return null;
    }

    protected static class SwitchData {
        private boolean fHasDefaultCase;
        private List fRanges = new ArrayList(4);
        private List fInfos = new ArrayList(4);

        protected SwitchData() {
        }

        public void setHasDefaultCase() {
            this.fHasDefaultCase = true;
        }

        public boolean hasDefaultCase() {
            return this.fHasDefaultCase;
        }

        public void add(IRegion iRegion, FlowInfo flowInfo) {
            this.fRanges.add(iRegion);
            this.fInfos.add(flowInfo);
        }

        public IRegion[] getRanges() {
            return this.fRanges.toArray(new IRegion[this.fRanges.size()]);
        }

        public FlowInfo[] getInfos() {
            return this.fInfos.toArray(new FlowInfo[this.fInfos.size()]);
        }

        public FlowInfo getInfo(int n) {
            return (FlowInfo)this.fInfos.get(n);
        }
    }
}

