/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.nls;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStringStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.AccessorClassCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.AccessorClassModifier;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSHint;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSPropertyFileModifier;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSSourceModifier;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSSubstitution;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;

public class NLSRefactoring
extends Refactoring {
    public static final String BUNDLE_NAME = "BUNDLE_NAME";
    public static final String PROPERTY_FILE_EXT = ".properties";
    public static final String DEFAULT_ACCESSOR_CLASSNAME = "Messages";
    public static final String KEY = "${key}";
    public static final String DEFAULT_SUBST_PATTERN = "getString(${key})";
    public static final String DEFAULT_PROPERTY_FILENAME = "messages";
    private String fAccessorClassName;
    private IPackageFragment fAccessorClassPackage;
    private String fResourceBundleName;
    private IPackageFragment fResourceBundlePackage;
    private String fSubstitutionPattern;
    private ICompilationUnit fCu;
    private NLSSubstitution[] fSubstitutions;
    private String fPrefix;
    private boolean fIsEclipseNLS;
    static /* synthetic */ Class class$0;

    private NLSRefactoring(ICompilationUnit iCompilationUnit) {
        Assert.isNotNull((Object)iCompilationUnit);
        this.fCu = iCompilationUnit;
        CompilationUnit compilationUnit = JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)this.fCu, ASTProvider.WAIT_YES, null);
        NLSHint nLSHint = new NLSHint(this.fCu, compilationUnit);
        this.fSubstitutions = nLSHint.getSubstitutions();
        this.setAccessorClassName(nLSHint.getAccessorClassName());
        this.setAccessorClassPackage(nLSHint.getAccessorClassPackage());
        this.setIsEclipseNLS(this.detectIsEclipseNLS());
        this.setResourceBundleName(nLSHint.getResourceBundleName());
        this.setResourceBundlePackage(nLSHint.getResourceBundlePackage());
        this.setSubstitutionPattern(DEFAULT_SUBST_PATTERN);
        String string = this.fCu.getElementName();
        if (this.fIsEclipseNLS) {
            this.setPrefix(String.valueOf(string.substring(0, string.length() - 5)) + "_");
        } else {
            this.setPrefix(string.substring(0, string.length() - 4));
        }
    }

    public static NLSRefactoring create(ICompilationUnit iCompilationUnit) {
        if (iCompilationUnit == null || !iCompilationUnit.exists()) {
            return null;
        }
        return new NLSRefactoring(iCompilationUnit);
    }

    public void setSubstitutionPattern(String string) {
        Assert.isNotNull((Object)string);
        this.fSubstitutionPattern = string;
    }

    public String getSubstitutionPattern() {
        if (this.fIsEclipseNLS) {
            return KEY;
        }
        return this.fSubstitutionPattern;
    }

    public ICompilationUnit getCu() {
        return this.fCu;
    }

    public String getName() {
        return Messages.format(NLSMessages.NLSRefactoring_compilation_unit, this.fCu.getElementName());
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.fSubstitutions.length == 0) {
            String string = Messages.format(NLSMessages.NLSRefactoring_no_strings, this.fCu.getElementName());
            return RefactoringStatus.createFatalErrorStatus((String)string);
        }
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus;
        block9: {
            block8: {
                RefactoringStatus refactoringStatus2;
                this.checkParameters();
                try {
                    iProgressMonitor.beginTask(NLSMessages.NLSRefactoring_checking, 5);
                    refactoringStatus = new RefactoringStatus();
                    refactoringStatus.merge(this.checkIfAnythingToDo());
                    if (!refactoringStatus.hasFatalError()) break block8;
                    refactoringStatus2 = refactoringStatus;
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_9 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
                iProgressMonitor.done();
                return refactoringStatus2;
            }
            iProgressMonitor.worked(1);
            refactoringStatus.merge(this.validateModifiesFiles());
            if (!refactoringStatus.hasFatalError()) break block9;
            RefactoringStatus refactoringStatus3 = refactoringStatus;
            Object var4_7 = null;
            iProgressMonitor.done();
            return refactoringStatus3;
        }
        iProgressMonitor.worked(1);
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        refactoringStatus.merge(this.checkSubstitutionPattern());
        iProgressMonitor.worked(1);
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        refactoringStatus.merge(this.checkKeys());
        iProgressMonitor.worked(1);
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!this.propertyFileExists() && this.willModifyPropertyFile()) {
            String string = Messages.format(NLSMessages.NLSRefactoring_will_be_created, this.getPropertyFilePath().toString());
            refactoringStatus.addInfo(string);
        }
        iProgressMonitor.worked(1);
        RefactoringStatus refactoringStatus4 = refactoringStatus;
        Object var4_8 = null;
        iProgressMonitor.done();
        return refactoringStatus4;
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException {
        DynamicValidationStateChange dynamicValidationStateChange;
        try {
            this.checkParameters();
            iProgressMonitor.beginTask("", 3);
            DynamicValidationStateChange dynamicValidationStateChange2 = new DynamicValidationStateChange(NLSMessages.NLSRefactoring_change_name);
            boolean bl = this.willCreateAccessorClass();
            if (NLSSubstitution.countItems(this.fSubstitutions, 0) == 0) {
                bl = false;
            }
            if (bl) {
                dynamicValidationStateChange2.add(AccessorClassCreator.create(this.fCu, this.fAccessorClassName, this.getAccessorCUPath(), this.fAccessorClassPackage, this.getPropertyFilePath(), this.fIsEclipseNLS, this.fSubstitutions, this.getSubstitutionPattern(), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
            }
            iProgressMonitor.worked(1);
            if (this.willModifySource()) {
                dynamicValidationStateChange2.add(NLSSourceModifier.create(this.getCu(), this.fSubstitutions, this.getSubstitutionPattern(), this.fAccessorClassPackage, this.fAccessorClassName, this.fIsEclipseNLS));
            }
            iProgressMonitor.worked(1);
            if (this.willModifyPropertyFile()) {
                Change change;
                dynamicValidationStateChange2.add(NLSPropertyFileModifier.create(this.fSubstitutions, this.getPropertyFilePath()));
                if (this.isEclipseNLS() && !bl && (change = AccessorClassModifier.create(this.getAccessorCu(), this.fSubstitutions)) != null) {
                    dynamicValidationStateChange2.add(change);
                }
            }
            iProgressMonitor.worked(1);
            dynamicValidationStateChange = dynamicValidationStateChange2;
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return dynamicValidationStateChange;
    }

    private void checkParameters() {
        Assert.isNotNull((Object)this.fSubstitutions);
        Assert.isNotNull((Object)this.fAccessorClassPackage);
        Assert.isNotNull((Object)this.fAccessorClassName);
        Assert.isNotNull((Object)this.getSubstitutionPattern());
    }

    private IFile[] getAllFilesToModify() {
        IResource iResource;
        ArrayList<IResource> arrayList = new ArrayList<IResource>(2);
        if (this.willModifySource() && (iResource = this.fCu.getResource()).exists()) {
            arrayList.add(iResource);
        }
        if (this.willModifyPropertyFile() && (iResource = this.getPropertyFileHandle()).exists()) {
            arrayList.add(iResource);
        }
        if (this.willModifyAccessorClass() && (iResource = this.getAccessorClassFileHandle()).exists()) {
            arrayList.add(iResource);
        }
        return arrayList.toArray(new IFile[arrayList.size()]);
    }

    public IFile getPropertyFileHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getPropertyFilePath());
    }

    public IPath getPropertyFilePath() {
        return this.fResourceBundlePackage.getPath().append(this.fResourceBundleName);
    }

    public IFile getAccessorClassFileHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getAccessorClassFilePath());
    }

    public IPath getAccessorClassFilePath() {
        return this.getAccessorCUPath();
    }

    private RefactoringStatus validateModifiesFiles() {
        return Checks.validateModifiesFiles(this.getAllFilesToModify(), this.getValidationContext());
    }

    private RefactoringStatus checkIfAnythingToDo() throws JavaModelException {
        if (NLSSubstitution.countItems(this.fSubstitutions, 0) != 0 && this.willCreateAccessorClass()) {
            return null;
        }
        if (this.willModifyPropertyFile()) {
            return null;
        }
        if (this.willModifySource()) {
            return null;
        }
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        refactoringStatus.addFatalError(NLSMessages.NLSRefactoring_nothing_to_do);
        return refactoringStatus;
    }

    private boolean propertyFileExists() {
        return this.getPropertyFileHandle().exists();
    }

    private RefactoringStatus checkSubstitutionPattern() {
        String string;
        String string2 = this.getSubstitutionPattern();
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if (string2.trim().length() == 0) {
            refactoringStatus.addError(NLSMessages.NLSRefactoring_pattern_empty);
        }
        if (string2.indexOf(KEY) == -1) {
            string = Messages.format(NLSMessages.NLSRefactoring_pattern_does_not_contain, KEY);
            refactoringStatus.addWarning(string);
        }
        if (string2.indexOf(KEY) != string2.lastIndexOf(KEY)) {
            string = Messages.format(NLSMessages.NLSRefactoring_Only_the_first_occurrence_of, KEY);
            refactoringStatus.addWarning(string);
        }
        return refactoringStatus;
    }

    private RefactoringStatus checkKeys() {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        NLSSubstitution[] nLSSubstitutionArray = this.fSubstitutions;
        int n = 0;
        while (n < nLSSubstitutionArray.length) {
            NLSSubstitution nLSSubstitution = nLSSubstitutionArray[n];
            if (nLSSubstitution.getState() == 0 && nLSSubstitution.hasStateChanged()) {
                refactoringStatus.merge(NLSRefactoring.checkKey(nLSSubstitution.getKey()));
            }
            ++n;
        }
        return refactoringStatus;
    }

    private static RefactoringStatus checkKey(String string) {
        String[] stringArray;
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if (string == null) {
            refactoringStatus.addFatalError(NLSMessages.NLSRefactoring_null);
        }
        if (string.startsWith("!") || string.startsWith("#")) {
            stringArray = new JavaStringStatusContext(string, new SourceRange(0, 0));
            refactoringStatus.addWarning(NLSMessages.NLSRefactoring_warning, (RefactoringStatusContext)stringArray);
        }
        if ("".equals(string.trim())) {
            refactoringStatus.addFatalError(NLSMessages.NLSRefactoring_empty);
        }
        stringArray = new String[]{" ", ":", "\"", "\\", "'", "?", "="};
        int n = 0;
        while (n < stringArray.length) {
            if (string.indexOf(stringArray[n]) != -1) {
                Object[] objectArray = new String[]{string, stringArray[n]};
                String string2 = Messages.format(NLSMessages.NLSRefactoring_should_not_contain, objectArray);
                refactoringStatus.addError(string2);
            }
            ++n;
        }
        return refactoringStatus;
    }

    public boolean willCreateAccessorClass() throws JavaModelException {
        ICompilationUnit iCompilationUnit = this.getAccessorCu();
        if (iCompilationUnit.exists()) {
            return false;
        }
        if (this.typeNameExistsInPackage(this.fAccessorClassPackage, this.fAccessorClassName)) {
            return false;
        }
        return !Checks.resourceExists(this.getAccessorCUPath());
    }

    private ICompilationUnit getAccessorCu() {
        return this.fAccessorClassPackage.getCompilationUnit(this.getAccessorCUName());
    }

    private boolean willModifySource() {
        NLSSubstitution[] nLSSubstitutionArray = this.fSubstitutions;
        int n = 0;
        while (n < nLSSubstitutionArray.length) {
            if (nLSSubstitutionArray[n].hasSourceChange()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean willModifyPropertyFile() {
        NLSSubstitution[] nLSSubstitutionArray = this.fSubstitutions;
        int n = 0;
        while (n < nLSSubstitutionArray.length) {
            NLSSubstitution nLSSubstitution = nLSSubstitutionArray[n];
            if (nLSSubstitution.hasPropertyFileChange()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean willModifyAccessorClass() {
        if (!this.isEclipseNLS()) {
            return false;
        }
        NLSSubstitution[] nLSSubstitutionArray = this.fSubstitutions;
        int n = 0;
        while (n < nLSSubstitutionArray.length) {
            NLSSubstitution nLSSubstitution = nLSSubstitutionArray[n];
            if (nLSSubstitution.hasAccessorClassChange()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean typeNameExistsInPackage(IPackageFragment iPackageFragment, String string) throws JavaModelException {
        return Checks.findTypeInPackage(iPackageFragment, string) != null;
    }

    private String getAccessorCUName() {
        return String.valueOf(this.getAccessorClassName()) + ".js";
    }

    private IPath getAccessorCUPath() {
        return this.fAccessorClassPackage.getPath().append(this.getAccessorCUName());
    }

    public NLSSubstitution[] getSubstitutions() {
        return this.fSubstitutions;
    }

    public String getPrefix() {
        return this.fPrefix;
    }

    public void setPrefix(String string) {
        this.fPrefix = string;
        if (this.fSubstitutions != null) {
            int n = 0;
            while (n < this.fSubstitutions.length) {
                this.fSubstitutions[n].setPrefix(string);
                ++n;
            }
        }
    }

    public void setAccessorClassName(String string) {
        Assert.isNotNull((Object)string);
        this.fAccessorClassName = string;
    }

    public void setAccessorClassPackage(IPackageFragment iPackageFragment) {
        Assert.isNotNull((Object)iPackageFragment);
        this.fAccessorClassPackage = iPackageFragment;
    }

    public void setIsEclipseNLS(boolean bl) {
        this.fIsEclipseNLS = bl;
    }

    public void setResourceBundlePackage(IPackageFragment iPackageFragment) {
        Assert.isNotNull((Object)iPackageFragment);
        this.fResourceBundlePackage = iPackageFragment;
    }

    public void setResourceBundleName(String string) {
        Assert.isNotNull((Object)string);
        this.fResourceBundleName = string;
    }

    public IPackageFragment getAccessorClassPackage() {
        return this.fAccessorClassPackage;
    }

    public boolean detectIsEclipseNLS() {
        ICompilationUnit iCompilationUnit;
        IType iType;
        if (this.getAccessorClassPackage() != null && (iType = (iCompilationUnit = this.getAccessorClassPackage().getCompilationUnit(this.getAccessorCUName())).getType(this.getAccessorClassName())).exists()) {
            block12: {
                try {
                    String string = iType.getSuperclassName();
                    if ("NLS".equals(string)) break block12;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.osgi.util.NLS");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz.getName().equals(string)) break block12;
                    return false;
                }
                catch (JavaModelException javaModelException) {
                    return false;
                }
            }
            IType iType2 = iType.newSupertypeHierarchy(null).getSuperclass(iType);
            if (iType2 != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.osgi.util.NLS");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.getName().equals(iType2.getFullyQualifiedName())) {
                    return true;
                }
            }
            return false;
        }
        return this.fIsEclipseNLS;
    }

    public boolean isEclipseNLS() {
        return this.fIsEclipseNLS;
    }

    public IPackageFragment getResourceBundlePackage() {
        return this.fResourceBundlePackage;
    }

    public String getAccessorClassName() {
        return this.fAccessorClassName;
    }

    public String getResourceBundleName() {
        return this.fResourceBundleName;
    }
}

