/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.reorg;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.CreateTargetExecutionLog;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ICreateTargetQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ICreateTargetQuery;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.util.CoreUtility;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathsBlock;

public final class LoggedCreateTargetQueries
implements ICreateTargetQueries {
    private final CreateTargetExecutionLog fLog;

    public LoggedCreateTargetQueries(CreateTargetExecutionLog createTargetExecutionLog) {
        Assert.isNotNull((Object)createTargetExecutionLog);
        this.fLog = createTargetExecutionLog;
    }

    public ICreateTargetQuery createNewPackageQuery() {
        return new CreateTargetQuery();
    }

    public CreateTargetExecutionLog getCreateTargetExecutionLog() {
        return this.fLog;
    }

    private final class CreateTargetQuery
    implements ICreateTargetQuery {
        private CreateTargetQuery() {
        }

        private void createJavaProject(IProject iProject) throws CoreException {
            if (!iProject.exists()) {
                BuildPathsBlock.createProject(iProject, null, (IProgressMonitor)new NullProgressMonitor());
                BuildPathsBlock.addJavaNature(iProject, (IProgressMonitor)new NullProgressMonitor());
            }
        }

        private void createPackageFragmentRoot(IPackageFragmentRoot iPackageFragmentRoot) throws CoreException {
            IFolder iFolder;
            IJavaProject iJavaProject = iPackageFragmentRoot.getJavaProject();
            if (!iJavaProject.exists()) {
                this.createJavaProject(iJavaProject.getProject());
            }
            if (!(iFolder = iJavaProject.getProject().getFolder(iPackageFragmentRoot.getElementName())).exists()) {
                CoreUtility.createFolder(iFolder, true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            List<IClasspathEntry> list = Arrays.asList(iJavaProject.getRawClasspath());
            list.add(JavaCore.newSourceEntry((IPath)iFolder.getFullPath()));
            iJavaProject.setRawClasspath(list.toArray(new IClasspathEntry[list.size()]), (IProgressMonitor)new NullProgressMonitor());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object getCreatedTarget(Object object) {
            Object object2 = LoggedCreateTargetQueries.this.fLog.getCreatedElement(object);
            if (object2 instanceof IPackageFragment) {
                IPackageFragment iPackageFragment = (IPackageFragment)object2;
                IJavaElement iJavaElement = iPackageFragment.getParent();
                if (!(iJavaElement instanceof IPackageFragmentRoot)) return object2;
                try {
                    IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement;
                    if (!iPackageFragmentRoot.exists()) {
                        this.createPackageFragmentRoot(iPackageFragmentRoot);
                    }
                    if (iPackageFragment.exists()) return object2;
                    iPackageFragmentRoot.createPackageFragment(iPackageFragment.getElementName(), true, (IProgressMonitor)new NullProgressMonitor());
                    return object2;
                }
                catch (CoreException coreException) {
                    JavaPlugin.log(coreException);
                    return null;
                }
            }
            if (!(object2 instanceof IFolder)) return object2;
            try {
                IFolder iFolder = (IFolder)object2;
                IProject iProject = iFolder.getProject();
                if (!iProject.exists()) {
                    this.createJavaProject(iProject);
                }
                if (iFolder.exists()) return object2;
                CoreUtility.createFolder(iFolder, true, true, (IProgressMonitor)new NullProgressMonitor());
                return object2;
            }
            catch (CoreException coreException) {
                JavaPlugin.log(coreException);
                return null;
            }
        }

        public String getNewButtonLabel() {
            return "unused";
        }
    }
}

