/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;

public class ParentChecker {
    private IResource[] fResources;
    private IJavaElement[] fJavaElements;

    public ParentChecker(IResource[] iResourceArray, IJavaElement[] iJavaElementArray) {
        Assert.isNotNull((Object)iResourceArray);
        Assert.isNotNull((Object)iJavaElementArray);
        this.fResources = iResourceArray;
        this.fJavaElements = iJavaElementArray;
    }

    public boolean haveCommonParent() {
        return this.getCommonParent() != null;
    }

    public Object getCommonParent() {
        if (this.fJavaElements.length == 0 && this.fResources.length == 0) {
            return null;
        }
        if (!this.resourcesHaveCommonParent() || !this.javaElementsHaveCommonParent()) {
            return null;
        }
        if (this.fJavaElements.length == 0) {
            IResource iResource = this.getCommonResourceParent();
            Assert.isNotNull((Object)iResource);
            IJavaElement iJavaElement = JavaCore.create((IResource)iResource);
            if (iJavaElement != null && iJavaElement.exists()) {
                return iJavaElement;
            }
            return iResource;
        }
        if (this.fResources.length == 0) {
            return this.getCommonJavaElementParent();
        }
        IResource iResource = this.getCommonResourceParent();
        IJavaElement iJavaElement = this.getCommonJavaElementParent();
        Assert.isNotNull((Object)iJavaElement);
        Assert.isNotNull((Object)iResource);
        IJavaElement iJavaElement2 = JavaCore.create((IResource)iResource);
        if (iJavaElement2 == null || !iJavaElement2.exists() || !iJavaElement.equals(iJavaElement2)) {
            return null;
        }
        return iJavaElement;
    }

    private IJavaElement getCommonJavaElementParent() {
        Assert.isNotNull((Object)this.fJavaElements);
        Assert.isTrue((this.fJavaElements.length > 0 ? 1 : 0) != 0);
        return this.fJavaElements[0].getParent();
    }

    private IResource getCommonResourceParent() {
        Assert.isNotNull((Object)this.fResources);
        Assert.isTrue((this.fResources.length > 0 ? 1 : 0) != 0);
        return this.fResources[0].getParent();
    }

    private boolean javaElementsHaveCommonParent() {
        if (this.fJavaElements.length == 0) {
            return true;
        }
        IJavaElement iJavaElement = this.fJavaElements[0].getParent();
        Assert.isNotNull((Object)iJavaElement);
        int n = 1;
        while (n < this.fJavaElements.length) {
            if (!iJavaElement.equals(this.fJavaElements[n].getParent())) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean resourcesHaveCommonParent() {
        if (this.fResources.length == 0) {
            return true;
        }
        IContainer iContainer = this.fResources[0].getParent();
        Assert.isNotNull((Object)iContainer);
        int n = 1;
        while (n < this.fResources.length) {
            if (!iContainer.equals((Object)this.fResources[n].getParent())) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public IResource[] getResources() {
        return this.fResources;
    }

    public IJavaElement[] getJavaElements() {
        return this.fJavaElements;
    }

    public void removeElementsWithAncestorsOnList(boolean bl) {
        if (!bl) {
            this.removeResourcesDescendantsOfResources();
            this.removeResourcesDescendantsOfJavaElements();
        }
        this.removeJavaElementsDescendantsOfJavaElements();
    }

    private void removeResourcesDescendantsOfJavaElements() {
        ArrayList<IResource> arrayList = new ArrayList<IResource>(3);
        int n = 0;
        while (n < this.fResources.length) {
            IResource iResource = this.fResources[n];
            int n2 = 0;
            while (n2 < this.fJavaElements.length) {
                IJavaElement iJavaElement = this.fJavaElements[n2];
                if (ParentChecker.isDescendantOf(iResource, iJavaElement)) {
                    arrayList.add(iResource);
                }
                ++n2;
            }
            ++n;
        }
        this.removeFromSetToDelete(arrayList.toArray(new IResource[arrayList.size()]));
    }

    private void removeJavaElementsDescendantsOfJavaElements() {
        ArrayList<IJavaElement> arrayList = new ArrayList<IJavaElement>(3);
        int n = 0;
        while (n < this.fJavaElements.length) {
            IJavaElement iJavaElement = this.fJavaElements[n];
            int n2 = 0;
            while (n2 < this.fJavaElements.length) {
                IJavaElement iJavaElement2 = this.fJavaElements[n2];
                if (ParentChecker.isDescendantOf(iJavaElement, iJavaElement2)) {
                    arrayList.add(iJavaElement);
                }
                ++n2;
            }
            ++n;
        }
        this.removeFromSetToDelete(arrayList.toArray(new IJavaElement[arrayList.size()]));
    }

    private void removeResourcesDescendantsOfResources() {
        ArrayList<IResource> arrayList = new ArrayList<IResource>(3);
        int n = 0;
        while (n < this.fResources.length) {
            IResource iResource = this.fResources[n];
            int n2 = 0;
            while (n2 < this.fResources.length) {
                IResource iResource2 = this.fResources[n2];
                if (ParentChecker.isDescendantOf(iResource, iResource2)) {
                    arrayList.add(iResource);
                }
                ++n2;
            }
            ++n;
        }
        this.removeFromSetToDelete(arrayList.toArray(new IResource[arrayList.size()]));
    }

    public static boolean isDescendantOf(IResource iResource, IJavaElement iJavaElement) {
        IContainer iContainer = iResource.getParent();
        while (iContainer != null) {
            IJavaElement iJavaElement2 = JavaCore.create((IResource)iContainer);
            if (iJavaElement2 != null && iJavaElement2.exists() && iJavaElement2.equals(iJavaElement)) {
                return true;
            }
            iContainer = iContainer.getParent();
        }
        return false;
    }

    public static boolean isDescendantOf(IJavaElement iJavaElement, IJavaElement iJavaElement2) {
        if (iJavaElement.equals(iJavaElement2)) {
            return false;
        }
        IJavaElement iJavaElement3 = iJavaElement.getParent();
        while (iJavaElement3 != null) {
            if (iJavaElement3.equals(iJavaElement2)) {
                return true;
            }
            iJavaElement3 = iJavaElement3.getParent();
        }
        return false;
    }

    public static boolean isDescendantOf(IResource iResource, IResource iResource2) {
        return !iResource.equals((Object)iResource2) && iResource2.getFullPath().isPrefixOf(iResource.getFullPath());
    }

    private void removeFromSetToDelete(IResource[] iResourceArray) {
        this.fResources = ReorgUtils.setMinus(this.fResources, iResourceArray);
    }

    private void removeFromSetToDelete(IJavaElement[] iJavaElementArray) {
        this.fJavaElements = ReorgUtils.setMinus(this.fJavaElements, iJavaElementArray);
    }
}

