/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IInitializer;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.Annotation;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IExtendedModifier;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeParameter;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.SourceReferenceUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ConstructorReferenceFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ReferenceFinderUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.TypeVariableMaplet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsModel;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsSolver;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints.SuperTypeRefactoringProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextEditBasedChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public abstract class HierarchyProcessor
extends SuperTypeRefactoringProcessor {
    protected IType fCachedDeclaringType;
    protected final Map fCachedMembersReferences = new HashMap(2);
    protected IType[] fCachedReferencedTypes;
    protected TextEditBasedChangeManager fChangeManager;
    protected final boolean fLayer;
    protected IMember[] fMembersToMove;
    static /* synthetic */ Class class$0;

    protected static boolean areAllFragmentsDeleted(FieldDeclaration fieldDeclaration, List list) {
        Iterator iterator = fieldDeclaration.fragments().iterator();
        while (iterator.hasNext()) {
            if (list.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    protected static RefactoringStatus checkProjectCompliance(CompilationUnitRewrite compilationUnitRewrite, IType iType, IMember[] iMemberArray) {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if (!JavaModelUtil.is50OrHigher(iType.getJavaProject())) {
            int n = 0;
            while (n < iMemberArray.length) {
                BodyDeclaration bodyDeclaration;
                try {
                    bodyDeclaration = ASTNodeSearchUtil.getBodyDeclarationNode(iMemberArray[n], compilationUnitRewrite.getRoot());
                    if (bodyDeclaration != null) {
                        Iterator iterator = bodyDeclaration.modifiers().iterator();
                        while (iterator.hasNext()) {
                            boolean bl = false;
                            IExtendedModifier iExtendedModifier = (IExtendedModifier)iterator.next();
                            if (bl || !iExtendedModifier.isAnnotation()) continue;
                            refactoringStatus.merge(RefactoringStatus.createErrorStatus((String)Messages.format(RefactoringCoreMessages.PullUpRefactoring_incompatible_langauge_constructs, new String[]{JavaElementLabels.getTextLabel(iMemberArray[n], JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getTextLabel(iType, JavaElementLabels.ALL_DEFAULT)}), (RefactoringStatusContext)JavaStatusContext.create(iMemberArray[n])));
                            bl = true;
                        }
                    }
                }
                catch (JavaModelException javaModelException) {
                    JavaPlugin.log(javaModelException);
                }
                if (iMemberArray[n] instanceof IMethod) {
                    bodyDeclaration = (IMethod)iMemberArray[n];
                    try {
                        if (Flags.isVarargs((int)bodyDeclaration.getFlags())) {
                            refactoringStatus.merge(RefactoringStatus.createErrorStatus((String)Messages.format(RefactoringCoreMessages.PullUpRefactoring_incompatible_language_constructs1, new String[]{JavaElementLabels.getTextLabel(iMemberArray[n], JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getTextLabel(iType, JavaElementLabels.ALL_DEFAULT)}), (RefactoringStatusContext)JavaStatusContext.create(iMemberArray[n])));
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        JavaPlugin.log(javaModelException);
                    }
                }
                ++n;
            }
        }
        return refactoringStatus;
    }

    protected static void copyAnnotations(FieldDeclaration fieldDeclaration, FieldDeclaration fieldDeclaration2) {
        AST aST = fieldDeclaration2.getAST();
        int n = 0;
        int n2 = fieldDeclaration.modifiers().size();
        while (n < n2) {
            IExtendedModifier iExtendedModifier = (IExtendedModifier)fieldDeclaration.modifiers().get(n);
            List list = fieldDeclaration2.modifiers();
            if (iExtendedModifier.isAnnotation() && !list.contains(iExtendedModifier)) {
                list.add(n, ASTNode.copySubtree((AST)aST, (ASTNode)((Annotation)iExtendedModifier)));
            }
            ++n;
        }
    }

    protected static void copyAnnotations(MethodDeclaration methodDeclaration, MethodDeclaration methodDeclaration2) {
        AST aST = methodDeclaration2.getAST();
        int n = 0;
        int n2 = methodDeclaration.modifiers().size();
        while (n < n2) {
            IExtendedModifier iExtendedModifier = (IExtendedModifier)methodDeclaration.modifiers().get(n);
            List list = methodDeclaration2.modifiers();
            if (iExtendedModifier.isAnnotation() && !list.contains(iExtendedModifier)) {
                list.add(n, ASTNode.copySubtree((AST)aST, (ASTNode)((Annotation)iExtendedModifier)));
            }
            ++n;
        }
    }

    protected static void copyJavadocNode(ASTRewrite aSTRewrite, IMember iMember, BodyDeclaration bodyDeclaration, BodyDeclaration bodyDeclaration2) throws JavaModelException {
        Javadoc javadoc = bodyDeclaration.getJavadoc();
        if (javadoc != null) {
            Document document = new Document(iMember.getCompilationUnit().getBuffer().getContents());
            try {
                String[] stringArray = Strings.convertIntoLines(document.get(javadoc.getStartPosition(), javadoc.getLength()));
                Strings.trimIndentation(stringArray, iMember.getJavaProject(), false);
                Javadoc javadoc2 = (Javadoc)aSTRewrite.createStringPlaceholder(Strings.concatenate(stringArray, TextUtilities.getDefaultLineDelimiter((IDocument)document)), 29);
                bodyDeclaration2.setJavadoc(javadoc2);
            }
            catch (BadLocationException badLocationException) {
                JavaPlugin.log(badLocationException);
            }
        }
    }

    protected static void copyThrownExceptions(MethodDeclaration methodDeclaration, MethodDeclaration methodDeclaration2) {
        AST aST = methodDeclaration2.getAST();
        int n = 0;
        int n2 = methodDeclaration.thrownExceptions().size();
        while (n < n2) {
            methodDeclaration2.thrownExceptions().add(n, ASTNode.copySubtree((AST)aST, (ASTNode)((Name)methodDeclaration.thrownExceptions().get(n))));
            ++n;
        }
    }

    protected static void copyTypeParameters(MethodDeclaration methodDeclaration, MethodDeclaration methodDeclaration2) {
        AST aST = methodDeclaration2.getAST();
        int n = 0;
        int n2 = methodDeclaration.typeParameters().size();
        while (n < n2) {
            methodDeclaration2.typeParameters().add(n, ASTNode.copySubtree((AST)aST, (ASTNode)((TypeParameter)methodDeclaration.typeParameters().get(n))));
            ++n;
        }
    }

    protected static String createLabel(IMember iMember) {
        if (iMember instanceof IType) {
            return JavaElementLabels.getTextLabel(iMember, JavaElementLabels.ALL_FULLY_QUALIFIED);
        }
        if (iMember instanceof IMethod) {
            return JavaElementLabels.getTextLabel(iMember, JavaElementLabels.ALL_FULLY_QUALIFIED);
        }
        if (iMember instanceof IField) {
            return JavaElementLabels.getTextLabel(iMember, JavaElementLabels.ALL_FULLY_QUALIFIED);
        }
        if (iMember instanceof IInitializer) {
            return RefactoringCoreMessages.HierarchyRefactoring_initializer;
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    protected static FieldDeclaration createNewFieldDeclarationNode(ASTRewrite aSTRewrite, CompilationUnit compilationUnit, IField iField, VariableDeclarationFragment variableDeclarationFragment, TypeVariableMaplet[] typeVariableMapletArray, IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus, int n) throws JavaModelException {
        Expression expression;
        VariableDeclarationFragment variableDeclarationFragment2 = aSTRewrite.getAST().newVariableDeclarationFragment();
        variableDeclarationFragment2.setExtraDimensions(variableDeclarationFragment.getExtraDimensions());
        if (variableDeclarationFragment.getInitializer() != null) {
            expression = null;
            expression = typeVariableMapletArray.length > 0 ? HierarchyProcessor.createPlaceholderForExpression(variableDeclarationFragment.getInitializer(), iField.getCompilationUnit(), typeVariableMapletArray, aSTRewrite) : HierarchyProcessor.createPlaceholderForExpression(variableDeclarationFragment.getInitializer(), iField.getCompilationUnit(), aSTRewrite);
            variableDeclarationFragment2.setInitializer(expression);
        }
        variableDeclarationFragment2.setName((SimpleName)ASTNode.copySubtree((AST)aSTRewrite.getAST(), (ASTNode)variableDeclarationFragment.getName()));
        expression = aSTRewrite.getAST().newFieldDeclaration(variableDeclarationFragment2);
        FieldDeclaration fieldDeclaration = ASTNodeSearchUtil.getFieldDeclarationNode(iField, compilationUnit);
        HierarchyProcessor.copyJavadocNode(aSTRewrite, (IMember)iField, (BodyDeclaration)fieldDeclaration, (BodyDeclaration)expression);
        HierarchyProcessor.copyAnnotations(fieldDeclaration, (FieldDeclaration)expression);
        expression.modifiers().addAll(ASTNodeFactory.newModifiers(aSTRewrite.getAST(), n));
        Type type = fieldDeclaration.getType();
        Type type2 = null;
        type2 = typeVariableMapletArray.length > 0 ? HierarchyProcessor.createPlaceholderForType(type, iField.getCompilationUnit(), typeVariableMapletArray, aSTRewrite) : HierarchyProcessor.createPlaceholderForType(type, iField.getCompilationUnit(), aSTRewrite);
        expression.setType(type2);
        return expression;
    }

    protected static Expression createPlaceholderForExpression(Expression expression, ICompilationUnit iCompilationUnit, ASTRewrite aSTRewrite) throws JavaModelException {
        return (Expression)aSTRewrite.createStringPlaceholder(iCompilationUnit.getBuffer().getText(expression.getStartPosition(), expression.getLength()), 32);
    }

    protected static Expression createPlaceholderForExpression(Expression expression, ICompilationUnit iCompilationUnit, TypeVariableMaplet[] typeVariableMapletArray, ASTRewrite aSTRewrite) throws JavaModelException {
        Expression expression2 = null;
        try {
            Document document = new Document(iCompilationUnit.getBuffer().getContents());
            ASTRewrite aSTRewrite2 = ASTRewrite.create((AST)expression.getAST());
            ITrackedNodePosition iTrackedNodePosition = aSTRewrite2.track((ASTNode)expression);
            expression.accept((ASTVisitor)new TypeVariableMapper(aSTRewrite2, typeVariableMapletArray));
            aSTRewrite2.rewriteAST((IDocument)document, iCompilationUnit.getJavaProject().getOptions(true)).apply((IDocument)document, 0);
            expression2 = (Expression)aSTRewrite.createStringPlaceholder(document.get(iTrackedNodePosition.getStartPosition(), iTrackedNodePosition.getLength()), 32);
        }
        catch (MalformedTreeException malformedTreeException) {
            JavaPlugin.log(malformedTreeException);
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
        }
        return expression2;
    }

    protected static BodyDeclaration createPlaceholderForProtectedTypeDeclaration(BodyDeclaration bodyDeclaration, CompilationUnit compilationUnit, ICompilationUnit iCompilationUnit, ASTRewrite aSTRewrite, boolean bl) throws JavaModelException {
        String string = null;
        try {
            ASTRewrite aSTRewrite2 = ASTRewrite.create((AST)bodyDeclaration.getAST());
            ModifierRewrite.create(aSTRewrite2, (ASTNode)bodyDeclaration).setVisibility(4, null);
            ITrackedNodePosition iTrackedNodePosition = aSTRewrite2.track((ASTNode)bodyDeclaration);
            Document document = new Document(iCompilationUnit.getBuffer().getText(compilationUnit.getStartPosition(), compilationUnit.getLength()));
            aSTRewrite2.rewriteAST((IDocument)document, iCompilationUnit.getJavaProject().getOptions(true)).apply((IDocument)document, 2);
            string = document.get(iTrackedNodePosition.getStartPosition(), iTrackedNodePosition.getLength());
        }
        catch (BadLocationException badLocationException) {
            string = HierarchyProcessor.getNewText((ASTNode)bodyDeclaration, iCompilationUnit, bl);
        }
        return (BodyDeclaration)aSTRewrite.createStringPlaceholder(string, 55);
    }

    protected static BodyDeclaration createPlaceholderForProtectedTypeDeclaration(final BodyDeclaration bodyDeclaration, CompilationUnit compilationUnit, ICompilationUnit iCompilationUnit, TypeVariableMaplet[] typeVariableMapletArray, ASTRewrite aSTRewrite, boolean bl) throws JavaModelException {
        BodyDeclaration bodyDeclaration2 = null;
        try {
            Document document = new Document(iCompilationUnit.getBuffer().getContents());
            ASTRewrite aSTRewrite2 = ASTRewrite.create((AST)bodyDeclaration.getAST());
            ITrackedNodePosition iTrackedNodePosition = aSTRewrite2.track((ASTNode)bodyDeclaration);
            bodyDeclaration.accept((ASTVisitor)new TypeVariableMapper(aSTRewrite2, typeVariableMapletArray){

                public final boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
                    ModifierRewrite.create(this.fRewrite, (ASTNode)bodyDeclaration).setVisibility(4, null);
                    return true;
                }

                public final boolean visit(EnumDeclaration enumDeclaration) {
                    ModifierRewrite.create(this.fRewrite, (ASTNode)bodyDeclaration).setVisibility(4, null);
                    return true;
                }

                public final boolean visit(TypeDeclaration typeDeclaration) {
                    ModifierRewrite.create(this.fRewrite, (ASTNode)bodyDeclaration).setVisibility(4, null);
                    return true;
                }
            });
            aSTRewrite2.rewriteAST((IDocument)document, iCompilationUnit.getJavaProject().getOptions(true)).apply((IDocument)document, 0);
            bodyDeclaration2 = (BodyDeclaration)aSTRewrite.createStringPlaceholder(document.get(iTrackedNodePosition.getStartPosition(), iTrackedNodePosition.getLength()), 55);
        }
        catch (MalformedTreeException malformedTreeException) {
            JavaPlugin.log(malformedTreeException);
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
        }
        return bodyDeclaration2;
    }

    protected static SingleVariableDeclaration createPlaceholderForSingleVariableDeclaration(SingleVariableDeclaration singleVariableDeclaration, ICompilationUnit iCompilationUnit, ASTRewrite aSTRewrite) throws JavaModelException {
        return (SingleVariableDeclaration)aSTRewrite.createStringPlaceholder(iCompilationUnit.getBuffer().getText(singleVariableDeclaration.getStartPosition(), singleVariableDeclaration.getLength()), 44);
    }

    protected static SingleVariableDeclaration createPlaceholderForSingleVariableDeclaration(SingleVariableDeclaration singleVariableDeclaration, ICompilationUnit iCompilationUnit, TypeVariableMaplet[] typeVariableMapletArray, ASTRewrite aSTRewrite) throws JavaModelException {
        SingleVariableDeclaration singleVariableDeclaration2 = null;
        try {
            Document document = new Document(iCompilationUnit.getBuffer().getContents());
            ASTRewrite aSTRewrite2 = ASTRewrite.create((AST)singleVariableDeclaration.getAST());
            ITrackedNodePosition iTrackedNodePosition = aSTRewrite2.track((ASTNode)singleVariableDeclaration);
            singleVariableDeclaration.accept((ASTVisitor)new TypeVariableMapper(aSTRewrite2, typeVariableMapletArray));
            aSTRewrite2.rewriteAST((IDocument)document, iCompilationUnit.getJavaProject().getOptions(true)).apply((IDocument)document, 0);
            singleVariableDeclaration2 = (SingleVariableDeclaration)aSTRewrite.createStringPlaceholder(document.get(iTrackedNodePosition.getStartPosition(), iTrackedNodePosition.getLength()), 44);
        }
        catch (MalformedTreeException malformedTreeException) {
            JavaPlugin.log(malformedTreeException);
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
        }
        return singleVariableDeclaration2;
    }

    protected static Type createPlaceholderForType(Type type, ICompilationUnit iCompilationUnit, ASTRewrite aSTRewrite) throws JavaModelException {
        return (Type)aSTRewrite.createStringPlaceholder(iCompilationUnit.getBuffer().getText(type.getStartPosition(), type.getLength()), 43);
    }

    protected static Type createPlaceholderForType(Type type, ICompilationUnit iCompilationUnit, TypeVariableMaplet[] typeVariableMapletArray, ASTRewrite aSTRewrite) throws JavaModelException {
        Type type2 = null;
        try {
            Document document = new Document(iCompilationUnit.getBuffer().getContents());
            ASTRewrite aSTRewrite2 = ASTRewrite.create((AST)type.getAST());
            ITrackedNodePosition iTrackedNodePosition = aSTRewrite2.track((ASTNode)type);
            type.accept((ASTVisitor)new TypeVariableMapper(aSTRewrite2, typeVariableMapletArray));
            aSTRewrite2.rewriteAST((IDocument)document, iCompilationUnit.getJavaProject().getOptions(true)).apply((IDocument)document, 0);
            type2 = (Type)aSTRewrite.createStringPlaceholder(document.get(iTrackedNodePosition.getStartPosition(), iTrackedNodePosition.getLength()), 43);
        }
        catch (MalformedTreeException malformedTreeException) {
            JavaPlugin.log(malformedTreeException);
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
        }
        return type2;
    }

    protected static BodyDeclaration createPlaceholderForTypeDeclaration(BodyDeclaration bodyDeclaration, ICompilationUnit iCompilationUnit, ASTRewrite aSTRewrite, boolean bl) throws JavaModelException {
        return (BodyDeclaration)aSTRewrite.createStringPlaceholder(HierarchyProcessor.getNewText((ASTNode)bodyDeclaration, iCompilationUnit, bl), 55);
    }

    protected static BodyDeclaration createPlaceholderForTypeDeclaration(BodyDeclaration bodyDeclaration, ICompilationUnit iCompilationUnit, TypeVariableMaplet[] typeVariableMapletArray, ASTRewrite aSTRewrite, boolean bl) throws JavaModelException {
        BodyDeclaration bodyDeclaration2 = null;
        try {
            Document document = new Document(iCompilationUnit.getBuffer().getContents());
            ASTRewrite aSTRewrite2 = ASTRewrite.create((AST)bodyDeclaration.getAST());
            ITrackedNodePosition iTrackedNodePosition = aSTRewrite2.track((ASTNode)bodyDeclaration);
            bodyDeclaration.accept((ASTVisitor)new TypeVariableMapper(aSTRewrite2, typeVariableMapletArray));
            aSTRewrite2.rewriteAST((IDocument)document, iCompilationUnit.getJavaProject().getOptions(true)).apply((IDocument)document, 0);
            bodyDeclaration2 = (BodyDeclaration)aSTRewrite.createStringPlaceholder(document.get(iTrackedNodePosition.getStartPosition(), iTrackedNodePosition.getLength()), 55);
        }
        catch (MalformedTreeException malformedTreeException) {
            JavaPlugin.log(malformedTreeException);
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
        }
        return bodyDeclaration2;
    }

    protected static void deleteDeclarationNodes(CompilationUnitRewrite compilationUnitRewrite, boolean bl, CompilationUnitRewrite compilationUnitRewrite2, List list, GroupCategorySet groupCategorySet) throws JavaModelException {
        List list2 = HierarchyProcessor.getDeclarationNodes(compilationUnitRewrite2.getRoot(), list);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            ASTNode aSTNode = (ASTNode)iterator.next();
            ASTRewrite aSTRewrite = compilationUnitRewrite2.getASTRewrite();
            ImportRemover importRemover = compilationUnitRewrite2.getImportRemover();
            if (aSTNode instanceof VariableDeclarationFragment) {
                if (!(aSTNode.getParent() instanceof FieldDeclaration)) continue;
                FieldDeclaration fieldDeclaration = (FieldDeclaration)aSTNode.getParent();
                if (HierarchyProcessor.areAllFragmentsDeleted(fieldDeclaration, list2)) {
                    aSTRewrite.remove((ASTNode)fieldDeclaration, (TextEditGroup)compilationUnitRewrite2.createCategorizedGroupDescription(RefactoringCoreMessages.HierarchyRefactoring_remove_member, groupCategorySet));
                    if (bl) continue;
                    importRemover.registerRemovedNode((ASTNode)fieldDeclaration);
                    continue;
                }
                aSTRewrite.remove(aSTNode, (TextEditGroup)compilationUnitRewrite2.createCategorizedGroupDescription(RefactoringCoreMessages.HierarchyRefactoring_remove_member, groupCategorySet));
                if (bl) continue;
                importRemover.registerRemovedNode(aSTNode);
                continue;
            }
            aSTRewrite.remove(aSTNode, (TextEditGroup)compilationUnitRewrite2.createCategorizedGroupDescription(RefactoringCoreMessages.HierarchyRefactoring_remove_member, groupCategorySet));
            if (bl) continue;
            importRemover.registerRemovedNode(aSTNode);
        }
    }

    protected static List getDeclarationNodes(CompilationUnit compilationUnit, List list) throws JavaModelException {
        ArrayList<AbstractTypeDeclaration> arrayList = new ArrayList<AbstractTypeDeclaration>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IMember iMember = (IMember)iterator.next();
            Object object = null;
            if (iMember instanceof IField) {
                object = Flags.isEnum((int)iMember.getFlags()) ? ASTNodeSearchUtil.getEnumConstantDeclaration((IField)iMember, compilationUnit) : ASTNodeSearchUtil.getFieldDeclarationFragmentNode((IField)iMember, compilationUnit);
            } else if (iMember instanceof IType) {
                object = ASTNodeSearchUtil.getAbstractTypeDeclarationNode((IType)iMember, compilationUnit);
            } else if (iMember instanceof IMethod) {
                object = ASTNodeSearchUtil.getMethodDeclarationNode((IMethod)iMember, compilationUnit);
            }
            if (object == null) continue;
            arrayList.add((AbstractTypeDeclaration)object);
        }
        return arrayList;
    }

    protected static String getNewText(ASTNode aSTNode, ICompilationUnit iCompilationUnit, boolean bl) throws JavaModelException {
        String string = iCompilationUnit.getBuffer().getText(aSTNode.getStartPosition(), aSTNode.getLength());
        if (bl) {
            return HierarchyProcessor.getUnindentedText(string, iCompilationUnit);
        }
        return string;
    }

    protected static String getUnindentedText(String string, ICompilationUnit iCompilationUnit) throws JavaModelException {
        String[] stringArray = Strings.convertIntoLines(string);
        Strings.trimIndentation(stringArray, iCompilationUnit.getJavaProject(), false);
        return Strings.concatenate(stringArray, StubUtility.getLineDelimiterUsed((IJavaElement)iCompilationUnit));
    }

    protected HierarchyProcessor(IMember[] iMemberArray, CodeGenerationSettings codeGenerationSettings, boolean bl) {
        super(codeGenerationSettings);
        this.fLayer = bl;
        if (iMemberArray != null) {
            ICompilationUnit iCompilationUnit;
            this.fMembersToMove = (IMember[])SourceReferenceUtil.sortByOffset((ISourceReference[])iMemberArray);
            if (bl && this.fMembersToMove.length > 0 && (iCompilationUnit = this.fMembersToMove[0].getCompilationUnit()) != null) {
                try {
                    ICompilationUnit iCompilationUnit2 = this.getSharedWorkingCopy(iCompilationUnit.getPrimary(), (IProgressMonitor)new NullProgressMonitor());
                    if (iCompilationUnit2 != null) {
                        int n = 0;
                        while (n < this.fMembersToMove.length) {
                            IJavaElement[] iJavaElementArray = iCompilationUnit2.findElements((IJavaElement)this.fMembersToMove[n]);
                            if (iJavaElementArray != null && iJavaElementArray.length > 0 && iJavaElementArray[0] instanceof IMember) {
                                this.fMembersToMove[n] = (IMember)iJavaElementArray[0];
                            }
                            ++n;
                        }
                    }
                }
                catch (JavaModelException javaModelException) {
                    JavaPlugin.log(javaModelException);
                }
            }
        }
    }

    protected boolean canBeAccessedFrom(IMember iMember, IType iType, ITypeHierarchy iTypeHierarchy) throws JavaModelException {
        Assert.isTrue((!(iMember instanceof IInitializer) ? 1 : 0) != 0);
        return iMember.exists();
    }

    protected RefactoringStatus checkConstructorCalls(IType iType, IProgressMonitor iProgressMonitor) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        try {
            iProgressMonitor.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, 2);
            RefactoringStatus refactoringStatus2 = new RefactoringStatus();
            SearchResultGroup[] searchResultGroupArray = ConstructorReferenceFinder.getConstructorReferences(iType, this.fOwner, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), refactoringStatus2);
            String string = Messages.format(RefactoringCoreMessages.HierarchyRefactoring_gets_instantiated, new Object[]{JavaElementLabels.getTextLabel(iType, JavaElementLabels.ALL_FULLY_QUALIFIED)});
            ICompilationUnit iCompilationUnit = null;
            int n = 0;
            while (n < searchResultGroupArray.length) {
                iCompilationUnit = searchResultGroupArray[n].getCompilationUnit();
                if (iCompilationUnit != null) {
                    CompilationUnit compilationUnit = RefactoringASTParser.parseWithASTProvider((ITypeRoot)iCompilationUnit, false, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    ASTNode[] aSTNodeArray = ASTNodeSearchUtil.getAstNodes(searchResultGroupArray[n].getSearchResults(), compilationUnit);
                    ASTNode aSTNode = null;
                    int n2 = 0;
                    while (n2 < aSTNodeArray.length) {
                        aSTNode = aSTNodeArray[n2];
                        if (aSTNode instanceof ClassInstanceCreation || ConstructorReferenceFinder.isImplicitConstructorReferenceNodeInClassCreations(aSTNode)) {
                            RefactoringStatusContext refactoringStatusContext = JavaStatusContext.create((ITypeRoot)iCompilationUnit, aSTNode);
                            refactoringStatus2.addError(string, refactoringStatusContext);
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            refactoringStatus = refactoringStatus2;
            Object var13_14 = null;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return refactoringStatus;
    }

    protected RefactoringStatus checkDeclaringType(IProgressMonitor iProgressMonitor) throws JavaModelException {
        IType iType = this.getDeclaringType();
        if (iType.isEnum()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.HierarchyRefactoring_enum_members);
        }
        if (iType.isAnnotation()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.HierarchyRefactoring_annotation_members);
        }
        if (iType.isInterface()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.HierarchyRefactoring_interface_members);
        }
        if (iType.isBinary()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.HierarchyRefactoring_members_of_binary);
        }
        if (iType.isReadOnly()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.HierarchyRefactoring_members_of_read_only);
        }
        return new RefactoringStatus();
    }

    protected RefactoringStatus checkIfMembersExist() {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        IMember iMember = null;
        int n = 0;
        while (n < this.fMembersToMove.length) {
            iMember = this.fMembersToMove[n];
            if (iMember == null || !iMember.exists()) {
                refactoringStatus.addFatalError(RefactoringCoreMessages.HierarchyRefactoring_does_not_exist);
            }
            ++n;
        }
        return refactoringStatus;
    }

    protected void clearCaches() {
        this.fCachedReferencedTypes = null;
    }

    protected void copyParameters(ASTRewrite aSTRewrite, ICompilationUnit iCompilationUnit, MethodDeclaration methodDeclaration, MethodDeclaration methodDeclaration2, TypeVariableMaplet[] typeVariableMapletArray) throws JavaModelException {
        SingleVariableDeclaration singleVariableDeclaration = null;
        int n = 0;
        int n2 = methodDeclaration.parameters().size();
        while (n < n2) {
            SingleVariableDeclaration singleVariableDeclaration2 = (SingleVariableDeclaration)methodDeclaration.parameters().get(n);
            singleVariableDeclaration = typeVariableMapletArray.length > 0 ? HierarchyProcessor.createPlaceholderForSingleVariableDeclaration(singleVariableDeclaration2, iCompilationUnit, typeVariableMapletArray, aSTRewrite) : HierarchyProcessor.createPlaceholderForSingleVariableDeclaration(singleVariableDeclaration2, iCompilationUnit, aSTRewrite);
            methodDeclaration2.parameters().add(n, singleVariableDeclaration);
            ++n;
        }
    }

    protected void copyReturnType(ASTRewrite aSTRewrite, ICompilationUnit iCompilationUnit, MethodDeclaration methodDeclaration, MethodDeclaration methodDeclaration2, TypeVariableMaplet[] typeVariableMapletArray) throws JavaModelException {
        Type type = null;
        type = typeVariableMapletArray.length > 0 ? HierarchyProcessor.createPlaceholderForType(methodDeclaration.getReturnType2(), iCompilationUnit, typeVariableMapletArray, aSTRewrite) : HierarchyProcessor.createPlaceholderForType(methodDeclaration.getReturnType2(), iCompilationUnit, aSTRewrite);
        methodDeclaration2.setReturnType2(type);
    }

    protected SuperTypeConstraintsSolver createContraintSolver(SuperTypeConstraintsModel superTypeConstraintsModel) {
        return new SuperTypeConstraintsSolver(superTypeConstraintsModel);
    }

    public IType getDeclaringType() {
        if (this.fCachedDeclaringType != null) {
            return this.fCachedDeclaringType;
        }
        this.fCachedDeclaringType = RefactoringAvailabilityTester.getTopLevelType(this.fMembersToMove);
        if (this.fCachedDeclaringType == null) {
            this.fCachedDeclaringType = this.fMembersToMove[0].getDeclaringType();
        }
        return this.fCachedDeclaringType;
    }

    public IMember[] getMembersToMove() {
        return this.fMembersToMove;
    }

    protected IType[] getTypesReferencedInMovedMembers(IProgressMonitor iProgressMonitor) throws JavaModelException {
        if (this.fCachedReferencedTypes == null) {
            IType[] iTypeArray = ReferenceFinderUtil.getTypesReferencedIn((IJavaElement[])this.fMembersToMove, this.fOwner, iProgressMonitor);
            ArrayList<IType> arrayList = new ArrayList<IType>(iTypeArray.length);
            List<IMember> list = Arrays.asList(this.fMembersToMove);
            int n = 0;
            while (n < iTypeArray.length) {
                if (!list.contains(iTypeArray[n]) && !iTypeArray[n].equals(this.getDeclaringType())) {
                    arrayList.add(iTypeArray[n]);
                }
                ++n;
            }
            this.fCachedReferencedTypes = new IType[arrayList.size()];
            arrayList.toArray(this.fCachedReferencedTypes);
        }
        return this.fCachedReferencedTypes;
    }

    protected boolean hasNonMovedReferences(IMember iMember, IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws JavaModelException {
        Object object;
        if (!this.fCachedMembersReferences.containsKey(iMember)) {
            object = new RefactoringSearchEngine2(SearchPattern.createPattern((IJavaElement)iMember, (int)2, (int)24));
            ((RefactoringSearchEngine2)object).setFiltering(true, true);
            ((RefactoringSearchEngine2)object).setStatus(refactoringStatus);
            ((RefactoringSearchEngine2)object).setOwner(this.fOwner);
            ((RefactoringSearchEngine2)object).setScope(RefactoringScopeFactory.create((IJavaElement)iMember));
            ((RefactoringSearchEngine2)object).searchPattern((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            this.fCachedMembersReferences.put(iMember, ((RefactoringSearchEngine2)object).getResults());
        }
        if (((SearchResultGroup[])(object = (SearchResultGroup[])this.fCachedMembersReferences.get(iMember))).length == 0) {
            return false;
        }
        if (((SearchResultGroup[])object).length > 1) {
            return true;
        }
        ICompilationUnit iCompilationUnit = ((SearchResultGroup)object[0]).getCompilationUnit();
        if (!this.getDeclaringType().getCompilationUnit().equals(iCompilationUnit)) {
            return true;
        }
        SearchMatch[] searchMatchArray = ((SearchResultGroup)object[0]).getSearchResults();
        int n = 0;
        while (n < searchMatchArray.length) {
            if (!this.isMovedReference(searchMatchArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected boolean isMovedReference(SearchMatch searchMatch) throws JavaModelException {
        ISourceRange iSourceRange = null;
        int n = 0;
        while (n < this.fMembersToMove.length) {
            iSourceRange = this.fMembersToMove[n].getSourceRange();
            if (iSourceRange.getOffset() <= searchMatch.getOffset() && iSourceRange.getOffset() + iSourceRange.getLength() >= searchMatch.getOffset()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus refactoringStatus, SharableParticipants sharableParticipants) throws CoreException {
        return new RefactoringParticipant[0];
    }

    protected boolean needsVisibilityAdjustment(IMember iMember, boolean bl, IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws JavaModelException {
        if (JdtFlags.isPublic(iMember) || JdtFlags.isProtected(iMember)) {
            return false;
        }
        if (!bl) {
            return true;
        }
        return this.hasNonMovedReferences(iMember, iProgressMonitor, refactoringStatus);
    }

    public static class TypeVariableMapper
    extends ASTVisitor {
        protected final TypeVariableMaplet[] fMapping;
        protected final ASTRewrite fRewrite;

        public TypeVariableMapper(ASTRewrite aSTRewrite, TypeVariableMaplet[] typeVariableMapletArray) {
            Assert.isNotNull((Object)aSTRewrite);
            Assert.isNotNull((Object)typeVariableMapletArray);
            this.fRewrite = aSTRewrite;
            this.fMapping = typeVariableMapletArray;
        }

        public final boolean visit(SimpleName simpleName) {
            ITypeBinding iTypeBinding = simpleName.resolveTypeBinding();
            if (iTypeBinding != null && iTypeBinding.isTypeVariable()) {
                String string = null;
                int n = 0;
                while (n < this.fMapping.length) {
                    string = iTypeBinding.getName();
                    if (this.fMapping[n].getSourceName().equals(string) && simpleName.getIdentifier().equals(string)) {
                        IMethodBinding iMethodBinding;
                        MethodDeclaration methodDeclaration;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.wst.jsdt.core.dom.MethodDeclaration");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((methodDeclaration = (MethodDeclaration)ASTNodes.getParent((ASTNode)simpleName, clazz)) != null && (iMethodBinding = methodDeclaration.resolveBinding()) != null) {
                            ITypeBinding[] iTypeBindingArray = iMethodBinding.getTypeParameters();
                            int n2 = 0;
                            while (n2 < iTypeBindingArray.length) {
                                if (iTypeBindingArray[n2].isEqualTo((IBinding)iTypeBinding)) {
                                    return true;
                                }
                                ++n2;
                            }
                        }
                        this.fRewrite.set((ASTNode)simpleName, (StructuralPropertyDescriptor)SimpleName.IDENTIFIER_PROPERTY, (Object)this.fMapping[n].getTargetName(), null);
                    }
                    ++n;
                }
            }
            return true;
        }
    }
}

